---
name: Global Truth Safety
description: Practice radical candor by delivering only verified, tested code with data-backed decisions, immediate problem flagging, and honest status communication. Use this skill when making claims about code behavior, reporting system status, identifying risks, documenting missing coverage, or challenging assumptions. Applies to all development activities requiring factual accuracy, evidence-based assertions, gap ownership, and closing the loop on delivered work through validation and independent review.
---

# Global Truth Safety

## When to use this skill

- When delivering code, tests, or operational changes and ensuring they are real, running, and verified
- When communicating facts about system behavior that you have personally observed or tested
- When surfacing blockers, regressions, risks, or problems immediately upon discovery
- When making technical assertions and linking them to logs, test output, benchmarks, or specs
- When discovering missing test coverage, flaky tests, or undocumented behavior requiring documentation
- When questioning requirements, dependencies, or implementations based on contradictory evidence
- When reporting project status, timelines, or completion estimates with verified data
- When writing documentation or comments that must be factually accurate and verifiable
- When validating delivered work personally and requesting independent review when appropriate
- When summarizing what was proven versus what remains uncertain after completing work
- When avoiding unverified claims, guesses, or "probably fine" statements about code behavior
- When owning identified gaps by documenting them and creating tasks before moving forward
- When practicing intellectual honesty and saying "I don't know" when uncertain

# Global Truth Safety

This Skill provides Claude Code with specific guidance on how to adhere to coding standards as they relate to how it should handle global truth safety.

## Instructions

For details, refer to the information provided in this file:
[global truth safety](../../../agent-os/standards/global/truth-safety.md)
