---
name: goal-gradient-effect
description:
  El esfuerzo aumenta a medida que nos acercamos a una meta. Use cuando diseñe
  progress bars, programas de lealtad, flujos multi-paso, o gamificación.
metadata:
  author: ux-ui-skills
  version: "1.0"
  category: behavioral-effects
---

# Efecto de Gradiente de Meta

## Resumen

Las personas aceleran su comportamiento a medida que se acercan a una meta.
Cuanto más cerca del objetivo, mayor es la motivación y el esfuerzo invertido.

## Origen

- **Autor**: Clark Hull (original), Ran Kivetz & Oleg Urminsky (aplicación
  moderna)
- **Año**: 1932 (Hull), 2006 (Kivetz)
- **Fuente**: "The Goal-Gradient Hypothesis Resurrected"

## Fundamento Psicológico

Originalmente observado en ratas corriendo más rápido cerca de la comida, el
efecto aplica a humanos en contextos de recompensa. La proximidad a la meta
aumenta la expectativa de recompensa, liberando dopamina que motiva el
comportamiento.

## Aplicación en Diseño

### Progress Bars

- Mostrar progreso claramente
- Empezar con algo de progreso (no desde 0)
- Acelerar visualmente cerca del final
- Celebrar milestones intermedios

### Programas de Lealtad

- "Ya tienes 2 de 10 sellos"
- Dar puntos iniciales gratis
- Mostrar cuánto falta para recompensa
- Recompensas escalonadas frecuentes

### Flujos Multi-paso

- Steps visibles con posición actual
- "Solo 2 pasos más"
- Pasos finales más cortos
- Incentivo visible al final

### Gamificación

- XP para siguiente nivel visible
- Achievements con progreso parcial
- Daily goals alcanzables
- Streaks con recompensas cercanas

## Ejemplos

- **Starbucks**: Rewards con estrellas acumuladas
- **LinkedIn**: "Añade 3 skills para completar perfil"
- **Uber**: Progress bar de llegada del conductor
- **Kickstarter**: Funding meter que acelera al final
- **Fitbit**: Pasos restantes para meta diaria

## Anti-patterns

- ❌ Progress bars que no avanzan perceptiblemente
- ❌ Metas inalcanzables que desmotivan
- ❌ Recompensas demasiado lejanas
- ❌ Progreso que se reinicia sin aviso
- ❌ Ocultar cuánto falta para la meta

## Métricas

- **Completion Rate by Progress**: Tasa según % completado
- **Time per Step**: Aceleración en pasos finales
- **Engagement Near Goal**: Actividad cerca de metas
- **Loyalty Program Redemption**: Uso de recompensas

## Principios Relacionados

- [[zeigarnik-effect]] - Tareas incompletas motivan
- [[nielsen-visibility]] - Mostrar progreso claramente
- [[endowment-effect]] - Valorar progreso acumulado

## Referencias

- Hull, C.L. (1932). "The goal-gradient hypothesis and maze learning"
- Kivetz, R. et al. (2006). "The Goal-Gradient Hypothesis Resurrected"
- https://www.nngroup.com/articles/goal-gradient-effect/
