# Decision Rules Reference

Codified IF-THEN rules for all goal tracking decisions.

## Metric Source Selection

```
IF metric = "new_leads"
    → Use Contacts API with createdate filter
    → DO NOT use Deals API (deals don't exist until after discovery)

IF metric = "discovery_scheduled" OR "discovery_complete" OR "rate_creation" OR
   "proposals_sent" OR "setup_docs_sent" OR "implementation" OR "deals_closed"
    → Use Deals API with hs_v2_date_entered_[stageid] property
    → Filter by date range using BETWEEN operator
```

## Stage Entry vs Current Stage

```
IF counting deals for goal metrics
    → Use hs_v2_date_entered_[stageid] property
    → Filter by date range (deals that ENTERED in period)
    → NEVER count deals currently IN stage (stale data)

IF checking current pipeline state
    → Use dealstage property
    → This shows WHERE deals are NOW, not movement
```

## Goal Status Calculation

```
IF actual >= target * 0.90 → status = "on_track" (green)
IF actual >= target * 0.70 → status = "behind" (yellow)
IF actual >= target * 0.50 → status = "at_risk" (orange)
IF actual < target * 0.50 → status = "critical" (red)
```

## Archetype Selection

```
IF rep has archetype in profile → Use that archetype's weekly pattern
IF no archetype specified → Default to "volume_closer" pattern
ALWAYS verify archetype before calculating targets
```

## Red Stage Response

```
IF stage shows red status
    → Load 02-micro-actions-lookup.md
    → Find micro-actions for that stage
    → Execute NEXT incomplete action (not all at once)
    → Log activity to HubSpot
    → Re-run /cvm-goals to verify progress
```

## Diagnostic Patterns

```
IF Stage 1 (new_leads) = green AND Stages 2-4 = red
    → Diagnosis: Outreach bottleneck, NOT sourcing problem
    → Action: Focus on follow-ups and scheduling, not more prospecting

IF All stages = red
    → Diagnosis: Systemic issue OR archetype mismatch
    → Action: Verify data integrity, check archetype settings

IF Stage 1 = red AND other stages = green/yellow
    → Diagnosis: Lead generation gap
    → Action: Brand Scout campaigns, prospecting

IF Late stages (5-8) = red AND early stages = green
    → Diagnosis: Conversion/close issue
    → Action: Review proposals, follow-up cadence, objection handling
```

## WIP Limit Enforcement

```
IF stage_count >= WIP_LIMIT[stage]
    → STOP adding new items to that stage
    → Focus on moving existing items forward
    → Clear bottleneck before adding more

WIP Limits:
    Stage 1 (New Leads): 20
    Stage 2 (Discovery Scheduled): 15
    Stage 3 (Discovery Complete): 6
    Stage 4 (Rate Creation): 4
    Stage 5 (Proposals Sent): 3
    Stage 6 (Setup Docs): 3
    Stage 7 (Implementation): 2
    Stage 8 (Closed): No limit
```

## Time Period Calculations

```
IF period = "weekly"
    → Use current week (Monday to Sunday)
    → Target = archetype weekly pattern

IF period = "monthly"
    → Use current month
    → Target = weekly × 4.3

IF period = "quarterly"
    → Use current quarter
    → Target = weekly × 13
    → Distribution: Q1=15%, Q2=23%, Q3=28%, Q4=34%
```

## Date Filtering for HubSpot

```
IF filtering by date
    → Convert to Unix milliseconds
    → Pass as STRING (not integer)
    → Use BETWEEN operator
    → Format: "1734307200000" (not 1734307200000)
```
