# Micro-Actions Lookup Reference

Stage-by-stage micro-actions for ADHD-friendly execution. When a stage shows RED, find it here and execute the next incomplete action.

## WIP Limits by Stage

| Stage | Name | WIP Limit | Rationale |
|-------|------|-----------|-----------|
| 1 | New Leads | 20 | Enough pipeline feed without overwhelm |
| 2 | Discovery Scheduled | 15 | Active outreach capacity |
| 3 | Discovery Complete | 6 | Quality conversation limit |
| 4 | Rate Creation | 4 | Rate-building bandwidth |
| 5 | Proposals Sent | 3 | Active proposal tracking |
| 6 | Setup Docs | 3 | Contract review capacity |
| 7 | Implementation | 2 | Active integration support |
| 8 | Closed | No limit | Celebrate! |

## Stage 1: New Leads (Target: 15/week)

**Goal**: Generate qualified leads through research and outreach

**Micro-Actions**:
1. Run Brand Scout on target company
2. Scrape shipping/returns page for carrier data
3. Find decision-maker contacts (LinkedIn/Apollo)
4. Run `/check-lead` to verify not in HubSpot
5. Run `/add-lead` to create Company + Contact
6. Log source in lead_type field

**If RED**: Focus on Brand Scout campaigns, not email follow-ups

## Stage 2: Discovery Scheduled (Target: 6/week)

**Goal**: Convert leads to scheduled discovery calls

**Micro-Actions**:
1. Send Email 1 (Day 1 after Brand Scout)
2. Send Email 2 (Day 4 - value add)
3. Send Email 3 (Day 8 - social proof)
4. Make direct phone call
5. Send calendar link with time options
6. Confirm meeting details

**Daily Quota**: 3 Email-1s + 2 calls = 15 touches/week

**If RED but Stage 1 GREEN**: Outreach bottleneck - focus here, not more sourcing

## Stage 3: Discovery Complete (Target: 4/week)

**Goal**: Conduct and complete discovery calls

**Micro-Actions**:
1. Prepare discovery call notes (38 Questions framework)
2. Conduct discovery call
3. Qualify opportunity (volume, timeline, decision process)
4. Log meeting summary to HubSpot
5. Send follow-up email with next steps
6. Create deal if qualified

**If RED**: Check calendar, reschedule no-shows, send reminders

## Stage 4: Rate Creation (Target: 4/week)

**Goal**: Build and deliver custom rate cards

**Micro-Actions**:
1. Request PLD (Parcel Level Detail) data
2. Analyze shipping profile (weight, zones, destinations)
3. Build rate card in pricing tool
4. Get internal approval on rates
5. Document savings analysis
6. Prepare rate presentation

**If RED**: Follow up on PLD requests, escalate data blockers

## Stage 5: Proposals Sent (Target: 3/week)

**Goal**: Deliver proposals and get to decision

**Micro-Actions**:
1. Build proposal deck
2. Include savings analysis with specifics
3. Present proposal (meeting preferred)
4. Send proposal follow-up email
5. Schedule decision timeline call
6. Handle objections

**If RED**: Use swipe files from `ai-native-workflow` skill for follow-ups

## Stage 6: Setup Docs Sent (Target: 2/week)

**Goal**: Get verbal yes and send contracts

**Micro-Actions**:
1. Get verbal commitment
2. Send MSA (Master Service Agreement)
3. Send integration documentation
4. Introduce ops/implementation team
5. Answer contract questions
6. Track signature status

**If RED**: Check for contract blockers, legal review delays

## Stage 7: Implementation (Target: 1/week)

**Goal**: Go live with first shipments

**Micro-Actions**:
1. Confirm signed contract received
2. Set up account credentials
3. Complete technical integration
4. Run test shipments
5. Set go-live date
6. Week 1 check-in scheduled

**If RED**: Technical blockers, escalate to ops team

## Stage 8: Deals Closed (Target: 1/week)

**Goal**: First production shipments

**Micro-Actions**:
1. Confirm first production shipments
2. Week 1 performance check-in
3. Send first invoice
4. Mark deal as Closed Won
5. Hand off to Customer Success
6. Request referral/testimonial

## ADHD Execution Loop

```
1. Run /cvm-goals weekly
2. See dashboard with red stages
3. Find FIRST red stage (don't skip around)
4. Look up micro-actions above
5. Execute ONE action (not all)
6. Log to HubSpot
7. Repeat from step 1
```

## Diagnostic Rules

| Pattern | Meaning | Action |
|---------|---------|--------|
| Stage 1 GREEN, Stages 2-4 RED | Outreach bottleneck | Stop sourcing, focus on follow-ups |
| All stages RED | Data issue or burnout | Check data integrity, take break, reset |
| Stage 1 RED only | Lead gen gap | Brand Scout campaign |
| Late stages RED | Close rate issue | Review proposals, objection handling |

## Stale Deal Rules

| Time in Stage | Status | Auto-Action |
|---------------|--------|-------------|
| 48 hours | Warning | `/create-followup` |
| 72 hours | Alert | `/engagement-gap` review |
| 7 days | Critical | Escalation or re-qualify |
