## 国际化处理插件使用


### 项目国际化

-   切换到项目目录下 执行 web i18n

#### 指令参数

| 参数 | 类型 | 默认值 | 描述 |
| - | - | - | - |
| projectType | String | 根据项目 package.json 中的 vue 版本进行判断 | 项目类型，是 Vue2，Vue3 或者 uniapp(仅支持 vue3) |



#### 安装国际化插件

```js
npm i vue-i18n -S
```

-   src/i18n 文件夹下的 index.js 文件

-   main.js 引入 i18n

```js
import i18n from '@/i18n'
app.use(i18n)
```

#### 或者直接引入新版组件库

```js
import ElementPlus from 'element-plus'

eslinkPlus.updateLocale(lang as eslinkPlus.Locale)
```

#### 注意

-   locales/zh-CN.json 是每次新提取的中文语言包，每次提取都会覆盖，完整中文请查看 src/i18n/zh-CN.json
-   英文请自行维护
-   如果项目内使用了 pug 会先转化为 html 解析，然后再处理国际化，转化过程中可能会有问题，有报错自行排查及修改（保证自己的代码没有明显的语法错误比如：缺少key属性、v-if判断v-for循环、v-model绑定等）
-   若有增量再次执行web i18n 会额外生成zh-CN-incremental.json增量文件，请自行合并

