import type { UiFormConfig } from '@e-cloud/eslink-plus'
export default {
	list: [
		{
			list: [
				{
					type: 'blank',
					icon: 'icon-zidingyishuju',
					options: {
						customClass: '',
						labelWidth: 100,
						isLabelWidth: false,
						hidden: false,
						dataBind: true,
						width: '',
						validator: '',
						tip: '',
						remoteFunc: 'func_1utrawh9',
						remoteOption: 'option_1utrawh9',
						tableColumn: false,
						subform: false,
						defaultType: 'String',
						required: false,
						pattern: '',
						hideLabel: true,
					},
					events: {
						onMounted: '',
						onChange: '',
					},
					name: '自定义区域',
					key: '1utrawh9',
					model: 'addressInfo',
					rules: [],
				},
			],
			type: 'group',
			icon: 'icon-fenzu',
			options: {
				defaultValue: {},
				customClass: '',
				labelWidth: 100,
				isLabelWidth: false,
				hidden: false,
				dataBind: true,
				width: '',
				validatorCheck: false,
				validator: '',
				tip: '',
				remoteFunc: 'func_g4vu90cd',
				remoteOption: 'option_g4vu90cd',
				tableColumn: false,
				subform: false,
				labelWrap: true,
			},
			events: {
				onMounted: '',
			},
			name: '地址信息',
			key: 'g4vu90cd',
			model: 'group_address',
			rules: [],
		},
		{
			list: [
				{
					type: 'grid',
					icon: 'icon-RectangleCopy',
					options: {
						customClass: '',
						hidden: false,
						remoteFunc: 'func_s6krx77b',
						remoteOption: 'option_s6krx77b',
						tableColumn: false,
						subform: false,
						gutter: 25,
						justify: 'start',
						align: 'top',
						flex: true,
						responsive: true,
					},
					name: '栅格布局',
					key: 's6krx77b',
					model: 'grid_s6krx77b',
					rules: [],
					columns: [
						{
							list: [
								{
									type: 'input',
									icon: 'icon-input',
									options: {
										defaultValue: '',
										customClass: '',
										labelWidth: 100,
										isLabelWidth: false,
										hidden: false,
										dataBind: true,
										width: '',
										validatorCheck: false,
										validator: '',
										tip: '',
										remoteFunc: 'func_m1aa1chq',
										remoteOption: 'option_m1aa1chq',
										tableColumn: false,
										subform: false,
										labelWrap: true,
										required: true,
										pattern: '',
										requiredMessage: '',
										dataType: '',
										dataTypeCheck: false,
										dataTypeMessage: '',
										patternCheck: false,
										patternMessage: '',
										placeholder: '',
										disabled: false,
										showPassword: false,
										clearable: false,
										maxlength: '',
										showWordLimit: false,
										customProps: {},
										extendProps: {},
									},
									events: {
										onMounted: '',
										onChange: '',
										onFocus: '',
										onBlur: '',
									},
									name: '客户名称',
									key: 'm1aa1chq',
									model: 'custName',
									rules: [
										{
											required: true,
											message: '',
										},
									],
									novalid: {},
								},
							],
							type: 'col',
							options: {
								customClass: '',
								span: 12,
								offset: 0,
								push: 0,
								pull: 0,
								xs: 24,
								sm: 12,
								md: 12,
								lg: 12,
								xl: 12,
							},
							key: 'g7db86ob',
							rules: [],
						},
						{
							list: [
								{
									type: 'select',
									icon: 'icon-select',
									options: {
										options: [
											{
												value: '1',
												label: '非居',
											},
											{
												value: '2',
												label: '居民',
											},
										],
										defaultValue: '',
										customClass: '',
										labelWidth: 100,
										isLabelWidth: false,
										hidden: false,
										dataBind: true,
										width: '',
										validatorCheck: false,
										validator: '',
										tip: '',
										remoteFunc: 'func_djxrxyxj',
										remoteOption: 'option_djxrxyxj',
										tableColumn: false,
										subform: false,
										labelWrap: true,
										required: true,
										requiredMessage: '',
										placeholder: '',
										disabled: false,
										clearable: false,
										customProps: {},
										extendProps: {},
										multiple: false,
										showLabel: true,
										remote: false,
										remoteType: 'datasource',
										filterable: false,
										remoteOptions: [],
										props: {
											value: 'value',
											label: 'label',
										},
									},
									events: {
										onMounted: '',
										onChange: '',
										onFocus: '',
										onBlur: '',
									},
									name: '客户类型',
									key: 'djxrxyxj',
									model: 'custType',
									rules: [
										{
											required: true,
											message: '',
										},
									],
									novalid: {},
								},
							],
							type: 'col',
							options: {
								customClass: '',
								span: 12,
								offset: 0,
								push: 0,
								pull: 0,
								xs: 24,
								sm: 12,
								md: 12,
								lg: 12,
								xl: 12,
							},
							key: 'armutw1j',
							rules: [],
						},
						{
							list: [
								{
									type: 'input',
									icon: 'icon-input',
									options: {
										defaultValue: '',
										customClass: '',
										labelWidth: 100,
										isLabelWidth: false,
										hidden: false,
										dataBind: true,
										width: '',
										validatorCheck: false,
										validator: '',
										tip: '',
										remoteFunc: 'func_th1uagcd',
										remoteOption: 'option_th1uagcd',
										tableColumn: false,
										subform: false,
										labelWrap: true,
										required: true,
										pattern: '',
										requiredMessage: '',
										dataType: '',
										dataTypeCheck: false,
										dataTypeMessage: '',
										patternCheck: false,
										patternMessage: '',
										placeholder: '',
										disabled: false,
										showPassword: false,
										clearable: false,
										maxlength: '',
										showWordLimit: false,
										customProps: {},
										extendProps: {},
									},
									events: {
										onMounted: '',
										onChange: '',
										onFocus: '',
										onBlur: '',
									},
									name: '手机号码',
									key: 'th1uagcd',
									model: 'custPhone',
									rules: [
										{
											required: true,
											message: '',
										},
									],
									novalid: {},
								},
							],
							type: 'col',
							options: {
								customClass: '',
								span: 12,
								offset: 0,
								push: 0,
								pull: 0,
								xs: 24,
								sm: 12,
								md: 12,
								lg: 12,
								xl: 12,
							},
							key: 'vxuy0bqa',
							rules: [],
						},
						{
							list: [
								{
									type: 'input',
									icon: 'icon-input',
									options: {
										defaultValue: '',
										customClass: '',
										labelWidth: 100,
										isLabelWidth: false,
										hidden: false,
										dataBind: true,
										width: '',
										validatorCheck: false,
										validator: '',
										tip: '',
										remoteFunc: 'func_2c7s2sen',
										remoteOption: 'option_2c7s2sen',
										tableColumn: false,
										subform: false,
										labelWrap: true,
										required: true,
										pattern: '',
										requiredMessage: '',
										dataType: '',
										dataTypeCheck: false,
										dataTypeMessage: '',
										patternCheck: false,
										patternMessage: '',
										placeholder: '',
										disabled: false,
										showPassword: false,
										clearable: false,
										maxlength: '',
										showWordLimit: false,
										customProps: {},
										extendProps: {},
									},
									events: {
										onMounted: '',
										onChange: '',
										onFocus: '',
										onBlur: '',
									},
									name: '身份证号',
									key: '2c7s2sen',
									model: 'certificateNo',
									rules: [
										{
											required: true,
											message: '',
										},
									],
									novalid: {},
								},
							],
							type: 'col',
							options: {
								customClass: '',
								span: 12,
								offset: 0,
								push: 0,
								pull: 0,
								xs: 24,
								sm: 12,
								md: 12,
								lg: 12,
								xl: 12,
							},
							key: 'uoy5fuun',
							rules: [],
						},
						{
							list: [
								{
									type: 'select',
									icon: 'icon-select',
									options: {
										options: [
											{
												value: '1',
												label: '护照',
											},
											{
												value: '2',
												label: '军官证',
											},
											{
												value: '3',
												label: '港澳台同胞证',
											},
										],
										defaultValue: '',
										customClass: '',
										labelWidth: 100,
										isLabelWidth: false,
										hidden: false,
										dataBind: true,
										width: '',
										validatorCheck: false,
										validator: '',
										tip: '',
										remoteFunc: 'func_tr58euea',
										remoteOption: 'option_tr58euea',
										tableColumn: false,
										subform: false,
										labelWrap: true,
										required: false,
										requiredMessage: '',
										placeholder: '',
										disabled: false,
										clearable: false,
										customProps: {},
										extendProps: {},
										multiple: false,
										showLabel: true,
										remote: false,
										remoteType: 'datasource',
										filterable: false,
										remoteOptions: [],
										props: {
											value: 'value',
											label: 'label',
										},
									},
									events: {
										onMounted: '',
										onChange: '',
										onFocus: '',
										onBlur: '',
									},
									name: '其他证件',
									key: 'tr58euea',
									model: 'otherCertificate',
									rules: [],
									novalid: {},
								},
							],
							type: 'col',
							options: {
								customClass: '',
								span: 12,
								offset: 0,
								push: 0,
								pull: 0,
								xs: 24,
								sm: 12,
								md: 12,
								lg: 12,
								xl: 12,
							},
							key: '225x1qbu',
							rules: [],
						},
						{
							list: [
								{
									type: 'input',
									icon: 'icon-input',
									options: {
										defaultValue: '',
										customClass: '',
										labelWidth: 100,
										isLabelWidth: false,
										hidden: false,
										dataBind: true,
										width: '',
										validatorCheck: false,
										validator: '',
										tip: '',
										remoteFunc: 'func_l55k3h4t',
										remoteOption: 'option_l55k3h4t',
										tableColumn: false,
										subform: false,
										labelWrap: true,
										required: false,
										pattern: '',
										requiredMessage: '',
										dataType: '',
										dataTypeCheck: false,
										dataTypeMessage: '',
										patternCheck: false,
										patternMessage: '',
										placeholder: '',
										disabled: false,
										showPassword: false,
										clearable: false,
										maxlength: '',
										showWordLimit: false,
										customProps: {},
										extendProps: {},
									},
									events: {
										onMounted: '',
										onChange: '',
										onFocus: '',
										onBlur: '',
									},
									name: '其他证件号',
									key: 'l55k3h4t',
									model: 'otherCertificateNo',
									rules: [],
									novalid: {},
								},
							],
							type: 'col',
							options: {
								customClass: '',
								span: 12,
								offset: 0,
								push: 0,
								pull: 0,
								xs: 24,
								sm: 12,
								md: 12,
								lg: 12,
								xl: 12,
							},
							key: 'e71hpf0p',
							rules: [],
						},
						{
							list: [
								{
									type: 'input',
									icon: 'icon-input',
									options: {
										defaultValue: '',
										customClass: '',
										labelWidth: 100,
										isLabelWidth: false,
										hidden: false,
										dataBind: true,
										width: '',
										validatorCheck: false,
										validator: '',
										tip: '',
										remoteFunc: 'func_zojjug9h',
										remoteOption: 'option_zojjug9h',
										tableColumn: false,
										subform: false,
										labelWrap: true,
										required: false,
										pattern: '',
										requiredMessage: '',
										dataType: '',
										dataTypeCheck: false,
										dataTypeMessage: '',
										patternCheck: false,
										patternMessage: '',
										placeholder: '',
										disabled: false,
										showPassword: false,
										clearable: false,
										maxlength: '',
										showWordLimit: false,
										customProps: {},
										extendProps: {},
									},
									events: {
										onMounted: '',
										onChange: '',
										onFocus: '',
										onBlur: '',
									},
									name: '固定电话',
									key: 'zojjug9h',
									model: 'tel',
									rules: [],
									novalid: {},
								},
							],
							type: 'col',
							options: {
								customClass: '',
								span: 12,
								offset: 0,
								push: 0,
								pull: 0,
								xs: 24,
								sm: 12,
								md: 24,
								lg: 12,
								xl: 12,
							},
							key: 'qdnnnleg',
							rules: [],
						},
					],
				},
			],
			type: 'group',
			icon: 'icon-fenzu',
			options: {
				defaultValue: {},
				customClass: '',
				labelWidth: 100,
				isLabelWidth: false,
				hidden: false,
				dataBind: true,
				width: '',
				validatorCheck: false,
				validator: '',
				tip: '',
				remoteFunc: 'func_g4vu90cd',
				remoteOption: 'option_g4vu90cd',
				tableColumn: false,
				subform: false,
				labelWrap: true,
			},
			events: {
				onMounted: '',
			},
			name: '客户信息',
			key: 'am3pd7cb',
			model: 'group_customer',
			rules: [],
		},
		{
			list: [
				{
					type: 'grid',
					icon: 'icon-RectangleCopy',
					options: {
						customClass: '',
						hidden: false,
						remoteFunc: 'func_s6krx77b',
						remoteOption: 'option_s6krx77b',
						tableColumn: false,
						subform: false,
						gutter: 25,
						justify: 'start',
						align: 'top',
						flex: true,
						responsive: true,
					},
					name: '栅格布局',
					key: 'bd3pt903',
					model: 'grid_bd3pt903',
					rules: [],
					columns: [
						{
							list: [
								{
									type: 'select',
									icon: 'icon-select',
									options: {
										options: [
											{
												value: '1',
												label: '开票方式1',
											},
											{
												value: '2',
												label: '开票方式2',
											},
											{
												value: '3',
												label: '开票方式3',
											},
										],
										defaultValue: '',
										customClass: '',
										labelWidth: 100,
										isLabelWidth: false,
										hidden: false,
										dataBind: true,
										width: '',
										validatorCheck: false,
										validator: '',
										tip: '',
										remoteFunc: 'func_2at1ggmn',
										remoteOption: 'option_2at1ggmn',
										tableColumn: false,
										subform: false,
										labelWrap: true,
										required: true,
										requiredMessage: '',
										placeholder: '',
										disabled: false,
										clearable: false,
										customProps: {},
										extendProps: {},
										multiple: false,
										showLabel: true,
										remote: false,
										remoteType: 'datasource',
										filterable: false,
										remoteOptions: [],
										props: {
											value: 'value',
											label: 'label',
										},
									},
									events: {
										onMounted: '',
										onChange: '',
										onFocus: '',
										onBlur: '',
									},
									name: '开票方式',
									key: '2at1ggmn',
									model: 'invoiceOpenType',
									rules: [
										{
											required: true,
											message: '',
										},
									],
									novalid: {},
								},
							],
							type: 'col',
							options: {
								customClass: '',
								span: 12,
								offset: 0,
								push: 0,
								pull: 0,
								xs: 24,
								sm: 12,
								md: 12,
								lg: 12,
								xl: 12,
							},
							key: 'm35zgtgn',
							rules: [],
						},
						{
							list: [
								{
									type: 'select',
									icon: 'icon-select',
									options: {
										options: [
											{
												value: '1',
												label: '普通发票',
											},
											{
												value: '2',
												label: '电子发票',
											},
											{
												value: '3',
												label: '专用发票',
											},
										],
										defaultValue: '',
										customClass: '',
										labelWidth: 100,
										isLabelWidth: false,
										hidden: false,
										dataBind: true,
										width: '',
										validatorCheck: false,
										validator: '',
										tip: '',
										remoteFunc: 'func_2at1ggmn',
										remoteOption: 'option_2at1ggmn',
										tableColumn: false,
										subform: false,
										labelWrap: true,
										required: true,
										requiredMessage: '',
										placeholder: '',
										disabled: false,
										clearable: false,
										customProps: {},
										extendProps: {},
										multiple: false,
										showLabel: true,
										remote: false,
										remoteType: 'datasource',
										filterable: false,
										remoteOptions: [],
										props: {
											value: 'value',
											label: 'label',
										},
									},
									events: {
										onMounted: '',
										onChange: '',
										onFocus: '',
										onBlur: '',
									},
									name: '发票类型',
									key: '7z0as4wm',
									model: 'select_7z0as4wm',
									rules: [
										{
											required: true,
											message: '',
										},
									],
									novalid: {},
								},
							],
							type: 'col',
							options: {
								customClass: '',
								span: 12,
								offset: 0,
								push: 0,
								pull: 0,
								xs: 24,
								sm: 12,
								md: 12,
								lg: 12,
								xl: 12,
							},
							key: '76wuriso',
							rules: [],
						},
						{
							list: [
								{
									type: 'input',
									icon: 'icon-input',
									options: {
										defaultValue: '',
										customClass: '',
										labelWidth: 100,
										isLabelWidth: false,
										hidden: false,
										dataBind: true,
										width: '',
										validatorCheck: false,
										validator: '',
										tip: '',
										remoteFunc: 'func_kcwd0n0j',
										remoteOption: 'option_kcwd0n0j',
										tableColumn: false,
										subform: false,
										labelWrap: true,
										required: true,
										pattern: '',
										requiredMessage: '',
										dataType: '',
										dataTypeCheck: false,
										dataTypeMessage: '',
										patternCheck: false,
										patternMessage: '',
										placeholder: '',
										disabled: false,
										showPassword: false,
										clearable: false,
										maxlength: '',
										showWordLimit: false,
										customProps: {},
										extendProps: {},
									},
									events: {
										onMounted: '',
										onChange: '',
										onFocus: '',
										onBlur: '',
									},
									name: '发票抬头',
									key: 'kcwd0n0j',
									model: 'invoiceUserName',
									rules: [
										{
											required: true,
											message: '',
										},
									],
									novalid: {},
								},
							],
							type: 'col',
							options: {
								customClass: '',
								span: 12,
								offset: 0,
								push: 0,
								pull: 0,
								xs: 24,
								sm: 12,
								md: 12,
								lg: 12,
								xl: 12,
							},
							key: 's1m4v3nu',
							rules: [],
						},
						{
							list: [
								{
									type: 'input',
									icon: 'icon-input',
									options: {
										defaultValue: '',
										customClass: '',
										labelWidth: 100,
										isLabelWidth: false,
										hidden: false,
										dataBind: true,
										width: '',
										validatorCheck: false,
										validator: '',
										tip: '',
										remoteFunc: 'func_kcwd0n0j',
										remoteOption: 'option_kcwd0n0j',
										tableColumn: false,
										subform: false,
										labelWrap: true,
										required: true,
										pattern: '',
										requiredMessage: '',
										dataType: '',
										dataTypeCheck: false,
										dataTypeMessage: '',
										patternCheck: false,
										patternMessage: '',
										placeholder: '',
										disabled: false,
										showPassword: false,
										clearable: false,
										maxlength: '',
										showWordLimit: false,
										customProps: {},
										extendProps: {},
									},
									events: {
										onMounted: '',
										onChange: '',
										onFocus: '',
										onBlur: '',
									},
									name: '税号',
									key: 'nyxo162r',
									model: 'taxNo',
									rules: [
										{
											required: true,
											message: '',
										},
									],
									novalid: {},
								},
							],
							type: 'col',
							options: {
								customClass: '',
								span: 12,
								offset: 0,
								push: 0,
								pull: 0,
								xs: 24,
								sm: 12,
								md: 12,
								lg: 12,
								xl: 12,
							},
							key: 'mfg36xos',
							rules: [],
						},
						{
							list: [
								{
									type: 'input',
									icon: 'icon-input',
									options: {
										defaultValue: '',
										customClass: '',
										labelWidth: 100,
										isLabelWidth: false,
										hidden: false,
										dataBind: true,
										width: '',
										validatorCheck: false,
										validator: '',
										tip: '',
										remoteFunc: 'func_qrse347a',
										remoteOption: 'option_qrse347a',
										tableColumn: false,
										subform: false,
										labelWrap: true,
										required: true,
										pattern: '',
										requiredMessage: '',
										dataType: '',
										dataTypeCheck: false,
										dataTypeMessage: '',
										patternCheck: false,
										patternMessage: '',
										placeholder: '',
										disabled: false,
										showPassword: false,
										clearable: false,
										maxlength: '',
										showWordLimit: false,
										customProps: {},
										extendProps: {},
									},
									events: {
										onMounted: '',
										onChange: '',
										onFocus: '',
										onBlur: '',
									},
									name: '开票地址',
									key: 'qrse347a',
									model: 'invoiceAddress',
									rules: [
										{
											required: true,
											message: '',
										},
									],
									novalid: {},
								},
							],
							type: 'col',
							options: {
								customClass: '',
								span: 12,
								offset: 0,
								push: 0,
								pull: 0,
								xs: 24,
								sm: 12,
								md: 24,
								lg: 12,
								xl: 12,
							},
							key: 'fey2dpyn',
							rules: [],
						},
						{
							list: [
								{
									type: 'input',
									icon: 'icon-input',
									options: {
										defaultValue: '',
										customClass: '',
										labelWidth: 100,
										isLabelWidth: false,
										hidden: false,
										dataBind: true,
										width: '',
										validatorCheck: false,
										validator: '',
										tip: '',
										remoteFunc: 'func_qrse347a',
										remoteOption: 'option_qrse347a',
										tableColumn: false,
										subform: false,
										labelWrap: true,
										required: true,
										pattern: '',
										requiredMessage: '',
										dataType: '',
										dataTypeCheck: false,
										dataTypeMessage: '',
										patternCheck: false,
										patternMessage: '',
										placeholder: '',
										disabled: false,
										showPassword: false,
										clearable: false,
										maxlength: '',
										showWordLimit: false,
										customProps: {},
										extendProps: {},
									},
									events: {
										onMounted: '',
										onChange: '',
										onFocus: '',
										onBlur: '',
									},
									name: '开户银行',
									key: '3bvsfq0w',
									model: 'invoiceBank',
									rules: [
										{
											required: true,
											message: '',
										},
									],
									novalid: {},
								},
							],
							type: 'col',
							options: {
								customClass: '',
								span: 12,
								offset: 0,
								push: 0,
								pull: 0,
								xs: 24,
								sm: 12,
								md: 24,
								lg: 12,
								xl: 12,
							},
							key: 'v9andhu9',
							rules: [],
						},
						{
							list: [
								{
									type: 'input',
									icon: 'icon-input',
									options: {
										defaultValue: '',
										customClass: '',
										labelWidth: 100,
										isLabelWidth: false,
										hidden: false,
										dataBind: true,
										width: '',
										validatorCheck: false,
										validator: '',
										tip: '',
										remoteFunc: 'func_kcwd0n0j',
										remoteOption: 'option_kcwd0n0j',
										tableColumn: false,
										subform: false,
										labelWrap: true,
										required: true,
										pattern: '',
										requiredMessage: '',
										dataType: '',
										dataTypeCheck: false,
										dataTypeMessage: '',
										patternCheck: false,
										patternMessage: '',
										placeholder: '',
										disabled: false,
										showPassword: false,
										clearable: false,
										maxlength: '',
										showWordLimit: false,
										customProps: {},
										extendProps: {},
									},
									events: {
										onMounted: '',
										onChange: '',
										onFocus: '',
										onBlur: '',
									},
									name: '银行账号',
									key: '1cn755q2',
									model: 'invoiceBankAccount',
									rules: [
										{
											required: true,
											message: '',
										},
									],
									novalid: {},
								},
							],
							type: 'col',
							options: {
								customClass: '',
								span: 12,
								offset: 0,
								push: 0,
								pull: 0,
								xs: 24,
								sm: 12,
								md: 12,
								lg: 12,
								xl: 12,
							},
							key: 'm97s338c',
							rules: [],
						},
						{
							list: [
								{
									type: 'input',
									icon: 'icon-input',
									options: {
										defaultValue: '',
										customClass: '',
										labelWidth: 100,
										isLabelWidth: false,
										hidden: false,
										dataBind: true,
										width: '',
										validatorCheck: false,
										validator: '',
										tip: '',
										remoteFunc: 'func_kcwd0n0j',
										remoteOption: 'option_kcwd0n0j',
										tableColumn: false,
										subform: false,
										labelWrap: true,
										required: true,
										pattern: '',
										requiredMessage: '',
										dataType: '',
										dataTypeCheck: false,
										dataTypeMessage: '',
										patternCheck: false,
										patternMessage: '',
										placeholder: '',
										disabled: false,
										showPassword: false,
										clearable: false,
										maxlength: '',
										showWordLimit: false,
										customProps: {},
										extendProps: {},
									},
									events: {
										onMounted: '',
										onChange: '',
										onFocus: '',
										onBlur: '',
									},
									name: '电话',
									key: 'p35pkk38',
									model: 'invoicePhone',
									rules: [
										{
											required: true,
											message: '',
										},
									],
									novalid: {},
								},
							],
							type: 'col',
							options: {
								customClass: '',
								span: 12,
								offset: 0,
								push: 0,
								pull: 0,
								xs: 24,
								sm: 12,
								md: 12,
								lg: 12,
								xl: 12,
							},
							key: '4y4al5qu',
							rules: [],
						},
					],
				},
			],
			type: 'group',
			icon: 'icon-fenzu',
			options: {
				defaultValue: {},
				customClass: '',
				labelWidth: 100,
				isLabelWidth: false,
				hidden: false,
				dataBind: true,
				width: '',
				validatorCheck: false,
				validator: '',
				tip: '',
				remoteFunc: 'func_g4vu90cd',
				remoteOption: 'option_g4vu90cd',
				tableColumn: false,
				subform: false,
				labelWrap: true,
			},
			events: {
				onMounted: '',
			},
			name: '开票信息',
			key: 'alfpjiyb',
			model: 'group_invoice',
			rules: [],
		},
		{
			list: [
				{
					list: [
						{
							type: 'grid',
							icon: 'icon-RectangleCopy',
							options: {
								customClass: '',
								hidden: false,
								remoteFunc: 'func_s6krx77b',
								remoteOption: 'option_s6krx77b',
								tableColumn: false,
								subform: false,
								gutter: 25,
								justify: 'start',
								align: 'top',
								flex: true,
								responsive: true,
							},
							name: '栅格布局',
							key: 'rc1p91dp',
							model: 'grid_rc1p91dp',
							rules: [],
							columns: [
								{
									list: [
										{
											type: 'select',
											icon: 'icon-select',
											options: {
												options: [
													{
														value: '1',
														label: '普通协议',
													},
													{
														value: '2',
														label: '餐饮协议',
													},
													{
														value: '3',
														label: '公服协议',
													},
												],
												defaultValue: '',
												customClass: '',
												labelWidth: 100,
												isLabelWidth: false,
												hidden: false,
												dataBind: true,
												width: '',
												validatorCheck: false,
												validator: '',
												tip: '',
												remoteFunc: 'func_2at1ggmn',
												remoteOption: 'option_2at1ggmn',
												tableColumn: false,
												subform: false,
												labelWrap: true,
												required: true,
												requiredMessage: '',
												placeholder: '',
												disabled: false,
												clearable: false,
												customProps: {},
												extendProps: {},
												multiple: false,
												showLabel: true,
												remote: false,
												remoteType: 'datasource',
												filterable: false,
												remoteOptions: [],
												props: {
													value: 'value',
													label: 'label',
												},
											},
											events: {
												onMounted: '',
												onChange: '',
												onFocus: '',
												onBlur: '',
											},
											name: '协议类型',
											key: 'kp95fa4f',
											model: 'protocolType',
											rules: [
												{
													required: true,
													message: '',
												},
											],
											novalid: {},
										},
									],
									type: 'col',
									options: {
										customClass: '',
										span: 12,
										offset: 0,
										push: 0,
										pull: 0,
										xs: 24,
										sm: 12,
										md: 12,
										lg: 12,
										xl: 12,
									},
									key: 'cyysmhl8',
									rules: [],
								},
								{
									list: [
										{
											type: 'select',
											icon: 'icon-select',
											options: {
												options: [
													{
														value: '1',
														label: '居民用气阶梯',
													},
													{
														value: '2',
														label: '非居用气阶梯',
													},
													{
														value: '3',
														label: '谷峰用气阶梯',
													},
												],
												defaultValue: '',
												customClass: '',
												labelWidth: 100,
												isLabelWidth: false,
												hidden: false,
												dataBind: true,
												width: '',
												validatorCheck: false,
												validator: '',
												tip: '',
												remoteFunc: 'func_2at1ggmn',
												remoteOption: 'option_2at1ggmn',
												tableColumn: false,
												subform: false,
												labelWrap: true,
												required: true,
												requiredMessage: '',
												placeholder: '',
												disabled: false,
												clearable: false,
												customProps: {},
												extendProps: {},
												multiple: false,
												showLabel: true,
												remote: false,
												remoteType: 'datasource',
												filterable: false,
												remoteOptions: [],
												props: {
													value: 'value',
													label: 'label',
												},
											},
											events: {
												onMounted: '',
												onChange: '',
												onFocus: '',
												onBlur: '',
											},
											name: '价格名称',
											key: 'sdnehufn',
											model: 'priceName',
											rules: [
												{
													required: true,
													message: '',
												},
											],
											novalid: {},
										},
									],
									type: 'col',
									options: {
										customClass: '',
										span: 12,
										offset: 0,
										push: 0,
										pull: 0,
										xs: 24,
										sm: 12,
										md: 12,
										lg: 12,
										xl: 12,
									},
									key: 'cqfq4y35',
									rules: [],
								},
								{
									list: [
										{
											type: 'blank',
											icon: 'icon-zidingyishuju',
											options: {
												customClass: '',
												labelWidth: 100,
												isLabelWidth: false,
												hidden: false,
												dataBind: true,
												width: '',
												validator: '',
												tip: '',
												remoteFunc: 'func_wrkx5nzw',
												remoteOption: 'option_wrkx5nzw',
												tableColumn: false,
												subform: false,
												defaultType: 'String',
												required: false,
												pattern: '',
												hideLabel: true,
											},
											events: {
												onMounted: '',
												onChange: '',
											},
											name: '自定义区域',
											key: '07hm24ac',
											model: 'protocolDetail',
											rules: [],
											novalid: {},
										},
									],
									type: 'col',
									options: {
										customClass: '',
										span: 12,
										offset: 0,
										push: 0,
										pull: 0,
										xs: 24,
										sm: 12,
										md: 24,
										lg: 12,
										xl: 12,
									},
									key: 'huit5d91',
									rules: [],
								},
								{
									list: [
										{
											type: 'input',
											icon: 'icon-input',
											options: {
												defaultValue: '',
												customClass: '',
												labelWidth: 100,
												isLabelWidth: false,
												hidden: false,
												dataBind: true,
												width: '',
												validatorCheck: false,
												validator: '',
												tip: '',
												remoteFunc: 'func_s487n1dc',
												remoteOption: 'option_s487n1dc',
												tableColumn: false,
												subform: false,
												labelWrap: true,
												required: false,
												pattern: '',
												requiredMessage: '',
												dataType: '',
												dataTypeCheck: false,
												dataTypeMessage: '',
												patternCheck: false,
												patternMessage: '',
												placeholder: '',
												disabled: false,
												showPassword: false,
												clearable: false,
												maxlength: '',
												showWordLimit: false,
												customProps: {},
												extendProps: {},
											},
											events: {
												onMounted: '',
												onChange: '',
												onFocus: '',
												onBlur: '',
											},
											name: '合同编号',
											key: '4gbzebvc',
											model: 'contractNo',
											rules: [],
											novalid: {},
										},
									],
									type: 'col',
									options: {
										customClass: '',
										span: 12,
										offset: 0,
										push: 0,
										pull: 0,
										xs: 24,
										sm: 12,
										md: 12,
										lg: 12,
										xl: 12,
									},
									key: 'hm34is8f',
									rules: [],
								},
								{
									list: [
										{
											type: 'select',
											icon: 'icon-select',
											options: {
												options: [
													{
														value: '1',
														label: '不定期',
													},
													{
														value: '2',
														label: '5年定期',
													},
												],
												defaultValue: '',
												customClass: '',
												labelWidth: 100,
												isLabelWidth: false,
												hidden: false,
												dataBind: true,
												width: '',
												validatorCheck: false,
												validator: '',
												tip: '',
												remoteFunc: 'func_2at1ggmn',
												remoteOption: 'option_2at1ggmn',
												tableColumn: false,
												subform: false,
												labelWrap: true,
												required: true,
												requiredMessage: '',
												placeholder: '',
												disabled: false,
												clearable: false,
												customProps: {},
												extendProps: {},
												multiple: false,
												showLabel: true,
												remote: false,
												remoteType: 'datasource',
												filterable: false,
												remoteOptions: [],
												props: {
													value: 'value',
													label: 'label',
												},
											},
											events: {
												onMounted: '',
												onChange: '',
												onFocus: '',
												onBlur: '',
											},
											name: '服务周期',
											key: 'azp0wohe',
											model: 'protocolCircle',
											rules: [
												{
													required: true,
													message: '',
												},
											],
											novalid: {},
										},
									],
									type: 'col',
									options: {
										customClass: '',
										span: 12,
										offset: 0,
										push: 0,
										pull: 0,
										xs: 24,
										sm: 12,
										md: 12,
										lg: 12,
										xl: 12,
									},
									key: 'z7n7ie28',
									rules: [],
								},
								{
									list: [
										{
											type: 'date',
											icon: 'icon-date',
											options: {
												type: 'date',
												defaultValue: '',
												customClass: '',
												labelWidth: 100,
												isLabelWidth: false,
												hidden: false,
												dataBind: true,
												width: '100%',
												validatorCheck: false,
												validator: '',
												tip: '',
												remoteFunc: 'func_0c7wgs3f',
												remoteOption: 'option_0c7wgs3f',
												tableColumn: false,
												subform: false,
												labelWrap: true,
												required: false,
												requiredMessage: '',
												placeholder: '',
												disabled: false,
												clearable: true,
												customProps: {},
												extendProps: {},
												readonly: false,
												editable: false,
												startPlaceholder: '',
												endPlaceholder: '',
												format: 'YYYY-MM-DD',
												timestamp: false,
											},
											events: {
												onMounted: '',
												onChange: '',
												onFocus: '',
												onBlur: '',
											},
											name: '协议生效日',
											key: 'wwyr0qhi',
											model: 'protocolStartDate',
											rules: [],
											novalid: {},
										},
									],
									type: 'col',
									options: {
										customClass: '',
										span: 12,
										offset: 0,
										push: 0,
										pull: 0,
										xs: 24,
										sm: 12,
										md: 12,
										lg: 12,
										xl: 12,
									},
									key: 'qso670mp',
									rules: [],
								},
								{
									list: [
										{
											type: 'date',
											icon: 'icon-date',
											options: {
												type: 'date',
												defaultValue: '',
												customClass: '',
												labelWidth: 100,
												isLabelWidth: false,
												hidden: false,
												dataBind: true,
												width: '100%',
												validatorCheck: false,
												validator: '',
												tip: '',
												remoteFunc: 'func_0c7wgs3f',
												remoteOption: 'option_0c7wgs3f',
												tableColumn: false,
												subform: false,
												labelWrap: true,
												required: false,
												requiredMessage: '',
												placeholder: '',
												disabled: false,
												clearable: true,
												customProps: {},
												extendProps: {},
												readonly: false,
												editable: false,
												startPlaceholder: '',
												endPlaceholder: '',
												format: 'YYYY-MM-DD',
												timestamp: false,
											},
											events: {
												onMounted: '',
												onChange: '',
												onFocus: '',
												onBlur: '',
											},
											name: '协议到期日',
											key: 'ea8idbgr',
											model: 'protocolEndDate',
											rules: [],
											novalid: {},
										},
									],
									type: 'col',
									options: {
										customClass: '',
										span: 12,
										offset: 0,
										push: 0,
										pull: 0,
										xs: 24,
										sm: 12,
										md: 12,
										lg: 12,
										xl: 12,
									},
									key: 'jubp28fg',
									rules: [],
								},
								{
									list: [
										{
											type: 'select',
											icon: 'icon-select',
											options: {
												options: [
													{
														value: '1',
														label: '中国银行',
													},
													{
														value: '2',
														label: '工商银行',
													},
													{
														value: '3',
														label: '农业银行',
													},
												],
												defaultValue: '',
												customClass: '',
												labelWidth: 100,
												isLabelWidth: false,
												hidden: false,
												dataBind: true,
												width: '',
												validatorCheck: false,
												validator: '',
												tip: '',
												remoteFunc: 'func_2at1ggmn',
												remoteOption: 'option_2at1ggmn',
												tableColumn: false,
												subform: false,
												labelWrap: true,
												required: true,
												requiredMessage: '',
												placeholder: '',
												disabled: false,
												clearable: false,
												customProps: {},
												extendProps: {},
												multiple: false,
												showLabel: true,
												remote: false,
												remoteType: 'datasource',
												filterable: false,
												remoteOptions: [],
												props: {
													value: 'value',
													label: 'label',
												},
											},
											events: {
												onMounted: '',
												onChange: '',
												onFocus: '',
												onBlur: '',
											},
											name: '扣款银行',
											key: 'c0ipvxao',
											model: 'protocolBankName',
											rules: [
												{
													required: true,
													message: '',
												},
											],
											novalid: {},
										},
									],
									type: 'col',
									options: {
										customClass: '',
										span: 12,
										offset: 0,
										push: 0,
										pull: 0,
										xs: 24,
										sm: 12,
										md: 12,
										lg: 12,
										xl: 12,
									},
									key: 'igde2fsf',
									rules: [],
								},
								{
									list: [
										{
											type: 'input',
											icon: 'icon-input',
											options: {
												defaultValue: '',
												customClass: '',
												labelWidth: 100,
												isLabelWidth: false,
												hidden: false,
												dataBind: true,
												width: '',
												validatorCheck: false,
												validator: '',
												tip: '',
												remoteFunc: 'func_kcwd0n0j',
												remoteOption: 'option_kcwd0n0j',
												tableColumn: false,
												subform: false,
												labelWrap: true,
												required: true,
												pattern: '',
												requiredMessage: '',
												dataType: '',
												dataTypeCheck: false,
												dataTypeMessage: '',
												patternCheck: false,
												patternMessage: '',
												placeholder: '',
												disabled: false,
												showPassword: false,
												clearable: false,
												maxlength: '',
												showWordLimit: false,
												customProps: {},
												extendProps: {},
											},
											events: {
												onMounted: '',
												onChange: '',
												onFocus: '',
												onBlur: '',
											},
											name: '银行账号',
											key: 'b1g9a92o',
											model: 'protocolBankAccount',
											rules: [
												{
													required: true,
													message: '',
												},
											],
											novalid: {},
										},
									],
									type: 'col',
									options: {
										customClass: '',
										span: 12,
										offset: 0,
										push: 0,
										pull: 0,
										xs: 24,
										sm: 12,
										md: 12,
										lg: 12,
										xl: 12,
									},
									key: '7nknv0tu',
									rules: [],
								},
							],
						},
					],
					type: 'group',
					icon: 'icon-fenzu',
					options: {
						defaultValue: {},
						customClass: '',
						labelWidth: 100,
						isLabelWidth: false,
						hidden: false,
						dataBind: true,
						width: '',
						validatorCheck: false,
						validator: '',
						tip: '',
						remoteFunc: 'func_g4vu90cd',
						remoteOption: 'option_g4vu90cd',
						tableColumn: false,
						subform: true,
						labelWrap: true,
					},
					events: {
						onMounted: '',
					},
					name: '服务协议',
					key: 'ze61w067',
					model: 'protocolItem',
					rules: [],
				},
			],
			type: 'subform',
			icon: 'icon-a-ziyuan25',
			options: {
				defaultValue: [],
				customClass: '',
				labelWidth: 100,
				isLabelWidth: false,
				hidden: false,
				dataBind: true,
				validatorCheck: false,
				validator: '',
				tip: '',
				remoteFunc: 'func_tjzt3ydp',
				remoteOption: 'option_tjzt3ydp',
				tableColumn: false,
				subform: false,
				labelWrap: true,
				required: false,
				disabled: false,
				paging: false,
				pageSize: 5,
				showControl: true,
				useTabsStyle: true,
				isAdd: true,
				isDelete: true,
			},
			events: {
				onMounted: '',
				onChange: '',
				onRowAdd: '',
				onRowRemove: '',
				onPageChange: '',
			},
			name: '服务协议组',
			key: 'tjzt3ydp',
			model: 'protocolList',
			rules: [],
		},
	],
	config: {
		customClass: '',
		labelWidth: 100,
		width: '100%',
		hideLabel: false,
		labelPosition: 'left',
		size: 'large',
		ui: 'element',
		layout: 'horizontal',
		hideErrorMessage: false,
		mobileVant: true,
		eventScript: [
			{
				name: 'mounted',
				key: 'mounted',
				func: '',
			},
			{
				name: 'refresh',
				key: 'refresh',
				func: '',
			},
			{
				type: 'rule',
				name: 'onFormChange',
				key: 'onFormChange',
			},
			{
				type: 'js',
				name: 'onMounted_a2fkvmks',
				key: 'a2fkvmks',
				rules: [
					{
						options: {
							condition: '',
							isCondition: true,
							field: '',
						},
						key: 'wizqm9q9',
						action: 'openDialog',
					},
					{
						options: {
							condition: '',
							isCondition: true,
							fields: ['group_vizdbi5z.input_801hb3du'],
							values: {
								'group_4ni72wmh.input_oyvg5eg5': 0,
								'group_vizdbi5z.input_801hb3du': '0',
							},
							valueTypes: {
								'group_4ni72wmh.input_oyvg5eg5': 'number',
							},
						},
						key: 'ds1mohe4',
						action: 'setData',
					},
				],
				func: 'return 2025',
			},
			{
				type: 'js',
				name: 'onMounted_a2fkvmks_copy',
				key: 'yvhi02g8',
				rules: [
					{
						options: {
							condition: '',
							isCondition: true,
							field: '',
						},
						key: 'wizqm9q9',
						action: 'openDialog',
					},
					{
						options: {
							condition: '',
							isCondition: true,
							fields: ['group_vizdbi5z.input_801hb3du'],
							values: {
								'group_4ni72wmh.input_oyvg5eg5': 0,
								'group_vizdbi5z.input_801hb3du': '0',
							},
							valueTypes: {
								'group_4ni72wmh.input_oyvg5eg5': 'number',
							},
						},
						key: 'ds1mohe4',
						action: 'setData',
					},
				],
				func: 'return 2025',
			},
		],
		dataSource: [],
		labelSuffix: false,
		styleSheets: '.font-bold{\n  font-weight: bold;\n}',
	},
} as UiFormConfig
