---
name: golden-age-author
description: Book writing system with 9-author council methodology for world-class manuscripts
---

# Golden Age Author System
## The 9-Author Council for World-Class Books

Transform from writer to author through a multi-agent system that brings 9 specialized perspectives to every manuscript.

## The 9-Author Council

### 1. The Visionary
**Role:** Big picture, paradigm-shifting ideas
**Question:** "What new world does this book create?"
**Focus:** Originality, impact, legacy

### 2. The Researcher
**Role:** Deep knowledge, credibility, citations
**Question:** "What evidence supports this?"
**Focus:** Facts, sources, accuracy

### 3. The Storyteller
**Role:** Narrative, emotion, engagement
**Question:** "Does this move the reader?"
**Focus:** Story arc, characters, tension

### 4. The Teacher
**Role:** Clarity, frameworks, understanding
**Question:** "Will readers learn this effectively?"
**Focus:** Structure, examples, exercises

### 5. The Editor
**Role:** Precision, flow, polish
**Question:** "Is every word earning its place?"
**Focus:** Language, rhythm, clarity

### 6. The Marketer
**Role:** Positioning, hook, audience
**Question:** "Will this title sell?"
**Focus:** Title, cover, description

### 7. The Reader
**Role:** Audience perspective, objections
**Question:** "What would a skeptic ask?"
**Focus:** Accessibility, relatability

### 8. The Artist
**Role:** Beauty, aesthetics, experience
**Question:** "Is this a pleasure to read?"
**Focus:** Typography, layout, white space

### 9. The Sage
**Role:** Wisdom, integration, truth
**Question:** "Does this serve the highest good?"
**Focus:** Ethics, depth, timelessness

## The Writing Process

### Phase 1: Vision (Council: Visionary, Sage)
- Define the book's transformation promise
- Identify the paradigm shift
- Set the legacy intention

### Phase 2: Research (Council: Researcher, Teacher)
- Gather evidence and sources
- Interview experts if needed
- Build knowledge foundation

### Phase 3: Structure (Council: Teacher, Storyteller)
- Create chapter outline
- Design narrative arc
- Plan teaching moments

### Phase 4: Draft (Council: Storyteller, Writer)
- Write ugly first draft
- Focus on flow, not perfection
- Capture all ideas

### Phase 5: Refine (Council: Editor, Reader)
- Multiple revision passes
- Kill your darlings
- Test with beta readers

### Phase 6: Polish (Council: Artist, Marketer)
- Final language refinement
- Format and design
- Prepare for market

### Phase 7: Launch (Council: Marketer, Visionary)
- Position for audience
- Create launch strategy
- Share with the world

## Quality Rubric (9 Dimensions)

| Dimension | Question | Score 1-10 |
|-----------|----------|------------|
| Vision | Does it shift paradigms? | |
| Research | Is it well-supported? | |
| Story | Does it engage emotionally? | |
| Teaching | Do readers learn effectively? | |
| Editing | Is language precise? | |
| Marketing | Will it attract readers? | |
| Reader | Does it address objections? | |
| Art | Is it beautiful to read? | |
| Wisdom | Does it serve truth? | |

**Target: 7+ on all dimensions, 9+ on 3 core dimensions**
