---
name: golden-circle
description: "Golden Circle framework implementation based on Simon Sinek's concept of Why, How, and What for creating meaningful projects and products. Use when Claude needs to develop projects with clear purpose, methodology, and implementation: (1) Starting with 'Why' to establish purpose and motivation, (2) Defining 'How' to outline methodology and approach, (3) Specifying 'What' to detail the tangible outcomes, (4) Ensuring alignment between all three circles for authentic value creation, or any other purpose-driven development operations."
---

# Golden Circle Framework Assistant

## Overview

The Golden Circle framework, popularized by Simon Sinek, consists of three concentric circles representing Why, How, and What. Great leaders and organizations think, act, and communicate from the inside out: starting with Why (purpose), then How (process/methodology), and finally What (products/services). This framework ensures that projects and products have authentic value and resonate deeply with users.

## Core Capabilities

### 1. Purpose-Driven Development
- Establish clear 'Why' - the purpose, cause, or belief behind the project
- Align goals with deeper meaning and user value
- Create compelling narratives that inspire action
- Define mission and vision statements

### 2. Methodology Design
- Develop 'How' - the specific processes, values, and differentiating factors
- Create implementation strategies that support the 'Why'
- Design workflows and methodologies that embody the purpose
- Establish principles and guidelines for execution

### 3. Tangible Outcomes
- Specify 'What' - the concrete deliverables, products, or services
- Ensure alignment between purpose, methodology, and outcomes
- Define measurable results that reflect the deeper purpose
- Create authentic value propositions

### 4. Alignment Verification
- Check consistency between Why, How, and What
- Identify gaps or misalignments in the framework
- Ensure authentic communication from inside-out
- Validate that the final product reflects the original purpose

## Golden Circle Framework

### The Three Circles

#### 1. WHY (The Center Circle)
The core purpose, cause, or belief that drives everything. This is:
- Your reason for existence beyond profit
- The cause you champion
- The change you want to see in the world
- The inspiration that motivates your team and resonates with customers

**Key Questions:**
- Why does this project/product exist?
- Why should anyone care about this?
- What deeper purpose does this serve?
- What cause or belief does this advance?

#### 2. HOW (The Middle Circle)
The specific processes, values, and differentiating factors that bring the Why to life:
- The guiding principles and values
- The unique approach or methodology
- The specific actions that manifest the Why
- The differentiating factors that set you apart

**Key Questions:**
- How do we bring our purpose to life?
- What specific processes embody our values?
- How do we differ from competitors?
- What principles guide our implementation?

#### 3. WHAT (The Outer Circle)
The tangible outcomes, products, or services that people can see, touch, and experience:
- The actual products or services
- The concrete deliverables
- The measurable outcomes
- The visible manifestations of your Why

**Key Questions:**
- What do we actually produce/deliver?
- What are the tangible results?
- What do customers see and experience?
- How do we measure success?

## Golden Circle Applications

### Project Initiation
```markdown
**WHY:**
- What is the deeper purpose of this project?
- What problem are we solving for humanity/our users?
- What change do we want to create in the world?
- Why should our team be passionate about this?

**HOW:**
- What principles will guide our development?
- What methodologies will we use to achieve our purpose?
- How will we differentiate our approach?
- What values will shape our implementation?

**WHAT:**
- What specific features will we build?
- What deliverables will we create?
- What metrics will we use to measure success?
- What tangible outcomes will users experience?
```

### Product Development
```markdown
**WHY:**
- What user pain point are we addressing at the deepest level?
- What meaningful change are we facilitating for users?
- Why does this product need to exist in the world?
- What belief about the world does this product represent?

**HOW:**
- What design principles will guide our product development?
- How will our product uniquely solve the problem?
- What user experience philosophy will we follow?
- What development methodology aligns with our purpose?

**WHAT:**
- What specific features will the product have?
- What technology stack will we use?
- What user interface will we create?
- What measurable benefits will users receive?
```

### Team Communication
```markdown
**WHY:**
- What mission are we collectively pursuing?
- What impact do we want to have on users/industry/world?
- Why should team members be excited to contribute?
- What shared values drive our collaboration?

**HOW:**
- How will we work together to achieve our goals?
- What team principles and processes will we follow?
- How will we maintain alignment with our purpose?
- What culture will support our mission?

**WHAT:**
- What specific roles and responsibilities will team members have?
- What deliverables will we produce together?
- What milestones will we achieve?
- What results will demonstrate our success?
```

## Golden Circle Analysis Framework

### Purpose Validation Checklist
- Does the 'Why' inspire and motivate?
- Is the purpose clear and compelling?
- Does it transcend product/service features?
- Would people support this cause even without knowing the specifics?

### Methodology Alignment Checklist
- Do the 'Hows' directly support the 'Why'?
- Are the processes and values consistent with the purpose?
- Do the methods differentiate us in meaningful ways?
- Do the approaches authentically reflect our beliefs?

### Outcome Authenticity Checklist
- Do the 'Whats' genuinely express the 'Why'?
- Are the deliverables consistent with our stated purpose?
- Do the results provide authentic value aligned with our mission?
- Would customers recognize the connection between our Why and What?

## Golden Circle Communication Patterns

### Inside-Out Communication (Effective)
Start with Why, then How, then What:
```markdown
"We believe that everyone deserves [WHY - the purpose]. That's why we [HOW - the approach]. And that's why we [WHAT - the product/service]."
```

### Example Pattern:
```markdown
"Apple believes in challenging the status quo and thinking differently (WHY). That's why they approach design and innovation with simplicity and elegance (HOW). And that's why they create products like the iPhone, Mac, and iPad (WHAT)."
```

### Outside-In Communication (Less Effective)
Starting with What, then How, then Why often fails to inspire:
```markdown
"We make products like [WHAT]. We do this by [HOW]. We believe [WHY]."
```

## Golden Circle Integration with Other Skills

### With Project Management
- Start every project with Why definition
- Align methodologies with the core purpose
- Ensure deliverables reflect the deeper mission
- Regular alignment checks throughout the project lifecycle

### With Product Development
- Define product purpose before features
- Design methodology around user values
- Build features that authentically serve the purpose
- Measure success by impact on the core mission

### With Team Leadership
- Communicate vision (Why) before tasks (What)
- Explain methodology (How) in context of purpose
- Connect daily activities to the larger mission
- Foster team buy-in through shared purpose

## Resources

This skill includes resources for different aspects of Golden Circle implementation:

### scripts/
Python and shell scripts for Golden Circle analysis and validation.

**Examples:**
- `golden_circle_analysis.py` - Script to analyze alignment between Why, How, and What
- `purpose_validator.py` - Script to validate the authenticity of a project's purpose
- `alignment_checker.py` - Script to check consistency across the three circles
- `communication_generator.py` - Script to generate inside-out communication messages

### references/
Detailed documentation and reference materials for Golden Circle applications.

**Examples:**
- `case_studies.md` - Real-world examples of successful Golden Circle implementations
- `pitfalls.md` - Common mistakes and how to avoid them
- `measurement_framework.md` - How to measure success in each circle
- `leadership_examples.md` - Famous leaders who exemplify the Golden Circle

### assets/
Templates and frameworks for implementing the Golden Circle in various contexts.

**Examples:**
- `templates/project-template/` - Golden Circle project initiation template
- `templates/product-brief/` - Product development template with Golden Circle focus
- `templates/team-charter/` - Team alignment template based on Golden Circle
- `templates/communication-framework/` - Internal and external communication template

**Any unneeded directories can be deleted.** Not every skill requires all three types of resources.
