# Google-Search-Docs - Appearance

**Pages:** 58

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#video-result

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#image-result-attribution

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#visible-url

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Video SEO best practices

**URL:** https://developers.google.com/search/docs/appearance/video#help-google-find

**Contents:**
- Video SEO best practices
- Help Google find your videos
- Ensure your videos can be indexed
  - Use a supported video file type
  - Use stable URLs
  - Create a dedicated watch page for each video
  - Using third-party embedded players
- Which URL is which?
  - Provide a high-quality video thumbnail
  - Provide consistent and unique information in your structured data

If you have videos on your site, following these video SEO best practices can help more people find your site through video results on Google. Videos can appear in several different places on Google, including the main search results page, Video mode, Google Images, and Discover:

Optimize your videos to appear on Google by following these best practices:

The technical requirements for getting your content in Google's search results applies to videos too. There are some additional requirements to making your videos eligible to be discovered, crawled, and indexed by Google Search:

To make it easier for Google to find your videos, we recommend providing metadata about the video. We support structured data, video sitemaps, and the Open Graph protocol (OGP).

To be eligible for video features, a video must meet the following indexing requirements:

To be eligible for video features, use a supported video file type. Google can process the following video file types: 3GP, 3G2, ASF, AVI, DivX, M2V, M3U, M3U8, M4V, MKV, MOV, MP4, MPEG, OGV, QVT, RAM, RM, VOB, WebM, WMV, and XAP.

Data URLs aren't supported.

Some CDNs use quickly expiring URLs. If the video's thumbnail URL changes too often, Google may not be able to successfully index your videos. To make sure your videos can be indexed, use a single unique and stable thumbnail URL for each video.

To make your videos eligible for specific features like key moments and video previews, make sure your video files are available at stable URLs too. This also helps Google discover and process the videos consistently, confirm they are still available, and collect signals on the videos.

If you are concerned about bad actors (for example, hackers or spammers) accessing your content, you can verify Googlebot before displaying a stable version of your media URLs. For example, you can choose to serve the contentUrl property only to trusted clients like Googlebot, whereas other clients accessing your page wouldn't see that field. With this setup, only trusted clients will be able to access the location of your video file.

To be eligible for video features (including video results on the main search results page, Video mode, Key Moments, the Live Badge, and other rich formats), create a dedicated watch page for each video, if it makes sense for your business.

A watch page's main purpose is to show users a single video. The following pages are watch pages because watching an individual video is the main reason the user is

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
    xmlns:video="http://www.google.com/schemas/sitemap-video/1.1">
<url>
<loc>https://example.com/videos/some_video_landing_page.html</loc>
  <video:video>
  ...
```

Example 2 (unknown):
```unknown
<iframe src="https://example.com/videoplayer.php?video=123" width="640" height="360" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe>
```

Example 3 (unknown):
```unknown
"embedUrl": "https://example.com/videoplayer.php?video=123"
```

Example 4 (unknown):
```unknown
<video:player_loc>https://example.com/videoplayer.php?video=123</video:player_loc>
```

---

## Video (VideoObject, Clip, BroadcastEvent) structured data

**URL:** https://developers.google.com/search/docs/appearance/structured-data/video

**Contents:**
- Video (VideoObject, Clip, BroadcastEvent) structured data
- How to add structured data
- Examples
  - Standard video result
  - LIVE badge
  - Clip
  - SeekToAction
- Guidelines
  - LIVE badge guidelines
  - Best practices for marking timestamps on YouTube

While Google tries to automatically understand details about your video, you can influence the information that's shown in video results, such as the description, thumbnail URL, upload date, and duration, by marking up your video with VideoObject. Adding video structured data to your watch pages can also make it easier for Google to find your video. Videos can appear in several different places on Google, including the main search results page, Video mode, Google Images, and Google Discover.

Based on how you mark up your watch page, your videos may also be eligible for the following specific video features:

LIVE badge: Get a LIVE badge added to your video by marking your video with BroadcastEvent. The LIVE badge can be applied to any public video that is live-streamed for any length of time. Here are a few examples:

Make sure you follow the LIVE badge guidelines and use the Indexing API to make sure Google crawls your page at the right time.

The key moments feature is a way for users to navigate video segments like chapters in a book, which can help users engage more deeply with your content. Google Search tries to automatically detect the segments in your video and show key moments to users, without any effort on your part. Alternatively, you can tell Google about the important points of your video. We will prioritize key moments set by you, either through structured data or the YouTube description.

To opt out of the key moments feature completely (including any efforts Google may make to show key moments automatically for your video), use the nosnippet meta tag.

Structured data is a standardized format for providing information about a page and classifying the page content. If you're new to structured data, you can learn more about how structured data works.

Here's an overview of how to build, test, and release structured data.

Here's an example of a single VideoObject.

Here's an example of VideoObject and BroadcastEvent.

Here's an example of VideoObject and Clip.

Here's an example of a single VideoObject that includes the additional properties needed for SeekToAction markup.

For your video structured data to be eligible for usage in Google Search, you must follow the Search Essentials, general structured data guidelines, and video indexing requirements.

In addition, we recommend that you check out these guidelines if they apply to your video content:

If you're adding BroadcastEvent to livestream videos, follow these guidelines:

If your vi

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
<html>
  <head>
    <title>Introducing the self-driving bicycle in the Netherlands</title>
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "VideoObject",
      "name": "Introducing the self-driving bicycle in the Netherlands",
      "description": "This spring, Google is introducing the self-driving bicycle in Amsterdam, the world's premier cycling city. The Dutch cycle more than any other nation in the world, almost 900 kilometres per year per person, amounting to over 15 billion kilometres annually. The self-driving bicycle enables safe na
...
```

Example 2 (unknown):
```unknown
<html itemscope itemprop="VideoObject" itemtype="https://schema.org/VideoObject">
<head>
  <title itemprop="name">Introducing the self-driving bicycle in the Netherlands</title>
</head>
<body>
  <meta itemprop="uploadDate" content="2024-03-31T08:00:00+08:00" />
  <meta itemprop="duration" content="PT1M54S" />
  <p itemprop="description">This spring, Google is introducing the self-driving bicycle in Amsterdam, the world's premier cycling city. The Dutch cycle more than any other nation in the world, almost 900 kilometres per year per person, amounting to over 15 billion kilometres annually. The
...
```

Example 3 (unknown):
```unknown
<html>
  <head>
    <title>Bald Eagle at the Park - Livestream</title>
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "VideoObject",
      "contentURL": "https://example.com/bald-eagle-at-the-park.mp4",
      "description": "Bald eagle at the park livestream.",
      "duration": "PT37M14S",
      "embedUrl": "https://example.com/bald-eagle-at-the-park",
      "expires": "2024-10-30T14:37:14+00:00",
      "regionsAllowed": "US",
      "interactionStatistic": {
        "@type": "InteractionCounter",
        "interactionType": { "@type": "Watc
...
```

Example 4 (unknown):
```unknown
<html itemscope itemprop="VideoObject" itemtype="https://schema.org/VideoObject">
<head>
  <title itemprop="name">Bald Eagle at the Park - Livestream</title>
</head>
<body>
  <meta itemprop="uploadDate" content="2024-10-27T14:00:00+00:00" />
  <meta itemprop="duration" content="PT37M14S" />
  <p itemprop="description">Bald eagle at the park livestream.</p>
  <div itemprop="interactionStatistic" itemtype="https://schema.org/InteractionCounter" itemscope>
    <meta itemprop="userInteractionCount" content="4756" />
    <meta itemprop="interactionType" itemtype="https://schema.org/WatchAction" />

...
```

---

## Google image SEO best practices

**URL:** https://developers.google.com/search/docs/appearance/google-images#use-descriptive-alt-text

**Contents:**
- Google image SEO best practices
- Help us discover and index your images
  - Use HTML image elements to embed images
  - Use an image sitemap
  - Responsive images
  - Use supported image formats
  - Optimize for speed and quality
- Optimize the image landing pages
  - Check your page title and description
  - Add structured data

Google provides several Search features and products that help users visually discover information on the web, such as the text result images, Google Discover, and Google Images. While each feature and product looks different, the general recommendations for getting images to appear in them is the same.

You can optimize your images to appear in Google's search results by following these best practices:

The technical requirements for getting your content in Google's search results applies to images too. Since images are a substantially different format compared to HTML, it means there are additional requirements for getting images indexed; for example, finding the images on your site is different, and the presentation of the images also influences whether an image is indexed at all, and for the right keywords.

Using standard HTML image elements helps crawlers find and process images. Google can find images in src attribute of <img> element (even when it's a child of other elements, such as the <picture> element). Google doesn't index CSS images.

You can provide the URL of images we might not have otherwise discovered by submitting an image sitemap.

Unlike regular sitemaps, you can include URLs from other domains in the <image:loc> elements of the image sitemaps. This lets you use CDNs (content delivery networks) to host images. If you're using a CDN, we encourage you to verify ownership of the CDN's domain name in Search Console so that we can inform you of any crawl errors that we may find.

Designing responsive web pages leads to better user experience, since people can access them across a plethora of device types. Refer to our guide to responsive images to learn about the best practices for handling images on your website.

Web pages use the <picture> element or the srcset attribute of an img element to specify responsive images. However, some browsers and crawlers don't understand these attributes. We recommend that you always specify a fallback URL using the src attribute.

The srcset attribute allows specifying different versions of the same image, specifically for different screen sizes. For example:

The <picture> element is a container that is used to group different <source> versions of the same image. It offers a fallback approach so the browser can choose the right image depending on device capabilities, like pixel density and screen size. The picture element also comes in handy for using new image formats with built-in graceful degradatio

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
<img
  srcset="maine-coon-nap-320w.jpg 320w, maine-coon-nap-480w.jpg 480w, maine-coon-nap-800w.jpg 800w"
  sizes="(max-width: 320px) 280px, (max-width: 480px) 440px, 800px"
  src="maine-coon-nap-800w.jpg"
  alt="A watercolor illustration of a maine coon napping leisurely in front of a fireplace">
```

Example 2 (unknown):
```unknown
<picture>
  <source type="image/svg+xml" srcset="pyramid.svg">
  <source type="image/webp" srcset="pyramid.webp">
  <img src="pyramid.png" alt="An 1800s oil painting of The Great Pyramid">
</picture>
```

Example 3 (unknown):
```unknown
<img src="data:image/svg+xml;base64,[data]">
```

Example 4 (unknown):
```unknown
<svg aria-labelledby="svgtitle1">
  <title id="svgtitle1">Googlebot wearing an apron and chef hat, struggling to make pancakes on the stovetop</title>
</svg>
```

---

## Influencing your title links in search results

**URL:** https://developers.google.com/search/docs/appearance/title-link#page-titles

**Contents:**
- Influencing your title links in search results
- Best practices for influencing title links
- How title links in Google Search are created
- Common issues and how Google manages them
  - Half-empty <title> elements
  - Obsolete <title> elements
  - Inaccurate <title> elements
  - Micro-boilerplate text in <title> elements
  - No clear main title
  - Mismatch of writing system or language used in <title> elements

A title link is the title of a search result on Google Search and other properties (for example, Google News) that links to the web page. Google uses a number of different sources to automatically determine the title link, but you can indicate your preferences by following our best practices for influencing title links.

How to make crispy fried eggs

Title links are critical to giving users a quick insight into the content of a result and why it's relevant to their query. It's often the primary piece of information people use to decide which result to click, so it's important to use high-quality title text on your web pages.

One solution is to dynamically update the <title> element to better reflect the actual content of the page. For example, include the words "video" and "lyrics" only if that particular page contains video or lyrics.

Google's generation of title links on the Google Search results page is completely automated and takes into account both the content of a page and references to it that appear on the web. The goal of the title link is to best represent and describe each result.

Google Search uses the following sources to automatically determine title links:

Keep in mind that Google has to recrawl and reprocess the page to notice updates to these sources, which may take a few days to a few weeks. If you've made changes, you can request that Google recrawl your pages.

While we can't manually change title links for individual sites, we're always working to make them as relevant as possible. You can help improve the quality of the title link that's displayed for your page by following the best practices.

Here are the most common issues we see with title links in search results. To avoid these issues, follow the best practices for influencing title links.

When part of the title text is missing. For example:

Google Search looks at information in header elements or other large and prominent text on the page to produce a title link:

When the same page is used year-after-year for recurring information, but the <title> element didn't get updated to reflect the latest date. For example:

In this example, the page has a large, visible title that says "2021 admissions criteria", and the <title> element wasn't updated to the current date. Google Search may detect this inconsistency and uses the right date from the visible title on the page in the title link:

When the <title> elements don't accurately reflect what the page is about. For example,

*[Content truncated]*

---

## Understanding page experience in Google Search results

**URL:** https://developers.google.com/search/docs/appearance/page-experience

**Contents:**
- Understanding page experience in Google Search results
- Self-assess your content's page experience
- Page experience resources
- FAQ
  - Is there a single "page experience signal" that Google Search uses for ranking?
  - What aspects of page experience are used in ranking?
  - Is page experience evaluated on a site-wide or page-specific basis?
  - How important is page experience to ranking success?
- Recent updates on our blog

Google's core ranking systems look to reward content that provides a good page experience. Site owners seeking to be successful with our systems should not focus on only one or two aspects of page experience. Instead, check if you're providing an overall great page experience across many aspects.

Answering yes to the following questions means you're probably on track in providing a good page experience:

These questions don't encompass all page experience aspects to consider. However, questions like these, and consulting the following resources, may help you align with providing an overall good page experience.

Here are some resources that can help you measure, monitor, and optimize your page experience:

There is no single signal. Our core ranking systems look at a variety of signals that align with overall page experience.

Core Web Vitals are used by our ranking systems. We recommend site owners achieve good Core Web Vitals for success with Search and to ensure a great user experience generally. Keep in mind that getting good results in reports like Search Console's Core Web Vitals report or third-party tools doesn't guarantee that your pages will rank at the top of Google Search results; there's more to great page experience than Core Web Vitals scores alone. These scores are meant to help you to improve your site for your users overall, and trying to get a perfect score just for SEO reasons may not be the best use of your time.

Beyond Core Web Vitals, other page experience aspects don't directly help your website rank higher in search results. However, they can make your website more satisfying to use, which is generally aligned with what our ranking systems seek to reward. Therefore it's still worth working to improve page experience overall.

Our core ranking systems generally evaluate content on a page-specific basis, including when understanding aspects related to page experience. However, we do have some site-wide assessments.

Google Search always seeks to show the most relevant content, even if the page experience is sub-par. But for many queries, there is lots of helpful content available. Having a great page experience can contribute to success in Search, in such cases.

Here's everything we've announced about page experience on the Google Search Central blog:

Except as otherwise noted, the content of this page is licensed under the Creative Commons Attribution 4.0 License, and code samples are licensed under the Apache 2.0 License. For d

*[Content truncated]*

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#image-thumbnail

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Google image SEO best practices

**URL:** https://developers.google.com/search/docs/appearance/google-images#descriptive-alt-text

**Contents:**
- Google image SEO best practices
- Help us discover and index your images
  - Use HTML image elements to embed images
  - Use an image sitemap
  - Responsive images
  - Use supported image formats
  - Optimize for speed and quality
- Optimize the image landing pages
  - Check your page title and description
  - Add structured data

Google provides several Search features and products that help users visually discover information on the web, such as the text result images, Google Discover, and Google Images. While each feature and product looks different, the general recommendations for getting images to appear in them is the same.

You can optimize your images to appear in Google's search results by following these best practices:

The technical requirements for getting your content in Google's search results applies to images too. Since images are a substantially different format compared to HTML, it means there are additional requirements for getting images indexed; for example, finding the images on your site is different, and the presentation of the images also influences whether an image is indexed at all, and for the right keywords.

Using standard HTML image elements helps crawlers find and process images. Google can find images in src attribute of <img> element (even when it's a child of other elements, such as the <picture> element). Google doesn't index CSS images.

You can provide the URL of images we might not have otherwise discovered by submitting an image sitemap.

Unlike regular sitemaps, you can include URLs from other domains in the <image:loc> elements of the image sitemaps. This lets you use CDNs (content delivery networks) to host images. If you're using a CDN, we encourage you to verify ownership of the CDN's domain name in Search Console so that we can inform you of any crawl errors that we may find.

Designing responsive web pages leads to better user experience, since people can access them across a plethora of device types. Refer to our guide to responsive images to learn about the best practices for handling images on your website.

Web pages use the <picture> element or the srcset attribute of an img element to specify responsive images. However, some browsers and crawlers don't understand these attributes. We recommend that you always specify a fallback URL using the src attribute.

The srcset attribute allows specifying different versions of the same image, specifically for different screen sizes. For example:

The <picture> element is a container that is used to group different <source> versions of the same image. It offers a fallback approach so the browser can choose the right image depending on device capabilities, like pixel density and screen size. The picture element also comes in handy for using new image formats with built-in graceful degradatio

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
<img
  srcset="maine-coon-nap-320w.jpg 320w, maine-coon-nap-480w.jpg 480w, maine-coon-nap-800w.jpg 800w"
  sizes="(max-width: 320px) 280px, (max-width: 480px) 440px, 800px"
  src="maine-coon-nap-800w.jpg"
  alt="A watercolor illustration of a maine coon napping leisurely in front of a fireplace">
```

Example 2 (unknown):
```unknown
<picture>
  <source type="image/svg+xml" srcset="pyramid.svg">
  <source type="image/webp" srcset="pyramid.webp">
  <img src="pyramid.png" alt="An 1800s oil painting of The Great Pyramid">
</picture>
```

Example 3 (unknown):
```unknown
<img src="data:image/svg+xml;base64,[data]">
```

Example 4 (unknown):
```unknown
<svg aria-labelledby="svgtitle1">
  <title id="svgtitle1">Googlebot wearing an apron and chef hat, struggling to make pancakes on the stovetop</title>
</svg>
```

---

## Sitelinks

**URL:** https://developers.google.com/search/docs/appearance/sitelinks#sitelinks-best-practices

**Contents:**
- Sitelinks
- Sitelinks best practices

Sitelinks are links from the same domain that are clustered together under a text result. Our systems analyze the link structure of your site to find shortcuts that will save users time and allow them to quickly find the information they're looking for.

Pet Paradise: Food, Accessories, and Supplies

Aquariums and accessories

We only show sitelinks for results when we think they'll be useful to the user. If the structure of your site doesn't allow our algorithms to find good sitelinks, or we don't think that the sitelinks for your site are relevant for the user's query, we won't show them.

At the moment, sitelinks are automated. We're always working to improve our sitelinks algorithms, and we may incorporate site owner input in the future. There are best practices you can follow, however, to improve the quality of your sitelinks.

If you need to remove a sitelink, consider removing the page from your site or using noindex.

Except as otherwise noted, the content of this page is licensed under the Creative Commons Attribution 4.0 License, and code samples are licensed under the Apache 2.0 License. For details, see the Google Developers Site Policies. Java is a registered trademark of Oracle and/or its affiliates.

Last updated 2025-02-04 UTC.

---

## General structured data guidelines

**URL:** https://developers.google.com/search/docs/appearance/structured-data/sd-policies

**Contents:**
- General structured data guidelines
- Technical guidelines
  - Format
  - Access
- Quality guidelines
  - Content
  - Relevance
  - Completeness
  - Location
  - Specificity

To be eligible for rich result appearance in Google Search results, structured data shouldn't violate the Content policies for Google Search (which include our spam policies). In addition, this page details the general guidelines that apply to all structured data: they must be followed in order to be eligible for appearance as a rich result in Google Search.

If your page contains a structured data issue, it can result in a manual action. A structured data manual action means that a page loses eligibility for appearance as a rich result; it doesn't affect how the page ranks in Google web search. To check if you have a manual action, open the Manual Actions report in Search Console.

Important: Google does not guarantee that your structured data will show up in search results, even if your page is marked up correctly according to the Rich Results Test. Here are some common reasons why:

You can test compliance with technical guidelines using the Rich Results Test and the URL Inspection tool, which catch most technical errors.

In order to be eligible for rich results, mark up your site's pages using one of three supported formats:

Do not block your structured data pages to Googlebot using robots.txt, noindex, or any other access control methods.

These quality guidelines are not easily testable using an automated tool. Violating a quality guideline can prevent syntactically correct structured data from being displayed as a rich result in Google Search, or possibly cause it to be marked as spam.

Your structured data must be a true representation of the page content. Here are some examples of irrelevant data:

Multiple items on a page means that there is more than one kind of thing on a page. For example, a page could contain a recipe, a video that shows how to make that recipe, and breadcrumb information for how people can discover that recipe. All of this user-visible information can also be marked up with structured data, which makes it easier for search engines like Google Search to understand the information on a page. When you add more items that apply to a page, Google Search has a fuller picture of what the page is about and can display that page in different search features.

Google Search understands multiple items on a page, whether you nest the items or specify each item individually: Nesting: When there is one main item, and additional items are grouped under the main item. This is particularly helpful when grouping related items (for example, 

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
<html>
  <head>
    <title>How To Make Banana Bread</title>
    <script type="application/ld+json">
    {
      "@context": "https://schema.org/",
      "@type": "Recipe",
      "name": "Banana Bread Recipe",
      "description": "The best banana bread recipe you'll ever find! Learn how to use up all those extra bananas.",
      "aggregateRating": {
        "@type": "AggregateRating",
        "ratingValue": 4.7,
        "ratingCount": 123
      },
      "video": {
        "@type": "VideoObject",
        "name": "How To Make Banana Bread",
        "description": "This is how you make banana bre
...
```

Example 2 (unknown):
```unknown
<html>
  <head>
    <title>How To Make Banana Bread</title>
    <script type="application/ld+json">
    [{
      "@context": "https://schema.org/",
      "@type": "Recipe",
      "name": "Banana Bread Recipe",
      "description": "The best banana bread recipe you'll ever find! Learn how to use up all those extra bananas."
    },
    {
      "@context": "https://schema.org",
      "@type": "BreadcrumbList",
      "itemListElement": [{
        "@type": "ListItem",
        "position": 1,
        "name": "Recipes",
        "item": "https://example.com/recipes"
      },{
        "@type": "ListItem
...
```

---

## Breadcrumb (BreadcrumbList) structured data

**URL:** https://developers.google.com/search/docs/appearance/structured-data/breadcrumb

**Contents:**
- Breadcrumb (BreadcrumbList) structured data
- Feature availability
- How to add structured data
- Examples
  - Single breadcrumb trail
  - JSON-LD
  - RDFa
  - Microdata
  - HTML
  - Multiple breadcrumb trail

A breadcrumb trail on a page indicates the page's position in the site hierarchy, and it may help users understand and explore a site effectively. A user can navigate all the way up in the site hierarchy, one level at a time, by starting from the last breadcrumb in the breadcrumb trail.

This feature is available on desktop in all regions and languages where Google Search is available.

Structured data is a standardized format for providing information about a page and classifying the page content. If you're new to structured data, you can learn more about how structured data works.

Here's an overview of how to build, test, and release structured data.

Google Search uses breadcrumb markup in the body of a web page to categorize the information from the page in search results. Often, as illustrated in following use cases, users can arrive at a page from very different types of search queries. While each search may return the same web page, the breadcrumb categorizes the content within the context of the Google Search query. The page for the winners of a fictional book award might use the following breadcrumb trails:

If there is only one breadcrumb trail that can lead to the page, the page could specify the following breadcrumb trail:

Books › Science Fiction › Award Winners

Here's an example in JSON-LD to support that breadcrumb:

Here's an example in RDFa to support that breadcrumb:

Here's an example in Microdata to support that breadcrumb:

Here's an example of an HTML breadcrumb block within the page as part of the visual design.

If there are multiple ways to navigate to a page on your site, you can specify multiple breadcrumb trails for a single page. Here's one breadcrumb trail that leads to a page for award winning books:

Books › Science Fiction › Award Winners

Here's the another breadcrumb trail that leads to the same page:

Literature › Award Winners

Here's the example JSON-LD that supports multiple breadcrumb trails:

Here's the example RDFa that supports multiple breadcrumb trails:

Here's the example Microdata that supports multiple breadcrumb trails:

Here's an example of an HTML breadcrumb block within the page as part of the visual design.

You must follow these guidelines to be eligible to appear with breadcrumbs in Google Search.

We recommend providing breadcrumbs that represent a typical user path to a page, instead of mirroring the URL structure. It is not required to include a breadcrumb ListItem for the top level path (your sit

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
<html>
  <head>
    <title>Award Winners</title>
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "BreadcrumbList",
      "itemListElement": [{
        "@type": "ListItem",
        "position": 1,
        "name": "Books",
        "item": "https://example.com/books"
      },{
        "@type": "ListItem",
        "position": 2,
        "name": "Science Fiction",
        "item": "https://example.com/books/sciencefiction"
      },{
        "@type": "ListItem",
        "position": 3,
        "name": "Award Winners"
      }]
    }
    </script>
  </
...
```

Example 2 (unknown):
```unknown
<html>
  <head>
    <title>Award Winners</title>
  </head>
  <body>
    <ol vocab="https://schema.org/" typeof="BreadcrumbList">
      <li property="itemListElement" typeof="ListItem">
        <a property="item" typeof="WebPage"
            href="https://example.com/books">
          <span property="name">Books</span></a>
        <meta property="position" content="1">
      </li>
      ›
      <li property="itemListElement" typeof="ListItem">
        <a property="item" typeof="WebPage"
            href="https://example.com/books/sciencefiction">
          <span property="name">Science Fiction<
...
```

Example 3 (unknown):
```unknown
<html>
  <head>
    <title>Award Winners</title>
  </head>
  <body>
    <ol itemscope itemtype="https://schema.org/BreadcrumbList">
      <li itemprop="itemListElement" itemscope
          itemtype="https://schema.org/ListItem">
        <a itemprop="item" href="https://example.com/books">
            <span itemprop="name">Books</span></a>
        <meta itemprop="position" content="1" />
      </li>
      ›
      <li itemprop="itemListElement" itemscope
          itemtype="https://schema.org/ListItem">
        <a itemscope itemtype="https://schema.org/WebPage"
           itemprop="item" itemid=
...
```

Example 4 (unknown):
```unknown
<html>
  <head>
    <title>Award Winners</title>
  </head>
  <body>
    <ol>
      <li>
        <a href="https://www.example.com/books">Books</a>
      </li>
      <li>
        <a href="https://www.example.com/sciencefiction">Science Fiction</a>
      </li>
      <li>
        Award Winners
      </li>
    </ol>
  </body>
</html>
```

---

## Google image SEO best practices

**URL:** https://developers.google.com/search/docs/appearance/google-images#help-us-discover-all-your-images

**Contents:**
- Google image SEO best practices
- Help us discover and index your images
  - Use HTML image elements to embed images
  - Use an image sitemap
  - Responsive images
  - Use supported image formats
  - Optimize for speed and quality
- Optimize the image landing pages
  - Check your page title and description
  - Add structured data

Google provides several Search features and products that help users visually discover information on the web, such as the text result images, Google Discover, and Google Images. While each feature and product looks different, the general recommendations for getting images to appear in them is the same.

You can optimize your images to appear in Google's search results by following these best practices:

The technical requirements for getting your content in Google's search results applies to images too. Since images are a substantially different format compared to HTML, it means there are additional requirements for getting images indexed; for example, finding the images on your site is different, and the presentation of the images also influences whether an image is indexed at all, and for the right keywords.

Using standard HTML image elements helps crawlers find and process images. Google can find images in src attribute of <img> element (even when it's a child of other elements, such as the <picture> element). Google doesn't index CSS images.

You can provide the URL of images we might not have otherwise discovered by submitting an image sitemap.

Unlike regular sitemaps, you can include URLs from other domains in the <image:loc> elements of the image sitemaps. This lets you use CDNs (content delivery networks) to host images. If you're using a CDN, we encourage you to verify ownership of the CDN's domain name in Search Console so that we can inform you of any crawl errors that we may find.

Designing responsive web pages leads to better user experience, since people can access them across a plethora of device types. Refer to our guide to responsive images to learn about the best practices for handling images on your website.

Web pages use the <picture> element or the srcset attribute of an img element to specify responsive images. However, some browsers and crawlers don't understand these attributes. We recommend that you always specify a fallback URL using the src attribute.

The srcset attribute allows specifying different versions of the same image, specifically for different screen sizes. For example:

The <picture> element is a container that is used to group different <source> versions of the same image. It offers a fallback approach so the browser can choose the right image depending on device capabilities, like pixel density and screen size. The picture element also comes in handy for using new image formats with built-in graceful degradatio

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
<img
  srcset="maine-coon-nap-320w.jpg 320w, maine-coon-nap-480w.jpg 480w, maine-coon-nap-800w.jpg 800w"
  sizes="(max-width: 320px) 280px, (max-width: 480px) 440px, 800px"
  src="maine-coon-nap-800w.jpg"
  alt="A watercolor illustration of a maine coon napping leisurely in front of a fireplace">
```

Example 2 (unknown):
```unknown
<picture>
  <source type="image/svg+xml" srcset="pyramid.svg">
  <source type="image/webp" srcset="pyramid.webp">
  <img src="pyramid.png" alt="An 1800s oil painting of The Great Pyramid">
</picture>
```

Example 3 (unknown):
```unknown
<img src="data:image/svg+xml;base64,[data]">
```

Example 4 (unknown):
```unknown
<svg aria-labelledby="svgtitle1">
  <title id="svgtitle1">Googlebot wearing an apron and chef hat, struggling to make pancakes on the stovetop</title>
</svg>
```

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#upload-date

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Video SEO best practices

**URL:** https://developers.google.com/search/docs/appearance/video#troubleshoot

**Contents:**
- Video SEO best practices
- Help Google find your videos
- Ensure your videos can be indexed
  - Use a supported video file type
  - Use stable URLs
  - Create a dedicated watch page for each video
  - Using third-party embedded players
- Which URL is which?
  - Provide a high-quality video thumbnail
  - Provide consistent and unique information in your structured data

If you have videos on your site, following these video SEO best practices can help more people find your site through video results on Google. Videos can appear in several different places on Google, including the main search results page, Video mode, Google Images, and Discover:

Optimize your videos to appear on Google by following these best practices:

The technical requirements for getting your content in Google's search results applies to videos too. There are some additional requirements to making your videos eligible to be discovered, crawled, and indexed by Google Search:

To make it easier for Google to find your videos, we recommend providing metadata about the video. We support structured data, video sitemaps, and the Open Graph protocol (OGP).

To be eligible for video features, a video must meet the following indexing requirements:

To be eligible for video features, use a supported video file type. Google can process the following video file types: 3GP, 3G2, ASF, AVI, DivX, M2V, M3U, M3U8, M4V, MKV, MOV, MP4, MPEG, OGV, QVT, RAM, RM, VOB, WebM, WMV, and XAP.

Data URLs aren't supported.

Some CDNs use quickly expiring URLs. If the video's thumbnail URL changes too often, Google may not be able to successfully index your videos. To make sure your videos can be indexed, use a single unique and stable thumbnail URL for each video.

To make your videos eligible for specific features like key moments and video previews, make sure your video files are available at stable URLs too. This also helps Google discover and process the videos consistently, confirm they are still available, and collect signals on the videos.

If you are concerned about bad actors (for example, hackers or spammers) accessing your content, you can verify Googlebot before displaying a stable version of your media URLs. For example, you can choose to serve the contentUrl property only to trusted clients like Googlebot, whereas other clients accessing your page wouldn't see that field. With this setup, only trusted clients will be able to access the location of your video file.

To be eligible for video features (including video results on the main search results page, Video mode, Key Moments, the Live Badge, and other rich formats), create a dedicated watch page for each video, if it makes sense for your business.

A watch page's main purpose is to show users a single video. The following pages are watch pages because watching an individual video is the main reason the user is

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
    xmlns:video="http://www.google.com/schemas/sitemap-video/1.1">
<url>
<loc>https://example.com/videos/some_video_landing_page.html</loc>
  <video:video>
  ...
```

Example 2 (unknown):
```unknown
<iframe src="https://example.com/videoplayer.php?video=123" width="640" height="360" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe>
```

Example 3 (unknown):
```unknown
"embedUrl": "https://example.com/videoplayer.php?video=123"
```

Example 4 (unknown):
```unknown
<video:player_loc>https://example.com/videoplayer.php?video=123</video:player_loc>
```

---

## Provide a site name to Google Search

**URL:** https://developers.google.com/search/docs/appearance/site-names

**Contents:**
- Provide a site name to Google Search
- Feature availability
- How site names in Google Search are created
- Choosing your site name
- How to add a site name with structured data
  - Follow the guidelines
    - Technical guidelines
  - Add required site name properties
    - JSON-LD
    - Microdata

When Google lists a page in search results, it shows the name of the site the page comes from. This is called the site name. Note that the site name is different from the per-page title links (title links are specific to each web page, whereas the site name is for the entire site).

How to make toast in a pan

Site names are available in all languages where Google Search is available, on both mobile and desktop. Site names can appear for domain-level and subdomain-level sites (learn more in the technical guidelines).

Google's generation of site names on the Google Search results page is completely automated and takes into account content from a site's home page and references to it that appear on the web. The goal of the site name in Google Search is to best represent and describe the source of each result.

To indicate your site name preference, add WebSite structured data to your home page. Our site name system will also consider content in og:site_name, <title>, heading elements, and other text on a home page. However, WebSite structured data is most important, if you want to specify a preference.

While we can't manually change automatically selected site names, you can indicate alternatives for our automated system to consider if your primary preference isn't selected.

Structured data is a standardized format for providing information about a page and classifying the page content. If you're new to structured data, you can learn more about how structured data works.

This section goes over the technical guidelines, required properties, and how to add and test site name structured data.

To help Google better understand your site name, make sure you follow the Search Essentials, General structured data guidelines, guidelines for choosing your site name, and the following technical guidelines:

Add the required properties to the home page of your website, in either JSON-LD, RDFa, or microdata format. You don't need to include this markup on every page of your site; you only need to add this markup to the home page of your site.

The name of the website. Make sure the name meets the guidelines for choosing your site name.

The URL of the home page of the site. Set this to the canonical home page of your site's domain or subdomain. For example, https://example.com/ or https://news.example.com/.

Here's an example of WebSite structured data that includes the required fields:

If you want to provide an alternate version of your site name (for example, an a

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
<html>
  <head>
    <title>Example: A Site about Examples</title>
    <script type="application/ld+json">
    {
      "@context" : "https://schema.org",
      "@type" : "WebSite",
      "name" : "Example",
      "url" : "https://example.com/"
    }
  </script>
  </head>
  <body>
  </body>
</html>
```

Example 2 (unknown):
```unknown
<html>
  <head>
    <title>Example: A Site about Examples</title>
  </head>
  <body>
  <div itemscope itemtype="https://schema.org/WebSite">
    <link itemprop="url" href="https://example.com" />
    <meta itemprop="name" content="Example"/>
  </div>
  </body>
</html>
```

Example 3 (unknown):
```unknown
<script type="application/ld+json">
  {
    "@context": "https://schema.org",
    "@type": "WebSite",
    "name": "Burnt Toast",
    "alternateName": ["BT", "B-T", "Burnt Toast Shop"],
    "url": "https://www.example.com/"
  }
</script>
```

Example 4 (unknown):
```unknown
<html>
  <head>
    <title>Example: A Site about Examples</title>
    <script type="application/ld+json">
    {
      "@context" : "https://schema.org",
      "@type" : "WebSite",
      "name" : "Example Company",
      "alternateName" : "EC",
      "url" : "https://example.com/"
    }
  </script>
  </head>
  <body>
  </body>
</html>
```

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#exploration

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#favicon

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#video-thumbnail

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Featured snippets and your website

**URL:** https://developers.google.com/search/docs/appearance/featured-snippets

**Contents:**
- Featured snippets and your website
- How can I opt out of featured snippets?
  - Block all snippets
  - Block featured snippets only
- How can I mark my page as a featured snippet?
- What happens when a user clicks a featured snippet?

Featured snippets are special boxes where the format of a regular search result is reversed, showing the descriptive snippet first. They can also appear within a related questions group (also known as "People Also Ask"). Read more about how Google's Featured Snippets work.

How to make a hard-boiled egg

There are two ways that you can opt out of featured snippets:

To block all snippets (including featured snippets and regular snippets) from appearing for a given page, add the nosnippet rule to that page.

If you want to retain snippets in regularly-formatted search results, but you don't want to appear in featured snippets, experiment with setting the max-snippet rule to lower lengths. Featured snippets will only appear if enough text can be shown to generate a useful featured snippet.

Keep lowering the value if pages continue to show for featured snippets. In general, the shorter your max-snippet rule setting, the less likely the page will appear as a featured snippet.

Google does not provide an exact minimum length required to appear as a featured snippet. This is because the minimum length is variable based on a number of factors, including—but not limited to—the information in the snippet, the language, and the platform (mobile device, app, or desktop).

You can't. Google systems determine whether a page would make a good featured snippet for a user's search request, and if so, elevates it.

Clicking a featured snippet takes the user directly to the section of the page that appeared in the featured snippet. Scrolling to the position that appeared in the snippet happens automatically, without any additional annotation by the site. If a browser doesn't support the underlying technology needed, or if our systems can't confidently determine exactly where within a page to direct a click, clicking a featured snippet will take a user to the top of the source web page.

Except as otherwise noted, the content of this page is licensed under the Creative Commons Attribution 4.0 License, and code samples are licensed under the Apache 2.0 License. For details, see the Google Developers Site Policies. Java is a registered trademark of Oracle and/or its affiliates.

Last updated 2025-02-04 UTC.

---

## Define a favicon to show in search results

**URL:** https://developers.google.com/search/docs/appearance/favicon-in-search

**Contents:**
- Define a favicon to show in search results
- Implementation
- Guidelines

If your site has a favicon, it can be included in Google Search results for your site.

Here's how to make your site eligible for a favicon in Google Search results:

To extract the favicon information, Google relies on the following attributes of the link element:

Google supports the following rel attribute values for specifying a favicon; use whichever one fits your use case:

The icon that represents your site, as defined in the HTML standard.

An iOS-friendly icon that represents your site, per Apple's developer documentation.

An alternative icon for earlier versions of iOS, per Apple's developer documentation.

The URL of the favicon. The URL can be a relative path (/smile.ico) or absolute path (https://example.com/smile.ico). The URL doesn't need to be hosted on your site (for example, your favicon could be hosted on a content delivery network (CDN)).

You must follow these guidelines to be eligible for a favicon in Google Search results.

Except as otherwise noted, the content of this page is licensed under the Creative Commons Attribution 4.0 License, and code samples are licensed under the Apache 2.0 License. For details, see the Google Developers Site Policies. Java is a registered trademark of Oracle and/or its affiliates.

Last updated 2025-02-04 UTC.

**Examples:**

Example 1 (unknown):
```unknown
<link rel="icon" href="/path/to/favicon.ico">
```

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#site-name

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#sitelink

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#text-result

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#byline-date

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Structured data for subscription and paywalled content (CreativeWork)

**URL:** https://developers.google.com/search/docs/appearance/structured-data/paywalled-content

**Contents:**
- Structured data for subscription and paywalled content (CreativeWork)
- Example
- Guidelines
- Add markup to paywalled content
  - Multiple paywalled sections
  - Supported types
- AMP considerations
- Generative AI in Search considerations
- Make sure Google can crawl and index your pages
- Control what information is shown in search results

This page describes how to use schema.org JSON-LD to indicate paywalled content on your site with CreativeWork properties. This structured data helps Google differentiate paywalled content from the practice of cloaking, which violates spam policies. Learn more about subscription and paywalled content.

Here's an example of NewsArticle structured data with paywalled content.

You must follow the general structured data guidelines and technical guidelines for your page to be eligible to appear in search results. In addition, the following guidelines apply to paywalled content:

If you offer any subscription-based access to your website content, or if users must register for access to any content you want to be indexed, follow these steps. The following example applies to NewsArticle structured data. Make sure to follow these steps for all versions of your page (including AMP and non-AMP).

If you have multiple paywalled sections on a page, add the class names as an array.

Here's an example of the paywalled sections on a page:

Here's an example of NewsArticle structured data with multiple paywalled sections.

This markup is supported for the CreativeWork type or one of the following more specific types of CreativeWork:

Multiple schema.org types can be used, such as the following:

"@type": ["Article", "LearningResource"]

You must include the required properties for Google to understand that your article has paywalled content. You can add the recommended properties for more granularity about which sections of a page are behind a paywall (or require a subscription or registration).

Whether the article is accessible to everyone, or if it's behind a paywall (or requires a subscription or registration). Set the isAccessibleForFree property to false to specify that this section is behind a paywall.

A CSS selector that references the class name that you set in the HTML to specify the paywalled section.

Set the @type to WebPageElement.

Whether this section of the article is behind a paywall (or requires a subscription or registration). Set the isAccessibleForFree property to False to specify that this section is behind a paywall.

Here's a list of considerations to keep in mind if you use AMP pages:

AI Overviews and AI Mode offer a preview of a topic or query based on a variety of sources, including web sources. As such, they are subject to Search's preview controls.

If you want Google to crawl and index your content, including the paywalled sections, make 

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
<html>
  <head>
    <title>Article headline</title>
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "NewsArticle",
      "headline": "Article headline",
      "image": "https://example.org/thumbnail1.jpg",
      "datePublished": "2025-02-05T08:00:00+08:00",
      "dateModified": "2025-02-05T09:20:00+08:00",
      "author": {
        "@type": "Person",
        "name": "John Doe",
        "url": "https://example.com/profile/johndoe123"
      },
      "description": "A most wonderful article",
      "isAccessibleForFree": false,
      "hasPart"
...
```

Example 2 (unknown):
```unknown
<body>
<p>This content is outside a paywall and is visible to all.</p>
<div class="paywall">This content is inside a paywall, and requires a subscription or registration.</div>
</body>
```

Example 3 (unknown):
```unknown
{
  "@context": "https://schema.org",
  "@type": "NewsArticle",
  "mainEntityOfPage": {
    "@type": "WebPage",
    "@id": "https://example.org/article"
  },
  (...)
  "isAccessibleForFree": false,
  "hasPart": {
    "@type": "WebPageElement",
    "isAccessibleForFree": false,
    "cssSelector": ".paywall"
  }
}
```

Example 4 (unknown):
```unknown
<body>
  <div class="section1">This content is inside a paywall, and requires a subscription or registration.</div>
  <p>This content is outside a paywall and is visible to all.</p>
  <div class="section2">This is another section that's inside a paywall, or requires a subscription or registration.</div>
</body>
```

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#breadcrumb

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Avoid intrusive interstitials and dialogs

**URL:** https://developers.google.com/search/docs/appearance/avoid-intrusive-interstitials

**Contents:**
- Avoid intrusive interstitials and dialogs
- Create unintrusive dialogs
  - Use banners instead of interstitials
  - Use common libraries
  - Avoid common mistakes
- Mandatory interstitials

Intrusive interstitials and dialogs are page elements that obstruct users' view of the content, usually for promotional purposes. Interstitials are overlays on the whole page and dialogs are overlays only on a part of the page, sometimes also obfuscating the underlying content.

Websites often need to show dialogs for various reasons; however, interrupting users with intrusive interstitials may frustrate them and erode their trust in your website.

Intrusive dialogs and interstitials make it hard for Google and other search engines to understand your content, which may lead to poor search performance. Equally, if users find your site hard to use, they are unlikely to want to visit those websites again, including through search engines.

Creating unintrusive dialogs means that users can access your content without being interrupted by a dialog. This applies to all kinds of promotional dialogs, including app install prompts. Following these best practices will help your users have a good experience on your site, in addition to helping Google Search understand the content and structure of your site.

Instead of full page interstitials, use banners that take up only a small fraction of the screen to grab your users' attention. Banners ensure that users and search engines can get to the content as soon as they land on the page.

These can be implemented in various ways. For example, for app install banners, you can use a browser-supported banner, such as Smart App Banners for Safari or in-app install experience for Chrome. Another option is to create an HTML banner, similar to a typical small advertisement, that links to the correct app store for download. You can reuse these small containers for other kinds of notifications, such as newsletter sign-up prompts.

Many CMSes have plugins that create standard dialogs and interstitials for the most common use cases, such as newsletter sign-up prompts. For example, if you are using WordPress, search for "newsletter signup wordpress". Using such plugins can be helpful for Google, other search engines, and the internet in general, as the plugin developers can deploy improvements at scale.

Unless they're legally mandatory, avoid the following common mistakes when designing a dialog or interstitial to help Google Search crawl and understand your content:

Certain sites are required to show an interstitial due to the kind of content they are publishing. For example, a casino site may need to show an age gate, which is a

*[Content truncated]*

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#image-result

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Generate structured data with JavaScript

**URL:** https://developers.google.com/search/docs/guides/generate-structured-data-with-javascript

**Contents:**
- Generate structured data with JavaScript
- Use Google Tag Manager to generate JSON-LD dynamically
  - Using variables in Google Tag Manager
- Generate structured data with custom JavaScript
- Using server-side rendering
- Test your implementation

Modern websites use JavaScript to display lots of dynamic content. There are a few things you need to look out for when using JavaScript to generate structured data on your websites, and this guide covers best practices and implementation strategies. If you're new to structured data, you can learn more about how structured data works.

There are different ways to generate structured data with JavaScript, but the most common are:

Google Tag Manager is a platform that lets you manage tags on your website without editing the code. To generate structured data with Google Tag Manager, follow these steps:

Google Tag Manager (GTM) supports variables to use information on the page as part of your structured data. Use variables to extract the structured data from the page instead of duplicating the information in GTM. Duplicating the information in GTM increases the risk of having a mismatch between page content and the structured data inserted using GTM.

For example, you can dynamically create a Recipe JSON-LD block that uses the page title as the recipe name by creating the following custom variable named recipe_name:

You can then use {{recipe_name}} in your custom tag HTML.

We recommend to create variables to collect all the necessary information from the page using variables.

Here is an example for the custom HTML tag content:

Another way you can generate structured data is by using JavaScript to either generate all of your structured data or add more information to the server-side rendered structured data. Either way, Google Search can understand and process structured data that's available in the DOM when it renders the page. To learn more about how Google Search processes JavaScript, check out the JavaScript basics guide.

Here is an example of JavaScript-generated structured data:

If you are using server-side rendering, you can also include the structured data in the rendered output. Check the documentation of your framework to find out how to generate the JSON-LD for the type of structured data you're interested in.

To make sure Google Search can crawl and index your structured data, test your implementation:

Success: If you did everything correctly and your structured data type is supported in the tool, you will see the message "Page is eligible for rich results". If you are testing a structured data type that is not supported by the Rich Results test, check the rendered HTML. If the rendered HTML contains the structured data, Google Search will

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
function() { return document.title; }
```

Example 2 (unknown):
```unknown
<script type="application/ld+json">
  {
    "@context": "https://schema.org/",
    "@type": "Recipe",
    "name": "{{recipe_name}}",
    "image": [ "{{recipe_image}}" ],
    "author": {
      "@type": "Person",
      "name": "{{recipe_author}}"
    }
  }
</script>
```

Example 3 (javascript):
```javascript
fetch('https://api.example.com/recipes/123')
.then(response => response.text())
.then(structuredDataText => {
  const script = document.createElement('script');
  script.setAttribute('type', 'application/ld+json');
  script.textContent = structuredDataText;
  document.head.appendChild(script);
});
```

---

## Video SEO best practices

**URL:** https://developers.google.com/search/docs/appearance/video

**Contents:**
- Video SEO best practices
- Help Google find your videos
- Ensure your videos can be indexed
  - Use a supported video file type
  - Use stable URLs
  - Create a dedicated watch page for each video
  - Using third-party embedded players
- Which URL is which?
  - Provide a high-quality video thumbnail
  - Provide consistent and unique information in your structured data

If you have videos on your site, following these video SEO best practices can help more people find your site through video results on Google. Videos can appear in several different places on Google, including the main search results page, Video mode, Google Images, and Discover:

Optimize your videos to appear on Google by following these best practices:

The technical requirements for getting your content in Google's search results applies to videos too. There are some additional requirements to making your videos eligible to be discovered, crawled, and indexed by Google Search:

To make it easier for Google to find your videos, we recommend providing metadata about the video. We support structured data, video sitemaps, and the Open Graph protocol (OGP).

To be eligible for video features, a video must meet the following indexing requirements:

To be eligible for video features, use a supported video file type. Google can process the following video file types: 3GP, 3G2, ASF, AVI, DivX, M2V, M3U, M3U8, M4V, MKV, MOV, MP4, MPEG, OGV, QVT, RAM, RM, VOB, WebM, WMV, and XAP.

Data URLs aren't supported.

Some CDNs use quickly expiring URLs. If the video's thumbnail URL changes too often, Google may not be able to successfully index your videos. To make sure your videos can be indexed, use a single unique and stable thumbnail URL for each video.

To make your videos eligible for specific features like key moments and video previews, make sure your video files are available at stable URLs too. This also helps Google discover and process the videos consistently, confirm they are still available, and collect signals on the videos.

If you are concerned about bad actors (for example, hackers or spammers) accessing your content, you can verify Googlebot before displaying a stable version of your media URLs. For example, you can choose to serve the contentUrl property only to trusted clients like Googlebot, whereas other clients accessing your page wouldn't see that field. With this setup, only trusted clients will be able to access the location of your video file.

To be eligible for video features (including video results on the main search results page, Video mode, Key Moments, the Live Badge, and other rich formats), create a dedicated watch page for each video, if it makes sense for your business.

A watch page's main purpose is to show users a single video. The following pages are watch pages because watching an individual video is the main reason the user is

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
    xmlns:video="http://www.google.com/schemas/sitemap-video/1.1">
<url>
<loc>https://example.com/videos/some_video_landing_page.html</loc>
  <video:video>
  ...
```

Example 2 (unknown):
```unknown
<iframe src="https://example.com/videoplayer.php?video=123" width="640" height="360" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe>
```

Example 3 (unknown):
```unknown
"embedUrl": "https://example.com/videoplayer.php?video=123"
```

Example 4 (unknown):
```unknown
<video:player_loc>https://example.com/videoplayer.php?video=123</video:player_loc>
```

---

## Influencing your title links in search results

**URL:** https://developers.google.com/search/docs/appearance/title-link

**Contents:**
- Influencing your title links in search results
- Best practices for influencing title links
- How title links in Google Search are created
- Common issues and how Google manages them
  - Half-empty <title> elements
  - Obsolete <title> elements
  - Inaccurate <title> elements
  - Micro-boilerplate text in <title> elements
  - No clear main title
  - Mismatch of writing system or language used in <title> elements

A title link is the title of a search result on Google Search and other properties (for example, Google News) that links to the web page. Google uses a number of different sources to automatically determine the title link, but you can indicate your preferences by following our best practices for influencing title links.

How to make crispy fried eggs

Title links are critical to giving users a quick insight into the content of a result and why it's relevant to their query. It's often the primary piece of information people use to decide which result to click, so it's important to use high-quality title text on your web pages.

One solution is to dynamically update the <title> element to better reflect the actual content of the page. For example, include the words "video" and "lyrics" only if that particular page contains video or lyrics.

Google's generation of title links on the Google Search results page is completely automated and takes into account both the content of a page and references to it that appear on the web. The goal of the title link is to best represent and describe each result.

Google Search uses the following sources to automatically determine title links:

Keep in mind that Google has to recrawl and reprocess the page to notice updates to these sources, which may take a few days to a few weeks. If you've made changes, you can request that Google recrawl your pages.

While we can't manually change title links for individual sites, we're always working to make them as relevant as possible. You can help improve the quality of the title link that's displayed for your page by following the best practices.

Here are the most common issues we see with title links in search results. To avoid these issues, follow the best practices for influencing title links.

When part of the title text is missing. For example:

Google Search looks at information in header elements or other large and prominent text on the page to produce a title link:

When the same page is used year-after-year for recurring information, but the <title> element didn't get updated to reflect the latest date. For example:

In this example, the page has a large, visible title that says "2021 admissions criteria", and the <title> element wasn't updated to the current date. Google Search may detect this inconsistency and uses the right date from the visible title on the page in the title link:

When the <title> elements don't accurately reflect what the page is about. For example,

*[Content truncated]*

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#sitelinks-group

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#rich-result

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#video-result-attribution

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Discover and your website

**URL:** https://developers.google.com/search/docs/appearance/google-discover

**Contents:**
- Discover and your website
- How content appears in Discover
- The Follow feature and your website
  - Optimize your web pages for the Follow feature
  - RSS
  - Atom
  - Hub page
  - Leaf page
  - Feed guidelines
  - Specifying multiple feeds

Discover is a part of Google Search that shows people content related to their interests, based on their Web and App Activity. This page explains more about how content may appear in Discover and best practices for site owners to consider.

Content is automatically eligible to appear in Discover if it is indexed by Google and meets Discover's content policies. No special tags or structured data are required. Note that being eligible to appear in Discover is not a guarantee of appearing.

Content that may appear in Discover includes a wide range of topics that aligns with a person's interests. Older content may appear if it's helpful and relevant to individuals based on their interests.

As part of Google Search, Discover makes use of many of the same signals and systems used by Search to determine what is helpful, people-first content. Given this, those looking for success with Discover should review our advice on creating helpful, reliable, people-first content.

To increase the likelihood of your content appearing in Discover, we recommend the following:

To deliver a good user experience, Discover seeks to present content that's suitable for interest-based feeds, such as articles and videos, as well as filter out content that's not wanted or that might confuse readers. For example, Discover might not recommend job applications, petitions, forms, code repositories, or satirical content without any context. Discover makes use of SafeSearch but beyond that filters out content that might be seen as shocking or unexpected.

The Follow feature lets people follow a website and get the latest updates from that website in the Following tab within Discover in Chrome. The Follow button is a feature that's available to signed-in users in English in the US, New Zealand, South Africa, UK, Canada, and Australia that are using Chrome Android. It's also available to signed in users in English in the US that are using Chrome iOS.

By default, the Follow feature uses RSS or Atom feeds on your website. If you don't have an RSS or Atom feed on your website, Google automatically generates a feed for your entire domain based on our view of your site. If you have one or more feeds on your website, you can optimize your Follow experience by explicitly telling Google which feed you want people to follow for a given page on your site.

To help Google understand which feed that you want people to follow for a given page, link your RSS or Atom feed in the <head> section of your hub

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
<link rel="alternate" type="application/rss+xml" href="https://example.com/rssfeed">
```

Example 2 (unknown):
```unknown
<link rel="alternate" type="application/atom+xml" href="https://example.com/atom-feed">
```

Example 3 (unknown):
```unknown
<html>
  <head>
    <link rel="alternate" type="application/rss+xml" href="https://feeds.feedburner.com/blogspot/amDG" />
  </head>
  <body>
    <h1>Google Search Central Blog</h1>
  </body>
</html>
```

Example 4 (unknown):
```unknown
<html>
  <head>
    <link rel="alternate" type="application/rss+xml" href="https://feeds.feedburner.com/blogspot/amDG" />
  </head>
  <body>
    <h1>A new way to enable video key moments in Search</h1>
  </body>
</html>
```

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#domain

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Video SEO best practices

**URL:** https://developers.google.com/search/docs/appearance/video#watch-page

**Contents:**
- Video SEO best practices
- Help Google find your videos
- Ensure your videos can be indexed
  - Use a supported video file type
  - Use stable URLs
  - Create a dedicated watch page for each video
  - Using third-party embedded players
- Which URL is which?
  - Provide a high-quality video thumbnail
  - Provide consistent and unique information in your structured data

If you have videos on your site, following these video SEO best practices can help more people find your site through video results on Google. Videos can appear in several different places on Google, including the main search results page, Video mode, Google Images, and Discover:

Optimize your videos to appear on Google by following these best practices:

The technical requirements for getting your content in Google's search results applies to videos too. There are some additional requirements to making your videos eligible to be discovered, crawled, and indexed by Google Search:

To make it easier for Google to find your videos, we recommend providing metadata about the video. We support structured data, video sitemaps, and the Open Graph protocol (OGP).

To be eligible for video features, a video must meet the following indexing requirements:

To be eligible for video features, use a supported video file type. Google can process the following video file types: 3GP, 3G2, ASF, AVI, DivX, M2V, M3U, M3U8, M4V, MKV, MOV, MP4, MPEG, OGV, QVT, RAM, RM, VOB, WebM, WMV, and XAP.

Data URLs aren't supported.

Some CDNs use quickly expiring URLs. If the video's thumbnail URL changes too often, Google may not be able to successfully index your videos. To make sure your videos can be indexed, use a single unique and stable thumbnail URL for each video.

To make your videos eligible for specific features like key moments and video previews, make sure your video files are available at stable URLs too. This also helps Google discover and process the videos consistently, confirm they are still available, and collect signals on the videos.

If you are concerned about bad actors (for example, hackers or spammers) accessing your content, you can verify Googlebot before displaying a stable version of your media URLs. For example, you can choose to serve the contentUrl property only to trusted clients like Googlebot, whereas other clients accessing your page wouldn't see that field. With this setup, only trusted clients will be able to access the location of your video file.

To be eligible for video features (including video results on the main search results page, Video mode, Key Moments, the Live Badge, and other rich formats), create a dedicated watch page for each video, if it makes sense for your business.

A watch page's main purpose is to show users a single video. The following pages are watch pages because watching an individual video is the main reason the user is

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
    xmlns:video="http://www.google.com/schemas/sitemap-video/1.1">
<url>
<loc>https://example.com/videos/some_video_landing_page.html</loc>
  <video:video>
  ...
```

Example 2 (unknown):
```unknown
<iframe src="https://example.com/videoplayer.php?video=123" width="640" height="360" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe>
```

Example 3 (unknown):
```unknown
"embedUrl": "https://example.com/videoplayer.php?video=123"
```

Example 4 (unknown):
```unknown
<video:player_loc>https://example.com/videoplayer.php?video=123</video:player_loc>
```

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#snippet

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#text-result-attribution

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Video SEO best practices

**URL:** https://developers.google.com/search/docs/appearance/video#video-thumbnail

**Contents:**
- Video SEO best practices
- Help Google find your videos
- Ensure your videos can be indexed
  - Use a supported video file type
  - Use stable URLs
  - Create a dedicated watch page for each video
  - Using third-party embedded players
- Which URL is which?
  - Provide a high-quality video thumbnail
  - Provide consistent and unique information in your structured data

If you have videos on your site, following these video SEO best practices can help more people find your site through video results on Google. Videos can appear in several different places on Google, including the main search results page, Video mode, Google Images, and Discover:

Optimize your videos to appear on Google by following these best practices:

The technical requirements for getting your content in Google's search results applies to videos too. There are some additional requirements to making your videos eligible to be discovered, crawled, and indexed by Google Search:

To make it easier for Google to find your videos, we recommend providing metadata about the video. We support structured data, video sitemaps, and the Open Graph protocol (OGP).

To be eligible for video features, a video must meet the following indexing requirements:

To be eligible for video features, use a supported video file type. Google can process the following video file types: 3GP, 3G2, ASF, AVI, DivX, M2V, M3U, M3U8, M4V, MKV, MOV, MP4, MPEG, OGV, QVT, RAM, RM, VOB, WebM, WMV, and XAP.

Data URLs aren't supported.

Some CDNs use quickly expiring URLs. If the video's thumbnail URL changes too often, Google may not be able to successfully index your videos. To make sure your videos can be indexed, use a single unique and stable thumbnail URL for each video.

To make your videos eligible for specific features like key moments and video previews, make sure your video files are available at stable URLs too. This also helps Google discover and process the videos consistently, confirm they are still available, and collect signals on the videos.

If you are concerned about bad actors (for example, hackers or spammers) accessing your content, you can verify Googlebot before displaying a stable version of your media URLs. For example, you can choose to serve the contentUrl property only to trusted clients like Googlebot, whereas other clients accessing your page wouldn't see that field. With this setup, only trusted clients will be able to access the location of your video file.

To be eligible for video features (including video results on the main search results page, Video mode, Key Moments, the Live Badge, and other rich formats), create a dedicated watch page for each video, if it makes sense for your business.

A watch page's main purpose is to show users a single video. The following pages are watch pages because watching an individual video is the main reason the user is

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
    xmlns:video="http://www.google.com/schemas/sitemap-video/1.1">
<url>
<loc>https://example.com/videos/some_video_landing_page.html</loc>
  <video:video>
  ...
```

Example 2 (unknown):
```unknown
<iframe src="https://example.com/videoplayer.php?video=123" width="640" height="360" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe>
```

Example 3 (unknown):
```unknown
"embedUrl": "https://example.com/videoplayer.php?video=123"
```

Example 4 (unknown):
```unknown
<video:player_loc>https://example.com/videoplayer.php?video=123</video:player_loc>
```

---

## Video SEO best practices

**URL:** https://developers.google.com/search/docs/appearance/video#remove

**Contents:**
- Video SEO best practices
- Help Google find your videos
- Ensure your videos can be indexed
  - Use a supported video file type
  - Use stable URLs
  - Create a dedicated watch page for each video
  - Using third-party embedded players
- Which URL is which?
  - Provide a high-quality video thumbnail
  - Provide consistent and unique information in your structured data

If you have videos on your site, following these video SEO best practices can help more people find your site through video results on Google. Videos can appear in several different places on Google, including the main search results page, Video mode, Google Images, and Discover:

Optimize your videos to appear on Google by following these best practices:

The technical requirements for getting your content in Google's search results applies to videos too. There are some additional requirements to making your videos eligible to be discovered, crawled, and indexed by Google Search:

To make it easier for Google to find your videos, we recommend providing metadata about the video. We support structured data, video sitemaps, and the Open Graph protocol (OGP).

To be eligible for video features, a video must meet the following indexing requirements:

To be eligible for video features, use a supported video file type. Google can process the following video file types: 3GP, 3G2, ASF, AVI, DivX, M2V, M3U, M3U8, M4V, MKV, MOV, MP4, MPEG, OGV, QVT, RAM, RM, VOB, WebM, WMV, and XAP.

Data URLs aren't supported.

Some CDNs use quickly expiring URLs. If the video's thumbnail URL changes too often, Google may not be able to successfully index your videos. To make sure your videos can be indexed, use a single unique and stable thumbnail URL for each video.

To make your videos eligible for specific features like key moments and video previews, make sure your video files are available at stable URLs too. This also helps Google discover and process the videos consistently, confirm they are still available, and collect signals on the videos.

If you are concerned about bad actors (for example, hackers or spammers) accessing your content, you can verify Googlebot before displaying a stable version of your media URLs. For example, you can choose to serve the contentUrl property only to trusted clients like Googlebot, whereas other clients accessing your page wouldn't see that field. With this setup, only trusted clients will be able to access the location of your video file.

To be eligible for video features (including video results on the main search results page, Video mode, Key Moments, the Live Badge, and other rich formats), create a dedicated watch page for each video, if it makes sense for your business.

A watch page's main purpose is to show users a single video. The following pages are watch pages because watching an individual video is the main reason the user is

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
    xmlns:video="http://www.google.com/schemas/sitemap-video/1.1">
<url>
<loc>https://example.com/videos/some_video_landing_page.html</loc>
  <video:video>
  ...
```

Example 2 (unknown):
```unknown
<iframe src="https://example.com/videoplayer.php?video=123" width="640" height="360" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe>
```

Example 3 (unknown):
```unknown
"embedUrl": "https://example.com/videoplayer.php?video=123"
```

Example 4 (unknown):
```unknown
<video:player_loc>https://example.com/videoplayer.php?video=123</video:player_loc>
```

---

## Google image SEO best practices

**URL:** https://developers.google.com/search/docs/appearance/google-images

**Contents:**
- Google image SEO best practices
- Help us discover and index your images
  - Use HTML image elements to embed images
  - Use an image sitemap
  - Responsive images
  - Use supported image formats
  - Optimize for speed and quality
- Optimize the image landing pages
  - Check your page title and description
  - Add structured data

Google provides several Search features and products that help users visually discover information on the web, such as the text result images, Google Discover, and Google Images. While each feature and product looks different, the general recommendations for getting images to appear in them is the same.

You can optimize your images to appear in Google's search results by following these best practices:

The technical requirements for getting your content in Google's search results applies to images too. Since images are a substantially different format compared to HTML, it means there are additional requirements for getting images indexed; for example, finding the images on your site is different, and the presentation of the images also influences whether an image is indexed at all, and for the right keywords.

Using standard HTML image elements helps crawlers find and process images. Google can find images in src attribute of <img> element (even when it's a child of other elements, such as the <picture> element). Google doesn't index CSS images.

You can provide the URL of images we might not have otherwise discovered by submitting an image sitemap.

Unlike regular sitemaps, you can include URLs from other domains in the <image:loc> elements of the image sitemaps. This lets you use CDNs (content delivery networks) to host images. If you're using a CDN, we encourage you to verify ownership of the CDN's domain name in Search Console so that we can inform you of any crawl errors that we may find.

Designing responsive web pages leads to better user experience, since people can access them across a plethora of device types. Refer to our guide to responsive images to learn about the best practices for handling images on your website.

Web pages use the <picture> element or the srcset attribute of an img element to specify responsive images. However, some browsers and crawlers don't understand these attributes. We recommend that you always specify a fallback URL using the src attribute.

The srcset attribute allows specifying different versions of the same image, specifically for different screen sizes. For example:

The <picture> element is a container that is used to group different <source> versions of the same image. It offers a fallback approach so the browser can choose the right image depending on device capabilities, like pixel density and screen size. The picture element also comes in handy for using new image formats with built-in graceful degradatio

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
<img
  srcset="maine-coon-nap-320w.jpg 320w, maine-coon-nap-480w.jpg 480w, maine-coon-nap-800w.jpg 800w"
  sizes="(max-width: 320px) 280px, (max-width: 480px) 440px, 800px"
  src="maine-coon-nap-800w.jpg"
  alt="A watercolor illustration of a maine coon napping leisurely in front of a fireplace">
```

Example 2 (unknown):
```unknown
<picture>
  <source type="image/svg+xml" srcset="pyramid.svg">
  <source type="image/webp" srcset="pyramid.webp">
  <img src="pyramid.png" alt="An 1800s oil painting of The Great Pyramid">
</picture>
```

Example 3 (unknown):
```unknown
<img src="data:image/svg+xml;base64,[data]">
```

Example 4 (unknown):
```unknown
<svg aria-labelledby="svgtitle1">
  <title id="svgtitle1">Googlebot wearing an apron and chef hat, struggling to make pancakes on the stovetop</title>
</svg>
```

---

## Video SEO best practices

**URL:** https://developers.google.com/search/docs/appearance/video#monitor

**Contents:**
- Video SEO best practices
- Help Google find your videos
- Ensure your videos can be indexed
  - Use a supported video file type
  - Use stable URLs
  - Create a dedicated watch page for each video
  - Using third-party embedded players
- Which URL is which?
  - Provide a high-quality video thumbnail
  - Provide consistent and unique information in your structured data

If you have videos on your site, following these video SEO best practices can help more people find your site through video results on Google. Videos can appear in several different places on Google, including the main search results page, Video mode, Google Images, and Discover:

Optimize your videos to appear on Google by following these best practices:

The technical requirements for getting your content in Google's search results applies to videos too. There are some additional requirements to making your videos eligible to be discovered, crawled, and indexed by Google Search:

To make it easier for Google to find your videos, we recommend providing metadata about the video. We support structured data, video sitemaps, and the Open Graph protocol (OGP).

To be eligible for video features, a video must meet the following indexing requirements:

To be eligible for video features, use a supported video file type. Google can process the following video file types: 3GP, 3G2, ASF, AVI, DivX, M2V, M3U, M3U8, M4V, MKV, MOV, MP4, MPEG, OGV, QVT, RAM, RM, VOB, WebM, WMV, and XAP.

Data URLs aren't supported.

Some CDNs use quickly expiring URLs. If the video's thumbnail URL changes too often, Google may not be able to successfully index your videos. To make sure your videos can be indexed, use a single unique and stable thumbnail URL for each video.

To make your videos eligible for specific features like key moments and video previews, make sure your video files are available at stable URLs too. This also helps Google discover and process the videos consistently, confirm they are still available, and collect signals on the videos.

If you are concerned about bad actors (for example, hackers or spammers) accessing your content, you can verify Googlebot before displaying a stable version of your media URLs. For example, you can choose to serve the contentUrl property only to trusted clients like Googlebot, whereas other clients accessing your page wouldn't see that field. With this setup, only trusted clients will be able to access the location of your video file.

To be eligible for video features (including video results on the main search results page, Video mode, Key Moments, the Live Badge, and other rich formats), create a dedicated watch page for each video, if it makes sense for your business.

A watch page's main purpose is to show users a single video. The following pages are watch pages because watching an individual video is the main reason the user is

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
    xmlns:video="http://www.google.com/schemas/sitemap-video/1.1">
<url>
<loc>https://example.com/videos/some_video_landing_page.html</loc>
  <video:video>
  ...
```

Example 2 (unknown):
```unknown
<iframe src="https://example.com/videoplayer.php?video=123" width="640" height="360" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe>
```

Example 3 (unknown):
```unknown
"embedUrl": "https://example.com/videoplayer.php?video=123"
```

Example 4 (unknown):
```unknown
<video:player_loc>https://example.com/videoplayer.php?video=123</video:player_loc>
```

---

## Structured data markup that Google Search supports

**URL:** https://developers.google.com/search/docs/appearance/structured-data/search-gallery

**Contents:**
- Structured data markup that Google Search supports

Google uses structured data to understand the content on the page and show that content in a richer appearance in search results, which is called a rich result. To make your site eligible for appearance as one of these rich results, follow the guide to learn how to implement structured data on your site. If you're just getting started, visit Understand how structured data works.

A news, sports, or blog article displayed in various rich result features, such as the title of the article and larger-than-thumbnail images.

Navigation that indicates the page's position in the site hierarchy.

Rich results that display in a sequential list or gallery from a single site. This feature must be combined with one of the following features: Recipe, Course list, Restaurant, Movie.

A list of educational course from the same course provider. Courses can include the course title, provider, and a short description.

Large data sets that appear in Google Dataset Search.

User-generated content (traditionally short-form compared to Article), followed by a threaded or non-threaded discussion about that topic.

Education-related questions and answers that help students discover flashcards on Google Search.

Employer aggregate rating

An evaluation of a hiring organization compiled from many users that's displayed in the job search experience on Google.

An interactive rich result that shows a list of organized events, such as concerts or art festivals, that people may attend at a particular time and place.

A Frequently Asked Question (FAQ) page contains a list of questions and answers pertaining to a particular topic.

When you specify image metadata, Google Images can show more details about the image, such as who the creator is, how people can use an image, and credit information.

An interactive rich result that allows job seekers to find a job. The job search experience on Google can feature your logo, reviews, ratings, and job details.

Business details displayed in the Google knowledge panel, including open hours, ratings, directions, and actions to book appointments or order items.

Help students, teachers, and others with math problems by adding structured data to indicate the type of math problems and step-by-step walkthroughs for specific math problems.

The movie carousel helps users explore lists of movies on Google Search (for example, "best movies of 2023"). You can provide details about the movies, such as the title of each movie, director information, and im

*[Content truncated]*

---

## Introduction to structured data markup in Google Search

**URL:** https://developers.google.com/search/docs/appearance/structured-data/intro-structured-data

**Contents:**
- Introduction to structured data markup in Google Search
- Why add structured data to a page?
- How structured data works in Google Search
- Structured data vocabulary and format
  - Supported formats
- Structured data guidelines
- Get started with structured data
- Measuring the effect of structured data

Google Search works hard to understand the content of a page. You can help us by providing explicit clues about the meaning of a page to Google by including structured data on the page. Structured data is a standardized format for providing information about a page and classifying the page content; for example, on a recipe page, what are the ingredients, the cooking time and temperature, the calories, and so on.

Adding structured data can enable search results that are more engaging to users and might encourage them to interact more with your website, which are called rich results. Here are some case studies of websites that have implemented structured data for their site:

Google uses structured data that it finds on the web to understand the content of the page, as well as to gather information about the web and the world in general, such as information about the people, books, or companies that are included in the markup. For example, when a recipe page has JSON-LD structured data (describing the title of the recipe, the author of the recipe, and other details), Google Search can use that information to display a rich result for the recipe:

Because the structured data labels each individual element of the recipe, users can search for your recipe by ingredient, calorie count, cook time, and so on.

Structured data is coded using in-page markup on the page that the information applies to. The structured data on the page describes the content of that page. Don't create blank or empty pages just to hold structured data, and don't add structured data about information that is not visible to the user, even if the information is accurate. For more technical and quality guidelines, see the Structured data general guidelines.

The Rich Results Test is an easy and useful tool for validating your structured data, and in some cases, previewing a feature in Google Search. Try it out:

This documentation describes which properties are required, recommended, or optional for structured data with special meaning to Google Search. Most Search structured data uses schema.org vocabulary, but you should rely on the Google Search Central documentation as definitive for Google Search behavior, rather than the schema.org documentation. There are more attributes and objects on schema.org that aren't required by Google Search; they may be useful for other search engines, services, tools, and platforms.

Be sure to check your structured data using the Rich Results Test during d

*[Content truncated]*

---

## Influence your byline dates in Google Search

**URL:** https://developers.google.com/search/docs/appearance/publication-dates

**Contents:**
- Influence your byline dates in Google Search
- How to provide date information to Google
- Best practices for influencing byline dates

A byline date is the date that Google estimates that the web page was updated or published. When Google can determine the byline date of your page or video, it can expose this information in Search results, if this information is considered to be useful to the user. You can provide information to help Google determine the byline date.

Why are sloths so slow?

Google doesn't depend on a single date factor because all factors can be prone to issues. That's why our systems look at several factors to determine our best estimate of when a page was published or significantly updated.

To provide date information to Google, follow these steps:

Except as otherwise noted, the content of this page is licensed under the Creative Commons Attribution 4.0 License, and code samples are licensed under the Apache 2.0 License. For details, see the Google Developers Site Policies. Java is a registered trademark of Oracle and/or its affiliates.

Last updated 2025-05-09 UTC.

**Examples:**

Example 1 (unknown):
```unknown
<html>
  <head>
    <title>Analyzing Google Search traffic drops</title>
  </head>
  <body>
    <p>
      Posted Tuesday, July 20, 2021
    </p>
    <p>
      Suppose you open Search Console and find out that your Google Search traffic dropped. What should you do?
    </p>
  </body>
</html>
```

Example 2 (unknown):
```unknown
<html>
  <head>
    <title>Analyzing Google Search traffic drops</title>
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "NewsArticle",
      "headline": "Analyzing Google Search traffic drops",
      "datePublished": "2021-07-20T08:00:00+08:00",
      "dateModified": "2021-07-20T09:20:00+08:00"
    }
    </script>
  </head>
  <body>
    <p>
      Posted Tuesday, July 20, 2021
    </p>
    <p>
      Suppose you open Search Console and find out that your Google Search traffic dropped. What should you do?
    </p>
  </body>
</html>
```

---

## A guide to Google Search ranking systems

**URL:** https://developers.google.com/search/docs/appearance/ranking-systems-guide#link-analysis

**Contents:**
- A guide to Google Search ranking systems
- BERT
- Crisis information systems
- Deduplication systems
- Exact match domain system
- Freshness systems
- Link analysis systems and PageRank
- Local news systems
- MUM
- Neural matching

Google uses automated ranking systems that look at many factors and signals about hundreds of billions of web pages and other content in our Search index to present the most relevant, useful results, all in a fraction of a second. This page is a guide to understanding some of our more notable ranking systems. It covers some systems that are part of our core ranking systems, which are the underlying technologies that produce search results in response to queries. It also covers some systems involved with specific ranking needs.

Our ranking systems are designed to work on the page level, using a variety of signals and systems to understand how to rank individual pages. Site-wide signals and classifiers are also used and contribute to our understanding of pages. Having some good site-wide signals does not mean that all content from a site will always rank highly, just as having some poor site-wide signals does not mean all the content from a site will rank poorly.

We regularly improve our ranking systems through rigorous testing and evaluation and provide notice of updates to our ranking systems when those might be useful to content creators and others.

You can also visit our How Search Works site to understand how our ranking systems, combined with other processes, work together so that Google Search delivers on our mission to organize the world's information and make it universally accessible and useful.

Bidirectional Encoder Representations from Transformers (BERT) is an AI system Google uses that allows us to understand how combinations of words express different meanings and intent.

Google has developed systems to provide helpful and timely information during times of crisis, whether those involve personal crisis situations, natural disasters, or other wide-spread crisis situations:

Searches on Google may find thousands or even millions of matching web pages. Some of these may be very similar to each other. In such cases, our systems show only the most relevant results to avoid unhelpful duplication. Learn more about how deduplication works and how to see omitted results if desired, when deduplication happens.

Deduplication also happens with featured snippets. If a web page listing is elevated to become a featured snippet, we don't repeat the listing later on the first page of results. This declutters the results and helps people locate relevant information more easily.

Our ranking systems consider the words in domain names as one of many factors

*[Content truncated]*

---

## Video SEO best practices

**URL:** https://developers.google.com/search/docs/appearance/video#enable-search-features

**Contents:**
- Video SEO best practices
- Help Google find your videos
- Ensure your videos can be indexed
  - Use a supported video file type
  - Use stable URLs
  - Create a dedicated watch page for each video
  - Using third-party embedded players
- Which URL is which?
  - Provide a high-quality video thumbnail
  - Provide consistent and unique information in your structured data

If you have videos on your site, following these video SEO best practices can help more people find your site through video results on Google. Videos can appear in several different places on Google, including the main search results page, Video mode, Google Images, and Discover:

Optimize your videos to appear on Google by following these best practices:

The technical requirements for getting your content in Google's search results applies to videos too. There are some additional requirements to making your videos eligible to be discovered, crawled, and indexed by Google Search:

To make it easier for Google to find your videos, we recommend providing metadata about the video. We support structured data, video sitemaps, and the Open Graph protocol (OGP).

To be eligible for video features, a video must meet the following indexing requirements:

To be eligible for video features, use a supported video file type. Google can process the following video file types: 3GP, 3G2, ASF, AVI, DivX, M2V, M3U, M3U8, M4V, MKV, MOV, MP4, MPEG, OGV, QVT, RAM, RM, VOB, WebM, WMV, and XAP.

Data URLs aren't supported.

Some CDNs use quickly expiring URLs. If the video's thumbnail URL changes too often, Google may not be able to successfully index your videos. To make sure your videos can be indexed, use a single unique and stable thumbnail URL for each video.

To make your videos eligible for specific features like key moments and video previews, make sure your video files are available at stable URLs too. This also helps Google discover and process the videos consistently, confirm they are still available, and collect signals on the videos.

If you are concerned about bad actors (for example, hackers or spammers) accessing your content, you can verify Googlebot before displaying a stable version of your media URLs. For example, you can choose to serve the contentUrl property only to trusted clients like Googlebot, whereas other clients accessing your page wouldn't see that field. With this setup, only trusted clients will be able to access the location of your video file.

To be eligible for video features (including video results on the main search results page, Video mode, Key Moments, the Live Badge, and other rich formats), create a dedicated watch page for each video, if it makes sense for your business.

A watch page's main purpose is to show users a single video. The following pages are watch pages because watching an individual video is the main reason the user is

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
    xmlns:video="http://www.google.com/schemas/sitemap-video/1.1">
<url>
<loc>https://example.com/videos/some_video_landing_page.html</loc>
  <video:video>
  ...
```

Example 2 (unknown):
```unknown
<iframe src="https://example.com/videoplayer.php?video=123" width="640" height="360" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe>
```

Example 3 (unknown):
```unknown
"embedUrl": "https://example.com/videoplayer.php?video=123"
```

Example 4 (unknown):
```unknown
<video:player_loc>https://example.com/videoplayer.php?video=123</video:player_loc>
```

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#attribution

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#text-result-title-link

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---

## Control your snippets in search results

**URL:** https://developers.google.com/search/docs/appearance/snippet#meta-descriptions

**Contents:**
- Control your snippets in search results
- How snippets are created
- How to prevent snippets or adjust snippet length
- Best practices for creating quality meta descriptions
  - Create unique descriptions for each page on your site
  - Include relevant information about the content in the description
  - Programmatically generate descriptions
  - Use quality descriptions

A snippet is the description or summary part of search result on Google Search and other properties (for example, Google News). Google primarily uses the content on the page to automatically determine the appropriate snippet. We may also use descriptive information in the meta description element when it describes the page better than other parts of the content.

Get everything you need to sew your next garment. Open Monday-Friday 8-5pm, located in the Fashion District.

While we can't manually change snippets for individual sites, we're always working to make them as relevant as possible. You can help improve the quality of the snippet displayed for your pages by following the best practices for creating quality meta descriptions.

Snippets are automatically created from page content. Snippets are designed to emphasize and preview the page content that best relates to a user's specific search. This means that Google Search might show different snippets for different searches.

Snippets are primarily created from the page content itself. However, Google sometimes uses the meta description HTML element if it might give users a more accurate description of the page than content taken directly from the page.

You can prevent snippets from being created and shown for your site in search results, or let Google know about the maximum lengths that you want your snippets to be. To prevent Google from displaying a snippet for your page in search results, use the nosnippet meta tag. To specify the maximum length for your snippets, use the max-snippet:[number] meta tag. You can also prevent certain parts of the page from being shown in a snippet by using the data-nosnippet attribute.

Google will sometimes use the <meta name="description"> tag from a page to generate a snippet in search results, if we think it gives users a more accurate description than would be possible purely from the on-page content. A meta description tag generally informs and interests users with a short, relevant summary of what a particular page is about. They are like a pitch that convince the user that the page is exactly what they're looking for. There's no limit on how long a meta description can be, but the snippet is truncated in Google Search results as needed, typically to fit the device width.

If you use a CMS, such as Wix, WordPress, or Blogger, you might not be able to edit your HTML directly, or you might prefer not to. Instead, your CMS might have a search engine settings page o

*[Content truncated]*

---

## Generate structured data with JavaScript

**URL:** https://developers.google.com/search/docs/guides/generate-structured-data-with-javascript#testing

**Contents:**
- Generate structured data with JavaScript
- Use Google Tag Manager to generate JSON-LD dynamically
  - Using variables in Google Tag Manager
- Generate structured data with custom JavaScript
- Using server-side rendering
- Test your implementation

Modern websites use JavaScript to display lots of dynamic content. There are a few things you need to look out for when using JavaScript to generate structured data on your websites, and this guide covers best practices and implementation strategies. If you're new to structured data, you can learn more about how structured data works.

There are different ways to generate structured data with JavaScript, but the most common are:

Google Tag Manager is a platform that lets you manage tags on your website without editing the code. To generate structured data with Google Tag Manager, follow these steps:

Google Tag Manager (GTM) supports variables to use information on the page as part of your structured data. Use variables to extract the structured data from the page instead of duplicating the information in GTM. Duplicating the information in GTM increases the risk of having a mismatch between page content and the structured data inserted using GTM.

For example, you can dynamically create a Recipe JSON-LD block that uses the page title as the recipe name by creating the following custom variable named recipe_name:

You can then use {{recipe_name}} in your custom tag HTML.

We recommend to create variables to collect all the necessary information from the page using variables.

Here is an example for the custom HTML tag content:

Another way you can generate structured data is by using JavaScript to either generate all of your structured data or add more information to the server-side rendered structured data. Either way, Google Search can understand and process structured data that's available in the DOM when it renders the page. To learn more about how Google Search processes JavaScript, check out the JavaScript basics guide.

Here is an example of JavaScript-generated structured data:

If you are using server-side rendering, you can also include the structured data in the rendered output. Check the documentation of your framework to find out how to generate the JSON-LD for the type of structured data you're interested in.

To make sure Google Search can crawl and index your structured data, test your implementation:

Success: If you did everything correctly and your structured data type is supported in the tool, you will see the message "Page is eligible for rich results". If you are testing a structured data type that is not supported by the Rich Results test, check the rendered HTML. If the rendered HTML contains the structured data, Google Search will

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
function() { return document.title; }
```

Example 2 (unknown):
```unknown
<script type="application/ld+json">
  {
    "@context": "https://schema.org/",
    "@type": "Recipe",
    "name": "{{recipe_name}}",
    "image": [ "{{recipe_image}}" ],
    "author": {
      "@type": "Person",
      "name": "{{recipe_author}}"
    }
  }
</script>
```

Example 3 (javascript):
```javascript
fetch('https://api.example.com/recipes/123')
.then(response => response.text())
.then(structuredDataText => {
  const script = document.createElement('script');
  script.setAttribute('type', 'application/ld+json');
  script.textContent = structuredDataText;
  document.head.appendChild(script);
});
```

---

## Flexible Sampling general guidance

**URL:** https://developers.google.com/search/docs/appearance/flexible-sampling

**Contents:**
- Flexible Sampling general guidance
- Metering
  - How much content?
- Lead-in
- Making Changes
- How to indicate paywalled content

In order to better understand the potential impact of sampling changes on Google users and publishers' subscription models, we developed a series of experiments in cooperation with our publishing partners. From these experiments we learned that even minor changes to the current sampling levels could degrade user experience and, as user access is restricted, unintentionally impact article ranking in Google Search.

There are two types of sampling we advise: metering, which provides users with a quota of articles to consume before requiring users to subscribe or log in, after which paywalls will start appearing; and lead-in, which offers a portion of an article's content without it being shown in full.

We encourage publishers to experiment cautiously with different amounts of sampling. Here is some general guidance for implementing flexible sampling.

In general, we think that monthly, rather than daily metering provides more flexibility and a safer environment for testing. The user impact of changing from one integer value to the next is less significant at, say, 10 monthly samples than at 3 daily samples. Monthly metering also has the advantage of focusing paywall views on your most engaged users, who are those most likely to subscribe, while allowing your newer and less engaged users to become acquainted with the value of your content before experiencing a paywall. ("Paywall," in this context, applies equally to barriers that require either subscription or merely registration for content access.)

There is no single value for optimal sampling across different businesses. However, for most daily news publishers, we expect the value to fall between 6 and 10 articles per user per month. We think most publishers will find a number in that range that preserves a good user experience for new potential subscribers while driving conversion opportunities among the most engaged users.

As a starting point for your explorations, we encourage you to provide 10 articles per month to Google search users and iterate from there. We leave the exact number to the discretion of individual publishers, who are best positioned to understand the particular demands of their businesses. We encourage publishers to analyze the current percentage of search users who land on their paywalls, and select a monthly number that achieves a similar result. You can always lower the value later, after you have some confidence that you are on a stable footing.

In addition to metering, some p

*[Content truncated]*

---

## Control your snippets in search results

**URL:** https://developers.google.com/search/docs/appearance/snippet

**Contents:**
- Control your snippets in search results
- How snippets are created
- How to prevent snippets or adjust snippet length
- Best practices for creating quality meta descriptions
  - Create unique descriptions for each page on your site
  - Include relevant information about the content in the description
  - Programmatically generate descriptions
  - Use quality descriptions

A snippet is the description or summary part of search result on Google Search and other properties (for example, Google News). Google primarily uses the content on the page to automatically determine the appropriate snippet. We may also use descriptive information in the meta description element when it describes the page better than other parts of the content.

Get everything you need to sew your next garment. Open Monday-Friday 8-5pm, located in the Fashion District.

While we can't manually change snippets for individual sites, we're always working to make them as relevant as possible. You can help improve the quality of the snippet displayed for your pages by following the best practices for creating quality meta descriptions.

Snippets are automatically created from page content. Snippets are designed to emphasize and preview the page content that best relates to a user's specific search. This means that Google Search might show different snippets for different searches.

Snippets are primarily created from the page content itself. However, Google sometimes uses the meta description HTML element if it might give users a more accurate description of the page than content taken directly from the page.

You can prevent snippets from being created and shown for your site in search results, or let Google know about the maximum lengths that you want your snippets to be. To prevent Google from displaying a snippet for your page in search results, use the nosnippet meta tag. To specify the maximum length for your snippets, use the max-snippet:[number] meta tag. You can also prevent certain parts of the page from being shown in a snippet by using the data-nosnippet attribute.

Google will sometimes use the <meta name="description"> tag from a page to generate a snippet in search results, if we think it gives users a more accurate description than would be possible purely from the on-page content. A meta description tag generally informs and interests users with a short, relevant summary of what a particular page is about. They are like a pitch that convince the user that the page is exactly what they're looking for. There's no limit on how long a meta description can be, but the snippet is truncated in Google Search results as needed, typically to fit the device width.

If you use a CMS, such as Wix, WordPress, or Blogger, you might not be able to edit your HTML directly, or you might prefer not to. Instead, your CMS might have a search engine settings page o

*[Content truncated]*

---

## Visual Elements gallery of Google Search

**URL:** https://developers.google.com/search/docs/appearance/visual-elements-gallery#video-result-title-link

**Contents:**
- Visual Elements gallery of Google Search
- Anatomy of a Google Search results page
- Attribution
  - Favicon
  - Site name
  - Visible URL
  - Domain
  - Breadcrumb
- Text result
  - Attribution

Visual elements are the building blocks of the Google Search results page that a user can perceive or interact with. The Visual Elements gallery is an illustrated guide to the most common UI elements of Google web search: it explains what the elements look like, what they're called, and whether you can optimize your website for each element.

The Google Search results page contains a set of different types of search result visual elements, and each search result has its own set of possible child visual elements. For example, a text result is a visual element in its own right, and it has various child visual elements, such as attribution, title link, and snippet.

How the visual elements look can change over time, and a given result can be displayed differently depending on whether you're using a desktop computer or a phone, what country you're in, the language of your search query, and many other factors. Here are the most common types of search result visual elements that you might see in Google Search:

A result in Google Search that's based on the textual content of the page. Learn more about the text result visual elements.

A result that typically relies on structured data in the markup of your page to display graphical elements or interactive experiences. Explore the list of structured data features.

A result that's based on an image that's embedded on that web page. An image result is more likely to show for image-seeking queries. Learn more about the image result visual elements.

A result that's based on a video that's embedded on that web page. A video result is more likely to show for video-seeking queries. Learn more about the video result visual elements.

A feature that helps searchers expand and refine their initial search. Learn more about exploration features.

Attribution describes the source of a search result, and can appear for a variety of search result types, including text, image, and video results. Attribution can include various aspects of the source, such as the name of the site, favicon, and URL to the web page.

The small icon that's associated with the site. Learn how to provide a favicon.

The name of the site. Learn how to provide a site name with structured data.

The URL of the page that's shown in a readable format. A visible URL has two parts: domain and breadcrumb.

The site address as defined by the domain name. This is the name you chose when setting up the website (for example, example.com).

The trail that shows th

*[Content truncated]*

---
