# Google-Search-Docs - Fundamentals

**Pages:** 16

---

## Creating helpful, reliable, people-first content

**URL:** https://developers.google.com/search/docs/fundamentals/creating-helpful-content#eat

**Contents:**
- Creating helpful, reliable, people-first content
- Self-assess your content
  - Content and quality questions
  - Expertise questions
- Provide a great page experience
- Focus on people-first content
- Avoid creating search engine-first content
  - What about SEO? Isn't that search engine-first?
- Get to know E-E-A-T and the quality rater guidelines
- Ask "Who, How, and Why" about your content

Google's automated ranking systems are designed to prioritize helpful, reliable information that's created to benefit people, and not content that's created to manipulate search engine rankings. This page is designed to help creators evaluate if they're producing such content.

Evaluating your own content against these questions can help you gauge if the content you're making is helpful and reliable. Beyond asking yourself these questions, consider having others you trust but who are unaffiliated with your site provide an honest assessment.

Also consider an audit of the drops you may have experienced. What pages were most impacted and for what types of searches? Look closely at these to understand how they're assessed against some of the questions outlined here.

Google's core ranking systems look to reward content that provides a good page experience. Site owners seeking to be successful with our systems should not focus on only one or two aspects of page experience. Instead, check if you're providing an overall great page experience across many aspects. For more advice, see our page, Understanding page experience in Google Search results.

People-first content means content that's created primarily for people, and not to manipulate search engine rankings. How can you evaluate if you're creating people-first content? Answering yes to the questions below means you're probably on the right track with a people-first approach:

We recommend that you focus on creating people-first content to be successful with Google Search, rather than search engine-first content made primarily to gain search engine rankings. Answering yes to some or all of the questions below is a warning sign that you should reevaluate how you're creating content:

There are some things you could do that are specifically meant to help search engines better discover and understand your content. Collectively, this is called "search engine optimization" or SEO, for short. Google's own SEO guide covers best practices to consider. SEO can be a helpful activity when it is applied to people-first content, rather than search engine-first content.

Google's automated systems are designed to use many different factors to rank great content. After identifying relevant content, our systems aim to prioritize those that seem most helpful. To do this, they identify a mix of factors that can help determine which content demonstrates aspects of experience, expertise, authoritativeness, and trustworthiness,

*[Content truncated]*

---

## Search Engine Optimization (SEO) Starter Guide

**URL:** https://developers.google.com/search/docs/fundamentals/seo-starter-guide#expect-search-terms

**Contents:**
- Search Engine Optimization (SEO) Starter Guide
- How does Google Search work?
- How long until I see impact in search results?
- Help Google find your content
  - Check if Google can see your page the same way a user does
  - Don't want a page in Google's search results?
- Organize your site
  - Use descriptive URLs
  - Group topically similar pages in directories
  - Reduce duplicate content

When you built your website, you likely created it with your users in mind, trying to make it easy for them to find and explore your content. One of those users is a search engine, which helps people discover your content. SEO—short for search engine optimization—is about helping search engines understand your content, and helping users find your site and make a decision about whether they should visit your site through a search engine.

The Search Essentials outline the most important elements of what makes your website eligible to appear on Google Search. While there's no guarantee that any particular site will be added to Google's index, sites that follow the Search Essentials are more likely to show up in Google's search results. SEO is about taking the next step and working on improving your site's presence in Search. This guide will walk you through some of the most common and effective improvements you can do on your site.

There are no secrets here that'll automatically rank your site first in Google (sorry!). In fact some of the suggestions might not even apply to your business, but following the best practices will hopefully make it easier for search engines (not just Google) to crawl, index, and understand your content.

Google is a fully automated search engine that uses programs called crawlers to explore the web constantly, looking for pages to add to our index. You usually don't need to do anything except publish your site on the web. In fact, the vast majority of sites listed in our results are found and added automatically as we crawl the web. If you're hungry for more, we have documentation about how Google discovers, crawls, and serves web pages.

Every change you make will take some time to be reflected on Google's end. Some changes might take effect in a few hours, others could take several months. In general, you likely want to wait a few weeks to assess whether your work had beneficial effects in Google Search results. Keep in mind that not all changes you make to your website will result in noticeable impact in search results; if you're not satisfied with your results and your business strategies allow it, try iterating with the changes and see if they make a difference.

Before you actually do anything mentioned in this section, check if Google has already found your content (maybe you don't need to do anything!). Try searching on Google for your site with the site: search operator. If you see results pointing to your site, you're 

*[Content truncated]*

---

## In-depth guide to how Google Search works

**URL:** https://developers.google.com/search/docs/fundamentals/how-search-works#indexing

**Contents:**
- In-depth guide to how Google Search works
- A few notes before we get started
- Introducing the three stages of Google Search
- Crawling
- Indexing
- Serving search results

Google Search is a fully-automated search engine that uses software known as web crawlers that explore the web regularly to find pages to add to our index. In fact, the vast majority of pages listed in our results aren't manually submitted for inclusion, but are found and added automatically when our web crawlers explore the web. This document explains the stages of how Search works in the context of your website. Having this base knowledge can help you fix crawling issues, get your pages indexed, and learn how to optimize how your site appears in Google Search.

Before we get into the details of how Search works, it's important to note that Google doesn't accept payment to crawl a site more frequently, or rank it higher. If anyone tells you otherwise, they're wrong.

Google doesn't guarantee that it will crawl, index, or serve your page, even if your page follows the Google Search Essentials.

Google Search works in three stages, and not all pages make it through each stage:

The first stage is finding out what pages exist on the web. There isn't a central registry of all web pages, so Google must constantly look for new and updated pages and add them to its list of known pages. This process is called "URL discovery". Some pages are known because Google has already visited them. Other pages are discovered when Google extracts a link from a known page to a new page: for example, a hub page, such as a category page, links to a new blog post. Still other pages are discovered when you submit a list of pages (a sitemap) for Google to crawl.

Once Google discovers a page's URL, it may visit (or "crawl") the page to find out what's on it. We use a huge set of computers to crawl billions of pages on the web. The program that does the fetching is called Googlebot (also known as a crawler, robot, bot, or spider). Googlebot uses an algorithmic process to determine which sites to crawl, how often, and how many pages to fetch from each site. Google's crawlers are also programmed such that they try not to crawl the site too fast to avoid overloading it. This mechanism is based on the responses of the site (for example, HTTP 500 errors mean "slow down").

However, Googlebot doesn't crawl all the pages it discovered. Some pages may be disallowed for crawling by the site owner, other pages may not be accessible without logging in to the site.

During the crawl, Google renders the page and runs any JavaScript it finds using a recent version of Chrome, similar to how your b

*[Content truncated]*

---

## Maintaining your website's SEO

**URL:** https://developers.google.com/search/docs/fundamentals/get-started

**Contents:**
- Maintaining your website's SEO
- Control how Google crawls and indexes your site
  - Duplicate content
  - Resources
  - Robots.txt
  - Sitemaps
  - Internationalized or multi-lingual sites
  - Migrating a page or a site
    - Migrating a single URL
    - Migrating a site

If your site is on Google and you're familiar with the fundamentals of SEO, there are more things you can do to improve how your site appears on Google. As you manage and maintain your website, you may come across more unique scenarios that affect Google Search. This guide covers more in-depth SEO tasks, such as preparing for a site move or managing a multi-lingual site.

Read our guide to understand how Google Search works; if you don't understand the crawl/index/serving pipeline well, it will be difficult to debug issues or anticipate Search behavior on your site.

Be sure that you understand what canonical pages are, and how they affect crawling and indexing of your site.

Be sure that any resources (images, CSS files, and so on) or pages that Google is meant to crawl are accessible to Google; that is, they are not blocked by any robots.txt rules and are accessible to an anonymous user. Inaccessible pages will not appear in the Page Indexing report, and the URL Inspection tool will show them as not crawled. Blocked resources are shown only at the individual URL level, in the URL Inspection tool. If important resources on a page are blocked, this can prevent Google from crawling your page properly. Use the URL Inspection tool to render the live page to verify whether Google sees the page as you expect.

Use robots.txt rules to prevent crawling, and sitemaps to encourage crawling. Block crawling of duplicate content on your site, or unimportant resources (such as small, frequently used graphics such as icons or logos) that might overload your server with requests. Don't use robots.txt as a mechanism to prevent indexing; use the noindex tag or login requirements for that. Read more about blocking access to your content.

Sitemaps are a very important way to tell Google which pages are important to your site, and also provide additional information (such as update frequency), and are very important for crawling non-textual content (such as images or video). Although Google won't limit crawling to pages listed in your sitemaps, it will prioritize crawling these pages. This is especially important for sites with rapidly changing content, or with pages that might not be discovered through links. Using sitemaps helps Google discover and prioritize which pages to crawl on your site. Read all about sitemaps here.

If your site includes multiple languages, or is targeted at users in specific locales:

On the occasion that you might need to move a single URL or eve

*[Content truncated]*

---

## Understand the JavaScript SEO basics

**URL:** https://developers.google.com/search/docs/crawling-indexing/javascript/javascript-seo-basics#how-googlebot-processes-javascript

**Contents:**
- Understand the JavaScript SEO basics
- How Google processes JavaScript
- Describe your page with unique titles and snippets
- Write compatible code
- Use meaningful HTTP status codes
  - Avoid soft 404 errors in single-page apps
- Use the History API instead of fragments
- Properly inject the rel="canonical" link tag
- Use robots meta tags carefully
- Use long-lived caching

JavaScript is an important part of the web platform because it provides many features that turn the web into a powerful application platform. Making your JavaScript-powered web applications discoverable via Google Search can help you find new users and re-engage existing users as they search for the content your web app provides. While Google Search runs JavaScript with an evergreen version of Chromium, there are a few things that you can optimize.

This guide describes how Google Search processes JavaScript and best practices for improving JavaScript web apps for Google Search.

Google processes JavaScript web apps in three main phases:

Googlebot queues pages for both crawling and rendering. It is not immediately obvious when a page is waiting for crawling and when it is waiting for rendering. When Googlebot fetches a URL from the crawling queue by making an HTTP request, it first checks if you allow crawling. Googlebot reads the robots.txt file. If it marks the URL as disallowed, then Googlebot skips making an HTTP request to this URL and skips the URL. Google Search won't render JavaScript from blocked files or on blocked pages.

Googlebot then parses the response for other URLs in the href attribute of HTML links and adds the URLs to the crawl queue. To prevent link discovery, use the nofollow mechanism.

Crawling a URL and parsing the HTML response works well for classical websites or server-side rendered pages where the HTML in the HTTP response contains all content. Some JavaScript sites may use the app shell model where the initial HTML does not contain the actual content and Google needs to execute JavaScript before being able to see the actual page content that JavaScript generates.

Googlebot queues all pages for rendering, unless a robots meta tag or header tells Google not to index the page. The page may stay on this queue for a few seconds, but it can take longer than that. Once Google's resources allow, a headless Chromium renders the page and executes the JavaScript. Googlebot parses the rendered HTML for links again and queues the URLs it finds for crawling. Google also uses the rendered HTML to index the page.

Keep in mind that server-side or pre-rendering is still a great idea because it makes your website faster for users and crawlers, and not all bots can run JavaScript.

Unique, descriptive <title> elements and meta descriptions help users quickly identify the best result for their goal. You can use JavaScript to set or change the m

*[Content truncated]*

**Examples:**

Example 1 (javascript):
```javascript
fetch(`/api/products/${productId}`)
.then(response => response.json())
.then(product => {
  if(product.exists) {
    showProductDetails(product); // shows the product information on the page
  } else {
    // this product does not exist, so this is an error page.
    window.location.href = '/not-found'; // redirect to 404 page on the server.
  }
})
```

Example 2 (javascript):
```javascript
fetch(`/api/products/${productId}`)
.then(response => response.json())
.then(product => {
  if(product.exists) {
    showProductDetails(product); // shows the product information on the page
  } else {
    // this product does not exist, so this is an error page.
    // Note: This example assumes there is no other robots meta tag present in the HTML.
    const metaRobots = document.createElement('meta');
    metaRobots.name = 'robots';
    metaRobots.content = 'noindex';
    document.head.appendChild(metaRobots);
  }
})
```

Example 3 (javascript):
```javascript
<nav>
  <ul>
    <li><a href="#/products">Our products</a></li>
    <li><a href="#/services">Our services</a></li>
  </ul>
</nav>

<h1>Welcome to example.com!</h1>
<div id="placeholder">
  <p>Learn more about <a href="#/products">our products</a> and <a href="#/services">our services</a></p>
</div>
<script>
window.addEventListener('hashchange', function goToPage() {
  // this function loads different content based on the current URL fragment
  const pageToLoad = window.location.hash.slice(1); // URL fragment
  document.getElementById('placeholder').innerHTML = load(pageToLoad);
});
</script>
```

Example 4 (javascript):
```javascript
<nav>
  <ul>
    <li><a href="/products">Our products</a></li>
    <li><a href="/services">Our services</a></li>
  </ul>
</nav>

<h1>Welcome to example.com!</h1>
<div id="placeholder">
  <p>Learn more about <a href="/products">our products</a> and <a href="/services">our services</a></p>
</div>
<script>
function goToPage(event) {
  event.preventDefault(); // stop the browser from navigating to the destination URL.
  const hrefUrl = event.target.getAttribute('href');
  const pageToLoad = hrefUrl.slice(1); // remove the leading slash
  document.getElementById('placeholder').innerHTML = load(page
...
```

---

## Search Engine Optimization (SEO) Starter Guide

**URL:** https://developers.google.com/search/docs/fundamentals/seo-starter-guide#promoting

**Contents:**
- Search Engine Optimization (SEO) Starter Guide
- How does Google Search work?
- How long until I see impact in search results?
- Help Google find your content
  - Check if Google can see your page the same way a user does
  - Don't want a page in Google's search results?
- Organize your site
  - Use descriptive URLs
  - Group topically similar pages in directories
  - Reduce duplicate content

When you built your website, you likely created it with your users in mind, trying to make it easy for them to find and explore your content. One of those users is a search engine, which helps people discover your content. SEO—short for search engine optimization—is about helping search engines understand your content, and helping users find your site and make a decision about whether they should visit your site through a search engine.

The Search Essentials outline the most important elements of what makes your website eligible to appear on Google Search. While there's no guarantee that any particular site will be added to Google's index, sites that follow the Search Essentials are more likely to show up in Google's search results. SEO is about taking the next step and working on improving your site's presence in Search. This guide will walk you through some of the most common and effective improvements you can do on your site.

There are no secrets here that'll automatically rank your site first in Google (sorry!). In fact some of the suggestions might not even apply to your business, but following the best practices will hopefully make it easier for search engines (not just Google) to crawl, index, and understand your content.

Google is a fully automated search engine that uses programs called crawlers to explore the web constantly, looking for pages to add to our index. You usually don't need to do anything except publish your site on the web. In fact, the vast majority of sites listed in our results are found and added automatically as we crawl the web. If you're hungry for more, we have documentation about how Google discovers, crawls, and serves web pages.

Every change you make will take some time to be reflected on Google's end. Some changes might take effect in a few hours, others could take several months. In general, you likely want to wait a few weeks to assess whether your work had beneficial effects in Google Search results. Keep in mind that not all changes you make to your website will result in noticeable impact in search results; if you're not satisfied with your results and your business strategies allow it, try iterating with the changes and see if they make a difference.

Before you actually do anything mentioned in this section, check if Google has already found your content (maybe you don't need to do anything!). Try searching on Google for your site with the site: search operator. If you see results pointing to your site, you're 

*[Content truncated]*

---

## In-depth guide to how Google Search works

**URL:** https://developers.google.com/search/docs/fundamentals/how-search-works#serving

**Contents:**
- In-depth guide to how Google Search works
- A few notes before we get started
- Introducing the three stages of Google Search
- Crawling
- Indexing
- Serving search results

Google Search is a fully-automated search engine that uses software known as web crawlers that explore the web regularly to find pages to add to our index. In fact, the vast majority of pages listed in our results aren't manually submitted for inclusion, but are found and added automatically when our web crawlers explore the web. This document explains the stages of how Search works in the context of your website. Having this base knowledge can help you fix crawling issues, get your pages indexed, and learn how to optimize how your site appears in Google Search.

Before we get into the details of how Search works, it's important to note that Google doesn't accept payment to crawl a site more frequently, or rank it higher. If anyone tells you otherwise, they're wrong.

Google doesn't guarantee that it will crawl, index, or serve your page, even if your page follows the Google Search Essentials.

Google Search works in three stages, and not all pages make it through each stage:

The first stage is finding out what pages exist on the web. There isn't a central registry of all web pages, so Google must constantly look for new and updated pages and add them to its list of known pages. This process is called "URL discovery". Some pages are known because Google has already visited them. Other pages are discovered when Google extracts a link from a known page to a new page: for example, a hub page, such as a category page, links to a new blog post. Still other pages are discovered when you submit a list of pages (a sitemap) for Google to crawl.

Once Google discovers a page's URL, it may visit (or "crawl") the page to find out what's on it. We use a huge set of computers to crawl billions of pages on the web. The program that does the fetching is called Googlebot (also known as a crawler, robot, bot, or spider). Googlebot uses an algorithmic process to determine which sites to crawl, how often, and how many pages to fetch from each site. Google's crawlers are also programmed such that they try not to crawl the site too fast to avoid overloading it. This mechanism is based on the responses of the site (for example, HTTP 500 errors mean "slow down").

However, Googlebot doesn't crawl all the pages it discovered. Some pages may be disallowed for crawling by the site owner, other pages may not be accessible without logging in to the site.

During the crawl, Google renders the page and runs any JavaScript it finds using a recent version of Chrome, similar to how your b

*[Content truncated]*

---

## In-depth guide to how Google Search works

**URL:** https://developers.google.com/search/docs/fundamentals/how-search-works

**Contents:**
- In-depth guide to how Google Search works
- A few notes before we get started
- Introducing the three stages of Google Search
- Crawling
- Indexing
- Serving search results

Google Search is a fully-automated search engine that uses software known as web crawlers that explore the web regularly to find pages to add to our index. In fact, the vast majority of pages listed in our results aren't manually submitted for inclusion, but are found and added automatically when our web crawlers explore the web. This document explains the stages of how Search works in the context of your website. Having this base knowledge can help you fix crawling issues, get your pages indexed, and learn how to optimize how your site appears in Google Search.

Before we get into the details of how Search works, it's important to note that Google doesn't accept payment to crawl a site more frequently, or rank it higher. If anyone tells you otherwise, they're wrong.

Google doesn't guarantee that it will crawl, index, or serve your page, even if your page follows the Google Search Essentials.

Google Search works in three stages, and not all pages make it through each stage:

The first stage is finding out what pages exist on the web. There isn't a central registry of all web pages, so Google must constantly look for new and updated pages and add them to its list of known pages. This process is called "URL discovery". Some pages are known because Google has already visited them. Other pages are discovered when Google extracts a link from a known page to a new page: for example, a hub page, such as a category page, links to a new blog post. Still other pages are discovered when you submit a list of pages (a sitemap) for Google to crawl.

Once Google discovers a page's URL, it may visit (or "crawl") the page to find out what's on it. We use a huge set of computers to crawl billions of pages on the web. The program that does the fetching is called Googlebot (also known as a crawler, robot, bot, or spider). Googlebot uses an algorithmic process to determine which sites to crawl, how often, and how many pages to fetch from each site. Google's crawlers are also programmed such that they try not to crawl the site too fast to avoid overloading it. This mechanism is based on the responses of the site (for example, HTTP 500 errors mean "slow down").

However, Googlebot doesn't crawl all the pages it discovered. Some pages may be disallowed for crawling by the site owner, other pages may not be accessible without logging in to the site.

During the crawl, Google renders the page and runs any JavaScript it finds using a recent version of Chrome, similar to how your b

*[Content truncated]*

---

## Do you need an SEO?

**URL:** https://developers.google.com/search/docs/fundamentals/do-i-need-seo

**Contents:**
- Do you need an SEO?
- Getting started with SEO
- Choosing an SEO
  - Precautions
- Helpful guidelines

SEO is an acronym for "search engine optimization" or "search engine optimizer." Deciding to hire an SEO is a big decision that can potentially improve your site and save time, but you can also risk damage to your site and reputation. Make sure to research the potential advantages as well as the damage that an irresponsible SEO can do to your site. Many SEOs and other agencies and consultants provide useful services for website owners, including:

Advertising with Google won't have any effect on your site's presence in our search results. Google never accepts money to include or rank sites in our search results, and it costs nothing to appear in our organic search results. Resources such as Search Console, the official Google Search Central blog, and our discussion forum can provide you with a great deal of information about how to optimize your site for organic search.

If you run a small local business, you can probably do much of the work yourself. Here are some good resources:

Remember that it will take time for you to see results: typically from four months to a year from the time you begin making changes until you start to see the benefits.

If you think that you still need extra help from a professional, continue reading about how to choose an SEO.

If you're thinking about hiring an SEO, the earlier the better. A great time to hire is when you're considering a site redesign, or planning to launch a new site. That way, you and your SEO can ensure that your site is designed to be search engine-friendly from the bottom up. However, a good SEO can also help improve an existing site.

While SEOs can provide clients with valuable services, some unethical SEOs have given the industry a black eye by using overly aggressive marketing efforts and attempting to manipulate search engine results in unfair ways. Practices that violate our spam policies may result in a negative adjustment of your site's presence in Google, or even the removal of your site from our index.

When your SEO comes up with a set of recommendations for your site, ask them to corroborate these recommendations with a trusted source, such as a Search Console help page, Google Search Central blog entry, or Google-sanctioned response in the forum.

Here are some things to consider:

If you feel that you were deceived by an SEO in some way, you may want to report it.

In the United States, the Federal Trade Commission (FTC) handles complaints about deceptive or unfair business practices. To f

*[Content truncated]*

---

## Creating helpful, reliable, people-first content

**URL:** https://developers.google.com/search/docs/fundamentals/creating-helpful-content#self-assess

**Contents:**
- Creating helpful, reliable, people-first content
- Self-assess your content
  - Content and quality questions
  - Expertise questions
- Provide a great page experience
- Focus on people-first content
- Avoid creating search engine-first content
  - What about SEO? Isn't that search engine-first?
- Get to know E-E-A-T and the quality rater guidelines
- Ask "Who, How, and Why" about your content

Google's automated ranking systems are designed to prioritize helpful, reliable information that's created to benefit people, and not content that's created to manipulate search engine rankings. This page is designed to help creators evaluate if they're producing such content.

Evaluating your own content against these questions can help you gauge if the content you're making is helpful and reliable. Beyond asking yourself these questions, consider having others you trust but who are unaffiliated with your site provide an honest assessment.

Also consider an audit of the drops you may have experienced. What pages were most impacted and for what types of searches? Look closely at these to understand how they're assessed against some of the questions outlined here.

Google's core ranking systems look to reward content that provides a good page experience. Site owners seeking to be successful with our systems should not focus on only one or two aspects of page experience. Instead, check if you're providing an overall great page experience across many aspects. For more advice, see our page, Understanding page experience in Google Search results.

People-first content means content that's created primarily for people, and not to manipulate search engine rankings. How can you evaluate if you're creating people-first content? Answering yes to the questions below means you're probably on the right track with a people-first approach:

We recommend that you focus on creating people-first content to be successful with Google Search, rather than search engine-first content made primarily to gain search engine rankings. Answering yes to some or all of the questions below is a warning sign that you should reevaluate how you're creating content:

There are some things you could do that are specifically meant to help search engines better discover and understand your content. Collectively, this is called "search engine optimization" or SEO, for short. Google's own SEO guide covers best practices to consider. SEO can be a helpful activity when it is applied to people-first content, rather than search engine-first content.

Google's automated systems are designed to use many different factors to rank great content. After identifying relevant content, our systems aim to prioritize those that seem most helpful. To do this, they identify a mix of factors that can help determine which content demonstrates aspects of experience, expertise, authoritativeness, and trustworthiness,

*[Content truncated]*

---

## Search Engine Optimization (SEO) Starter Guide

**URL:** https://developers.google.com/search/docs/fundamentals/seo-starter-guide

**Contents:**
- Search Engine Optimization (SEO) Starter Guide
- How does Google Search work?
- How long until I see impact in search results?
- Help Google find your content
  - Check if Google can see your page the same way a user does
  - Don't want a page in Google's search results?
- Organize your site
  - Use descriptive URLs
  - Group topically similar pages in directories
  - Reduce duplicate content

When you built your website, you likely created it with your users in mind, trying to make it easy for them to find and explore your content. One of those users is a search engine, which helps people discover your content. SEO—short for search engine optimization—is about helping search engines understand your content, and helping users find your site and make a decision about whether they should visit your site through a search engine.

The Search Essentials outline the most important elements of what makes your website eligible to appear on Google Search. While there's no guarantee that any particular site will be added to Google's index, sites that follow the Search Essentials are more likely to show up in Google's search results. SEO is about taking the next step and working on improving your site's presence in Search. This guide will walk you through some of the most common and effective improvements you can do on your site.

There are no secrets here that'll automatically rank your site first in Google (sorry!). In fact some of the suggestions might not even apply to your business, but following the best practices will hopefully make it easier for search engines (not just Google) to crawl, index, and understand your content.

Google is a fully automated search engine that uses programs called crawlers to explore the web constantly, looking for pages to add to our index. You usually don't need to do anything except publish your site on the web. In fact, the vast majority of sites listed in our results are found and added automatically as we crawl the web. If you're hungry for more, we have documentation about how Google discovers, crawls, and serves web pages.

Every change you make will take some time to be reflected on Google's end. Some changes might take effect in a few hours, others could take several months. In general, you likely want to wait a few weeks to assess whether your work had beneficial effects in Google Search results. Keep in mind that not all changes you make to your website will result in noticeable impact in search results; if you're not satisfied with your results and your business strategies allow it, try iterating with the changes and see if they make a difference.

Before you actually do anything mentioned in this section, check if Google has already found your content (maybe you don't need to do anything!). Try searching on Google for your site with the site: search operator. If you see results pointing to your site, you're 

*[Content truncated]*

---

## Creating helpful, reliable, people-first content

**URL:** https://developers.google.com/search/docs/fundamentals/creating-helpful-content

**Contents:**
- Creating helpful, reliable, people-first content
- Self-assess your content
  - Content and quality questions
  - Expertise questions
- Provide a great page experience
- Focus on people-first content
- Avoid creating search engine-first content
  - What about SEO? Isn't that search engine-first?
- Get to know E-E-A-T and the quality rater guidelines
- Ask "Who, How, and Why" about your content

Google's automated ranking systems are designed to prioritize helpful, reliable information that's created to benefit people, and not content that's created to manipulate search engine rankings. This page is designed to help creators evaluate if they're producing such content.

Evaluating your own content against these questions can help you gauge if the content you're making is helpful and reliable. Beyond asking yourself these questions, consider having others you trust but who are unaffiliated with your site provide an honest assessment.

Also consider an audit of the drops you may have experienced. What pages were most impacted and for what types of searches? Look closely at these to understand how they're assessed against some of the questions outlined here.

Google's core ranking systems look to reward content that provides a good page experience. Site owners seeking to be successful with our systems should not focus on only one or two aspects of page experience. Instead, check if you're providing an overall great page experience across many aspects. For more advice, see our page, Understanding page experience in Google Search results.

People-first content means content that's created primarily for people, and not to manipulate search engine rankings. How can you evaluate if you're creating people-first content? Answering yes to the questions below means you're probably on the right track with a people-first approach:

We recommend that you focus on creating people-first content to be successful with Google Search, rather than search engine-first content made primarily to gain search engine rankings. Answering yes to some or all of the questions below is a warning sign that you should reevaluate how you're creating content:

There are some things you could do that are specifically meant to help search engines better discover and understand your content. Collectively, this is called "search engine optimization" or SEO, for short. Google's own SEO guide covers best practices to consider. SEO can be a helpful activity when it is applied to people-first content, rather than search engine-first content.

Google's automated systems are designed to use many different factors to rank great content. After identifying relevant content, our systems aim to prioritize those that seem most helpful. To do this, they identify a mix of factors that can help determine which content demonstrates aspects of experience, expertise, authoritativeness, and trustworthiness,

*[Content truncated]*

---

## In-depth guide to how Google Search works

**URL:** https://developers.google.com/search/docs/fundamentals/how-search-works#crawling

**Contents:**
- In-depth guide to how Google Search works
- A few notes before we get started
- Introducing the three stages of Google Search
- Crawling
- Indexing
- Serving search results

Google Search is a fully-automated search engine that uses software known as web crawlers that explore the web regularly to find pages to add to our index. In fact, the vast majority of pages listed in our results aren't manually submitted for inclusion, but are found and added automatically when our web crawlers explore the web. This document explains the stages of how Search works in the context of your website. Having this base knowledge can help you fix crawling issues, get your pages indexed, and learn how to optimize how your site appears in Google Search.

Before we get into the details of how Search works, it's important to note that Google doesn't accept payment to crawl a site more frequently, or rank it higher. If anyone tells you otherwise, they're wrong.

Google doesn't guarantee that it will crawl, index, or serve your page, even if your page follows the Google Search Essentials.

Google Search works in three stages, and not all pages make it through each stage:

The first stage is finding out what pages exist on the web. There isn't a central registry of all web pages, so Google must constantly look for new and updated pages and add them to its list of known pages. This process is called "URL discovery". Some pages are known because Google has already visited them. Other pages are discovered when Google extracts a link from a known page to a new page: for example, a hub page, such as a category page, links to a new blog post. Still other pages are discovered when you submit a list of pages (a sitemap) for Google to crawl.

Once Google discovers a page's URL, it may visit (or "crawl") the page to find out what's on it. We use a huge set of computers to crawl billions of pages on the web. The program that does the fetching is called Googlebot (also known as a crawler, robot, bot, or spider). Googlebot uses an algorithmic process to determine which sites to crawl, how often, and how many pages to fetch from each site. Google's crawlers are also programmed such that they try not to crawl the site too fast to avoid overloading it. This mechanism is based on the responses of the site (for example, HTTP 500 errors mean "slow down").

However, Googlebot doesn't crawl all the pages it discovered. Some pages may be disallowed for crawling by the site owner, other pages may not be accessible without logging in to the site.

During the crawl, Google renders the page and runs any JavaScript it finds using a recent version of Chrome, similar to how your b

*[Content truncated]*

---

## Understand the JavaScript SEO basics

**URL:** https://developers.google.com/search/docs/guides/javascript-seo-basics

**Contents:**
- Understand the JavaScript SEO basics
- How Google processes JavaScript
- Describe your page with unique titles and snippets
- Write compatible code
- Use meaningful HTTP status codes
  - Avoid soft 404 errors in single-page apps
- Use the History API instead of fragments
- Properly inject the rel="canonical" link tag
- Use robots meta tags carefully
- Use long-lived caching

JavaScript is an important part of the web platform because it provides many features that turn the web into a powerful application platform. Making your JavaScript-powered web applications discoverable via Google Search can help you find new users and re-engage existing users as they search for the content your web app provides. While Google Search runs JavaScript with an evergreen version of Chromium, there are a few things that you can optimize.

This guide describes how Google Search processes JavaScript and best practices for improving JavaScript web apps for Google Search.

Google processes JavaScript web apps in three main phases:

Googlebot queues pages for both crawling and rendering. It is not immediately obvious when a page is waiting for crawling and when it is waiting for rendering. When Googlebot fetches a URL from the crawling queue by making an HTTP request, it first checks if you allow crawling. Googlebot reads the robots.txt file. If it marks the URL as disallowed, then Googlebot skips making an HTTP request to this URL and skips the URL. Google Search won't render JavaScript from blocked files or on blocked pages.

Googlebot then parses the response for other URLs in the href attribute of HTML links and adds the URLs to the crawl queue. To prevent link discovery, use the nofollow mechanism.

Crawling a URL and parsing the HTML response works well for classical websites or server-side rendered pages where the HTML in the HTTP response contains all content. Some JavaScript sites may use the app shell model where the initial HTML does not contain the actual content and Google needs to execute JavaScript before being able to see the actual page content that JavaScript generates.

Googlebot queues all pages for rendering, unless a robots meta tag or header tells Google not to index the page. The page may stay on this queue for a few seconds, but it can take longer than that. Once Google's resources allow, a headless Chromium renders the page and executes the JavaScript. Googlebot parses the rendered HTML for links again and queues the URLs it finds for crawling. Google also uses the rendered HTML to index the page.

Keep in mind that server-side or pre-rendering is still a great idea because it makes your website faster for users and crawlers, and not all bots can run JavaScript.

Unique, descriptive <title> elements and meta descriptions help users quickly identify the best result for their goal. You can use JavaScript to set or change the m

*[Content truncated]*

**Examples:**

Example 1 (javascript):
```javascript
fetch(`/api/products/${productId}`)
.then(response => response.json())
.then(product => {
  if(product.exists) {
    showProductDetails(product); // shows the product information on the page
  } else {
    // this product does not exist, so this is an error page.
    window.location.href = '/not-found'; // redirect to 404 page on the server.
  }
})
```

Example 2 (javascript):
```javascript
fetch(`/api/products/${productId}`)
.then(response => response.json())
.then(product => {
  if(product.exists) {
    showProductDetails(product); // shows the product information on the page
  } else {
    // this product does not exist, so this is an error page.
    // Note: This example assumes there is no other robots meta tag present in the HTML.
    const metaRobots = document.createElement('meta');
    metaRobots.name = 'robots';
    metaRobots.content = 'noindex';
    document.head.appendChild(metaRobots);
  }
})
```

Example 3 (javascript):
```javascript
<nav>
  <ul>
    <li><a href="#/products">Our products</a></li>
    <li><a href="#/services">Our services</a></li>
  </ul>
</nav>

<h1>Welcome to example.com!</h1>
<div id="placeholder">
  <p>Learn more about <a href="#/products">our products</a> and <a href="#/services">our services</a></p>
</div>
<script>
window.addEventListener('hashchange', function goToPage() {
  // this function loads different content based on the current URL fragment
  const pageToLoad = window.location.hash.slice(1); // URL fragment
  document.getElementById('placeholder').innerHTML = load(pageToLoad);
});
</script>
```

Example 4 (javascript):
```javascript
<nav>
  <ul>
    <li><a href="/products">Our products</a></li>
    <li><a href="/services">Our services</a></li>
  </ul>
</nav>

<h1>Welcome to example.com!</h1>
<div id="placeholder">
  <p>Learn more about <a href="/products">our products</a> and <a href="/services">our services</a></p>
</div>
<script>
function goToPage(event) {
  event.preventDefault(); // stop the browser from navigating to the destination URL.
  const hrefUrl = event.target.getAttribute('href');
  const pageToLoad = hrefUrl.slice(1); // remove the leading slash
  document.getElementById('placeholder').innerHTML = load(page
...
```

---

## Get your website on Google

**URL:** https://developers.google.com/search/docs/fundamentals/get-on-google

**Contents:**
- Get your website on Google
- Basic checklist for appearing in Google Search results
  - Is your website showing up on Google?
  - Do you serve high-quality content to users?
  - Is your local business showing up on Google?
  - Is your content fast and easy to access on all devices?
  - Is your website secure?
  - Do you need additional help?
  - Is your content about a specialized topic?

Google automatically looks for sites to add to our index; you usually don't even need to do anything except post your site on the web. However, sometimes sites get missed. Check to see if your site is on Google and learn how to make your content more visible in Google Search.

Here are a few basic questions to ask yourself about your website when you get started. You can find additional getting started information in the SEO Starter Guide.

To see if your pages are already indexed, search for your site in Google Search with a query like this. Substitute your own site for "example.com".

Although Google crawls billions of pages, it's inevitable that some sites will be missed. When our crawlers miss a site, it's frequently for one of the following reasons:

If you're feeling adventurous, you can add your site to Search Console to see if there's an error that might prevent Google from understanding your site. You can also send us your most important URLs to let us know we should crawl and potentially index them.

Follow the Google Search Essentials to make sure that you're fulfilling the site guidelines for appearing on Google.

Your number one priority is ensuring that your users have the best possible experience on your site. Think about what makes your site unique, valuable, or engaging. To help you evaluate your content, ask yourself the self-assessment questions in our guide to creating content that's helpful, reliable, and people-first. To make sure that you're managing your website using Google-friendly practices, read the Search Essentials.

Your Business Profile lets you manage how your business information appears across Google, including Search and Maps. Consider claiming your Business Profile.

Most searches are now done from mobile devices; make sure that your content is optimized to load quickly and display properly on all screen sizes. You can use tools such as Lighthouse to test if your page is mobile-friendly.

Modern users expect a secure online experience. Secure your website's connection with HTTPS.

SEOs (search engine optimizers) are professionals who can help you improve your website and increase visibility on search engines. Learn more about why and how to hire an SEO.

Depending on what your content is about, there are more ways you can get that content on Google. The following table contains links to the different avenues Google provides to get your content related to a business or person on Google.

To learn more about getting digit

*[Content truncated]*

**Examples:**

Example 1 (unknown):
```unknown
site:example.com
```

---

## Understand the JavaScript SEO basics

**URL:** https://developers.google.com/search/docs/crawling-indexing/javascript/javascript-seo-basics

**Contents:**
- Understand the JavaScript SEO basics
- How Google processes JavaScript
- Describe your page with unique titles and snippets
- Write compatible code
- Use meaningful HTTP status codes
  - Avoid soft 404 errors in single-page apps
- Use the History API instead of fragments
- Properly inject the rel="canonical" link tag
- Use robots meta tags carefully
- Use long-lived caching

JavaScript is an important part of the web platform because it provides many features that turn the web into a powerful application platform. Making your JavaScript-powered web applications discoverable via Google Search can help you find new users and re-engage existing users as they search for the content your web app provides. While Google Search runs JavaScript with an evergreen version of Chromium, there are a few things that you can optimize.

This guide describes how Google Search processes JavaScript and best practices for improving JavaScript web apps for Google Search.

Google processes JavaScript web apps in three main phases:

Googlebot queues pages for both crawling and rendering. It is not immediately obvious when a page is waiting for crawling and when it is waiting for rendering. When Googlebot fetches a URL from the crawling queue by making an HTTP request, it first checks if you allow crawling. Googlebot reads the robots.txt file. If it marks the URL as disallowed, then Googlebot skips making an HTTP request to this URL and skips the URL. Google Search won't render JavaScript from blocked files or on blocked pages.

Googlebot then parses the response for other URLs in the href attribute of HTML links and adds the URLs to the crawl queue. To prevent link discovery, use the nofollow mechanism.

Crawling a URL and parsing the HTML response works well for classical websites or server-side rendered pages where the HTML in the HTTP response contains all content. Some JavaScript sites may use the app shell model where the initial HTML does not contain the actual content and Google needs to execute JavaScript before being able to see the actual page content that JavaScript generates.

Googlebot queues all pages for rendering, unless a robots meta tag or header tells Google not to index the page. The page may stay on this queue for a few seconds, but it can take longer than that. Once Google's resources allow, a headless Chromium renders the page and executes the JavaScript. Googlebot parses the rendered HTML for links again and queues the URLs it finds for crawling. Google also uses the rendered HTML to index the page.

Keep in mind that server-side or pre-rendering is still a great idea because it makes your website faster for users and crawlers, and not all bots can run JavaScript.

Unique, descriptive <title> elements and meta descriptions help users quickly identify the best result for their goal. You can use JavaScript to set or change the m

*[Content truncated]*

**Examples:**

Example 1 (javascript):
```javascript
fetch(`/api/products/${productId}`)
.then(response => response.json())
.then(product => {
  if(product.exists) {
    showProductDetails(product); // shows the product information on the page
  } else {
    // this product does not exist, so this is an error page.
    window.location.href = '/not-found'; // redirect to 404 page on the server.
  }
})
```

Example 2 (javascript):
```javascript
fetch(`/api/products/${productId}`)
.then(response => response.json())
.then(product => {
  if(product.exists) {
    showProductDetails(product); // shows the product information on the page
  } else {
    // this product does not exist, so this is an error page.
    // Note: This example assumes there is no other robots meta tag present in the HTML.
    const metaRobots = document.createElement('meta');
    metaRobots.name = 'robots';
    metaRobots.content = 'noindex';
    document.head.appendChild(metaRobots);
  }
})
```

Example 3 (javascript):
```javascript
<nav>
  <ul>
    <li><a href="#/products">Our products</a></li>
    <li><a href="#/services">Our services</a></li>
  </ul>
</nav>

<h1>Welcome to example.com!</h1>
<div id="placeholder">
  <p>Learn more about <a href="#/products">our products</a> and <a href="#/services">our services</a></p>
</div>
<script>
window.addEventListener('hashchange', function goToPage() {
  // this function loads different content based on the current URL fragment
  const pageToLoad = window.location.hash.slice(1); // URL fragment
  document.getElementById('placeholder').innerHTML = load(pageToLoad);
});
</script>
```

Example 4 (javascript):
```javascript
<nav>
  <ul>
    <li><a href="/products">Our products</a></li>
    <li><a href="/services">Our services</a></li>
  </ul>
</nav>

<h1>Welcome to example.com!</h1>
<div id="placeholder">
  <p>Learn more about <a href="/products">our products</a> and <a href="/services">our services</a></p>
</div>
<script>
function goToPage(event) {
  event.preventDefault(); // stop the browser from navigating to the destination URL.
  const hrefUrl = event.target.getAttribute('href');
  const pageToLoad = hrefUrl.slice(1); // remove the leading slash
  document.getElementById('placeholder').innerHTML = load(page
...
```

---
