# Question Message Template

## Format

```
❓ *Question: {PROJECT_NAME}*

{QUESTION - clear and specific}

*Context:*
{RELEVANT_BACKGROUND - what you're working on, what you've tried}

*Options considered:*
1. {OPTION_A}
2. {OPTION_B}
{3. OPTION_C if applicable}

_Would appreciate input from the team._
```

## Example

```
❓ *Question: Acme Dashboard*

Should we support dark mode in the embed widgets?

*Context:*
Working on the embeddable dashboard widgets. Some customers have dark-themed websites and the white widget looks out of place. Adding dark mode would require ~2 hours of work.

*Options considered:*
1. Add dark mode with auto-detect based on parent page
2. Add manual toggle in widget settings
3. Skip for now, revisit based on customer feedback

_Would appreciate input from the team._
```

## When to use

- When blocked on a decision
- When multiple valid approaches exist
- When the decision affects others on the team
- When you need domain knowledge you don't have

## What to include

- Clear, specific question (not vague)
- Context so team understands the situation
- Options you've considered (shows you've thought about it)
- Why you need input (optional but helpful)

## Tips

- Don't ask questions that could be answered by reading docs
- Include enough context that someone can answer without asking clarifying questions
- If urgent, say so at the start
- If you have a recommendation, mention it
