# Language and Grammar Guidelines

## Active Voice

Use active voice where the grammatical subject performs the action.

**Recommended:**

- "Send a query to the service."
- "The server sends an acknowledgment."

**Avoid passive voice like:**

- "A query should be sent to the service."
- "An acknowledgment is sent by the server."

### Why Active Voice Matters

Passive voice can obscure responsibility, making it unclear whether the reader, computer, server, or another entity should perform an action.

### Exceptions

Active voice isn't always required:

- When emphasizing the object: "The file is saved"
- When de-emphasizing the subject
- When the actor's identity is irrelevant to readers

## Present Tense

Use present tense for actions and states.

**Recommended:**

- "The API returns a response."
- "The function calculates the total."

**Avoid future tense:**

- "The API will return a response."
- "The function will calculate the total."

## Second Person

Address the reader directly using "you" (implied or explicit).

**Recommended:**

- "To start the server, run the command."
- "You can configure the settings in the config file."

## Pronouns

Use appropriate pronouns consistently throughout documentation.

### Gender-Neutral Pronouns

- Use "they/them" for singular gender-neutral references
- Avoid gendered assumptions in examples

**Recommended:**

- "When a user logs in, they see their dashboard."

**Avoid:**

- "When a user logs in, he sees his dashboard."

## Reference

For deeper exploration, see Google's _Technical Writing One_ guide on active versus passive voice principles.
