# Config File Grading Rubric

Score each criterion, then sum for pillar total. Final score = sum of pillars + modifiers.

## Contents

- [Pillar 1: Structure (25 pts)](#pillar-1-structure-25-pts)
- [Pillar 2: Content Quality (25 pts)](#pillar-2-content-quality-25-pts)
- [Pillar 3: PDA Implementation (25 pts)](#pillar-3-pda-implementation-25-pts)
- [Pillar 4: Maintainability (25 pts)](#pillar-4-maintainability-25-pts)
- [Modifiers (±10 pts)](#modifiers-10-pts)
- [Quick Scoring Guide](#quick-scoring-guide)

---

## Pillar 1: Structure (25 pts)

### File Size (0-8 pts)

| Score | CLAUDE.md | AGENTS.md |
|-------|-----------|-----------|
| 7-8 | < 150 lines, < 600 tokens | < 5KB |
| 5-6 | 150-300 lines, 600-1200 tokens | 5-10KB |
| 3-4 | 300-500 lines, 1200-2000 tokens | 10-20KB |
| 1-2 | 500-800 lines, 2000-4000 tokens | 20-32KB |
| 0 | > 800 lines, > 4000 tokens | > 32KB (truncated!) |

**Quick check:**
```bash
wc -l CLAUDE.md  # Lines
wc -c AGENTS.md  # Bytes
```

### Organization (0-8 pts)

| Score | Criteria |
|-------|----------|
| 7-8 | Clear sections, logical grouping, commands first, docs linked |
| 5-6 | Good sections but some content misplaced |
| 3-4 | Some structure but inconsistent |
| 1-2 | Minimal organization, wall of text with occasional headers |
| 0 | No structure, single blob of content |

**Good structure:**
```markdown
# Project Name
## Commands (first - most used)
## Structure (second - orientation)
## Conventions (third - rules)
## Documentation (last - links to details)
```

### Navigation (0-9 pts)

| Score | Criteria |
|-------|----------|
| 8-9 | TOC for files >100 lines, clear headers, grep-friendly |
| 6-7 | Headers present, no TOC but navigable |
| 4-5 | Some headers, inconsistent levels |
| 2-3 | Few headers, hard to navigate |
| 0-1 | No navigation aids |

**Check:** Does file >100 lines have `## Contents` or `## Table of Contents`?

---

## Pillar 2: Content Quality (25 pts)

### Relevance (0-8 pts)

| Score | Criteria |
|-------|----------|
| 7-8 | Every line provides value Claude doesn't already know |
| 5-6 | Mostly relevant, minor unnecessary content |
| 3-4 | Mixed - some valuable, some obvious/redundant |
| 1-2 | Significant bloat, explains common concepts |
| 0 | Mostly unnecessary content |

**Red flags (deduct points for each):**
- Explaining what JSON/REST/Git is (-1 each)
- Multi-paragraph introductions (-2)
- Duplicating content from README (-2)
- Including full API documentation inline (-3)

### Actionability (0-9 pts)

| Score | Criteria |
|-------|----------|
| 8-9 | Commands copy-pasteable, clear "do this, not that" |
| 6-7 | Mostly actionable, some vague guidance |
| 4-5 | Mix of actionable and theoretical |
| 2-3 | Mostly descriptive, few actionable items |
| 0-1 | No actionable content |

**Good actionability:**
```markdown
Build: `npm run build`
Test: `npm test -- --watch`
Deploy: `./scripts/deploy.sh production`
```

**Poor actionability:**
```markdown
The build process involves several steps including
compilation, bundling, and optimization...
```

### Accuracy (0-8 pts)

| Score | Criteria |
|-------|----------|
| 7-8 | Commands work, paths exist, tools available |
| 5-6 | Mostly accurate, minor stale content |
| 3-4 | Some outdated references |
| 1-2 | Significant inaccuracies |
| 0 | Largely outdated or incorrect |

**Check:**
- Do referenced files exist?
- Do commands work?
- Are tool versions current?

---

## Pillar 3: PDA Implementation (25 pts)

### Reference Usage (0-10 pts)

| Score | CLAUDE.md | AGENTS.md |
|-------|-----------|-----------|
| 9-10 | Uses @imports for all detailed content | Links to external docs |
| 7-8 | Most detailed content extracted | Most docs linked |
| 5-6 | Some @imports, some inline detail | Some links |
| 3-4 | Minimal references, mostly inline | Few external refs |
| 0-2 | No references, everything inline | No external links |

**Good example:**
```markdown
## API Development
Quick patterns: POST/GET/PUT/DELETE endpoints
Detailed guide: @docs/api-patterns.md
Error handling: @docs/error-codes.md
```

### Hierarchy Depth (0-8 pts)

| Score | Criteria |
|-------|----------|
| 7-8 | All references one level deep from root |
| 5-6 | Mostly flat, one or two chains |
| 3-4 | Some A→B→C chains |
| 1-2 | Deep nesting, content buried |
| 0 | Critical info 3+ levels deep |

**Check:** Trace any @import - is it more than 1 hop from CLAUDE.md?

### Subdirectory Configs (0-7 pts)

For monorepos/multi-package projects:

| Score | Criteria |
|-------|----------|
| 6-7 | Package-level CLAUDE.md files, lean root |
| 4-5 | Some subdirectory configs, could split more |
| 2-3 | All content in root, monorepo not leveraged |
| 0-1 | Massive root file, no package-level configs |

**N/A** for single-package projects (give 7 pts).

---

## Pillar 4: Maintainability (25 pts)

### Freshness (0-7 pts)

| Score | Criteria |
|-------|----------|
| 6-7 | Recently updated, no stale references |
| 4-5 | Mostly current, minor outdated items |
| 2-3 | Some stale content, needs review |
| 0-1 | Significantly outdated |

**Check:** Any references to deprecated tools, old versions, or moved files?

### Anti-Pattern Avoidance (0-10 pts)

Deduct points for each anti-pattern found:

| Anti-Pattern | Deduction |
|--------------|-----------|
| Style rules that should use linters | -2 |
| Negative-only instructions (no alternatives) | -1 each (max -3) |
| Secrets or credentials (even examples) | -3 |
| Large code blocks (>50 lines) | -2 |
| Explaining Claude's capabilities | -2 |
| Vague instructions ("be careful with...") | -1 each (max -2) |

Start at 10, apply deductions.

### Consistency (0-8 pts)

| Score | Criteria |
|-------|----------|
| 7-8 | Consistent terminology, formatting, style |
| 5-6 | Mostly consistent, minor variations |
| 3-4 | Noticeable inconsistencies |
| 1-2 | Chaotic formatting/terminology |
| 0 | No consistency |

**Check:**
- Same term for same concept throughout
- Consistent header capitalization
- Consistent list formatting

---

## Modifiers (±10 pts)

### Bonuses (max +10)

| Bonus | Points | Detection |
|-------|--------|-----------|
| Clear decision tree/workflow | +2 | Diagrams or numbered workflows |
| Commands table | +1 | Tabular command reference |
| "When to use" clarity | +1 | Explicit scope definition |
| Verified @imports all exist | +2 | All referenced files present |
| Cross-platform support | +2 | Both CLAUDE.md and AGENTS.md |
| Git hooks or CI integration | +1 | Mentions pre-commit or CI checks |
| Version-controlled config | +1 | Evidence of being in git |

### Penalties (max -10)

| Penalty | Points | Detection |
|---------|--------|-----------|
| Windows-style paths | -2 | Backslashes in paths |
| Magic numbers without explanation | -1 | Unexplained constants |
| First-person voice | -1 | "I will..." or "I can..." |
| Conflicting instructions | -3 | Contradictory rules |
| No .gitignore for local files | -1 | CLAUDE.local.md not ignored |
| Hardcoded environment-specific paths | -2 | /Users/name or C:\Users |

---

## Quick Scoring Guide

### Instant Grade Estimates

**Grade A (90+):**
- File < 200 lines
- TOC present
- All @imports resolve
- No anti-patterns
- Recently updated

**Grade B (80-89):**
- File < 400 lines
- Some @imports
- Minor anti-patterns
- Mostly organized

**Grade C (70-79):**
- File < 600 lines
- Few @imports
- Several anti-patterns
- Needs reorganization

**Grade D (60-69):**
- File > 600 lines
- No @imports
- Many anti-patterns
- Poor organization

**Grade F (<60):**
- File > 800 lines
- No structure
- Severe anti-patterns
- Largely unmaintained

### Scoring Worksheet

```
STRUCTURE (25 pts)
├── File Size:        __/8
├── Organization:     __/8
└── Navigation:       __/9
                      ──────
                      __/25

CONTENT QUALITY (25 pts)
├── Relevance:        __/8
├── Actionability:    __/9
└── Accuracy:         __/8
                      ──────
                      __/25

PDA IMPLEMENTATION (25 pts)
├── Reference Usage:  __/10
├── Hierarchy Depth:  __/8
└── Subdirectory Use: __/7
                      ──────
                      __/25

MAINTAINABILITY (25 pts)
├── Freshness:        __/7
├── Anti-Patterns:    __/10
└── Consistency:      __/8
                      ──────
                      __/25

MODIFIERS
├── Bonuses:          +__
└── Penalties:        -__
                      ──────
                      ±__/10

TOTAL: __/100  GRADE: __
```
