# Size Guide

Thresholds and targets for CLAUDE.md and AGENTS.md files.

## Contents

- [Size Thresholds](#size-thresholds)
- [Token Budgets](#token-budgets)
- [Measuring Size](#measuring-size)
- [Performance Impact](#performance-impact)

---

## Size Thresholds

### CLAUDE.md Thresholds

| Metric | 🟢 Optimal | 🟡 Warning | 🔴 Critical |
|--------|-----------|------------|-------------|
| Lines | < 150 | 150-400 | > 400 |
| Tokens | < 600 | 600-2000 | > 2000 |
| Bytes | < 6KB | 6-16KB | > 16KB |
| Sections | < 6 | 6-10 | > 10 |

### AGENTS.md Thresholds

| Metric | 🟢 Optimal | 🟡 Warning | 🔴 Critical |
|--------|-----------|------------|-------------|
| Per-file size | < 5KB | 5-15KB | > 15KB |
| Combined total | < 16KB | 16-32KB | > 32KB |
| Lines | < 120 | 120-300 | > 300 |

**Important:** Codex truncates at 32KB by default. Content beyond this limit is silently dropped.

---

## Token Budgets

### Context Window Allocation

| Component | Tokens | % of 200K |
|-----------|--------|-----------|
| System prompt | ~3,200 | 1.6% |
| System tools | ~11,600 | 5.8% |
| **CLAUDE.md (target)** | **< 600** | **< 0.3%** |
| **CLAUDE.md (max safe)** | **< 2,500** | **< 1.25%** |
| MCP servers | Variable | 0-10% |
| Conversation + files | Remaining | 80%+ |

### Why Size Matters

Every token in CLAUDE.md:
1. **Loads every message** - Processed with each interaction
2. **Competes for context** - Less room for actual work
3. **Costs money** - API charges per token
4. **Reduces quality** - More tokens = worse instruction following

### The 150-200 Rule

Research shows models reliably follow ~150-200 instructions:
- Claude Code system prompt uses ~50
- MCP servers consume additional slots
- Your CLAUDE.md competes for the rest

**Implication:** Every unnecessary instruction reduces adherence to important ones.

---

## Measuring Size

### Quick Commands

```bash
# Line count
wc -l CLAUDE.md

# Byte count
wc -c CLAUDE.md

# Word count (rough token estimate: words × 1.3)
wc -w CLAUDE.md

# Human-readable size
ls -lh CLAUDE.md
```

### Token Estimation

```
Tokens ≈ Words × 1.3
Tokens ≈ Bytes / 4
Tokens ≈ Characters / 4
```

| File Size | Estimated Tokens |
|-----------|------------------|
| 1 KB | ~250 tokens |
| 5 KB | ~1,250 tokens |
| 10 KB | ~2,500 tokens |
| 20 KB | ~5,000 tokens |

### Claude Code Commands

```
/context    # Shows token breakdown
/memory     # Shows loaded CLAUDE.md files
/cost       # Shows session token usage
```

---

## Performance Impact

### Context Length vs. Quality

| Context Size | Performance Impact |
|--------------|-------------------|
| < 4K tokens | Baseline (optimal) |
| 4K - 16K | 5-10% degradation |
| 16K - 64K | 15-30% degradation |
| > 64K | 30%+ degradation |

### "Lost in the Middle" Effect

Information in the middle of long contexts is poorly retained:
- Beginning: Well-retained
- **Middle: Significantly degraded**
- End: Well-retained

**Implication:** Put critical instructions at the START of CLAUDE.md.

### Recommended Order

```markdown
# Project Name

## Commands (FIRST - most used, best retained)
...

## Structure (SECOND - orientation)
...

## Conventions (THIRD - rules)
...

## Documentation (LAST - links to details)
...
```

---

## Target Sizes by Project Type

### Simple Project
```
Target: 50-100 lines
Tokens: 200-400
Structure: Single CLAUDE.md, no references
```

### Medium Project
```
Target: 100-200 lines
Tokens: 400-800
Structure: CLAUDE.md + 1-3 reference files
```

### Large Project / Monorepo
```
Target: 100-150 lines (root)
Tokens: 400-600 (root)
Structure: Root CLAUDE.md + package CLAUDE.md files + docs/
```

### Enterprise Project
```
Target: 100-200 lines (root)
Tokens: 400-800 (root)
Structure: Enterprise policy + user memory + project + local
```

---

## Quick Reference Card

```
┌────────────────────────────────────────┐
│         SIZE QUICK REFERENCE           │
├────────────────────────────────────────┤
│ CLAUDE.md Targets:                     │
│   Lines:  < 150 optimal, < 400 max     │
│   Tokens: < 600 optimal, < 2000 max    │
│   Bytes:  < 6KB optimal, < 16KB max    │
├────────────────────────────────────────┤
│ AGENTS.md Targets:                     │
│   Per-file: < 5KB optimal, < 15KB max  │
│   Combined: < 16KB optimal, < 32KB MAX │
├────────────────────────────────────────┤
│ Token Estimation:                      │
│   Tokens ≈ Words × 1.3                 │
│   Tokens ≈ Bytes / 4                   │
├────────────────────────────────────────┤
│ Commands:                              │
│   wc -l CLAUDE.md    (lines)           │
│   wc -c AGENTS.md    (bytes)           │
│   /context           (token breakdown) │
└────────────────────────────────────────┘
```
