# Grade Report Template

Use this template when generating grade reports.

---

## Report Structure

```markdown
# Config Grade Report: [CLAUDE.md / AGENTS.md]

**Graded:** [YYYY-MM-DD]
**File:** [path/to/file]
**Size:** [X lines, Y bytes, ~Z tokens]

---

## Score: XX/100 (Grade: X)

| Pillar | Score | Max |
|--------|-------|-----|
| Structure | XX | 25 |
| Content Quality | XX | 25 |
| PDA Implementation | XX | 25 |
| Maintainability | XX | 25 |
| Modifiers | ±X | ±10 |

---

## Detailed Scores

### Structure (XX/25)

| Criterion | Score | Max | Notes |
|-----------|-------|-----|-------|
| File Size | X | 8 | [X lines, Y tokens] |
| Organization | X | 8 | [assessment] |
| Navigation | X | 9 | [TOC present/missing] |

### Content Quality (XX/25)

| Criterion | Score | Max | Notes |
|-----------|-------|-----|-------|
| Relevance | X | 8 | [assessment] |
| Actionability | X | 9 | [assessment] |
| Accuracy | X | 8 | [assessment] |

### PDA Implementation (XX/25)

| Criterion | Score | Max | Notes |
|-----------|-------|-----|-------|
| Reference Usage | X | 10 | [X @imports found] |
| Hierarchy Depth | X | 8 | [flat/nested] |
| Subdirectory Use | X | 7 | [N/A or assessment] |

### Maintainability (XX/25)

| Criterion | Score | Max | Notes |
|-----------|-------|-----|-------|
| Freshness | X | 7 | [assessment] |
| Anti-Patterns | X | 10 | [X found] |
| Consistency | X | 8 | [assessment] |

### Modifiers Applied (±X)

**Bonuses:** [list or "None"]
**Penalties:** [list or "None"]

---

## Issues Found (Priority Order)

### 🔴 Critical Issues

1. **[Issue Title]**
   - Problem: [description]
   - Fix: [specific action]
   - Impact: +X points if fixed

### 🟡 Important Issues

2. **[Issue Title]**
   - Problem: [description]
   - Fix: [specific action]
   - Impact: +X points if fixed

### 🟢 Minor Issues

3. **[Issue Title]**
   - Problem: [description]
   - Fix: [specific action]
   - Impact: +X points if fixed

---

## Improvement Plan

### If Implemented:

| Action | Current → Target | Score Impact |
|--------|-----------------|--------------|
| [Action 1] | [before → after] | +X pts |
| [Action 2] | [before → after] | +X pts |
| [Action 3] | [before → after] | +X pts |

**Projected Score After Fixes:** XX/100 (Grade: X)

---

## Recommended Actions

- [ ] [Specific action 1]
- [ ] [Specific action 2]
- [ ] [Specific action 3]

---

**Implement these improvements? (y/n)**
```

---

## Grade Descriptions

Use these descriptions in reports:

| Grade | Score | Description |
|-------|-------|-------------|
| A | 90-100 | Excellent. Lean, well-organized, follows all best practices. Minimal or no changes needed. |
| B | 80-89 | Good. Well-structured with minor issues. A few improvements would optimize it. |
| C | 70-79 | Adequate. Functional but has notable issues. Recommend addressing top problems. |
| D | 60-69 | Poor. Significant issues affecting usability. Needs substantial refactoring. |
| F | <60 | Critical. Major problems throughout. Recommend complete overhaul. |

---

## Example Reports

### Example: Grade A Report

```markdown
# Config Grade Report: CLAUDE.md

**Graded:** 2026-01-03
**File:** ./CLAUDE.md
**Size:** 87 lines, 3,421 bytes, ~342 tokens

---

## Score: 94/100 (Grade: A)

| Pillar | Score | Max |
|--------|-------|-----|
| Structure | 24 | 25 |
| Content Quality | 23 | 25 |
| PDA Implementation | 23 | 25 |
| Maintainability | 22 | 25 |
| Modifiers | +2 | ±10 |

...

**Implement these improvements? (y/n)**
Minor tweaks available but not required.
```

### Example: Grade D Report

```markdown
# Config Grade Report: CLAUDE.md

**Graded:** 2026-01-03
**File:** ./CLAUDE.md
**Size:** 847 lines, 34,521 bytes, ~8,630 tokens

---

## Score: 62/100 (Grade: D)

| Pillar | Score | Max |
|--------|-------|-----|
| Structure | 12 | 25 |
| Content Quality | 18 | 25 |
| PDA Implementation | 8 | 25 |
| Maintainability | 16 | 25 |
| Modifiers | -6 | ±10 |

## Issues Found (Priority Order)

### 🔴 Critical Issues

1. **File Severely Oversized**
   - Problem: 847 lines, ~8,630 tokens (target: <150 lines, <600 tokens)
   - Fix: Extract 80% of content to reference files
   - Impact: +12 points if fixed

2. **No @imports Used**
   - Problem: All content inline, no progressive disclosure
   - Fix: Create docs/ folder, move detailed sections
   - Impact: +8 points if fixed

...

**Projected Score After Fixes:** 88/100 (Grade: B)

**Implement these improvements? (y/n)**
Strongly recommended.
```
