---
name: grammar-cheatsheet
description: Expert in creating visual grammar cheatsheets for Kabardian language with morphological breakdowns and corpus examples. Generates cheatsheets with ASCII-tree morpheme visualization (like verb_translation_cheatsheet.md). Activates when user requests grammar cheatsheet, mentions "создай шпаргалку", "cheatsheet for [category]", or wants visual breakdown of Kabardian grammar with real examples.
allowed-tools: Read, Write, Bash, Grep, Glob
---

# Grammar Cheatsheet Generator

Эксперт по созданию визуальных шпаргалок для кабардинской грамматики с морфологическим разбором и примерами из корпуса.

## 🎯 Когда активироваться

Этот skill активируется когда пользователь:

- Просит создать шпаргалку для грамматической категории
- Говорит **"создай шпаргалку для [категория]"** или **"cheatsheet for [category]"**
- Упоминает **"как сделать документ как verb_translation_cheatsheet.md"**
- Хочет визуальный разбор морфологии с примерами из корпуса
- Запрашивает справочный материал для перевода

**Триггеры:** "шпаргалка", "cheatsheet", "visual breakdown", "морфологический разбор", "создай документ", "grammar reference"

---

## 📋 Workflow

### Шаг 1: Определить категорию грамматики

Спросить пользователя какую категорию создать (или определить из запроса):

1. **Глаголы** (verbs) - уже создано `verb_translation_cheatsheet.md` ✓
2. **Существительные** (nouns) - падежи, число, определённость
3. **Прилагательные** (adjectives) - степени сравнения
4. **Послелоги** (postpositions) - пространственные отношения
5. **Числительные** (numerals) - 20-ричная система
6. **Синтаксис** (syntax) - порядок слов SOV
7. **Наречия** (adverbs) - время, место, образ действия
8. **Местоимения** (pronouns) - личные, указательные

Если категория не ясна - спросить явно.

### Шаг 2: Загрузить reference для категории

Прочитать `reference.md` из этого skill для получения:
- Грамматических паттернов для поиска
- Regex для grep в корпусе
- Ссылок на references/grammar/
- Ключевых морфем и суффиксов

### Шаг 3: Извлечь примеры из корпуса

**Использовать корпус:** `data/translations/sents_292k.csv`

```bash
# Поиск примеров с паттернами для категории
grep -i "PATTERN" data/translations/sents_292k.csv | head -10
```

**Критерии отбора примеров:**
- ✅ Короткие предложения (<150 символов)
- ✅ Ясная грамматическая структура
- ✅ Качественный перевод
- ✅ Разнообразие форм (ед./мн. число, разные лица)

**Количество:** Минимум 8-10 примеров для полноценной шпаргалки

### Шаг 4: Прочитать грамматические references

Загрузить релевантные chunks из `references/grammar/`:

- Для существительных: `references/grammar/nouns/`
- Для прилагательных: `references/grammar/adjectives/`
- Для синтаксиса: `references/grammar/syntax/`
- И т.д. (см. reference.md для маппинга)

**Цель:** Получить правила морфологии, таблицы парадигм, примеры

### Шаг 5: Создать морфологический разбор

Для каждого примера создать **визуализацию с ASCII-деревом**:

```
морфема-морфема-морфема-морфема
│       │       │       │
│       │       │       └─ описание
│       │       └───────── описание
│       └───────────────── описание
└───────────────────────── описание
```

**Формат как в verb_translation_cheatsheet.md:**
- Каждая морфема на отдельной линии
- Вертикальные линии (│) для связи
- Горизонтальные линии (└─) для пояснений
- Краткое описание функции каждой морфемы

### Шаг 6: Загрузить шаблон и сгенерировать документ

Прочитать `templates/cheatsheet_template.md` из этого skill.

**Заполнить секции:**

1. **Заголовок и метаданные**
   - Название категории
   - Источники (корпус + grammar references)

2. **Содержание** (TOC)
   - Список подкатегорий с якорями

3. **Для каждого примера:**
   - 🔍 Заголовок с ключевым словом
   - **Контекст из корпуса** (kbd + rus перевод)
   - **Морфологический разбор** (ASCII-дерево)
   - **Структура** (таблица префиксов/суффиксов)
   - **Примечания** (фономорфология, исключения)

4. **Сводные таблицы**
   - Таблицы морфем
   - Парадигмы
   - Правила

5. **Практические советы**
   - Как определить форму
   - Частые ошибки
   - Использование для перевода

6. **Ссылки на ресурсы**
   - references/grammar/
   - skills
   - корпус

### Шаг 7: Сохранить в references/

**Формат имени файла:**
```
references/[category]_translation_cheatsheet.md
```

Примеры:
- `references/nouns_translation_cheatsheet.md`
- `references/adjectives_translation_cheatsheet.md`
- `references/syntax_translation_cheatsheet.md`

### Шаг 8: Показать пользователю результат

**Вывести:**
1. Путь к созданному файлу
2. Статистику: количество примеров, категорий, размер
3. Пример 1-2 разборов из документа
4. Предложить создать другие категории

---

## 📚 Reference Files

Для детальных правил и паттернов см.:

- `reference.md` - Категории грамматики, regex паттерны, маппинг на grammar chunks
- `templates/cheatsheet_template.md` - Универсальный шаблон для генерации

**Когда загружать:**
- `reference.md` - всегда в Шаге 2 для получения паттернов
- `templates/cheatsheet_template.md` - в Шаге 6 при генерации документа

---

## 🛡️ Безопасность и ограничения

**allowed-tools:** `Read, Write, Bash, Grep, Glob`

Этот skill может:
- ✅ Читать корпус переводов (292k примеров)
- ✅ Искать паттерны с помощью grep
- ✅ Читать grammar references
- ✅ Создавать новые markdown файлы в references/
- ✅ Выполнять bash для анализа данных

Этот skill НЕ может:
- ❌ Редактировать существующие шпаргалки
- ❌ Удалять файлы
- ❌ Изменять корпус или grammar references

---

## 🎨 Best Practices

### Визуализация морфем

1. **Всегда используй ASCII-дерево** - это ключевая фича
2. **Одна линия на морфему** - не группируй
3. **Краткие описания** - 2-5 слов максимум
4. **Консистентная ширина** - выровняй визуально

### Примеры из корпуса

1. **Качество > количество** - 8-10 хороших примеров лучше 20 плохих
2. **Разнообразие** - покрой все основные формы
3. **Короткие предложения** - легче понять структуру
4. **Контекст важен** - показывай полное предложение

### Структура документа

1. **Следуй формату verb_translation_cheatsheet.md** - проверенный формат
2. **Прогрессивное усложнение** - от простого к сложному
3. **Много таблиц** - помогают систематизировать
4. **Практические советы** - как использовать для перевода

---

## 🚀 Примеры использования

### Пример 1: Шпаргалка для существительных

```
User: "Создай шпаргалку для кабардинских существительных"

Skill:
1. Определяет категорию: nouns
2. Загружает паттерны из reference.md
3. Ищет в корпусе примеры с -р (определённость), -м (эргатив), -хэ (мн.ч.)
4. Читает references/grammar/nouns/ для правил
5. Создаёт разборы для каждого примера с ASCII-деревом
6. Генерирует документ: references/nouns_translation_cheatsheet.md
7. Показывает статистику: 10 примеров, 4 категории, 18KB
```

### Пример 2: Шпаргалка для синтаксиса

```
User: "Хочу шпаргалку по порядку слов SOV"

Skill:
1. Определяет категорию: syntax
2. Загружает паттерны для SOV конструкций
3. Ищет примеры с ясным субъект-объект-глагол порядком
4. Читает references/grammar/syntax/chunk_074-075 (SOV правила)
5. Создаёт визуализации порядка слов
6. Генерирует: references/syntax_translation_cheatsheet.md
7. Включает правила трансформации RUS(SVO)↔KBD(SOV)
```

### Пример 3: Быстрое создание по образцу

```
User: "Сделай для прилагательных как ты сделал для глаголов"

Skill:
1. Понимает: нужен формат как в verb_translation_cheatsheet.md
2. Категория: adjectives
3. Использует те же принципы визуализации
4. Фокус на степенях сравнения (comparative, superlative)
5. Генерирует: references/adjectives_translation_cheatsheet.md
6. Консистентный стиль с verb_translation_cheatsheet.md ✓
```

---

## ⚙️ Технические детали

### Формат корпуса

**Файл:** `data/translations/sents_292k.csv`

**Структура:**
```csv
source,translated
"кабардинский текст","русский перевод"
```

**Поиск:**
```bash
# Базовый поиск
grep -i "паттерн" data/translations/sents_292k.csv | head -10

# С контекстом
grep -i -A 0 -B 0 "паттерн" data/translations/sents_292k.csv
```

### Маппинг на grammar chunks

См. `reference.md` для полного списка:

- Существительные → `references/grammar/nouns/chunk_012-016`
- Прилагательные → `references/grammar/adjectives/chunk_017-020`
- Синтаксис → `references/grammar/syntax/chunk_074-075` (SOV)
- И т.д.

---

**Этот skill следует проверенному формату verb_translation_cheatsheet.md и расширяет его на все категории кабардинской грамматики!**
