# Grammar Categories Reference

Полный справочник категорий кабардинской грамматики с паттернами для поиска в корпусе и ссылками на grammar chunks.

---

## 📚 Категории для шпаргалок

### 1. Глаголы (Verbs) ✅ ГОТОВО

**Статус:** `verb_translation_cheatsheet.md` уже создан

**Подкатегории:**
- Простые глаголы (прошедшее -щ)
- Направительные префиксы (къэ-, къы-, щы-)
- Будущее время (-н-щ)
- Каузатив (гъэ-)
- Реципрок (зэ-)
- Отрицание (-къым)
- Версия (хуэ-, фIэ-)

---

### 2. Существительные (Nouns)

**Grammar chunks:** `references/grammar/nouns/chunk_012-016` (pages 56-80)

**Ключевые морфемы:**
- **-р** - определённость (definiteness marker)
- **-м** - эргативный падеж (ergative case)
- **-кIэ** - инструментальный падеж
- **-хэ** - множественное число (plural)
- **-хэр** - определённое множественное
- **и-** - притяжательный префикс (3л.)

**Regex паттерны для grep:**
```regex
\b\w+р\b          # Слова с -р (определённость)
\b\w+м\b          # Слова с -м (эргатив)
\b\w+хэр?\b       # Слова с -хэ/-хэр (мн.ч.)
\b\w+кIэ\b        # Инструментальный падеж
\bи\w+\b          # Притяжательные формы
```

**Примеры для поиска:**
- унэр (дом-опр.) → "унэр"
- унэм (дом-эрг.) → "унэм"
- унэхэр (дома-опр.мн.) → "унэхэр"

**Фокус шпаргалки:**
- Падежная система (эргатив, послеложный, обстоятельственный)
- Категория определённости (-р)
- Категория числа (-хэ)
- Притяжательность (префиксы и-, ду-)

---

### 3. Прилагательные (Adjectives)

**Grammar chunks:** `references/grammar/adjectives/chunk_017-020` (pages 87-100)

**Ключевые морфемы:**
- **-щIэ** - сравнительная степень
- **-нэ** - превосходная степень
- **дахэ** - красивый (качественное)
- **-гъуэ** - суффикс прилагательных

**Regex паттерны:**
```regex
\b\w+щIэ\b        # Сравнительная степень
\b\w+нэ\b         # Превосходная степень
\bдахэ\w*\b       # Прилагательное "красивый"
\b\w+гъуэ\b       # Отглагольные прилагательные
```

**Примеры:**
- дахэ "красивый"
- дахэщIэ "красивее" (comparative)
- дахэнэ "самый красивый" (superlative)

**Фокус шпаргалки:**
- Качественные vs относительные прилагательные
- Степени сравнения (позитив, компаратив, суперлатив)
- Формы оценки (увеличительные, уменьшительные)
- Согласование с существительными

---

### 4. Послелоги (Postpositions)

**Grammar chunks:** `references/grammar/function_words/chunk_053-054` (pages 261-270)

**Ключевые послелоги:**
- **-м** (де) - в, внутри
- **-кIэ** - с помощью, посредством
- **-рэ** - у, около (локатив)
- **-уэ** - подобно, как

**Regex паттерны:**
```regex
\b\w+м\s+(щI|т|лъ)  # послелог "в" + статические глаголы
\b\w+рэ\b           # локатив "у, около"
\b\w+уэ\b           # "подобно, как"
```

**Примеры:**
- унэм "в доме"
- столым "на столе"
- щIалэм "во дворе"

**Фокус шпаргалки:**
- Пространственные послелоги
- Временные послелоги
- Функциональные послелоги
- Различие с падежами

---

### 5. Числительные (Numerals)

**Grammar chunks:** `references/grammar/numerals/chunk_020-022` (pages 96-110)

**Ключевые числа:**
- **зы** - один
- **тIу** - два
- **щы** - три
- **тIощI** - двадцать (20-ричная система!)
- **пщI** - десять

**Regex паттерны:**
```regex
\b(зы|тIу|щы|пщI|тIощI)\b   # Базовые числительные
\b\w+щI\b                    # Числа с -щI (20, 40, 60...)
\b\w+анэ\b                   # Порядковые числительные
```

**Примеры:**
- зы "один"
- тIощI "двадцать"
- пщIанэ "десятая часть"

**Фокус шпаргалки:**
- 20-ричная система счисления
- Количественные числительные
- Порядковые числительные (-анэ)
- Дробные числительные

---

### 6. Синтаксис (Syntax)

**Grammar chunks:** `references/grammar/syntax/chunk_074-075` (pages 366-375) ⭐ КРИТИЧНО

**Ключевые паттерны:**
- **SOV** - Субъект-Объект-Глагол порядок
- **Эргативная** конструкция
- Вопросительный порядок слов

**Regex паттерны:**
```regex
# Сложно определить паттерном, нужен структурный анализ предложений
# Искать примеры с ясным SOV:
\b\w+(р|м)\s+\w+(р|м)?\s+\w+щ\b   # Попытка найти S-O-V
```

**Примеры:**
- "Сэ унэр сыплъащ" (Я дом увидел) - SOV
- vs русский "Я увидел дом" - SVO

**Фокус шпаргалки:**
- Базовый порядок SOV
- Вариации порядка слов
- Роль падежных маркеров
- Эргативная vs номинативная конструкция
- Трансформация RUS(SVO) ↔ KBD(SOV)

---

### 7. Наречия (Adverbs)

**Grammar chunks:** `references/grammar/adverbs/chunk_050-051` (pages 246-255)

**Ключевые наречия:**
- **джыри** - сейчас (время)
- **пщэдей** - вчера
- **мыдрэ** - здесь (место)
- **ардрэ** - там
- **дахэу** - красиво (образ действия)

**Regex паттерны:**
```regex
\b(джыри|пщэдей|мыдрэ|ардрэ|дахэу)\b   # Конкретные наречия
\b\w+у\b                                 # Наречия образа действия на -у
```

**Примеры:**
- джыри "сейчас"
- пщэдей "вчера"
- дахэу "красиво"

**Фокус шпаргалки:**
- Наречия времени
- Наречия места
- Наречия образа действия
- Образование наречий от прилагательных

---

### 8. Местоимения (Pronouns)

**Grammar chunks:** Разбросаны по verb_morphology (личные) и nouns (указательные)

**Личные местоимения:**
- **сэ** - я
- **уэ** - ты
- **абы** - он/она
- **дэ** - мы
- **фэ** - вы
- **ахэр** - они

**Указательные:**
- **мы** - этот
- **а** - тот

**Regex паттерны:**
```regex
\b(сэ|уэ|абы|дэ|фэ|ахэр)\b      # Личные местоимения
\b(мы|а)\s+\w+\b                 # Указательные + сущ.
```

**Фокус шпаргалки:**
- Личные местоимения
- Указательные местоимения
- Вопросительные местоимения
- Склонение местоимений

---

## 🔧 Технические детали

### Маппинг категорий на grammar chunks

| Категория | Grammar chunks | Страницы | Размер |
|-----------|---------------|----------|--------|
| Глаголы | verb_morphology/ + advanced_verbs/ | 111-220 | 688 KB |
| Существительные | nouns/ | 56-80 | 170 KB |
| Прилагательные | adjectives/ | 87-100 | 119 KB |
| Числительные | numerals/ | 96-110 | 88 KB |
| Послелоги | function_words/chunk_053-054 | 261-270 | ~70 KB |
| Синтаксис | syntax/chunk_074-075 | 366-375 | ~70 KB |
| Наречия | adverbs/ | 246-255 | 68 KB |
| Морфология общая | morphology_intro/ | 46-55 | 71 KB |

### Приоритеты создания шпаргалок

**Высокий приоритет:**
1. ✅ Глаголы - ГОТОВО
2. ⭐ Существительные - критично для понимания падежей
3. ⭐ Синтаксис - SOV правила, основа перевода
4. Послелоги - пространственные отношения

**Средний приоритет:**
5. Прилагательные - степени сравнения
6. Наречия - время/место/образ действия

**Низкий приоритет:**
7. Числительные - 20-ричная система интересна, но не критична
8. Местоимения - относительно простая категория

---

## 📊 Статистика корпуса

**Файл:** `data/translations/sents_292k.csv`
**Размер:** ~45 MB
**Записей:** ~292,000 пар переводов

**Рекомендации по поиску:**
- ✅ Всегда используй `grep -i` (case-insensitive)
- ✅ Ограничивай результаты: `| head -10` или `-m 10`
- ✅ Проверяй длину предложений: короткие лучше для шпаргалок
- ✅ Ищи в первых 100k строк для скорости: `| head -100000`

---

## 🎯 Шаблон поиска примеров

### Базовый workflow для каждой категории:

```bash
# 1. Поиск примеров с ключевой морфемой
grep -i "PATTERN" data/translations/sents_292k.csv | head -20

# 2. Фильтрация по длине (короткие предложения)
grep -i "PATTERN" data/translations/sents_292k.csv | \
  awk -F',' 'length($1) < 100' | head -10

# 3. Поиск разнообразных форм
grep -i "PATTERN1\|PATTERN2\|PATTERN3" data/translations/sents_292k.csv | head -10
```

### Критерии качества примера:

✅ **Хороший пример:**
- Короткое предложение (<100 символов kbd, <150 символов rus)
- Ясная грамматическая структура
- Качественный перевод (без "...")
- Демонстрирует конкретную морфологическую форму

❌ **Плохой пример:**
- Слишком длинное предложение
- Сложная грамматика с множеством конструкций
- Неполный или некачественный перевод
- Нестандартная морфология

---

## 💡 Tips для создания качественных шпаргалок

### Визуализация

1. **Консистентность** - используй тот же формат ASCII-дерева
2. **Выравнивание** - визуально понятная структура
3. **Краткость** - описания 2-5 слов
4. **Примеры** - минимум 1 на каждую подкатегорию

### Структура документа

1. **Прогрессия** - от простого к сложному
2. **Таблицы** - для систематизации (парадигмы, морфемы)
3. **Контекст** - всегда показывай полное предложение из корпуса
4. **Практичность** - советы для использования в переводе

### Использование grammar chunks

1. **Точечное чтение** - не загружай весь chunk, только нужные разделы
2. **Извлечение таблиц** - парадигмы особенно полезны
3. **Примеры** - grammar chunks содержат примеры, используй их
4. **Правила** - фономорфологические правила важны для разбора

---

**Этот reference обновляется по мере создания новых шпаргалок!**
