# 📚 ШПАРГАЛКА ДЛЯ ПЕРЕВОДА: {{CATEGORY_RU}}

**Источник примеров:** data/translations/sents_292k.csv (292,000 проверенных пар переводов)
**Источник грамматики:** references/grammar/{{CATEGORY_DIR}}/

---

## 🎯 Формат визуализации

Каждая форма разбирается по морфемам с визуальным указанием структуры:

```
{{EXAMPLE_MORPHEME_BREAKDOWN}}
│  │   │  │
│  │   │  └─ {{DESCRIPTION}}
│  │   └──── {{DESCRIPTION}}
│  └──────── {{DESCRIPTION}}
└─────────── {{DESCRIPTION}}
```

---

## 📖 СОДЕРЖАНИЕ

{{TABLE_OF_CONTENTS}}

---

## {{SECTION_NUMBER}}. {{SUBCATEGORY_1}}

### 🔍 Пример {{EXAMPLE_NUMBER}}: **{{KEY_WORD}}** "{{TRANSLATION}}"

**Контекст из корпуса:**
```
🏔️  Кабардинский: {{KABARDIAN_SENTENCE}}
🇷🇺 Русский:      {{RUSSIAN_TRANSLATION}}
```

**Морфологический разбор:**
```
{{MORPHEME_BREAKDOWN}}
│  │   │  │
│  │   │  └─ {{DESCRIPTION}}
│  │   └──── {{DESCRIPTION}}
│  └──────── {{DESCRIPTION}}
└─────────── {{DESCRIPTION}}
```

**Структура:**
- **{{MORPHEME_TYPE_1}}:** {{DESCRIPTION}}
- **{{MORPHEME_TYPE_2}}:** {{DESCRIPTION}}
- **{{MORPHEME_TYPE_3}}:** {{DESCRIPTION}}

**Парадигма:** (если применимо)
| Лицо/Форма | Ед.ч. | Мн.ч. |
|------------|-------|-------|
| 1л.  | {{FORM}} | {{FORM}} |
| 2л.  | {{FORM}} | {{FORM}} |
| 3л.  | {{FORM}} | {{FORM}} |

**Примечание:** {{ADDITIONAL_NOTES}}

---

## 🎓 Сводная таблица {{MORPHEME_TYPE}}

### {{TABLE_TITLE}}:

```
[SLOT_1] [SLOT_2] [SLOT_3] + {{BASE}} + [SUFFIX_1] [SUFFIX_2]
```

| № | Слот/Тип | Морфемы | Примеры |
|---|----------|---------|---------|
| 1 | {{TYPE}} | {{MORPHEMES}} | {{EXAMPLES}} |
| 2 | {{TYPE}} | {{MORPHEMES}} | {{EXAMPLES}} |
| 3 | {{TYPE}} | {{MORPHEMES}} | {{EXAMPLES}} |

---

## 💡 Практические советы для перевода

### 1. Определение направления перевода

**RUS → KBD:** {{TRANSFORMATION_RULE}}
- Русский: {{RUS_EXAMPLE}}
- Кабардинский: {{KBD_EXAMPLE}}

**KBD → RUS:** {{TRANSFORMATION_RULE}}
- Кабардинский: {{KBD_EXAMPLE}}
- Русский: {{RUS_EXAMPLE}}

### 2. Шаги морфологического анализа

1. **Найти {{KEY_ELEMENT}}** (обычно {{LOCATION}})
2. **Выделить {{ELEMENT_TYPE}}** ({{DIRECTION}}: {{MARKERS}})
3. **Определить {{CATEGORY}}** (по {{INDICATORS}}: {{EXAMPLES}})
4. **Собрать значение** (объединить все морфемы)

### 3. Использование корпуса для проверки

Всегда проверяйте свой перевод по корпусу (292k примеров):

```bash
# Поиск примеров с {{PATTERN}}
grep -i "{{PATTERN}}" data/translations/sents_292k.csv | head -5
```

---

## 📊 Статистика из корпуса

**Источник:** data/translations/sents_292k.csv (292,000 пар)

**Самые частые конструкции для {{CATEGORY}}:**
1. **{{FORM_1}}** - "{{MEANING_1}}" ({{COUNT}} примеров)
2. **{{FORM_2}}** - "{{MEANING_2}}" ({{COUNT}} примеров)
3. **{{FORM_3}}** - "{{MEANING_3}}" ({{COUNT}} примеров)

---

## 📚 Дополнительные ресурсы

**Грамматика:**
- `references/grammar/{{CATEGORY_DIR}}/` - {{DESCRIPTION}} (chunks {{CHUNK_RANGE}})
- `references/grammar/morphology_intro/` - теоретические основы

**Skills:**
- `.claude/skills/kbd-morphology/` - морфологический анализ
- `.claude/skills/kbd-translator/` - BIDIRECTIONAL перевод с corpus-first подходом
- `.claude/skills/grammar-cheatsheet/` - генератор шпаргалок

**Корпус:**
- `data/translations/sents_292k.csv` - 292,000 проверенных пар переводов

---

## 🔧 Особенности категории {{CATEGORY}}

### {{SPECIAL_FEATURE_1}}

{{DESCRIPTION}}

**Примеры:**
- {{EXAMPLE_1}}
- {{EXAMPLE_2}}

### {{SPECIAL_FEATURE_2}}

{{DESCRIPTION}}

**Правило:**
{{RULE_DESCRIPTION}}

---

## ⚠️ Частые ошибки

### ❌ Ошибка 1: {{ERROR_DESCRIPTION}}

**Неправильно:**
```
{{INCORRECT_EXAMPLE}}
```

**Правильно:**
```
{{CORRECT_EXAMPLE}}
```

**Объяснение:** {{WHY_WRONG}}

---

### ❌ Ошибка 2: {{ERROR_DESCRIPTION}}

**Неправильно:**
```
{{INCORRECT_EXAMPLE}}
```

**Правильно:**
```
{{CORRECT_EXAMPLE}}
```

**Объяснение:** {{WHY_WRONG}}

---

## 🎯 Чеклист для проверки перевода

При переводе с участием {{CATEGORY}} проверь:

- [ ] {{CHECK_1}}
- [ ] {{CHECK_2}}
- [ ] {{CHECK_3}}
- [ ] {{CHECK_4}}
- [ ] Найдены примеры в корпусе для валидации

---

## 📖 Связь с другими категориями

{{CATEGORY}} часто сочетается с:

1. **{{RELATED_CATEGORY_1}}** - {{RELATIONSHIP}}
   - Пример: {{EXAMPLE}}

2. **{{RELATED_CATEGORY_2}}** - {{RELATIONSHIP}}
   - Пример: {{EXAMPLE}}

3. **{{RELATED_CATEGORY_3}}** - {{RELATIONSHIP}}
   - Пример: {{EXAMPLE}}

---

## 🚀 Быстрый reference

### Top-5 форм для {{CATEGORY}}:

| Форма | Морфемы | Значение | Пример |
|-------|---------|----------|--------|
| {{FORM_1}} | {{MORPHEMES}} | {{MEANING}} | {{EXAMPLE}} |
| {{FORM_2}} | {{MORPHEMES}} | {{MEANING}} | {{EXAMPLE}} |
| {{FORM_3}} | {{MORPHEMES}} | {{MEANING}} | {{EXAMPLE}} |
| {{FORM_4}} | {{MORPHEMES}} | {{MEANING}} | {{EXAMPLE}} |
| {{FORM_5}} | {{MORPHEMES}} | {{MEANING}} | {{EXAMPLE}} |

---

## 🔍 Поиск в корпусе

### Полезные команды grep:

```bash
# {{PURPOSE_1}}
grep -i "{{PATTERN_1}}" data/translations/sents_292k.csv | head -5

# {{PURPOSE_2}}
grep -i "{{PATTERN_2}}" data/translations/sents_292k.csv | head -5

# {{PURPOSE_3}}
grep -i "{{PATTERN_3}}" data/translations/sents_292k.csv | head -5
```

---

**Дата создания:** {{DATE}}
**Категория:** {{CATEGORY_EN}} ({{CATEGORY_RU}})
**Источник примеров:** Реальный корпус переводов
**Формат визуализации:** ASCII-дерево морфем
**Создано с помощью:** `.claude/skills/grammar-cheatsheet/`

---

## 🎨 Легенда символов

В визуализациях используются:

- **│** - вертикальная связь между морфемами
- **└─** - пояснение к морфеме
- **{{MORPHEME}}** - сама морфема
- **Ø** - нулевой маркер (отсутствует явный аффикс)
- **()** - факультативная морфема
- **[]** - слот для морфемы

---

## 📝 Примечания

{{ADDITIONAL_NOTES_SECTION}}

---

**Следующие шпаргалки для изучения:**
{{LIST_OF_NEXT_CHEATSHEETS}}

**См. также:**
- [Глаголы](verb_translation_cheatsheet.md) - полисинтетическая структура ✓
- [{{RELATED_1}}]({{FILENAME_1}}.md) - {{DESCRIPTION_1}}
- [{{RELATED_2}}]({{FILENAME_2}}.md) - {{DESCRIPTION_2}}
