---
name: greeting-generator
description: Generate friendly greetings in multiple languages with cultural context. Use when creating welcome messages, international greetings, or multilingual user interfaces.
---

# Greeting Generator

A simple skill that demonstrates the basic structure of a Claude Code skill. This skill generates friendly greetings in various languages with appropriate cultural context.

## When to Use This Skill

Use this skill when:
- Creating welcome messages for international users
- Building multilingual user interfaces
- Learning different greeting customs
- Adding friendly, culturally-appropriate greetings to applications

## Instructions

When generating greetings:

1. **Ask for context**: Determine the target language and formality level
2. **Generate greeting**: Provide the greeting in the requested language
3. **Add cultural context**: Explain any cultural nuances or usage notes
4. **Provide alternatives**: Suggest variations for different contexts (formal/informal)

## Examples

### Example 1: Formal Japanese Greeting

```
Language: Japanese
Formality: Formal
Context: Business meeting

Greeting: おはようございます (Ohayou gozaimasu)
Translation: Good morning
Cultural Note: Used until around 10-11 AM. Appropriate for business settings.
Alternative: こんにちは (Konnichiwa) - for afternoon greetings
```

### Example 2: Informal Spanish Greeting

```
Language: Spanish
Formality: Informal
Context: Friends meeting

Greeting: ¡Hola! ¿Qué tal?
Translation: Hi! How's it going?
Cultural Note: Very casual, perfect for friends and peers.
Alternative: ¡Buenos días! - more formal morning greeting
```

## Best Practices

- Always consider the formality level and context
- Provide pronunciation guides when helpful
- Include cultural notes to avoid misunderstandings
- Offer both formal and informal alternatives

## AI Assistant Instructions

When this skill is activated:

1. Ask the user about:
   - Target language
   - Formality level (formal/informal/neutral)
   - Context of use (business, casual, written, spoken)

2. Generate:
   - The greeting in the target language
   - Romanization/pronunciation if using non-Latin script
   - Translation to English
   - Cultural context and usage notes
   - Alternative options

3. Always provide:
   - At least one alternative greeting
   - Guidance on when to use each option
   - Any important cultural considerations

Never:
- Generate potentially offensive or inappropriate greetings
- Assume formality level without asking
- Ignore cultural context
