---
name: hackathon-rules
description: Enforces Hackathon II rules, phases, and evaluation constraints.
---

# Hackathon II Rules

## Mandatory Constraints
- All code must be generated via Claude Code
- No manual edits allowed
- Every feature requires specs
- Phases must be followed sequentially

## Phases
1. Phase I – Python CLI Todo (In-memory)
2. Phase II – Web App
3. Phase III – AI Agent / Chatbot
4. Phase IV – Kubernetes (Minikube)
5. Phase V – Cloud-Native Deployment

## Evaluation Focus
- Spec quality
- AI-first workflow
- Reusable intelligence (skills, agents)
- Architectural clarity

Violating these rules risks disqualification.
