---
name: health-wellness
description: Workplace health and wellness expertise for employee wellness programs, mental health initiatives, ergonomics and safety, healthcare benefits strategy, and health analytics. Use when designing wellness programs, improving workplace safety, or analyzing health metrics.
---

# Health & Wellness Expert

Comprehensive workplace wellness frameworks for employee wellbeing, safety, and health program design.

## Wellness Program Strategy

### Total Wellbeing Framework

```
PHYSICAL: Exercise, nutrition, sleep, preventive care, chronic disease management
MENTAL: Stress management, resilience, work-life balance, mindfulness
FINANCIAL: Financial literacy, retirement, debt management, emergency savings
SOCIAL: Community connection, team relationships, belonging
CAREER: Development, purpose, job satisfaction, growth, recognition
```

### Program Components

| Component                  | Description                      | Participation Target |
| -------------------------- | -------------------------------- | -------------------- |
| **Health Risk Assessment** | Annual health screening          | 70%+                 |
| **Biometric Screening**    | Blood pressure, BMI, cholesterol | 60%+                 |
| **Fitness Programs**       | Gym subsidies, challenges        | 40%+                 |
| **Nutrition Programs**     | Healthy eating, coaching         | 30%+                 |
| **Mental Health**          | EAP, counseling, apps            | 25%+                 |
| **Financial Wellness**     | Education, coaching              | 35%+                 |
| **Tobacco Cessation**      | Support programs                 | 50%+ of smokers      |

### Incentive Design

```
PARTICIPATION-BASED: HRA ($100), Biometric ($150), Coaching ($50), Challenges ($50)
OUTCOME-BASED: BP target ($100), Healthy BMI ($100), Non-smoker ($300)
PREMIUM DIFFERENTIALS: Up to $600/year reduction, HSA contributions
COMPLIANCE: EEOC 30% limit, ADA accommodations, privacy protections
```

## Mental Health Programs

### Mental Health Framework

```
PREVENTION: Awareness, stress management, manager training, work-life policies
EARLY INTERVENTION: Screening, EAP, digital tools, peer support
TREATMENT: Therapy, psychiatric services, substance abuse, crisis intervention
RECOVERY: Return-to-work programs, accommodations, relapse prevention
```

### Mental Health Resources

| Resource           | Access                 | Coverage          |
| ------------------ | ---------------------- | ----------------- |
| **EAP**            | 24/7 hotline, web      | 6-8 free sessions |
| **Teletherapy**    | App, video             | Varies by plan    |
| **Digital Tools**  | Apps (Calm, Headspace) | Free to employees |
| **Crisis Support** | Text/call lines        | Unlimited         |
| **Support Groups** | ERG-led                | Free              |

### Manager Training

```
MENTAL HEALTH FIRST AID:

RECOGNIZE:
- Warning signs
- Behavioral changes
- Performance impacts

RESPOND:
- Start conversation
- Listen without judgment
- Express concern

REFER:
- EAP resources
- HR support
- Professional help
- Crisis resources

SUPPORT:
- Reasonable accommodations
- Flexible arrangements
- Check-ins
- Return-to-work planning
```

## Workplace Safety

### Safety Program Framework

```
LEADERSHIP: Executive commitment, safety policy, accountability
HAZARD ID: Job analysis, risk assessments, incident investigation, near-miss reporting
CONTROLS: Elimination → Substitution → Engineering → Administrative → PPE
TRAINING: New hire, job-specific, refresher, emergency response
MONITORING: Inspections, observations, metrics, audits
```

### Safety Metrics

| Metric        | Formula                                  | Benchmark        |
| ------------- | ---------------------------------------- | ---------------- |
| **TRIR**      | (Incidents × 200,000) / Hours worked     | <1.0             |
| **DART**      | (Days away/restricted × 200,000) / Hours | <0.5             |
| **Lost Time** | Lost time incidents / Total incidents    | <20%             |
| **Near Miss** | Near misses reported                     | Increasing trend |
| **Training**  | Completion rate                          | >95%             |

### Ergonomics Program

```
ERGONOMIC ASSESSMENT:

WORKSTATION SETUP:
- Monitor at eye level
- Arms at 90° angle
- Feet flat on floor
- Back supported

EQUIPMENT:
- Adjustable chair
- Monitor stand
- Keyboard tray
- Footrest if needed

BEHAVIORS:
- Regular breaks
- Stretch exercises
- Position changes
- Eye rest (20-20-20 rule)

ASSESSMENT PROCESS:
1. Self-assessment questionnaire
2. Virtual assessment option
3. In-person evaluation
4. Equipment recommendations
5. Follow-up check
```

## Healthcare Benefits Strategy

### Benefits Design Philosophy

```
COMPREHENSIVENESS: Medical, dental, vision, behavioral health, specialty care
ACCESSIBILITY: Network adequacy, telemedicine, geographic coverage
AFFORDABILITY: Competitive premiums, HSA/FSA options, subsidies
FLEXIBILITY: Multiple plan options, voluntary benefits, life event changes
```

### Plan Design Options

| Plan Type    | Premium | Deductible | Best For                    |
| ------------ | ------- | ---------- | --------------------------- |
| **PPO**      | Higher  | Lower      | Frequent care needs         |
| **HDHP/HSA** | Lower   | Higher     | Healthy, want tax benefits  |
| **HMO**      | Lower   | Lower      | Cost-conscious, PCP-centric |
| **EPO**      | Medium  | Medium     | Network-only OK             |

### Cost Management

```
COST CONTAINMENT STRATEGIES:

PLAN DESIGN:
- High-deductible options
- Reference-based pricing
- Narrow networks
- Tiered cost-sharing

VENDOR MANAGEMENT:
- Competitive bidding
- Performance guarantees
- Coalition purchasing
- Carve-out programs

CARE MANAGEMENT:
- Utilization management
- Case management
- Disease management
- Centers of Excellence

MEMBER ENGAGEMENT:
- Transparency tools
- Navigation support
- Wellness incentives
- Consumer education
```

## Health Analytics

### Data Sources

| Source         | Data Type             | Use Case            |
| -------------- | --------------------- | ------------------- |
| **Claims**     | Utilization, costs    | Population health   |
| **Biometrics** | Health measures       | Risk identification |
| **HRA**        | Self-reported health  | Program targeting   |
| **Engagement** | Program participation | ROI analysis        |
| **Absence**    | Disability, leave     | Productivity impact |

### Key Metrics

```
HEALTH METRICS:

POPULATION HEALTH:
- Risk distribution (low/medium/high)
- Chronic condition prevalence
- Preventive care rates
- Medication adherence

UTILIZATION:
- ER visits per 1000
- Inpatient admits per 1000
- Primary care visits
- Specialist referrals

COST:
- Per-employee per-month (PEPM)
- Per-member per-month (PMPM)
- Year-over-year trend
- Plan cost vs. benchmark

PRODUCTIVITY:
- Absenteeism rate
- Presenteeism estimate
- Disability incidence
- Workers' comp claims
```

### ROI Analysis

```
WELLNESS ROI CALCULATION:

DIRECT SAVINGS:
- Healthcare cost reduction
- Disability cost reduction
- Workers' comp reduction
- Absenteeism reduction

INDIRECT BENEFITS:
- Productivity improvement
- Engagement increase
- Retention improvement
- Recruitment advantage

ROI FORMULA:
ROI = (Total Benefits - Program Costs) / Program Costs

VOI (VALUE ON INVESTMENT):
Include harder-to-quantify benefits:
- Culture improvement
- Employer brand
- Employee satisfaction
- Risk reduction

BENCHMARK:
$1.50 - $3.00 return per $1 invested (3-5 year horizon)
```

## Workplace Health Compliance

### Regulatory Requirements

| Regulation | Requirement                | Impact          |
| ---------- | -------------------------- | --------------- |
| **OSHA**   | Workplace safety standards | Safety programs |
| **ADA**    | Disability accommodations  | Wellness design |
| **GINA**   | Genetic non-discrimination | HRA limitations |
| **HIPAA**  | Health information privacy | Data handling   |
| **ERISA**  | Benefit plan requirements  | Plan documents  |
| **ACA**    | Wellness incentive limits  | Program design  |

### Privacy Protections

```
HEALTH DATA PRIVACY:

COLLECTION:
- Voluntary participation
- Informed consent
- Minimum necessary data

STORAGE:
- Encrypted at rest
- Access controls
- Separate from HR records

USE:
- Aggregate reporting only
- No individual disclosure
- De-identified for vendors

SHARING:
- HIPAA authorization required
- Business associate agreements
- Firewall from employment decisions
```

## Program Implementation

### Implementation Roadmap

| Phase          | Timeline  | Activities                       |
| -------------- | --------- | -------------------------------- |
| **Assessment** | Month 1-2 | Needs analysis, benchmarking     |
| **Design**     | Month 3-4 | Program design, vendor selection |
| **Build**      | Month 5-6 | Systems, communications          |
| **Launch**     | Month 7   | Rollout, training                |
| **Optimize**   | Month 8+  | Measure, iterate                 |

### Success Factors

```
CRITICAL SUCCESS FACTORS:

LEADERSHIP SUPPORT:
- Visible sponsorship
- Resource commitment
- Role modeling

CULTURE:
- Wellness as value
- Manager engagement
- Peer support

COMMUNICATION:
- Clear messaging
- Multiple channels
- Ongoing promotion

ACCESSIBILITY:
- Inclusive design
- Multiple options
- Remove barriers

MEASUREMENT:
- Track participation
- Measure outcomes
- Demonstrate value
- Continuous improvement
```

## See Also

- [Fortune 50 HR/Talent](../fortune50-hr-talent/SKILL.md)
- [Fortune 50 Leadership](../fortune50-leadership/SKILL.md)
- [Fortune 50 Operations](../fortune50-operations/SKILL.md)
