---
name: Help Article Writer
slug: help-article-writer
description: Write clear, effective help center articles that reduce support tickets and empower users
category: customer-support
complexity: moderate
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "help article"
  - "help center"
  - "documentation"
  - "knowledge base"
  - "support article"
  - "user guide"
tags:
  - help-center
  - documentation
  - technical-writing
  - knowledge-base
  - customer-support
---

# Help Article Writer

Expert help center content creation system that transforms complex product knowledge into clear, scannable, user-friendly documentation. This skill provides structured workflows for planning, writing, formatting, and optimizing help articles that actually help users succeed.

Help articles are the bridge between your product and user success. Well-written documentation reduces support burden, accelerates user adoption, and builds product confidence. This skill helps you create help content that users can find, understand, and act on.

Built on technical writing best practices and user experience principles, this skill combines content strategy, clear writing, and continuous optimization to create help centers that scale.

## Core Workflows

### Workflow 1: Content Planning
**Map what needs to be documented and prioritize**

1. **Content Audit**
   - Inventory existing help content
   - Identify gaps vs. product features
   - Flag outdated content needing updates
   - Map content to user journeys
   - Prioritize by support ticket volume

2. **User Journey Mapping**
   - Document key user flows
   - Identify decision points needing guidance
   - Note complexity spikes requiring documentation
   - Map onboarding to documentation needs
   - Align with feature adoption goals

3. **Content Hierarchy**
   - **Getting Started**: First-time user needs
   - **Core Features**: Main functionality guides
   - **Advanced Features**: Power user documentation
   - **Integrations**: Third-party connections
   - **Account & Billing**: Administrative needs
   - **Troubleshooting**: Problem resolution

4. **Priority Matrix**
   | Priority | Criteria |
   |----------|----------|
   | Critical | High ticket volume, core features, onboarding |
   | High | Moderate tickets, important features |
   | Medium | Low tickets, nice-to-have features |
   | Low | Edge cases, rarely used features |

### Workflow 2: Article Structure
**Design articles for scannability and comprehension**

1. **Standard Article Template**
   ```
   # [Clear, Action-Oriented Title]

   [One-sentence summary of what this article covers]

   ## Overview
   [Brief context - what, why, who needs this]

   ## Prerequisites
   [What users need before starting - optional]

   ## Steps / How It Works
   [Numbered steps or explanation]

   ## Examples
   [Concrete examples if helpful]

   ## Common Issues
   [Troubleshooting section if relevant]

   ## Related Articles
   [Links to related content]
   ```

2. **Article Types**
   - **Conceptual**: Explains what something is and why it matters
   - **Procedural**: Step-by-step how-to guides
   - **Reference**: Technical specifications, API docs
   - **Troubleshooting**: Problem-solution format
   - **Tutorial**: Learning-focused walkthroughs

3. **Formatting Standards**
   - H1 for title only
   - H2 for main sections
   - H3 for subsections
   - Numbered lists for sequential steps
   - Bullet lists for non-sequential items
   - Callouts for warnings, tips, notes

### Workflow 3: Writing Process
**Create clear, user-focused content**

1. **Pre-Writing**
   - Define the user and their goal
   - Identify the user's starting knowledge
   - Determine success criteria
   - Gather technical information
   - Test the process yourself

2. **Drafting**
   - Start with the user's goal, not the feature
   - Write in second person ("you")
   - Use active voice
   - Keep sentences under 25 words
   - One idea per paragraph
   - Lead with the action

3. **Editing Passes**
   - **Clarity pass**: Simplify jargon, shorten sentences
   - **Accuracy pass**: Verify all steps work
   - **Formatting pass**: Add headers, lists, callouts
   - **Link pass**: Add internal/external links
   - **Visual pass**: Add screenshots, diagrams

4. **Quality Checklist**
   - [ ] Title clearly states what user will accomplish
   - [ ] Overview provides context in 2-3 sentences
   - [ ] Steps are numbered and specific
   - [ ] Screenshots show current UI
   - [ ] No jargon without explanation
   - [ ] Includes troubleshooting for common issues
   - [ ] Links to related content
   - [ ] Tested by non-expert

### Workflow 4: Visual Content
**Enhance articles with effective imagery**

1. **Screenshot Guidelines**
   - Capture only relevant UI areas
   - Use consistent browser/device
   - Annotate with numbered callouts
   - Highlight clickable elements
   - Maintain consistent dimensions
   - Update when UI changes

2. **Diagram Guidelines**
   - Use for complex flows or architectures
   - Keep visual style consistent
   - Include legend if needed
   - Make text readable at small sizes
   - Provide alt text for accessibility

3. **Video Guidelines**
   - Keep under 3 minutes
   - Use for complex multi-step processes
   - Include captions
   - Provide text alternative
   - Host on reliable platform

4. **Visual Placement**
   - Screenshots after the step they illustrate
   - Diagrams at concept introduction
   - Videos as optional enhancement, not replacement

### Workflow 5: Optimization & Maintenance
**Keep content fresh and effective**

1. **SEO Optimization**
   - Include keywords in title and headers
   - Write descriptive meta descriptions
   - Use natural language (matches search queries)
   - Internal linking structure
   - Alt text for images

2. **Analytics Tracking**
   - Page views and unique visitors
   - Time on page
   - Bounce rate
   - Search terms leading to article
   - "Was this helpful?" feedback
   - Exit to support ticket rate

3. **Update Triggers**
   - Product UI changes
   - Feature updates or deprecations
   - User feedback indicating confusion
   - Support ticket patterns
   - Negative helpfulness ratings

4. **Review Cadence**
   - **On Release**: Update affected articles
   - **Monthly**: Review feedback and metrics
   - **Quarterly**: Comprehensive content audit
   - **Annually**: Full restructure if needed

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| Plan help content | "Create help center content plan" |
| Write new article | "Write help article for [feature]" |
| Improve existing article | "Optimize help article for [topic]" |
| Create screenshot guide | "Generate screenshot guidelines" |
| Audit help content | "Audit help center coverage" |
| Simplify article | "Simplify article for [topic]" |
| Add troubleshooting | "Add troubleshooting to [article]" |
| Convert to video script | "Create video script from [article]" |
| Check article metrics | "Analyze help article performance" |
| Generate article series | "Create article series for [workflow]" |

## Best Practices

### Writing Style
- Write at 8th grade reading level
- Use familiar words over technical terms
- Define acronyms on first use
- One instruction per step
- Start steps with verbs
- Avoid "simple," "just," "easy"

### Structure
- Front-load the most important information
- Keep articles focused (one topic per article)
- Use parallel structure in lists
- Limit nesting to 2 levels
- Include jump links for long articles

### User Experience
- Make articles findable via search
- Provide multiple navigation paths
- Include breadcrumbs
- Link related content
- Enable feedback mechanism
- Offer escalation path to support

### Accessibility
- Alt text for all images
- Descriptive link text (not "click here")
- Sufficient color contrast
- Keyboard-navigable
- Screen reader compatible
- Captions for videos

### Maintenance
- Assign article ownership
- Create update alerts for product changes
- Track content freshness dates
- Archive rather than delete
- Version control important articles

## Article Templates

### Procedural Article
```markdown
# How to [Accomplish Specific Goal]

Learn how to [brief description of what user will accomplish].

## Overview

[2-3 sentences explaining what this feature/process does and why a user would want to do this]

## Before You Start

- [Prerequisite 1]
- [Prerequisite 2]

## Steps

### Step 1: [Action]

[Explanation of what to do]

![Screenshot with annotation]

### Step 2: [Action]

[Explanation of what to do]

### Step 3: [Action]

[Explanation of what to do]

## Verify It Worked

You'll know you're successful when [observable outcome].

## Troubleshooting

**Issue**: [Common problem]
**Solution**: [How to fix it]

## What's Next

- [Related action 1]
- [Related action 2]

---
*Last updated: [Date] | [Feedback link]*
```

### Conceptual Article
```markdown
# Understanding [Concept]

[One-sentence definition of the concept]

## What Is [Concept]?

[2-3 paragraphs explaining the concept in user terms]

## Why It Matters

[Explain the benefit to the user - what problem it solves]

## How It Works

[Explain the mechanism at appropriate technical level]

![Diagram if helpful]

## Key Terms

| Term | Definition |
|------|------------|
| [Term 1] | [Definition] |
| [Term 2] | [Definition] |

## Examples

### Example 1: [Scenario]
[Concrete example of concept in action]

### Example 2: [Scenario]
[Another example]

## Related Topics

- [Related concept 1]
- [Related concept 2]

---
*Last updated: [Date] | [Feedback link]*
```

### Troubleshooting Article
```markdown
# Fixing [Problem Description]

Having trouble with [problem]? Here's how to resolve it.

## Symptoms

You might see this issue if:
- [Symptom 1]
- [Symptom 2]
- [Symptom 3]

## Quick Fixes

Try these solutions in order:

### Solution 1: [Most Common Fix]

[Steps to try]

### Solution 2: [Second Most Common]

[Steps to try]

### Solution 3: [Less Common]

[Steps to try]

## Still Having Issues?

If none of the above worked:

1. [Gather this information]
2. [Contact support] with details

## Why This Happens

[Brief technical explanation for curious users - optional]

## Prevent It in the Future

[Tips to avoid this issue - if applicable]

---
*Last updated: [Date] | [Feedback link]*
```

## Red Flags

- **Wall of text**: No headers, bullets, or visual breaks
- **Passive voice**: "The button should be clicked" vs "Click the button"
- **Feature-centric**: Describes feature, not user goal
- **Outdated screenshots**: UI doesn't match current product
- **Missing context**: Assumes too much user knowledge
- **No escalation**: User stuck with no next step
- **Buried answer**: Key information hidden in prose

## Content Style Guide

### Voice and Tone
- Friendly but not casual
- Confident but not arrogant
- Helpful but not condescending
- Clear but not oversimplified

### Word Choices
| Use | Avoid |
|-----|-------|
| Choose | Select |
| Click | Hit, Press (for mouse) |
| Enter | Type in |
| Go to | Navigate to |
| Make sure | Ensure |
| Use | Utilize |

### Formatting
- **Bold** for UI elements users interact with
- `Code formatting` for user input, code, paths
- *Italics* sparingly for emphasis
- > Blockquotes for important callouts
