# HeroUI Component Reference

This document lists the supported HeroUI components and their standard properties for use within this skill.

## Buttons
- **Variants**: `solid`, `faded`, `bordered`, `light`, `flat`, `ghost`, `shadow`
- **Colors**: `default`, `primary`, `secondary`, `success`, `warning`, `danger`
- **Sizes**: `sm`, `md`, `lg`

## Inputs
- **Variants**: `flat`, `bordered`, `underlined`, `faded`
- **Label Placements**: `inside`, `outside`, `outside-left`

## Layouts
- **Grid**: Responsive columns (1-12)
- **Flex**: Standard flexbox utilities via Tailwind CSS

## Best Practices
- Use `gap` for spacing between components.
- Prefer `shadow` variant for primary actions to make them pop.
- Always include `aria-label` for icon-only buttons.
