---
name: heroui-design-skill
description: Advanced UI/UX Design Skill using HeroUI and MCP Design Intelligence.
version: 2.0.0
tags: [ui, ux, heroui, design-intelligence, composition]
---

# HeroUI Design Intelligence Skill 🎨

This skill empowers Claude to act as a **Senior UI/UX Designer** by leveraging the HeroUI MCP Server. It goes beyond simple code generation by understanding design principles, layout orchestration, and component composition.

## 🚀 Core Capabilities

### 1. Layout Orchestration (`orchestrate_layout`)
- Understands the **business purpose** of a page.
- Designs information hierarchy based on **priority** (Conversion, Information, Aesthetic).
- Generates structural layouts that are responsive and production-ready.

### 2. Component Composition (`compose_section`)
- Composes complex sections (Hero, Features, Pricing) instead of just atomic components.
- Supports multiple **visual styles**: Minimal, Bold, Glassmorphism, and Flat.
- Ensures all sub-components work together harmoniously.

### 3. Theme Synchronization (`configure_theme`)
- Manages global design consistency.
- Synchronizes brand colors, border radius, and color modes (Dark/Light).

## 📂 Structure

- `script/`: Contains validation and utility scripts for UI testing.
- `reference/`: Documentation and design system guidelines.
- `asset/`: Visual assets and design tokens.

## 🛠 How to Use with MCP

Claude should use this skill to:
1. **Analyze** the user's requirement to determine the page purpose.
2. **Orchestrate** the layout first to establish the structure.
3. **Compose** individual sections with the chosen visual style.
4. **Refine** the theme to match the brand identity.

This approach ensures a **"Design-First"** workflow that is far superior to manual coding in an IDE.
