---
name: housekeeper
description: Automatically triggers when users ask about upgrading, updating, or checking versions of Oh My Opencode or other development tools. Use for version checks, upgrade procedures, maintenance recommendations, and keeping development tools current.
scope: global
license: MIT
---

# Housekeeper

## What this skill does
The Housekeeper skill monitors and maintains your development tools, starting with Oh My Opencode. It checks current versions, identifies available updates, and provides clear upgrade instructions to keep your tools current.

## When to use this skill
This skill automatically triggers when users ask about:
- "upgrade", "update", or "check version" for Oh My Opencode
- "is my tool up to date?", "how to update [tool name]"
- "check for updates", "what's the latest version of [tool]"
- General tool maintenance and version management queries

**Never use this skill** for:
- Installing tools for the first time (use installation skills instead)
- Questions about specific tool usage or features
- Bug fixes or troubleshooting unrelated to versions

## Instructions

### For Oh My Opencode Maintenance:

1. **Check Current Status**:
   - Run `bunx oh-my-opencode get-local-version` to check your current version
   - Compare against the latest available versions from npm

2. **Identify Update Type**:
   - Determine if the latest version is stable or beta
   - Check release notes for breaking changes or new features
   - Consider your stability requirements (stable vs beta)

3. **Perform Upgrade**:
   - For stable upgrades: `bunx oh-my-opencode install`
   - For specific versions: `bunx oh-my-opencode@<version> install`
   - For beta versions: `bunx oh-my-opencode@3.0.0-beta.2 install`

4. **Verify Installation**:
   - Run `bunx oh-my-opencode doctor` to ensure everything works correctly
   - Confirm configuration files are preserved (`oh-my-opencode.json`, `opencode.json`)

5. **Provide Maintenance Recommendations**:
   - Suggest regular update schedule (weekly/monthly)
   - Recommend testing major version upgrades in non-critical projects first
   - Advise on backing up configuration before major upgrades

### Future Tool Support:
This skill will be extended to support additional development tools. The framework is designed to be extensible for:
- Other OpenCode plugins
- Development environment tools
- Language-specific package managers
- CLI utilities

## Example Usage

**User**: "Is my Oh My Opencode installation up to date?"

**Housekeeper Response**:
- Checks current version with `bunx oh-my-opencode get-local-version`
- Compares against npm registry
- Reports status and provides upgrade command if needed

**User**: "How do I upgrade to the latest Oh My Opencode?"

**Housekeeper Response**:
- Identifies latest stable vs beta versions
- Provides appropriate upgrade command
- Explains any important considerations for the upgrade

## Important Notes

- **Configuration Preservation**: Your existing configuration files are preserved during upgrades
- **No Auto-Update**: Manual intervention is required for all updates
- **Version Pinning**: You can pin to specific versions if needed
- **Backup Recommended**: Always backup configuration before major version upgrades
- **Stable vs Beta**: Choose stable versions for production, beta for testing new features