---
name: HR Assistant
slug: hr-assistant
description: Human resources management, employee relations, recruitment support, and HR compliance assistance
category: domain
complexity: complex
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "create job description"
  - "interview questions"
  - "employee handbook"
  - "performance review"
  - "HR policy"
  - "onboarding process"
tags:
  - human-resources
  - recruitment
  - employee-relations
  - compliance
  - talent-management
---

# HR Assistant

Comprehensive human resources support system designed for HR professionals, managers, business owners, and team leads handling people operations. This skill provides assistance with recruitment, employee onboarding, performance management, policy creation, compliance guidance, and employee relations.

The HR Assistant excels at creating job descriptions, developing interview questions, designing onboarding programs, drafting HR policies, structuring performance review processes, handling sensitive employee situations, and ensuring HR best practices. It's valuable for startups building their first HR function, small businesses without dedicated HR staff, and HR professionals seeking templates and guidance.

**Important Disclaimer:** This skill provides general HR guidance and templates. It does not constitute legal advice. Employment law varies by country, state, and local jurisdiction. Always consult with employment attorneys, HR compliance specialists, and local labor authorities for legal compliance, especially regarding terminations, discrimination claims, wage/hour issues, and workplace investigations.

## Core Workflows

### Workflow 1: Recruitment & Hiring

**Purpose:** Attract, evaluate, and hire top talent through structured recruitment processes.

**Steps:**

**1. Job Description Creation**

**Structure:**
- **Job Title:** Clear, industry-standard title (avoid creative titles that confuse candidates)
- **Company Overview:** 2-3 sentences about company mission, culture, stage
- **Role Summary:** 2-3 sentences on what the position does and why it matters
- **Responsibilities:** 5-8 bullet points on primary duties and expectations
- **Requirements:**
  - Must-have qualifications (education, experience, skills)
  - Nice-to-have qualifications
  - Avoid unnecessary requirements that limit candidate pool
- **Benefits & Perks:** Compensation range (transparency increases applicant quality), health benefits, retirement, PTO, remote work, professional development
- **Equal Opportunity Statement:** Required compliance language

**Best Practices:**
- Use inclusive language (avoid gendered terms, cultural bias)
- Be specific about expectations (remote/hybrid/office, travel %, hours)
- Include salary range (required in some states, best practice everywhere)
- Focus on outcomes and impact, not just tasks
- Highlight growth opportunities and career development
- Keep to 400-800 words (longer descriptions have lower apply rates)

**2. Candidate Sourcing**

**Channels:**
- **Job boards:** LinkedIn, Indeed, Glassdoor, ZipRecruiter
- **Niche boards:** AngelList (startups), Dice (tech), Behance (creative), Mediabistro (media)
- **Employee referrals:** Highest quality hires, fastest time-to-fill
- **Social recruiting:** LinkedIn recruiter, targeted ads, industry groups
- **University partnerships:** Campus recruiting, internship programs
- **Recruiting agencies:** For hard-to-fill or executive roles

**Candidate pipeline goals:**
- 5-10 qualified applicants per opening
- Top-of-funnel: 20-50 total applicants
- Screen to interview ratio: 5:1
- Interview to offer ratio: 3:1

**3. Resume Screening**

**Red flags:**
- Unexplained employment gaps
- Job hopping (multiple 6-12 month stints without reason)
- Lack of progression/growth
- Typos and grammatical errors (attention to detail)
- Missing key required qualifications

**Green flags:**
- Relevant experience in similar roles/industries
- Progressive responsibility and career growth
- Specific, quantified accomplishments
- Continuous learning (courses, certifications, side projects)
- Alignment with company values and mission

**4. Interview Process Design**

**Typical structure:**
- **Phone/video screen (30 min):** Recruiter or hiring manager
  - Verify basic qualifications
  - Assess communication skills
  - Culture fit initial assessment
  - Compensation expectations
  - Logistics (start date, location requirements)

- **First-round interview (60 min):** Hiring manager
  - Deep dive on experience and skills
  - Behavioral questions (STAR method)
  - Role-specific scenarios
  - Assess problem-solving and critical thinking
  - Culture fit

- **Panel/team interview (60-90 min):** Meet potential colleagues
  - Team dynamics and collaboration
  - Technical assessment or case study (if applicable)
  - Different perspectives on candidate fit

- **Final interview (30-60 min):** Senior leader or executive
  - Vision and values alignment
  - Long-term potential
  - Executive presence
  - Final sell on opportunity

**Interview question types:**
- **Behavioral:** "Tell me about a time when..." (past behavior predicts future)
- **Situational:** "What would you do if..." (judgment and problem-solving)
- **Technical:** Role-specific skills assessment
- **Culture fit:** Values, work style, motivation

**5. Candidate Evaluation**

**Scoring rubric (1-5 scale):**
- Required skills and experience
- Problem-solving and critical thinking
- Communication skills
- Culture fit and values alignment
- Growth potential
- Team collaboration

**Process:**
- All interviewers submit scores independently
- Debrief meeting to discuss and align
- Avoid "gut feel" decisions; use structured evaluation
- Check references (2-3 professional references)
- Background check (if applicable)

**6. Offer & Negotiation**

**Offer components:**
- Base salary
- Bonus/commission structure (if applicable)
- Equity (if startup/growth company)
- Benefits (health, dental, vision, 401k match, etc.)
- PTO and holidays
- Start date
- Any contingencies (background check, references)

**Negotiation tips:**
- Know your salary range before offering (market research)
- Lead with fair offer; don't lowball (damages relationship)
- Be prepared for counter; have room to move on non-salary items
- Explain total compensation package (benefits value, equity upside)
- Set deadline for decision (3-7 days typical)

**Deliverables:**
- Job description template
- Interview question bank by role type
- Candidate scorecard template
- Offer letter template
- Recruitment process checklist

### Workflow 2: Employee Onboarding

**Purpose:** Set new hires up for success through structured orientation and integration.

**Pre-Start Preparation:**

**Week before start date:**
- Send welcome email with first-day logistics (time, location, dress code, parking, contact)
- Complete paperwork (I-9, W-4, direct deposit, benefits enrollment)
- Prepare workspace (desk, computer, phone, supplies, access badges)
- Set up accounts (email, Slack, project management tools, etc.)
- Assign onboarding buddy/mentor
- Schedule first-week meetings and training
- Prepare welcome package (company swag, handbook, org chart)

**First Day:**
- Warm welcome from manager and team
- Office/facility tour
- IT setup and system access
- HR orientation (benefits, policies, timekeeping)
- Review role expectations and immediate priorities
- Team introductions
- First day assignment (small, achievable task)
- Lunch with team or buddy

**First Week:**
- Detailed role training and expectations
- Meet key stakeholders and cross-functional partners
- Product/service overview and company history
- Culture and values discussion
- 30-60-90 day plan development
- Set initial goals and success metrics
- Daily check-ins with manager

**First Month:**
- Role-specific training and skill development
- Deeper relationship building across organization
- Regular 1:1s with manager
- Progress check on 30-day goals
- Feedback session (how onboarding is going, what support needed)

**First 90 Days:**
- Increasing autonomy and responsibility
- 90-day review (formal feedback, performance against goals)
- Assess cultural fit and long-term potential
- Development plan for ongoing growth
- Confirm successful onboarding completion

**Onboarding checklist categories:**
- Administrative (paperwork, systems, compliance)
- Workspace and equipment
- Role training and knowledge transfer
- Relationship building (team, stakeholders, culture)
- Goals and expectations setting

**Success metrics:**
- Time to productivity (how quickly new hire is fully effective)
- 90-day retention rate (are new hires staying?)
- Manager and new hire satisfaction scores
- Completion of onboarding tasks

**Deliverables:**
- Onboarding checklist template
- Welcome email template
- First-day agenda
- 30-60-90 day plan template
- Onboarding buddy guide

### Workflow 3: Performance Management

**Purpose:** Continuously develop employees, recognize contributions, and address underperformance.

**Continuous Performance Management:**

**1. Goal Setting (OKRs or SMART Goals)**

**OKR framework (Objectives and Key Results):**
- **Objective:** Qualitative, inspirational goal (what you want to achieve)
- **Key Results:** Quantitative metrics showing progress toward objective (how you measure success)
- **Example:**
  - Objective: Become the industry leader in customer satisfaction
  - Key Results:
    - Increase NPS from 45 to 70
    - Reduce average response time from 24hr to 4hr
    - Achieve 95%+ resolution rate on first contact

**SMART goals:**
- **S**pecific - Clear and well-defined
- **M**easurable - Quantifiable metrics
- **A**chievable - Realistic given resources
- **R**elevant - Aligned with company and role priorities
- **T**ime-bound - Specific deadline

**Best practices:**
- Set quarterly or annual goals
- Align individual goals to team and company objectives
- 3-5 goals per person (more = diluted focus)
- Balance outcome goals (results) and development goals (skills)
- Employee co-creates goals (ownership and buy-in)

**2. Regular 1:1s (Weekly or Bi-weekly)**

**Structure:**
- Employee brings agenda (their meeting, not yours)
- Discuss progress on goals and projects
- Address blockers and needs
- Provide coaching and feedback
- Build relationship and trust
- 30-60 minutes

**Manager responsibilities:**
- Active listening
- Ask open-ended questions
- Provide timely, specific feedback
- Remove obstacles
- Recognize wins and effort
- Address concerns early

**3. Formal Performance Reviews (Annual or Semi-Annual)**

**Review components:**
- **Self-assessment:** Employee reflects on accomplishments, challenges, growth
- **Manager assessment:** Evaluation of performance against goals and competencies
- **Peer feedback:** 360-degree input from colleagues (optional)
- **Rating/scoring:** Numerical or categorical rating (exceeds/meets/needs improvement)
- **Development discussion:** Strengths, growth areas, career aspirations
- **Goal setting:** Objectives for next review period

**Performance review template:**
1. **Summary:** Overall performance narrative
2. **Goal achievement:** Progress on each goal (met/exceeded/missed)
3. **Core competencies:** Communication, collaboration, problem-solving, leadership, etc.
4. **Accomplishments:** Major wins and contributions
5. **Development areas:** Where to improve and how
6. **Career discussion:** Aspirations, growth path, opportunities
7. **Goals for next period:** New objectives and key results
8. **Manager support:** What employee needs from manager to succeed

**Best practices:**
- No surprises (feedback should be ongoing, not just at review)
- Focus on behavior and outcomes, not personality
- Be specific with examples
- Balance positive and constructive feedback
- Make it a dialogue, not a monologue
- Document everything (written record protects both parties)

**4. Addressing Underperformance**

**Progressive discipline approach:**

**Step 1: Informal coaching conversation**
- Identify the issue (specific behaviors or outcomes)
- Understand root cause (skill gap, unclear expectations, personal issues)
- Agree on improvement plan
- Set timeline for improvement
- Document conversation

**Step 2: Formal written warning**
- If no improvement after coaching
- Document specific performance gaps
- Outline expectations and required improvements
- Set clear timeline (typically 30-60 days)
- Schedule check-in meetings
- State consequences of continued underperformance
- Employee and manager sign

**Step 3: Final written warning**
- If insufficient improvement
- Reiterate expectations and gaps
- Final chance to improve (typically 30 days)
- Explicit statement that termination is next step
- More frequent check-ins (weekly)

**Step 4: Termination**
- If no improvement or serious misconduct
- Consult HR and legal before proceeding
- Document all prior steps and current justification
- Prepare termination meeting (brief, respectful, final)
- Handle logistics (final paycheck, benefits, return of property)

**Important:** Skip steps for serious misconduct (harassment, theft, violence, gross negligence). Always consult legal counsel before termination.

**Deliverables:**
- Performance review template
- 1:1 meeting template
- Goal-setting worksheet (OKR/SMART)
- Performance improvement plan (PIP) template
- Feedback conversation guide

### Workflow 4: HR Policies & Employee Handbook

**Purpose:** Establish clear expectations, protect company legally, and create positive workplace culture.

**Essential Handbook Sections:**

**1. Welcome & Company Overview**
- Welcome letter from CEO
- Mission, vision, values
- Company history and culture
- Organization structure

**2. Employment Basics**
- At-will employment disclaimer (if applicable)
- Equal employment opportunity (EEO) statement
- Employment classifications (full-time, part-time, contractor)
- Background checks and reference verification

**3. Workplace Policies**
- Work hours and schedule
- Remote work policy (if applicable)
- Attendance and punctuality
- Dress code
- Workplace safety
- Substance abuse policy
- Email and internet usage
- Social media policy
- Confidentiality and intellectual property

**4. Compensation & Benefits**
- Pay periods and timekeeping
- Overtime policy
- Performance reviews and raises
- Health insurance
- Retirement plans (401k, match)
- Other benefits (life insurance, disability, commuter, etc.)

**5. Time Off**
- Holidays
- Paid time off (PTO) or separate vacation/sick leave
- Accrual and carryover rules
- Bereavement leave
- Jury duty
- Military leave
- Parental leave (maternity, paternity, adoption)
- Leave of absence (FMLA, personal, medical)

**6. Professional Development**
- Training and development opportunities
- Tuition reimbursement
- Conference attendance
- Performance management process

**7. Workplace Conduct**
- Code of conduct
- Anti-discrimination and harassment policy (required)
- Complaint and investigation procedures
- Disciplinary procedures
- Conflict of interest
- Whistleblower protection

**8. Termination**
- Resignation (notice period)
- Termination for cause
- Layoffs and reductions in force
- Exit procedures
- Final paycheck timing
- COBRA (health insurance continuation)

**9. Acknowledgment**
- Employee signature acknowledging receipt and understanding
- Disclaimer that handbook is not a contract
- At-will employment restatement

**Compliance considerations:**
- **Federal:** FLSA (wage/hour), Title VII (discrimination), ADA (disability), FMLA (family leave), OSHA (safety)
- **State:** Varies widely (California, New York especially strict on wages, leave, privacy)
- **Local:** City/county ordinances (sick leave, minimum wage)

**Best practices:**
- Review and update annually
- Have employment attorney review
- Make accessible (online portal, intranet)
- Acknowledge receipt in writing
- Train managers on policies
- Apply consistently (selective enforcement is discriminatory)
- Keep language clear and conversational, not overly legal

**Deliverables:**
- Employee handbook template
- Policy templates (remote work, social media, harassment, etc.)
- Acknowledgment form
- Compliance checklist by state

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| Create job description | "Job description for [role title]" |
| Interview questions | "Interview questions for [role/skill]" |
| Onboarding checklist | "Onboarding plan for [role]" |
| Performance review | "Performance review template for [role/level]" |
| HR policy | "Create [policy type] policy" |
| Offer letter | "Draft offer letter for [role], [salary]" |
| Termination guidance | "How to handle termination for [situation]" |
| Employee handbook | "Employee handbook outline" |
| 1:1 template | "1:1 meeting agenda template" |
| Feedback conversation | "How to give feedback on [issue]" |

## Best Practices

### Recruitment Excellence
- **Write inclusive job descriptions** - Remove biased language, unnecessary requirements
- **Structured interviews** - Same questions for all candidates, scored evaluation
- **Sell the opportunity** - Great candidates have options; make your role compelling
- **Move quickly** - Top talent is off the market in 10-14 days
- **Candidate experience matters** - How you treat candidates reflects your culture

### Onboarding Success
- **Start before day one** - Prepare workspace, send welcome materials
- **Make it personal** - Assign buddy, team welcome, manager involvement
- **Don't drink from fire hose** - Pace information over weeks, not all on day one
- **Set early wins** - Give achievable tasks to build confidence
- **Check in frequently** - Daily first week, weekly first month

### Performance Management
- **Feedback should be ongoing** - Don't wait for annual review
- **Be specific** - Vague feedback doesn't help anyone improve
- **Focus on behavior** - "You interrupted three times in that meeting" not "You're rude"
- **Balance positive and constructive** - Recognize wins, address gaps
- **Make it a dialogue** - Ask questions, listen, collaborate on solutions

### Policy & Compliance
- **Consistency is key** - Selective enforcement is discrimination
- **Document everything** - If it's not written down, it didn't happen
- **Get legal review** - Employment law is complex; don't guess
- **Communicate changes** - Update handbook, notify employees
- **Train managers** - They're your front line; ensure they know and follow policies

### Employee Relations
- **Listen first** - Understand before solving
- **Stay neutral** - Don't take sides in conflicts
- **Maintain confidentiality** - Only share on need-to-know basis
- **Follow process** - Consistent procedures protect everyone
- **Document concerns** - Create paper trail for serious issues

## Common HR Challenges & Solutions

### Challenge: Low candidate quality or volume
**Solutions:**
- Review job description (are requirements too stringent?)
- Expand sourcing channels
- Improve employer brand (Glassdoor, social media)
- Increase compensation or transparency about it
- Employee referral incentives

### Challenge: New hire turnover (leave within 6-12 months)
**Solutions:**
- Improve hiring process (better job preview, culture assessment)
- Strengthen onboarding (structure, support, early wins)
- Review compensation (are you at market?)
- Address manager quality (people leave managers, not companies)
- Career development opportunities

### Challenge: Employee disengagement
**Solutions:**
- Regular 1:1s and authentic communication
- Recognition and appreciation
- Career development and growth opportunities
- Meaningful work and connection to mission
- Address toxic behaviors or poor leadership

### Challenge: Inconsistent policy enforcement
**Solutions:**
- Manager training on policies and procedures
- Centralized HR oversight of disciplinary actions
- Regular policy reviews and updates
- Clear documentation requirements
- Audit for disparate impact

### Challenge: Difficult conversations (terminations, performance issues)
**Solutions:**
- Prepare thoroughly (documentation, talking points, legal review)
- Be direct and compassionate
- Focus on facts and behaviors
- Have witness present (HR or second manager)
- Follow up in writing
- Consult legal before terminations

## HR Metrics & Analytics

**Recruitment Metrics:**
- **Time to fill:** Days from requisition to offer acceptance (target: 30-45 days)
- **Cost per hire:** Total recruiting costs / Number of hires
- **Quality of hire:** Performance ratings of new hires after 1 year
- **Source of hire:** Which channels produce best candidates
- **Offer acceptance rate:** % of offers accepted (target: 80%+)

**Retention Metrics:**
- **Turnover rate:** (Number of departures / Average headcount) × 100
  - Voluntary vs. involuntary
  - By department, role, tenure
- **Retention rate:** (Employees remaining / Starting headcount) × 100
- **90-day retention:** % of new hires still employed after 90 days

**Performance Metrics:**
- **Goal achievement rate:** % of employees meeting goals
- **Performance distribution:** Ratings distribution (avoid "grade inflation")
- **Promotion rate:** Internal mobility and career progression
- **Manager effectiveness:** Team performance and retention

**Engagement Metrics:**
- **Employee Net Promoter Score (eNPS):** "Would you recommend company as place to work?"
- **Engagement survey scores:** Annual or pulse surveys
- **Participation rates:** In programs, training, events

**Compensation Metrics:**
- **Compa-ratio:** Individual salary / Midpoint of salary range (target: 0.8-1.2)
- **Pay equity:** Compensation by gender, race (identify and address gaps)
- **Total compensation:** Salary + benefits + equity value

## Legal Compliance Checklist

**Federal Requirements (US):**
- [ ] I-9 verification for all employees (within 3 days of hire)
- [ ] W-4 and state withholding forms
- [ ] FLSA compliance (exempt vs. non-exempt classification, overtime)
- [ ] Equal Employment Opportunity (no discrimination based on protected classes)
- [ ] ADA reasonable accommodations (disability)
- [ ] FMLA eligibility and leave tracking (if 50+ employees)
- [ ] OSHA workplace safety (if applicable)
- [ ] COBRA notices (health insurance continuation)
- [ ] Workers' compensation insurance
- [ ] Unemployment insurance
- [ ] Required posters displayed (EEOC, FLSA, OSHA, etc.)

**State-Specific (varies by state):**
- [ ] Meal and rest break requirements
- [ ] Sick leave mandates (paid sick leave laws)
- [ ] Salary history ban compliance
- [ ] Pay transparency (salary range in job postings)
- [ ] Final paycheck timing rules
- [ ] State-specific leaves (pregnancy disability, family leave, etc.)

**Record Keeping:**
- Personnel files (confidential, locked)
- I-9 forms (separate file, 3 years after hire or 1 year after termination)
- Medical records (separate, ADA-compliant)
- Payroll records (3-7 years depending on jurisdiction)

## Confidence Signaling

**High Confidence Areas:**
- General HR best practices and processes
- Recruitment and interview techniques
- Onboarding program design
- Performance management frameworks
- Employee handbook structure and common policies
- HR metrics and analytics

**Medium Confidence Areas:**
- Specific legal compliance requirements (varies by jurisdiction)
- Complex compensation structures (equity, commissions)
- Executive hiring and search
- Union/labor relations
- International employment and global HR
- HRIS and HR technology implementation

**Requires Legal/Compliance Expertise:**
- Termination decisions (especially for cause, discrimination claims)
- Harassment or discrimination investigations
- Wage and hour classification (exempt vs. non-exempt)
- FMLA, ADA, and other leave law compliance
- Severance agreements and releases
- Non-compete and restrictive covenant enforcement
- Worker misclassification (employee vs. contractor)
- Union organizing and collective bargaining
- WARN Act (mass layoffs)

**Always consult employment attorney for:**
- Any termination with litigation risk
- Discrimination or harassment complaints
- Wage and hour disputes
- Reasonable accommodation denials
- Policy creation with legal implications
- Investigation of serious misconduct

## Resources

**Government Agencies:**
- EEOC (eeoc.gov) - Discrimination enforcement
- DOL (dol.gov) - Wage/hour, FMLA, OSHA
- IRS (irs.gov) - Payroll tax, worker classification
- State labor departments - State-specific requirements

**HR Organizations:**
- SHRM (Society for Human Resource Management) - Certification, resources, templates
- HR.com - Community and content
- Workable, Greenhouse, Lever - Applicant tracking systems
- BambooHR, Namely, Gusto - HRIS platforms

**Legal Resources:**
- NOLO (nolo.com) - Legal guides and state-specific info
- Fisher Phillips, Littler Mendelson - Employment law firms
- Local employment law attorneys

**Benchmarking Data:**
- Payscale, Glassdoor - Salary data
- LinkedIn Talent Insights - Market data
- SHRM Benchmarking - HR metrics

---

**Final Reminder:** HR involves significant legal risk and compliance obligations. This skill provides frameworks, templates, and best practices, but it is NOT legal advice. Always consult with qualified employment attorneys, especially for terminations, investigations, policy creation, and compliance questions. When in doubt, get professional guidance.
