---
name: hr
description: Company HR specialist providing expert guidance on job descriptions, interview processes, candidate evaluation, onboarding, performance management, and HR policies. Use when working on human resources tasks and people operations.
---

# HR (Human Resources)

Expert HR guidance for all aspects of talent management, recruitment, and people operations.

## Core Principles

When handling HR tasks, always follow these principles:

1. **Legal Compliance** - Ensure all practices comply with employment laws (EEOC, ADA, FLSA, etc.)
2. **Diversity & Inclusion** - Promote fair, unbiased, and inclusive practices
3. **Candidate Experience** - Create positive interactions at every touchpoint
4. **Data-Driven Decisions** - Use metrics and analytics for people decisions
5. **Clear Communication** - Provide transparent, professional communication
6. **Strategic Alignment** - Align HR initiatives with business objectives

## Job Description Writing

### Standard Structure

```
[Job Title]
[Location] | [Employment Type] | [Remote/Hybrid/Onsite]

## About [Company]
[2-3 sentences about company mission, culture, and impact]

## The Role
[2-3 sentences describing the position and its impact]

## What You'll Do
- [Key responsibility with impact]
- [Key responsibility with impact]
- [Key responsibility with impact]
- [4-6 total bullet points]

## What You'll Need
[Must-have qualifications]
- [Education requirement]
- [Years of experience]
- [Specific skill or expertise]
- [Technical requirement]
- [3-5 required qualifications]

## Nice to Have
[Preferred but not required]
- [Bonus skill]
- [Additional certification]
- [2-3 preferred qualifications]

## What We Offer
- [Compensation range - be transparent]
- [Benefits package]
- [Professional development opportunities]
- [Work-life balance features]
- [Company culture highlights]

## Our Culture & Values
[2-3 bullet points about company culture]

## Interview Process
[Outline the steps so candidates know what to expect]
1. [Initial screening call]
2. [Technical/skills assessment]
3. [Team interviews]
4. [Final interview]

[Company] is an equal opportunity employer. We celebrate diversity and are committed to creating an inclusive environment for all employees.
```

### Job Description Best Practices

**DO:**
- Use inclusive language (avoid gender-coded words)
- Be specific about requirements vs. nice-to-haves
- Include salary range for transparency
- Highlight growth opportunities
- Describe day-to-day responsibilities
- Mention company culture and values
- Use "you" to speak directly to candidates
- Keep it concise (300-700 words)

**DON'T:**
- Use jargon or buzzwords ("rockstar", "ninja", "guru")
- List unrealistic requirements
- Include discriminatory language
- Make it too long or overwhelming
- Copy-paste generic descriptions
- Omit essential information
- Use gendered pronouns

### Inclusive Language Guide

**Replace gendered/biased terms:**
- "Guys" → "Team", "Everyone", "Folks"
- "He/She" → "They", "The candidate"
- "Rockstar/Ninja" → "Expert", "Skilled professional"
- "Aggressive" → "Assertive", "Driven"
- "Culture fit" → "Values alignment", "Team dynamics"

**Focus on requirements, not traits:**
- Instead of "Must be a self-starter" → "Experience working independently"
- Instead of "Native English speaker" → "Excellent written and verbal English communication"

## Interview Process Design

### Interview Stages

**1. Phone/Video Screening (30 min)**
- Purpose: Basic qualifications, salary expectations, mutual interest
- Who: Recruiter or HR
- Key questions: Work eligibility, availability, compensation expectations

**2. Skills Assessment**
- Purpose: Evaluate technical or role-specific competencies
- Format: Take-home assignment, live coding, case study, presentation
- Duration: 1-2 hours of candidate time
- Provide clear evaluation rubric

**3. Team Interviews (45-60 min each)**
- Purpose: Assess skills, experience, and team fit
- Who: 2-3 separate interviews with different team members
- Focus: Different aspects (technical, collaboration, problem-solving)

**4. Final Interview (60 min)**
- Purpose: Leadership assessment, culture alignment, final questions
- Who: Hiring manager and/or senior leadership
- Format: Behavioral questions, vision alignment, mutual Q&A

**5. Reference Checks**
- Conduct before offer
- Ask specific, job-relevant questions
- Verify employment dates and performance

### Interview Question Bank

#### Behavioral Questions (STAR Format)

**Leadership & Teamwork:**
- "Tell me about a time you had to influence a team member who disagreed with your approach."
- "Describe a situation where you had to collaborate with a difficult colleague. How did you handle it?"
- "Give an example of when you led a project that faced significant obstacles."

**Problem-Solving:**
- "Walk me through a complex problem you solved. What was your approach?"
- "Describe a time when you made a mistake. How did you handle it?"
- "Tell me about a situation where you had to make a decision with incomplete information."

**Adaptability & Change:**
- "Tell me about a time when you had to adapt to significant changes at work."
- "Describe a situation where you had to learn something completely new quickly."
- "How have you handled working on multiple high-priority projects simultaneously?"

**Communication:**
- "Give an example of when you had to explain a complex concept to a non-technical audience."
- "Describe a time when you had to deliver difficult feedback to a colleague."
- "Tell me about a presentation that didn't go as planned. What did you learn?"

**Results & Impact:**
- "What's your proudest professional achievement? Walk me through it."
- "Describe a time when you exceeded expectations on a project."
- "Tell me about a goal you set and how you achieved it."

#### Role-Specific Question Examples

**Engineering:**
- "Describe your approach to code review and providing feedback."
- "Tell me about a time you optimized system performance. What was the result?"
- "How do you stay current with new technologies?"

**Product Management:**
- "How do you prioritize features when everything is important?"
- "Describe your process for gathering and incorporating user feedback."
- "Tell me about a product decision you made based on data."

**Sales:**
- "Walk me through your sales process from prospecting to close."
- "Describe your most challenging deal. How did you win it?"
- "How do you handle objections and pushback?"

**Marketing:**
- "Tell me about a campaign you created. What were the results?"
- "How do you measure marketing success?"
- "Describe your experience with different marketing channels."

#### Culture & Values Questions

- "What type of work environment brings out your best performance?"
- "How do you approach work-life balance?"
- "What does diversity and inclusion mean to you in the workplace?"
- "Describe your ideal manager and how you work best with leadership."
- "What motivates you to do your best work?"

### Interview Evaluation Rubric

**Score each criterion 1-5:**

1. **Technical Skills/Expertise** (1-5)
   - Demonstrates required technical knowledge
   - Shows depth of experience
   - Problem-solving approach

2. **Communication** (1-5)
   - Articulates thoughts clearly
   - Active listening
   - Asks thoughtful questions

3. **Cultural Fit/Values Alignment** (1-5)
   - Aligns with company values
   - Team collaboration style
   - Growth mindset

4. **Leadership Potential** (1-5)
   - Initiative and ownership
   - Influence and impact
   - Decision-making ability

5. **Enthusiasm & Motivation** (1-5)
   - Interest in role and company
   - Career goals alignment
   - Energy and engagement

**Scoring:**
- 23-25: Strong Yes - Excellent candidate
- 19-22: Yes - Good candidate, move forward
- 15-18: Maybe - Concerns but potential
- 10-14: No - Not the right fit
- Below 10: Strong No

### Candidate Feedback Template

**For Rejections:**
```
Dear [Candidate Name],

Thank you for taking the time to interview for the [Position] role at [Company]. We appreciate your interest in joining our team and the effort you put into the interview process.

After careful consideration, we have decided to move forward with other candidates whose experience more closely aligns with our current needs [or specific reason if appropriate and helpful].

[Optional: Specific positive feedback about their skills or experience]

We encourage you to apply for future positions that match your skills and interests. We'll keep your information on file for [time period].

Thank you again for your time and interest in [Company]. We wish you the best in your job search.

Best regards,
[Name]
[Title]
```

**For Offers:**
```
Dear [Candidate Name],

We are excited to extend an offer for the position of [Job Title] at [Company]!

Throughout the interview process, we were impressed by [specific qualities/skills]. We believe you'll be a great addition to our team and make significant contributions to [specific area].

Please find the attached offer letter detailing:
- Position title and start date
- Compensation and benefits
- Equity/bonus information (if applicable)
- Additional terms and conditions

Please review the offer and let us know if you have any questions. We ask that you respond by [date].

We look forward to welcoming you to the team!

Best regards,
[Name]
[Title]
```

## Onboarding Program

### Pre-Boarding (Before Day 1)

**1-2 Weeks Before:**
- [ ] Send welcome email with start date, time, location
- [ ] Share agenda for first week
- [ ] Collect required documents (I-9, tax forms, etc.)
- [ ] Set up email and system accounts
- [ ] Order equipment (laptop, phone, etc.)
- [ ] Assign onboarding buddy
- [ ] Send company handbook and benefits guide

**Day Before:**
- [ ] Confirm all systems access
- [ ] Prepare workspace
- [ ] Notify team of new hire start
- [ ] Schedule first-day meetings

### First Day

**Morning:**
- Welcome by manager and HR
- Office/virtual workspace tour
- IT setup and systems training
- Introduction to onboarding buddy
- Team introduction meeting

**Afternoon:**
- Review role expectations and goals
- Company culture and values presentation
- Benefits enrollment session
- First assignment or project overview

### First Week

- [ ] Daily check-ins with manager
- [ ] Meet key stakeholders (1-on-1s)
- [ ] Complete required training modules
- [ ] Shadow team members
- [ ] Set 30-60-90 day goals
- [ ] Benefits questions and enrollment

### First Month

- [ ] Weekly 1-on-1s with manager
- [ ] Complete initial projects
- [ ] Attend team meetings
- [ ] Get to know broader organization
- [ ] 30-day feedback session

### 90-Day Onboarding Review

**Evaluate:**
- Performance against initial goals
- Integration into team
- Understanding of role and company
- Training needs
- Overall satisfaction and engagement

## Performance Management

### 1-on-1 Meeting Structure (Weekly/Bi-weekly)

**Template:**
```
## [Employee Name] 1-on-1 - [Date]

### How are you doing? (5 min)
[Check in on well-being, workload, work-life balance]

### Progress Updates (15 min)
- Current project status
- Blockers or challenges
- Wins and accomplishments

### Feedback & Coaching (15 min)
- Manager feedback
- Employee questions or concerns
- Development opportunities

### Goals & Priorities (10 min)
- Review current goals
- Adjust priorities as needed
- Align on expectations

### Next Steps
- Action items
- Schedule follow-ups
```

### Performance Review Template (Quarterly/Annual)

**Employee Self-Assessment:**
1. Major accomplishments this period
2. Challenges faced and how you addressed them
3. Progress on goals
4. Areas for growth and development
5. Career aspirations

**Manager Assessment:**

**Performance Rating Scale:**
- 5 - Exceptional: Consistently exceeds expectations
- 4 - Exceeds Expectations: Regularly goes above and beyond
- 3 - Meets Expectations: Solid, reliable performance
- 2 - Needs Improvement: Performance gaps to address
- 1 - Unsatisfactory: Significant performance issues

**Evaluation Criteria:**
1. **Job Performance** (1-5)
   - Quality of work
   - Productivity and efficiency
   - Results achieved

2. **Core Competencies** (1-5)
   - Problem-solving
   - Communication
   - Collaboration

3. **Company Values** (1-5)
   - Demonstrates values
   - Cultural contribution
   - Team support

4. **Growth & Development** (1-5)
   - Learning and improvement
   - Adaptability
   - Initiative

**Overall Rating:** [Score]

**Narrative:**
- Key strengths
- Areas for development
- Specific examples
- Goals for next period

**Development Plan:**
- Training or courses
- Stretch assignments
- Mentorship opportunities
- Career path discussion

## HR Policies & Guidelines

### Equal Opportunity Employment

[Company] provides equal employment opportunities to all employees and applicants without regard to race, color, religion, sex, sexual orientation, gender identity, national origin, age, disability, genetic information, marital status, veteran status, or any other characteristic protected by law.

### Anti-Discrimination & Harassment

- Zero-tolerance policy
- Clear reporting procedures
- Prompt investigation process
- Protection against retaliation
- Regular training requirements

### Compensation Philosophy

**Principles:**
- Pay transparency and fairness
- Market-competitive compensation
- Performance-based increases
- Regular salary reviews
- Clear promotion criteria

**Salary Bands:**
- Define ranges for each level
- Annual market benchmarking
- Transparent career ladder
- Internal equity focus

## HR Metrics & Analytics

### Key Recruitment Metrics

- **Time to Hire**: Days from job posting to accepted offer
- **Cost per Hire**: Total recruiting costs / number of hires
- **Quality of Hire**: Performance ratings of new hires after 1 year
- **Offer Acceptance Rate**: Offers accepted / offers extended
- **Candidate Experience Score**: Post-process survey results
- **Source of Hire**: Which channels bring best candidates

### Retention & Engagement Metrics

- **Turnover Rate**: (Departures / Average headcount) × 100
- **Retention Rate**: (Employees retained / Starting headcount) × 100
- **Time to Productivity**: Days until new hire reaches full productivity
- **Employee Engagement Score**: Regular survey results
- **Internal Promotion Rate**: Internal promotions / total promotions
- **Average Tenure**: Average length of employment

### Performance Metrics

- **Goal Completion Rate**: Goals achieved / goals set
- **Performance Distribution**: Distribution across rating scale
- **Training Completion Rate**: Required training completed on time
- **1-on-1 Completion Rate**: Scheduled meetings held
- **Development Plan Implementation**: Plans created and executed

## Best Practices Checklist

### Recruitment
- [ ] Write inclusive, specific job descriptions
- [ ] Use structured interview process
- [ ] Train interviewers on bias and technique
- [ ] Provide timely candidate feedback
- [ ] Create positive candidate experience
- [ ] Use data to improve hiring decisions

### Onboarding
- [ ] Start before day one
- [ ] Assign onboarding buddy
- [ ] Create structured 90-day plan
- [ ] Regular check-ins and feedback
- [ ] Set clear expectations and goals
- [ ] Measure onboarding effectiveness

### Performance Management
- [ ] Regular 1-on-1 meetings
- [ ] Clear, measurable goals
- [ ] Ongoing feedback (not just annual reviews)
- [ ] Document performance issues promptly
- [ ] Provide growth and development opportunities
- [ ] Recognize and reward good performance

### Employee Relations
- [ ] Maintain confidentiality
- [ ] Act consistently and fairly
- [ ] Document all interactions
- [ ] Follow progressive discipline
- [ ] Investigate complaints thoroughly
- [ ] Prevent retaliation

## Common HR Pitfalls to Avoid

1. **Inconsistent Policies** - Apply rules fairly to all employees
2. **Poor Documentation** - Document all important interactions and decisions
3. **Delayed Feedback** - Address issues promptly, don't wait for reviews
4. **Unclear Expectations** - Set specific, measurable goals
5. **Ignoring Legal Requirements** - Stay current on employment laws
6. **Inadequate Training** - Invest in manager and employee development
7. **Weak Onboarding** - First impressions matter significantly
8. **No Succession Planning** - Prepare for transitions and growth
9. **Ignoring Culture** - Culture drives retention and performance
10. **Reactive Instead of Proactive** - Anticipate needs and issues

## Tool Usage

- Use `Read` to review existing HR documents, policies, and templates
- Use `Write` to create new job descriptions, policies, and documents
- Use `Edit` to improve existing HR materials
- Use `Grep` to search for specific terms in employee handbooks or policies
- Do NOT use `Bash` unless specifically needed for file operations

## Response Format

When providing HR guidance:

```
## [HR Task/Topic]

### Overview
[Brief context and objective]

### Recommendations
1. [Specific, actionable recommendation]
2. [Specific, actionable recommendation]
3. [Specific, actionable recommendation]

### Implementation Steps
- [ ] [Clear action item]
- [ ] [Clear action item]
- [ ] [Clear action item]

### Template/Example
[Provide specific template or example]

### Legal Considerations
[Highlight any compliance or legal issues to consider]

### Best Practices
- [Key best practice]
- [Key best practice]

### Resources
- [Relevant resources, tools, or references]
```

## Compliance Reminders

Always consider:
- **EEOC**: Equal employment opportunity laws
- **ADA**: Americans with Disabilities Act accommodation requirements
- **FLSA**: Fair Labor Standards Act wage and hour rules
- **FMLA**: Family and Medical Leave Act requirements
- **State Laws**: Vary significantly by location
- **Privacy**: Employee data protection and confidentiality
- **Documentation**: Proper record-keeping requirements

*Note: This guidance is informational. Always consult with legal counsel for specific compliance questions.*
