---
name: hr-talent
description: HR and talent management expertise for talent acquisition, performance management, compensation strategy, organizational design, culture building, succession planning, and D&I programs. Use when hiring, managing performance, designing organizations, or building culture.
---

# HR & Talent Expert

Comprehensive HR frameworks for talent acquisition, performance management, and organizational development.

## Talent Acquisition

### Strategic Workforce Planning

```
WORKFORCE PLANNING PROCESS:

1. DEMAND ANALYSIS
   - Business strategy alignment
   - Headcount projections (growth, attrition, productivity)
   - Skills gap analysis
   - Scenario modeling

2. SUPPLY ANALYSIS
   - Current workforce inventory
   - Skills assessment
   - Retirement projections
   - Internal mobility potential

3. GAP ANALYSIS
   - Quantity gaps (headcount)
   - Quality gaps (skills, capabilities)
   - Location gaps (geographic)
   - Timeline gaps (when needed)

4. ACTION PLANNING
   - Build (develop internally)
   - Buy (external hiring)
   - Borrow (contingent, partnerships)
   - Bot (automation)
```

### Recruiting Metrics

| Metric                    | Formula                                        | Benchmark     |
| ------------------------- | ---------------------------------------------- | ------------- |
| **Time to Fill**          | Days from req open to offer accept             | 30-45 days    |
| **Time to Hire**          | Days from first contact to start               | 25-35 days    |
| **Cost per Hire**         | Total recruiting costs / Hires                 | $3,000-$5,000 |
| **Quality of Hire**       | Performance + Retention + Time to Productivity | 80%+          |
| **Offer Acceptance Rate** | Offers accepted / Offers made                  | 85%+          |
| **Source Effectiveness**  | Hires by source / Applications by source       | Varies        |
| **Diversity Hiring**      | Diverse hires / Total hires                    | Target-based  |

### Interview Framework

```
STRUCTURED INTERVIEW DESIGN:

COMPETENCY-BASED:
- Define success profile
- Identify critical competencies
- Develop behavioral questions (STAR)
- Create scoring rubric

INTERVIEW SCORECARD:
| Competency | Weight | 1-5 Rating | Notes |
|------------|--------|------------|-------|
| Technical skills | 30% | | |
| Problem solving | 20% | | |
| Leadership | 20% | | |
| Culture fit | 15% | | |
| Communication | 15% | | |

STAR METHOD:
S - Situation: Context and background
T - Task: Responsibility and objective
A - Action: Steps taken personally
R - Result: Outcomes and learnings
```

## Performance Management

### Performance Framework

```
ANNUAL CYCLE:

Q1: Goal Setting
- Cascade from corporate objectives
- SMART goal creation
- Development goal inclusion
- Manager-employee alignment

Q2: Mid-Year Check-in
- Progress review
- Goal adjustment
- Feedback exchange
- Development discussion

Q3: Continuous Feedback
- Ongoing conversations
- Real-time recognition
- Course correction
- Skill development

Q4: Annual Review
- Performance assessment
- Calibration sessions
- Compensation decisions
- Development planning
```

### Goal Setting (OKR Framework)

```
OBJECTIVE: Qualitative description of what you want to achieve
- Inspirational
- Time-bound
- Action-oriented

KEY RESULTS: Quantitative measures of success
- Specific and measurable
- Aggressive but achievable
- Outcome-based (not task-based)

EXAMPLE:
Objective: Build a world-class engineering team
KR1: Increase eng hiring from 10 to 25/quarter
KR2: Improve offer acceptance rate from 70% to 85%
KR3: Reduce new hire 6-month attrition from 15% to 5%
KR4: Achieve 4.5/5.0 team engagement score
```

### Performance Calibration

| Rating                | Distribution | Definition                               |
| --------------------- | ------------ | ---------------------------------------- |
| **Exceptional**       | 5-10%        | Consistently exceeds, role model         |
| **Exceeds**           | 20-25%       | Above expectations, strong performer     |
| **Meets**             | 55-65%       | Achieves expectations, solid contributor |
| **Needs Improvement** | 10-15%       | Below expectations, support needed       |
| **Unsatisfactory**    | 0-5%         | Significantly below, action required     |

## Compensation Strategy

### Total Rewards Philosophy

```
COMPENSATION ELEMENTS:

BASE SALARY
- Market positioning (P25, P50, P75)
- Pay grades and ranges
- Geographic differentials
- Compression management

SHORT-TERM INCENTIVE
- Annual bonus
- Performance metrics (corporate, business, individual)
- Target and maximum payouts
- Threshold requirements

LONG-TERM INCENTIVE
- Stock options
- Restricted stock units (RSUs)
- Performance shares
- Vesting schedules

BENEFITS
- Health and welfare
- Retirement (401k match, pension)
- Time off
- Perquisites
```

### Market Positioning Strategy

| Percentile  | Philosophy  | When to Use                     |
| ----------- | ----------- | ------------------------------- |
| **P75+**    | Lead        | Critical skills, war for talent |
| **P50-P75** | Competitive | Key roles, retention focus      |
| **P50**     | Market      | Standard positions              |
| **P25-P50** | Lag         | Offset by other rewards         |

### Pay Equity Analysis

```
ANALYSIS FRAMEWORK:

1. STATISTICAL ANALYSIS
   - Regression analysis controlling for:
     - Job level/grade
     - Performance rating
     - Tenure
     - Geography
     - Education/credentials

2. COHORT ANALYSIS
   - Same job, same location
   - Compa-ratio comparisons
   - Progression analysis

3. ROOT CAUSE INVESTIGATION
   - Starting salary disparities
   - Promotion rate differences
   - Merit increase patterns
   - Hire mix analysis

4. REMEDIATION
   - Adjustment budgets
   - Process improvements
   - Policy changes
   - Monitoring systems
```

## Organizational Design

### Organization Structure Models

| Structure      | Best For                     | Advantages                     | Disadvantages            |
| -------------- | ---------------------------- | ------------------------------ | ------------------------ |
| **Functional** | Stable, efficiency-focused   | Expertise, efficiency          | Silos, slow decisions    |
| **Divisional** | Diverse products/markets     | Accountability, responsiveness | Duplication, competition |
| **Matrix**     | Complex, multiple priorities | Flexibility, resource sharing  | Conflict, complexity     |
| **Flat**       | Innovation, speed            | Agility, empowerment           | Scale limitations        |
| **Network**    | Partnerships, outsourcing    | Flexibility, cost              | Control, coordination    |

### Span of Control Guidelines

| Level          | Typical Span          | Factors                        |
| -------------- | --------------------- | ------------------------------ |
| **Executive**  | 5-8 direct reports    | Complexity, strategy time      |
| **Director**   | 6-10 direct reports   | Team maturity, role complexity |
| **Manager**    | 8-15 direct reports   | Task similarity, systems       |
| **Supervisor** | 15-25+ direct reports | Routine work, clear processes  |

### Role Design (RACI Matrix)

```
R - Responsible: Does the work
A - Accountable: Final decision authority
C - Consulted: Provides input
I - Informed: Kept updated

| Activity | Role A | Role B | Role C | Role D |
|----------|--------|--------|--------|--------|
| Task 1 | A | R | C | I |
| Task 2 | A/R | C | | I |
| Task 3 | A | R | R | C |
```

## Culture & Engagement

### Culture Framework

```
CULTURE ELEMENTS:

VALUES: Core beliefs guiding behavior
- What we stand for
- How we make decisions
- What we reward and recognize

NORMS: Unwritten rules of behavior
- How we communicate
- How we collaborate
- How we handle conflict

SYMBOLS: Visible representations
- Physical space design
- Dress code
- Rituals and ceremonies

PRACTICES: How work gets done
- Meeting culture
- Decision-making processes
- Recognition programs
```

### Employee Engagement Survey

| Category        | Sample Questions                     | Target |
| --------------- | ------------------------------------ | ------ |
| **Engagement**  | "I would recommend this company"     | 80%+   |
| **Purpose**     | "My work makes a difference"         | 85%+   |
| **Development** | "I have growth opportunities"        | 70%+   |
| **Manager**     | "My manager supports me"             | 80%+   |
| **Recognition** | "I feel valued for my contributions" | 75%+   |
| **Wellbeing**   | "I can maintain work-life balance"   | 70%+   |

### eNPS (Employee Net Promoter Score)

```
CALCULATION:
eNPS = % Promoters (9-10) - % Detractors (0-6)

SCORING:
70+ Excellent
50-69 Great
30-49 Good
10-29 Average
<10 Needs Work

ACTION PLANNING:
- Segment by team, location, tenure
- Identify drivers through comments
- Create targeted improvement plans
- Close the loop with employees
```

## Succession Planning

### Succession Framework

```
9-BOX ASSESSMENT:

                    PERFORMANCE
                    Low     Medium    High
POTENTIAL   High    Enigma  Rising    High
                            Star      Potential
            Medium  Under   Core      High
                    Performer Performer Performer
            Low     Poor    Effective Solid
                    Fit     Performer Performer
```

### Succession Planning Process

```
1. IDENTIFY CRITICAL ROLES
   - Business impact
   - Difficulty to fill
   - Single points of failure
   - Strategic importance

2. ASSESS TALENT
   - Current performance
   - Future potential
   - Readiness timeline
   - Risk of departure

3. DEVELOP SUCCESSORS
   - Individual development plans
   - Stretch assignments
   - Mentoring/coaching
   - Formal training

4. REVIEW AND UPDATE
   - Annual talent reviews
   - Emergency succession
   - Pipeline health metrics
```

### Readiness Assessment

| Timeline            | Characteristics            | Development Focus        |
| ------------------- | -------------------------- | ------------------------ |
| **Ready Now**       | Can perform immediately    | Retention, engagement    |
| **Ready 1-2 Years** | Needs minor development    | Targeted experiences     |
| **Ready 3-5 Years** | High potential, gaps exist | Accelerated development  |
| **Long-term**       | Early career potential     | Foundational development |

## Diversity, Equity & Inclusion

### DEI Strategy Framework

```
DIMENSIONS OF DIVERSITY:
- Identity: Race, gender, age, disability, LGBTQ+
- Experience: Background, education, industry
- Cognitive: Thinking styles, perspectives

EQUITY FOCUS AREAS:
- Hiring practices
- Promotion rates
- Compensation parity
- Access to opportunities
- Voice and representation

INCLUSION INDICATORS:
- Belonging scores
- Retention by demographic
- Participation rates
- Psychological safety
```

### DEI Metrics Dashboard

| Metric             | Measurement                                  | Cadence     |
| ------------------ | -------------------------------------------- | ----------- |
| **Representation** | % by demographic across levels               | Quarterly   |
| **Hiring**         | Application, interview, offer by demographic | Monthly     |
| **Promotion**      | Promotion rate by demographic                | Annual      |
| **Retention**      | Turnover by demographic                      | Quarterly   |
| **Pay Equity**     | Adjusted pay gaps                            | Annual      |
| **Inclusion**      | Survey scores by demographic                 | Semi-annual |

### Inclusive Hiring Practices

```
BIAS REDUCTION:
- [ ] Diverse interview panels
- [ ] Structured interviews
- [ ] Skills-based assessments
- [ ] Blind resume review
- [ ] Diverse candidate slates
- [ ] Inclusive job descriptions
- [ ] Equitable sourcing
- [ ] Interview training
```

## HR Analytics

### Key HR Metrics

| Category         | Metric               | Formula                                |
| ---------------- | -------------------- | -------------------------------------- |
| **Turnover**     | Voluntary Turnover   | Voluntary terms / Avg headcount        |
|                  | Regrettable Turnover | High performer terms / High performers |
|                  | First Year Turnover  | <1 yr terms / New hires                |
| **Retention**    | Retention Rate       | (Start HC - Terms) / Start HC          |
| **Engagement**   | eNPS                 | Promoters% - Detractors%               |
| **Development**  | Internal Fill Rate   | Internal hires / Total hires           |
| **Productivity** | Revenue per Employee | Revenue / FTE                          |
| **Cost**         | HR Cost per Employee | Total HR cost / FTE                    |

## See Also

- [Fortune 50 Leadership](../fortune50-leadership/SKILL.md)
- [Fortune 50 Operations](../fortune50-operations/SKILL.md)
- [Fortune 50 Business Strategy](../fortune50-business-strategy/SKILL.md)
