# Humanize Reference Tables

Quick-reference tables for AI pattern detection and replacement strategies.

---

## AI Pattern Detection Table

| Pattern Type | Examples | Why It Sounds AI |
|--------------|----------|------------------|
| **"By [gerund]" overuse** | "By implementing...", "By constructing...", "By training..." | Creates monotonous explanatory rhythm. SCAN FOR THIS FIRST. |
| **"That [noun]" connectors** | "That shift defines...", "That vulnerability underscores..." | Formulaic sentence linking; too smooth |
| **Indirect speech** | "The field is shifting...", "Research suggests...", "The implication is clear:" | Impersonal, avoids human actors |
| **Subordinate smoothness** | "while improving X", "thereby reducing Y" | Too-smooth clause connections |
| Formulaic transitions | "Furthermore,", "Additionally,", "Moreover," | Too consistent, textbook-like |
| "This [verb] that" | "This suggests that...", "This demonstrates that..." | Most common AI fingerprint |
| **Em-dashes** | "The result—faster inference—was surprising" | Humans rarely use em-dashes; AI overuses them |
| **Fragment + colon** | "The result:", "The implication is clear:", "What's needed:" | Headline fragments instead of sentences |
| **Too-orderly S-V-O** | Every sentence: clear Subject-Verb-Object | Robotic, lacks structural variety |
| Noun-heavy subjects | "The deployment of...", "The integration of..." | Passive, distancing |
| Passive constructions | "has been shown to", "is being developed" | Avoids direct statements |
| Balanced sentences | Every paragraph: claim → evidence → implication | Mechanical rhythm |
| Framework redundancy | "The BioDisco framework" after already introduced | Redundant after established |
| Opening formulas | "In the realm of...", "A systematic evaluation..." | Pompous, detached |
| Result phrasing | "achieves X% improvement on Y benchmark" | Always same structure |
| **Low vocabulary diversity** | Same connectors repeated multiple times | Measurably lower lexical diversity |
| **Uniform sentence length** | All sentences 12-18 words | Lacks human "burstiness" |
| **Lacks rhetorical flourishes** | No surprise, no emotion, no asides | Too "flat" and impersonal |
| **Framework intro pattern** | "The [X] framework mitigates/addresses..." | Robotic naming + verb combo |
| **Semicolon parallel lists** | "X does A; Y does B; Z does C" | Too structured, mechanical |
| **"rather than" contrast** | "treats X as Y rather than Z" | Overly formal contrast |
| **Lacks creative grammar** | "mitigates the problem", "addresses this directly" | Correct but unvaried phrasing |
| **Formulaic headings** | Clean, structured section headings | Too organized, "logical progression" |
| **"For X, Y does Z" opener** | "For real-time applications, AirGS optimizes..." | Overly formal prepositional opener |
| **Colon definition splits** | "X decouples A from B: it maintains..." | Colon-based explanatory structure |
| **"while maintaining [noun]"** | "while maintaining high reconstruction quality" | Smooth subordinate clause |
| **Too-simple declaratives** | "The drive for efficiency extends to X." | Short + direct = robotic formality |

---

## Transition Replacements

| AI Pattern | Human Alternatives |
|------------|-------------------|
| "However, ..." (overused) | Keep some! Vary with "That said,", "The catch is that", "The trade-off is" |
| "Furthermore, ..." | "Also,", "And", "Plus,", or just start new sentence |
| "Additionally, ..." | "On top of that,", remove and restructure |
| "This suggests that..." | "which suggests", "...suggesting that", or question form |
| "This demonstrates..." | "showing", "...which demonstrates", or just state the conclusion |
| "By [gerund]..." | "Through X,", "Using Y,", "When [verb]", lead with outcome, active voice |
| "In the realm of..." | "For...", "In...", or just name the domain directly |
| "Simultaneously, ..." | "Meanwhile,", "At the same time,", "In parallel," |
| "The [X] framework..." (repeat) | Just "X" after first introduction |
| "achieves X% on Y" | "a X% jump on Y", "X% better than", move metric position |

### New Patterns (High Priority)

| AI Pattern | Human Alternatives |
|------------|-------------------|
| **"That [noun] [verb]..."** ("That shift defines...") | Merge into previous sentence, or "This shift..." with specificity, or restructure entirely |
| **"The field is shifting..."** | "Researchers are shifting..." (add human actors), or name specific researchers |
| **"Research suggests..."** | "Three recent papers suggest...", "Smith et al. found...", or just state the finding |
| **"The implication is clear:"** | "What does this mean? It means...", or just state the implication directly |
| **"...while [gerund]..."** | Break into two sentences, or use "and also", or restructure clause order |
| **"...thereby [gerund]..."** | "This means...", "The result:", or break into cause-effect sentences |
| **"underscores the need for..."** | "highlights...", "points to...", "shows we need..." |
| **"The [X] framework mitigates..."** | "With X, teams can reduce...", "X—a new framework—helps cut down on...", or lead with the problem: "The problem? Y. X fixes it by..." |
| **"X rather than Y"** | "X instead of Y", "X, not Y", or break into two sentences |
| **"X; Y; Z" (semicolon lists)** | Vary punctuation: "X. Meanwhile, Y. And Z..." or use bullets |
| **"addresses this directly"** | "fixes this", "handles it", "deals with the issue" |
| **"For X, Y does Z"** | "When it comes to X, Y does Z", "In X scenarios, Y does Z", "Y does Z for X", or drop the opener entirely |
| **"X decouples A from B: it..."** | "X separates A and B. It...", "X keeps A and B apart—so it can...", break into two sentences |
| **"while maintaining [noun]"** | "without losing [noun]", "and still keeps [noun]", "but [noun] stays intact" |
| **"offers a radical alternative"** | "takes a different path", "goes another way", "breaks from the usual approach" |
| **Short robotic declarative** | Add personality: "The focus? Rigorous state management." or combine with adjacent sentence |

---

## Connector Replacements

Each connector should appear **maximum 2 times per 1000 words**.

| Overused | Alternatives (rotate through these) |
|----------|-------------------------------------|
| Furthermore | Also; And; Plus; [just start new sentence] |
| Additionally | On top of that; Beyond this; [restructure] |
| Moreover | What's more; And; [merge sentences] |
| However | But; That said; Yet; Still; [use "though" mid-sentence] |
| Therefore | So; This means; As a result; [restructure causally] |

---

## Vocabulary Alternatives

Replace 3-5 "AI-typical" words per paragraph with rarer synonyms **that preserve meaning exactly**.

| AI Word (Predictable) | Alternatives (Less Predictable) |
|-----------------------|--------------------------------|
| utilize | use, employ, harness, tap into |
| ensure | guarantee, lock in, make certain |
| implement | deploy, roll out, put in place |
| significant | substantial, marked, notable |
| facilitate | enable, allow, make possible |
| demonstrate | show, reveal, illustrate |
| leverage | use, build on, take advantage of |
| optimal | best, ideal, most effective |

### High-Risk AI Vocabulary (AVOID)

These words are flagged by AI detectors with high frequency. Do not use them.

| Avoid | Use Instead |
|-------|-------------|
| **mitigates** | reduces, fixes, helps with, cuts down on, lessens |
| **addresses** | fixes, handles, deals with, tackles, works on |
| **introduces** | adds, brings, creates, starts, opens up |
| **pivotal** | key, important, central, turning point |
| **broader** | wider, larger, more general, bigger picture |
| **crucial/critical** | key, important, central, major |
| **comprehensive** | complete, full, thorough |
| **underscores** | highlights, shows, points to |
| **nuanced** | subtle, fine-grained, detailed |
| **robust** | strong, solid, reliable |
| **seamlessly** | smoothly, easily, without friction |
| **enhances** | improves, boosts, helps, makes better |
| **facilitates** | helps, enables, makes easier, allows |

### High-Risk Phrase Combinations (CRITICAL)

These exact phrases have measured AI probability multipliers. Avoid them.

| Phrase (AI Multiplier) | Use Instead |
|------------------------|-------------|
| **"framework provides"** (7x) | "framework offers", "framework gives", "with X, you get", "X lets you" |
| **"maintaining high"** (6.4x) | "keeping", "holding onto", "preserving", "without losing" |
| **"eliminating the need"** (5.4x) | "removing the need", "cutting out", "so you don't need", "no more need for" |
| **"offers a radical alternative"** | "takes a different path", "tries something new", "breaks from tradition" |
| **"provides a framework"** | "gives you a way to", "offers tools for", "sets up" |
| **"while maintaining"** | "without losing", "and still keeps", "but keeps" |

---

## Verb Repetition Alternatives

If any verb appears 3+ times within 500 words, replace some instances:

| Verb | Alternatives |
|------|--------------|
| shows | reveals, demonstrates, indicates, illustrates, surfaces |
| uses | employs, relies on, leverages, taps into, harnesses |
| improves | enhances, boosts, strengthens, elevates, refines |
| provides | offers, delivers, supplies, gives, furnishes |

---

## Domain-Specific Calibration

| Domain | Edit Count | Focus Areas | Don't Do |
|--------|-----------|------------|----------|
| Academic/Research | 8-12 edits | "By [gerund]" → "When/Through", transition variety, sentence rhythm | Add asides or colloquialisms; use contractions |
| Technical docs | 6-10 edits | Remove "By [gerund]", fix passive voice, clarify with active verbs | Use conversational tone; lose precision |
| Blog posts | 15-20 edits | All patterns, add personality, conversational asides | Sacrifice clarity for style |
| Newsletters | 12-18 edits | Pattern removal plus selective personality additions | Sound unprofessional or lose authority |

---

## Burstiness Targets

Target distribution for every 10 sentences:
- 2-3 sentences: very short (2-6 words)
- 2-3 sentences: very long (25-40 words)
- 4-5 sentences: medium (10-20 words)

---

## Punctuation Targets (per 1000 words)

| Punctuation | Target |
|-------------|--------|
| Question marks | 2-4 (AI underuses) |
| Semicolons | 1-3 |
| Parentheses | 2-4 |
| Em-dashes | ≤ original (reduce, never add) |
