---
name: hunting-jobs
description: Use this skill when helping with job search activities including resume writing/tailoring, cover letters, LinkedIn optimization, interview preparation, salary negotiation, networking outreach, and application tracking. Triggers on phrases like "apply for job", "tailor my resume", "write cover letter", "prepare for interview", "negotiate salary", "optimize LinkedIn", or "job search". (project)
---

# Job Hunting Skill - Complete Career Search Assistant

Help users through every stage of the modern job search process using 2025 best practices, ATS optimization strategies, and AI-enhanced techniques.

## Quick Reference

| Stage | Key File |
|-------|----------|
| Resume & ATS | `./resume-ats-optimization.md` |
| Cover Letters | `./cover-letter-strategies.md` |
| LinkedIn & Networking | `./linkedin-networking.md` |
| Interview Prep | `./interview-preparation.md` |
| Salary Negotiation | `./salary-negotiation.md` |
| Application Tracking | `./application-tracking.md` |

## Workflow Overview

### 1. Profile Assessment
When starting with a new user:
- Ask for their current resume (or help create one)
- Understand target roles, industries, and locations
- Assess experience level and career goals
- Identify transferable skills

### 2. Resume Creation/Optimization
See `./resume-ats-optimization.md` for detailed guidance.

**Key Principles:**
- Use reverse-chronological format (preferred by 99% of recruiters)
- Save as .docx (not PDF) unless specifically requested
- Quantify achievements with metrics
- Mirror keywords from job descriptions (aim for 2-3 uses per key term)
- Keep important info OUT of headers/footers (25% parsing failure rate)
- Target 75%+ ATS match score

### 3. Cover Letter Writing
See `./cover-letter-strategies.md` for detailed guidance.

**Key Principles:**
- 150-250 words maximum (half page)
- Problem-solution focus, not career narrative
- Address hiring manager by name when possible
- Include quantified achievements
- Match keywords from job posting

### 4. LinkedIn Optimization
See `./linkedin-networking.md` for detailed guidance.

**Key Principles:**
- Optimize headline (220 chars) with target keywords
- Complete 100% of profile sections
- Turn on "Open to Work" with multiple job titles
- Engage weekly (comments, posts, reactions)
- Join and participate in industry groups

### 5. Interview Preparation
See `./interview-preparation.md` for detailed guidance.

**Key Principles:**
- Use STAR method (Situation, Task, Action, Result)
- Prepare 3-5 flexible stories covering common scenarios
- Action portion should be longest in responses
- Research company, role, and interviewers
- Prepare thoughtful questions to ask

### 6. Salary Negotiation
See `./salary-negotiation.md` for detailed guidance.

**Key Principles:**
- Never share salary expectations first
- Ask for 24-48 hours to consider offers
- Use anchoring (ask higher than target)
- Negotiate total compensation, not just base
- 66% of those who negotiate succeed

### 7. Application Tracking
See `./application-tracking.md` for detailed guidance.

**Recommended Tools:**
- Teal, Huntr, Simplify, Careerflow
- Track: company, role, date applied, status, contacts, follow-ups

## Task-Specific Instructions

### When User Asks to Tailor a Resume

1. Request the job description (URL or pasted text)
2. Request their current resume
3. Extract key requirements and keywords from the job posting
4. Map user's experience to job requirements
5. Rewrite bullet points with:
   - Keywords from job description
   - Quantified achievements
   - Strong action verbs (Developed, Implemented, Led, Optimized)
6. Ensure ATS-friendly formatting
7. Provide a match analysis

### When User Asks for a Cover Letter

1. Request the job description
2. Request their resume or key achievements
3. Identify 2-3 key problems the employer wants solved
4. Select 2-3 relevant achievements with metrics
5. Write using format in `./cover-letter-strategies.md`
6. Keep under 250 words
7. Include call to action

### When User Asks for Interview Prep

1. Request the job description and company name
2. Research the company (use WebSearch if needed)
3. Generate likely behavioral questions based on role
4. Help craft STAR-format responses
5. Prepare questions for the user to ask
6. Offer mock interview practice

### When User Asks About Salary Negotiation

1. Research market rates (use WebSearch for current data)
2. Help determine their walk-away number
3. Calculate total compensation value
4. Draft negotiation scripts
5. Plan for various scenarios (low offer, no room, etc.)

## Critical Statistics to Reference

- 90% of Fortune 500 use ATS systems
- 75% of resumes rejected by ATS before human review
- 83% of hiring managers read cover letters
- 66% who negotiate salary succeed
- Average 18.83% salary increase for those who negotiate
- Profiles without photos get 21x fewer LinkedIn views
- 7 people hired on LinkedIn every minute

## Response Format

Always provide:
1. Clear, actionable deliverables
2. Explanations of why (builds trust)
3. Next steps in the process
4. Offer to continue with related tasks

## AI Tool Recommendations

When appropriate, suggest these tools to users:
- **Resume:** Rezi, Jobscan, Teal
- **Cover Letters:** Kickresume, Rezi
- **LinkedIn:** Careerflow, Jobright
- **Interview:** Final Round AI
- **Tracking:** Huntr, Teal, Simplify
- **Auto-Apply:** Use cautiously - personalization matters
