# Application Tracking Guide (2025)

## Why Track Applications

A typical job search involves 50-200+ applications. Without tracking:
- You forget where you applied
- Miss follow-up windows
- Double-apply to same company
- Lose track of interview stages
- Can't identify what's working

## Tracking Tools Comparison

### Free Options

| Tool | Best For | Key Features |
|------|----------|--------------|
| **Teal** | All-in-one solution | Job saving, resume builder, 40+ email templates |
| **Huntr** | Visual trackers | Kanban board, notes, salary tracking |
| **Simplify** | Auto-fill | Chrome extension, ATS keyword analyzer |
| **Careerflow** | AI features | LinkedIn integration, follow-up reminders |
| **Notion** | Customization | Build your own system, free templates |
| **Spreadsheet** | Simplicity | Google Sheets or Excel, full control |

### Premium Features (worth paying for)

- AI resume tailoring per job
- ATS score checking
- Auto-application filling
- Analytics on application success
- Interview prep integration

## Recommended: Teal

**Why Teal stands out:**
- Save jobs directly from browser (Chrome Extension)
- Tracks all application details automatically
- 40+ email templates for every stage
- Resume builder with ATS optimization
- Skills-matching analysis
- Free tier is generous

**Setup:**
1. Create account at tealhq.com
2. Install Chrome extension
3. Save jobs as you browse
4. Track status as applications progress

## DIY Spreadsheet System

If you prefer manual control, here's a template:

### Column Headers:

| Column | Description |
|--------|-------------|
| Company | Company name |
| Role | Job title |
| URL | Link to job posting |
| Date Applied | When you submitted |
| Status | Applied/Screen/Interview/Offer/Rejected |
| Salary Range | Posted or estimated |
| Contact | Recruiter/hiring manager name |
| Contact Email | For follow-ups |
| Source | Where you found it (LinkedIn, Indeed, referral) |
| Referral | Who referred you (if any) |
| Resume Version | Which resume you used |
| Cover Letter | Y/N and which version |
| Next Action | What you need to do next |
| Next Date | When to do it |
| Notes | Interview feedback, company research, etc. |
| Result | Final outcome |

### Status Stages:

```
Saved → Applied → Screening → Phone Screen → Technical/Assessment →
Onsite/Final → Offer → Negotiating → Accepted/Declined
```

### Google Sheets Template Setup:

```
1. Create new sheet
2. Add columns above
3. Freeze header row (View → Freeze → 1 row)
4. Add data validation for Status column:
   - Select Status column
   - Data → Data validation
   - Criteria: List of items
   - Add: Saved, Applied, Screening, Interview, Offer, Rejected
5. Add conditional formatting:
   - Green: Offer
   - Yellow: Interview stages
   - Red: Rejected
   - Gray: Applied (waiting)
```

## Application Process Workflow

### Daily Routine:

**Morning (30 min):**
1. Check job boards for new postings
2. Save interesting jobs to tracker
3. Review "Next Action" items due today

**Application Session (1-2 hours):**
1. Select 3-5 jobs to apply to
2. Tailor resume for each (or batch similar roles)
3. Write/customize cover letters
4. Submit and update tracker
5. Note next follow-up date

**Evening (15 min):**
1. Update statuses from any responses
2. Prepare for tomorrow's tasks
3. Review what's working (response rates)

### Weekly Review:

- Total applications sent
- Response rate (aim for 10-20%)
- Interview conversion rate
- What job sources are working
- Which resume versions get responses
- Adjust strategy based on data

## Follow-Up Strategy

### Timeline:

| Stage | Follow-up Timing |
|-------|------------------|
| After applying | 5-7 business days (if no response) |
| After phone screen | 3-5 business days |
| After interview | 24 hours (thank you) + 1 week (check-in) |
| After final round | 3-5 business days |
| After offer | Respond within timeframe given |

### Follow-Up Email Templates:

**After Application (No Response):**
```
Subject: Following Up - [Position] Application

Hi [Name/Hiring Team],

I submitted my application for the [Position] role on [Date] and
wanted to express my continued interest. I'm particularly excited
about [specific aspect of role/company].

I'd welcome the opportunity to discuss how my experience with
[relevant skill] could contribute to your team. Is there any
additional information I can provide?

Thank you for your consideration.

Best regards,
[Name]
```

**After Interview (Thank You):**
```
Subject: Thank You - [Position] Interview

Hi [Interviewer Name],

Thank you for taking the time to speak with me today about the
[Position] role. I enjoyed learning about [specific topic discussed]
and [Company]'s approach to [relevant area].

Our conversation reinforced my enthusiasm for the opportunity. I'm
confident my experience with [skill discussed] would allow me to
contribute meaningfully to [project/goal mentioned].

Please let me know if there's any additional information I can
provide. I look forward to hearing about next steps.

Best regards,
[Name]
```

**After Interview (Check-In):**
```
Subject: Checking In - [Position] Role

Hi [Name],

I hope this message finds you well. I wanted to follow up on our
conversation about the [Position] role from [date].

I remain very interested in the opportunity and am happy to provide
any additional information that would be helpful for your decision.

Could you share an update on the timeline for next steps?

Thank you,
[Name]
```

## Tracking Metrics

### Key Performance Indicators:

| Metric | How to Calculate | Good Benchmark |
|--------|------------------|----------------|
| Response Rate | Responses ÷ Applications | 10-20% |
| Interview Rate | Interviews ÷ Applications | 5-10% |
| Offer Rate | Offers ÷ Interviews | 10-20% |
| Source Quality | Response rate by source | Varies |
| Resume Effectiveness | Response rate by version | A/B test |

### What the Numbers Tell You:

**Low Response Rate (<5%):**
- Resume may need optimization
- Applying to wrong-fit roles
- Application materials not standing out
- Consider reaching out to recruiters directly

**Good Response Rate, Low Interview Rate:**
- Phone screens aren't converting
- Practice your pitch
- Research companies more before calls

**Good Interviews, No Offers:**
- Interview skills need work
- May be missing culture fit signals
- Practice STAR method responses
- Get feedback when possible

## Automation Options

### Use Cautiously:

**Auto-apply tools (LazyApply, JobCopilot, Loopcv):**
- Can apply to 50-100 jobs/day
- Risk: less personalization
- Risk: applying to poor-fit roles
- Best for: high-volume strategies in competitive markets

**Better approach:**
- Use auto-fill for repetitive fields (Simplify)
- Manually customize resume/cover letter
- Quality over quantity

### Browser Extensions Worth Using:

1. **Simplify** - Auto-fills applications
2. **Teal** - Saves jobs, tracks applications
3. **Glassdoor** - Shows salary/reviews on job pages
4. **LinkedIn Easy Apply** - Quick applications (use selectively)

## Organization Tips

### Folder Structure:

```
Job Search/
├── Resumes/
│   ├── Master_Resume.docx
│   ├── PM_Resume_v1.docx
│   ├── PM_Resume_v2.docx
│   └── Leadership_Resume.docx
├── Cover Letters/
│   ├── Templates/
│   │   ├── Problem_Solution_Template.docx
│   │   └── Story_Impact_Template.docx
│   └── Submitted/
│       ├── CompanyA_CoverLetter.docx
│       └── CompanyB_CoverLetter.docx
├── Company Research/
│   └── [Company notes files]
├── Interview Prep/
│   ├── STAR_Stories.docx
│   └── Questions_to_Ask.docx
└── Offers/
    └── [Offer letters and comparisons]
```

### Version Naming Convention:

```
FirstName_LastName_Resume_[RoleType]_v[#].docx
FirstName_LastName_CoverLetter_[Company].docx
```

### Email Organization:

- Create label/folder for job search
- Set up filters for recruiter emails
- Star/flag time-sensitive responses
- Use email scheduling for optimal send times (Tuesday-Thursday, 9-11am)

## Red Flags to Track

Note these in your tracker to avoid wasting time:

- No salary information + won't disclose
- Extremely long interview processes (5+ rounds for non-exec roles)
- High turnover signals (same role posted repeatedly)
- Vague job descriptions
- Unprofessional communication
- Rescheduled interviews multiple times

## Weekly Checklist

- [ ] Apply to 15-25 quality jobs (or your target number)
- [ ] Follow up on applications from 1 week ago
- [ ] Send thank-you notes within 24 hours of interviews
- [ ] Update all application statuses
- [ ] Review and respond to all recruiter messages
- [ ] Analyze what's working (sources, resume versions)
- [ ] Adjust strategy based on data
- [ ] Maintain LinkedIn activity (2-3 engagements)
- [ ] Review and prep for upcoming interviews
