---
name: Fractionation Patterns
parent_skill: hypnotic-language
category: deepening
---

# Fractionation Patterns

Light↔deeper oscillation that creates controlled descent into trance without free-fall.

---

## Core Principle

**Fractionation = Controlled Oscillation**

Instead of pushing deeper continuously, alternate between lighter and deeper states. Each return to lighter awareness paradoxically enables deeper descent on the next cycle.

---

## Why Fractionation Works

1. **Prevents overwhelm** — Regular "surface breaks" prevent flooding
2. **Builds trust** — Demonstrates safe return is possible
3. **Increases depth** — Each cycle goes slightly deeper than before
4. **Maintains agency** — Listener experiences choice to go deeper

---

## The Basic Pattern

```
Light → Deeper → Surface → Even Deeper → Surface → Deepest → Emergence
```

Each descent is slightly deeper than the previous one.

---

## Pattern Library

### 1. Breath-Based Fractionation

```xml
<prosody rate="1.0" pitch="-2st">
  And you can drift a little deeper now... <break time="2s"/>
  with each exhale... <break time="1.5s"/>
  settling... <break time="2s"/>
  and then... <break time="1s"/>
  notice yourself here... <break time="1.5s"/>
  aware of this moment... <break time="1s"/>
  and then... <break time="1s"/>
  allowing yourself to go... <break time="1s"/>
  even deeper still.
</prosody>
```

**Structure**: Down → Surface → Deeper down

### 2. Staircase Fractionation

```xml
<prosody rate="1.0" pitch="-2st">
  Imagine a staircase before you... <break time="1.5s"/>
  and you can take a few steps down... <break time="2s"/>
  one... <break time="1.5s"/>
  two... <break time="1.5s"/>
  three... <break time="2s"/>
  and pause here... <break time="1.5s"/>
  looking back up... <break time="1s"/>
  seeing how far you've come... <break time="2s"/>
  and when you're ready... <break time="1s"/>
  continuing down... <break time="1.5s"/>
  four... <break time="1.5s"/>
  five... <break time="1.5s"/>
  six... <break time="2s"/>
  going deeper.
</prosody>
```

**Structure**: Counted descent with orientation pauses

### 3. Light Touch Fractionation

```xml
<prosody rate="1.0" pitch="-1st">
  Drifting into that peaceful space... <break time="2s"/>
  and you can come back just enough... <break time="1.5s"/>
  to notice you're still here... <break time="1s"/>
  still aware... <break time="1.5s"/>
  and then let yourself go... <break time="1.5s"/>
  drifting even more deeply... <break time="2s"/>
  into that comfortable place.
</prosody>
```

**Structure**: Gentle oscillation without imagery

### 4. Sensation-Based Fractionation

```xml
<prosody rate="1.0" pitch="-2st">
  Notice how relaxed your hands have become... <break time="1.5s"/>
  feeling that heaviness... <break time="2s"/>
  and now bring your attention... <break time="1s"/>
  back to the sounds around you... <break time="1.5s"/>
  just for a moment... <break time="2s"/>
  and then... <break time="1s"/>
  let that awareness drift away... <break time="1.5s"/>
  as you sink even deeper... <break time="2s"/>
  into that comfortable heaviness.
</prosody>
```

**Structure**: Body awareness → External → Deeper body

---

## Depth Markers

Use these to track position in the oscillation:

| Marker | Indicates |
|--------|-----------|
| "noticing the sounds around you" | Surface touch |
| "aware of this moment" | Orientation point |
| "letting yourself drift" | Descent phase |
| "going deeper" | Active deepening |
| "settling into" | Stabilization |

---

## Safety Integration

Every fractionation sequence must include:

1. **Return demonstration** — Show they CAN come back
2. **Agency affirmation** — "whenever you choose"
3. **Body anchor** — Physical sensation reference
4. **Depth ceiling** — Don't oscillate into unsafe territory

```xml
<!-- Safety wrapper example -->
<prosody rate="1.0" pitch="-1st">
  And as you go deeper... <break time="1.5s"/>
  you can know... <break time="1s"/>
  that part of you remains here... <break time="1s"/>
  aware... <break time="1.5s"/>
  ready to bring you back... <break time="1s"/>
  whenever you choose.
</prosody>
```

---

## Session Placement

| Phase | Fractionation Use |
|-------|-------------------|
| Induction | Light oscillation (2-3 cycles) |
| Deepening | More pronounced cycles (3-5 cycles) |
| Journey | Maintenance oscillation (as needed) |
| Emergence | Reverse fractionation (deeper → lighter → surface) |

---

## Contraindications

| Condition | Adjustment |
|-----------|------------|
| High anxiety | Gentler oscillation, more surface time |
| Dissociative tendency | Stronger body anchors at each surface |
| First-time listener | More frequent orientation checks |
| Trauma history | Explicit safety at each depth |

---

## Validation Checklist

- [ ] At least 3 oscillation cycles before deep content
- [ ] Surface touches include orientation cues
- [ ] Agency language at each descent choice
- [ ] Body anchors present throughout
- [ ] No free-fall without oscillation recovery
