---
name: Attention Pacing (Pace-Lead Sequences)
parent_skill: hypnotic-language
category: induction
---

# Attention Pacing Patterns

Sequences that match the listener's current experience (pacing) before gently guiding toward desired states (leading).

---

## Core Principle

**Pace → Lead → Pace → Lead**

First, describe what IS true. Then suggest what COULD be true.

---

## The Pacing-Leading Formula

```
[Pace] You may notice your breathing... (observable fact)
[Lead] and as it slows... (gentle suggestion)
[Pace] feeling the weight of your body... (observable fact)
[Lead] perhaps becoming heavier... (gentle suggestion)
```

**Ratio**: Start with 3 paces : 1 lead, gradually shift to 2:1, then 1:1.

---

## Pattern Library

### 1. Sensory Pacing Chain

```xml
<prosody rate="1.0" pitch="0st">
  You can feel the surface beneath you... <break time="1s"/>
  the temperature of the air around you... <break time="1s"/>
  the gentle rise and fall of your chest... <break time="1.5s"/>
  and as you notice these things... <break time="1s"/>
  you might find yourself... <break time="1.5s"/>
  settling a little more deeply.
</prosody>
```

**Structure**: 3 sensory paces → 1 deepening lead

### 2. Breath Pacing

```xml
<prosody rate="1.0" pitch="-1st">
  Each breath you take... <break time="1.5s"/>
  is happening naturally... <break time="1s"/>
  without any effort at all... <break time="1.5s"/>
  and with each exhale... <break time="1s"/>
  you can allow... <break time="1s"/>
  any tension to simply drift away.
</prosody>
```

**Structure**: 2 breath paces → 1 release lead

### 3. Mental State Pacing

```xml
<prosody rate="1.0" pitch="0st">
  Perhaps thoughts are drifting through your mind... <break time="1.5s"/>
  and that's perfectly fine... <break time="1s"/>
  thoughts come and go... <break time="1.5s"/>
  like clouds across a sky... <break time="2s"/>
  and you can simply... <break time="1s"/>
  let them pass... <break time="1.5s"/>
  settling into stillness beneath.
</prosody>
```

**Structure**: Acknowledge mental activity → naturalize it → lead toward stillness

### 4. Environmental Pacing

```xml
<prosody rate="1.0" pitch="0st">
  Whatever sounds you hear... <break time="1s"/>
  near or far... <break time="1.5s"/>
  they simply remind you... <break time="1s"/>
  that the world continues... <break time="1s"/>
  while you rest here... <break time="1.5s"/>
  safe and undisturbed.
</prosody>
```

**Structure**: Acknowledge external → reframe as supportive → lead to safety

---

## Progression Through Session

| Phase | Pace:Lead Ratio | Focus |
|-------|-----------------|-------|
| Entry (0-2 min) | 3:1 | Match current state exactly |
| Early Induction (2-5 min) | 2:1 | Begin gentle suggestions |
| Deep Induction (5-8 min) | 1:1 | Balance matching and leading |
| Journey (8+ min) | 1:2 | More leading, less matching needed |

---

## Common Mistakes

| Mistake | Correction |
|---------|------------|
| Leading too early | Start with pure pacing for 30-60 seconds |
| Pacing impossible states | Only pace observable/likely experiences |
| Breaking rhythm | Maintain consistent tempo through transitions |
| Demanding compliance | Always frame leads as possibilities |

---

## Validation Checklist

- [ ] First 3-4 statements are purely pacing
- [ ] Leads framed with "might," "perhaps," "can"
- [ ] No commands disguised as pacing
- [ ] Rhythm maintained through sequence
- [ ] Transitions feel natural, not forced
