---
name: Soft Entry Patterns
parent_skill: hypnotic-language
category: induction
---

# Soft Entry Patterns

Permissive opening sequences that establish safety and begin attention narrowing without pressure.

---

## Core Principle

Entry should feel like an **invitation**, not a command. The listener chooses to participate.

---

## Pattern Library

### 1. Permission-Based Opening

```xml
<prosody rate="1.0" pitch="0st">
  You can simply allow yourself... <break time="1s"/>
  to be here... <break time="1.5s"/>
  just as you are... <break time="1s"/>
  without needing to do anything at all.
</prosody>
```

**Why it works**: Removes performance pressure, establishes safety.

### 2. Present-Moment Anchoring

```xml
<prosody rate="1.0" pitch="0st">
  Right here... <break time="1s"/>
  in this moment... <break time="1.5s"/>
  wherever you are... <break time="1s"/>
  you can begin to notice... <break time="1s"/>
  the gentle rhythm of your breathing.
</prosody>
```

**Why it works**: Grounds attention in immediate sensory experience.

### 3. Choice Affirmation

```xml
<prosody rate="1.0" pitch="0st">
  This is your time... <break time="1.5s"/>
  your space... <break time="1s"/>
  and you can choose... <break time="1s"/>
  how deeply you wish to go... <break time="1.5s"/>
  how open you wish to be.
</prosody>
```

**Why it works**: Explicitly returns control to listener.

### 4. Environmental Acknowledgment

```xml
<prosody rate="1.0" pitch="0st">
  Whatever sounds may come and go... <break time="1s"/>
  they simply become part of this experience... <break time="1.5s"/>
  helping you settle... <break time="1s"/>
  even more deeply... <break time="1s"/>
  into this moment of rest.
</prosody>
```

**Why it works**: Prevents external distractions from breaking trance.

---

## Prohibited Patterns

| Pattern | Why Forbidden |
|---------|---------------|
| "You must relax now" | Commands, removes choice |
| "Let me take you somewhere" | Implies external control |
| "Surrender completely" | Ego dissolution risk |
| "Close your eyes" (command form) | Use "you might allow your eyes to close" |

---

## Session Type Adaptations

| Session Type | Entry Style |
|--------------|-------------|
| Healing | Gentle, nurturing, safety-focused |
| Transformation | Slightly more dynamic, change-oriented |
| Confidence | Empowering, strength-affirming |
| Relaxation | Ultra-soft, minimal engagement required |
| Spiritual | Reverent, sacred-space establishing |

---

## Integration Notes

- Always follow with `attention-pacing.md` patterns
- Coordinate with `audio-somatic/breath-regulation/` for breath cues
- Entry should last 1-2 minutes before transition to deepening
