---
name: Indirect Suggestion Patterns
parent_skill: hypnotic-language
category: suggestion
---

# Indirect Suggestion Patterns

Ericksonian techniques for bypassing resistance while preserving agency.

---

## Core Principle

**Direct suggestions create resistance. Indirect suggestions create discovery.**

Instead of telling the listener what to feel or do, create conditions where they discover it themselves.

---

## Why Indirect Works

1. **Bypasses critical faculty** — The conscious mind doesn't recognize it as a command
2. **Preserves agency** — Listener feels they chose the experience
3. **Reduces resistance** — Nothing to push back against
4. **Creates ownership** — Insights feel self-generated
5. **Respects free will** — Aligns with Christian values

---

## Pattern Library

### 1. Embedded Commands

Hide suggestions within larger sentences:

```xml
<prosody rate="1.0" pitch="-1st">
  I wonder if you've noticed... <break time="1s"/>
  how your breathing has begun to slow... <break time="1.5s"/>
  and I don't know exactly when... <break time="1s"/>
  you'll begin to <emphasis level="moderate">feel deeply relaxed</emphasis>... <break time="1.5s"/>
  but it's interesting... <break time="1s"/>
  how the body knows.
</prosody>
```

**Embedded command**: "feel deeply relaxed" (marked with slight emphasis)

### 2. Presupposition

Assume the desired state is already happening:

```xml
<prosody rate="1.0" pitch="-1st">
  As you continue to relax... <break time="1.5s"/>
  [presupposes they ARE relaxing]
  you might wonder... <break time="1s"/>
  which part of your body... <break time="1.5s"/>
  [presupposes some part will relax]
  will feel most comfortable first.
</prosody>
```

### 3. Bind of Comparable Alternatives

Offer choices that all lead to the goal:

```xml
<prosody rate="1.0" pitch="-1st">
  Would you like to drift deeper now... <break time="1.5s"/>
  or in a moment? <break time="2s"/>
  Perhaps with your next breath... <break time="1s"/>
  or the one after?
</prosody>
```

**All choices lead to going deeper.**

### 4. Implication

Suggest through logical connection:

```xml
<prosody rate="1.0" pitch="-1st">
  Each time you exhale... <break time="1.5s"/>
  you release a little more tension... <break time="1.5s"/>
  [implies: breathing = releasing = relaxing]
  and with each release... <break time="1s"/>
  you discover more peace within.
</prosody>
```

### 5. Questions as Suggestions

Frame suggestions as curious inquiries:

```xml
<prosody rate="1.0" pitch="0st">
  I wonder what it would feel like... <break time="1.5s"/>
  to simply let go... <break time="1s"/>
  even for just this moment? <break time="2s"/>
  What might open up... <break time="1.5s"/>
  if you allowed yourself... <break time="1s"/>
  that freedom?
</prosody>
```

### 6. Truisms Leading to Suggestion

Start with undeniable facts:

```xml
<prosody rate="1.0" pitch="-1st">
  Everyone breathes... <break time="1s"/>
  [truism - obviously true]
  and everyone can learn... <break time="1.5s"/>
  [truism - obviously true]
  to relax more deeply... <break time="1s"/>
  [suggestion - accepted because preceded by truisms]
  than they thought possible.
</prosody>
```

### 7. Not Knowing / Not Doing

Suggest by denying the need to do:

```xml
<prosody rate="1.0" pitch="-1st">
  You don't have to relax... <break time="1.5s"/>
  you don't have to do anything at all... <break time="1.5s"/>
  [removes pressure, paradoxically enabling relaxation]
  your body simply knows... <break time="1s"/>
  how to find its own comfort.
</prosody>
```

---

## Transformation Examples

| Direct (Avoid) | Indirect (Use) |
|----------------|----------------|
| "Relax now" | "I wonder when you'll notice the relaxation beginning" |
| "Feel peaceful" | "Perhaps a sense of peace is already beginning to settle" |
| "Go deeper" | "And you can go as deep as feels right... whenever you're ready" |
| "Let go of fear" | "Sometimes fears simply dissolve... when we stop holding them" |
| "You are safe" | "Many people discover... a surprising sense of safety here" |

---

## Christian-Safe Applications

Indirect suggestion aligns with invitational spirituality:

```xml
<prosody rate="1.0" pitch="-1st">
  I don't know what God might want... <break time="1.5s"/>
  to show you today... <break time="2s"/>
  but perhaps... <break time="1s"/>
  there's a gentle invitation... <break time="1.5s"/>
  waiting to be noticed.
</prosody>
```

**Key**: God invites; listener chooses to notice. No coercion.

---

## Forbidden Patterns

| Pattern | Why Prohibited |
|---------|----------------|
| "You WILL feel..." | Commands, overrides will |
| "I'm making you..." | External authority |
| "Without realizing it, you..." | Removes awareness consent |
| "You can't help but..." | Denies agency |

---

## Validation Rules

Generated suggestions should be checked for:

- [ ] No imperative commands without softeners
- [ ] Presuppositions lead toward positive states only
- [ ] Binds offer genuine choices (not manipulation)
- [ ] Questions don't demand specific answers
- [ ] Truisms are genuinely true (not false premises)
