---
name: Values-Aligned Suggestion Patterns
parent_skill: hypnotic-language
category: suggestion
---

# Values-Aligned Suggestion Patterns

Belief-congruent framing that works WITH the listener's existing values, not against them.

---

## Core Principle

**Effective suggestions align with the listener's core values.**

For Dreamweaving's Christian audience, suggestions must resonate with faith, free will, dignity, and relationship with God.

---

## The Alignment Framework

```
Suggestion + Listener's Values = Deep Acceptance
Suggestion - Listener's Values = Resistance or Harm
```

---

## Christian Value Alignment

### 1. Free Will (Agency)

**Value**: God gave humans free will; it must be respected.

```xml
<prosody rate="1.0" pitch="-1st">
  You can choose... <break time="1s"/>
  how deeply you wish to go... <break time="1.5s"/>
  this is your journey... <break time="1s"/>
  your invitation... <break time="1.5s"/>
  and you remain sovereign... <break time="1s"/>
  over every step.
</prosody>
```

### 2. Divine Presence (Not Autonomous Entities)

**Value**: God is the only spiritual authority; no other entities.

```xml
<!-- CORRECT -->
<prosody rate="1.0" pitch="-1st">
  And if you sense a presence... <break time="1.5s"/>
  it might simply be... <break time="1s"/>
  the God who knows you... <break time="1.5s"/>
  closer than your own breath.
</prosody>

<!-- WRONG - Implies autonomous entity -->
<prosody>
  A guide appears before you...
  Listen to what they say...
</prosody>
```

### 3. Inner Transformation (Not External Power)

**Value**: Change comes through relationship with God, not magic or technique.

```xml
<prosody rate="1.0" pitch="-1st">
  Perhaps something is already shifting... <break time="1.5s"/>
  not because of any technique... <break time="1s"/>
  but because God is at work... <break time="1.5s"/>
  in the quiet places... <break time="1.5s"/>
  where we finally stop striving.
</prosody>
```

### 4. Safety Through Faith (Not Fear)

**Value**: Perfect love casts out fear; safety comes from God's presence.

```xml
<prosody rate="1.0" pitch="0st">
  You are held... <break time="1.5s"/>
  not by this space... <break time="1s"/>
  not by my words... <break time="1.5s"/>
  but by the One... <break time="1s"/>
  who has always held you... <break time="2s"/>
  even when you didn't know.
</prosody>
```

### 5. Surrender to God (Not to Technique)

**Value**: Surrender is only safe when directed toward God.

```xml
<!-- CORRECT -->
<prosody rate="1.0" pitch="-1st">
  And you can release... <break time="1.5s"/>
  into God's hands... <break time="1s"/>
  whatever you've been carrying.
</prosody>

<!-- WRONG - Surrender to undefined force -->
<prosody>
  Let go completely...
  Surrender to the universe...
</prosody>
```

---

## Universal Value Patterns

These work regardless of specific belief:

### Autonomy

```xml
<prosody rate="1.0" pitch="0st">
  This is your experience... <break time="1.5s"/>
  shaped by your own inner wisdom... <break time="1.5s"/>
  unfolding in your own way.
</prosody>
```

### Safety

```xml
<prosody rate="1.0" pitch="0st">
  You are safe here... <break time="1.5s"/>
  held by the ground beneath you... <break time="1s"/>
  supported by your own breath.
</prosody>
```

### Worthiness

```xml
<prosody rate="1.0" pitch="-1st">
  You deserve this rest... <break time="1.5s"/>
  this peace... <break time="1s"/>
  this moment of care for yourself.
</prosody>
```

---

## Value-Misalignment Examples

| Misaligned | Why | Aligned Version |
|------------|-----|-----------------|
| "Your higher self knows..." | Implies inner god | "The wisdom within you, given by God..." |
| "The universe will provide..." | Impersonal force | "God provides..." |
| "Channel this energy..." | New Age framing | "Receive this peace..." |
| "Connect with your spirit guides..." | Entity invocation | "Open to God's guidance..." |
| "You are becoming enlightened..." | Non-Christian goal | "You are becoming more yourself..." |

---

## Outcome-Specific Alignment

| Outcome | Value to Emphasize | Pattern |
|---------|-------------------|---------|
| Healing | God as healer | "The One who made you can restore you" |
| Confidence | God-given worth | "You are fearfully and wonderfully made" |
| Relaxation | Rest as gift | "Come to me, all who are weary" |
| Transformation | Sanctification | "Being transformed by the renewing of mind" |
| Spiritual growth | Divine relationship | "Drawing closer to the heart of God" |

---

## Validation Checklist

- [ ] Suggestions compatible with Christian worldview
- [ ] No entity invocation (guides, masters, spirits)
- [ ] Authority remains with God, not technique
- [ ] Free will explicitly preserved
- [ ] No New Age or occult terminology
- [ ] Surrender directed only to God
