---
name: Depth Check Patterns
parent_skill: hypnotic-language
category: validation
---

# Depth Check Patterns

Trance level monitoring to ensure safe depth throughout the journey.

---

## Core Principle

**Know where the listener is before going deeper.**

Depth checks help calibrate the journey to the listener's actual state, preventing over-deepening or missed opportunities for safe exploration.

---

## Depth Indicators

### Signs of Light Trance

- Aware of surroundings
- Can easily follow instructions
- Thoughts still active
- Body relaxed but not heavy
- Time awareness intact

### Signs of Moderate Trance

- Reduced awareness of surroundings
- Deep relaxation and heaviness
- Thoughts slowed or distant
- Imagery more vivid
- Time slightly distorted

### Signs of Deep Trance

- Minimal environmental awareness
- Profound body heaviness
- Thoughts nearly absent
- Vivid, spontaneous imagery
- Significant time distortion

### Signs of Very Deep Trance (Caution)

- Complete environmental unawareness
- Body feels absent or merged
- No conscious thought
- Autonomous imagery
- Lost time sense

---

## In-Script Depth Checks

### Responsive Check

```xml
<prosody rate="1.0" pitch="-1st">
  And as you rest here... <break time="1.5s"/>
  you can notice... <break time="1s"/>
  how deep you've already gone... <break time="2s"/>
  perhaps deeper than expected... <break time="1.5s"/>
  or perhaps... <break time="1s"/>
  exactly where you need to be.
</prosody>
```

**Function**: Invites self-assessment without disruption.

### Calibration Check

```xml
<prosody rate="1.0" pitch="0st">
  Right now... <break time="1.5s"/>
  part of you knows... <break time="1s"/>
  exactly how relaxed you are... <break time="2s"/>
  and whether you'd like to go... <break time="1.5s"/>
  a little deeper... <break time="1s"/>
  or stay right here... <break time="1.5s"/>
  in this comfortable place.
</prosody>
```

**Function**: Gives listener control over depth progression.

### Safety Check

```xml
<prosody rate="1.0" pitch="0st">
  And you can know... <break time="1.5s"/>
  that part of you remains aware... <break time="1.5s"/>
  watching over this experience... <break time="2s"/>
  able to adjust... <break time="1s"/>
  able to speak... <break time="1s"/>
  able to move... <break time="1.5s"/>
  whenever you choose.
</prosody>
```

**Function**: Affirms agency at current depth.

---

## Depth Check Timing

| Phase | Check Frequency |
|-------|-----------------|
| Pre-talk | None (normal awareness) |
| Early Induction | Every 2-3 minutes |
| Deep Induction | After significant deepening |
| Journey Start | Before first major content |
| Helm (deepest) | Before AND during |
| Integration | Every 2-3 minutes |
| Emergence | Continuous monitoring |

---

## Depth Ceiling Enforcement

### Session Type Limits

| Session Type | Maximum Depth | Notes |
|--------------|---------------|-------|
| Relaxation | Light-Moderate | No deep work needed |
| Healing | Moderate-Deep | Deep for receptivity |
| Confidence | Light-Moderate | Retain active engagement |
| Transformation | Deep | Requires depth for change |
| Spiritual | Deep | With strong grounding |
| First-time listener | Light-Moderate | Build trust first |

### Depth Ceiling Language

When approaching session's ceiling:

```xml
<prosody rate="1.0" pitch="-1st">
  And this is deep enough... <break time="1.5s"/>
  exactly right for what we're doing today... <break time="2s"/>
  there's no need to go further... <break time="1.5s"/>
  everything you need... <break time="1s"/>
  is available right here.
</prosody>
```

---

## Red Flag Indicators

Immediate emergence needed if:

| Indicator | Action |
|-----------|--------|
| Listener reports distress | Emergency grounding |
| Breathing becomes irregular | Breath-based grounding |
| Sudden emotional overwhelm | Pause + safety check |
| Identity confusion expressed | Identity reaffirmation |
| Listener becomes unresponsive | Gentle reorientation |

---

## Depth Recovery Protocol

If depth exceeds intended level:

```xml
<prosody rate="1.0" pitch="0st">
  And now... <break time="1.5s"/>
  you can begin to rise... <break time="1s"/>
  just a little... <break time="1.5s"/>
  coming up to a lighter place... <break time="2s"/>
  where you're still relaxed... <break time="1.5s"/>
  but more aware... <break time="1.5s"/>
  more present... <break time="2s"/>
  finding that comfortable balance.
</prosody>
```

---

## Integration with Tier 2

Depth checks feed into Tier 2 Psychological Stability skill:

- Exceeding ceiling → Tier 2 trigger
- Distress signs → Emergency protocol
- Unresponsiveness → Safety intervention
- Time confusion → Reorientation sequence

---

## Validation Rules

For every script:

- [ ] Depth check present after each significant deepening
- [ ] Agency language accompanies depth references
- [ ] Depth ceiling appropriate for session type
- [ ] Recovery protocol available if needed
- [ ] No depth language that removes listener control
