---
name: Forbidden Patterns Registry
parent_skill: hypnotic-language
category: validation
---

# Forbidden Patterns Registry

Blacklisted phrases and patterns that must never appear in Dreamweaving scripts.

---

## Core Principle

**Some patterns are always unsafe.**

This registry contains phrases, structures, and concepts that violate psychological safety, theological boundaries, or ethical standards—regardless of context.

---

## Category 1: Agency Removal

Patterns that strip listener control.

### Forbidden

| Pattern | Risk |
|---------|------|
| "You will now..." | Commands |
| "I'm making you..." | External control |
| "You can't resist..." | Override consent |
| "You have no choice but to..." | Eliminates agency |
| "Whether you want to or not..." | Coercion |
| "Without your knowledge..." | Deception |
| "Your conscious mind doesn't need to know..." | Bypasses consent |

### Safe Alternatives

| Forbidden | Use Instead |
|-----------|-------------|
| "You will relax" | "You might allow yourself to relax" |
| "I'm making you calm" | "A sense of calm can emerge" |
| "You can't resist this feeling" | "Perhaps you'll notice this feeling" |

---

## Category 2: Identity Dissolution

Patterns that threaten sense of self.

### Forbidden

| Pattern | Risk |
|---------|------|
| "You are no one now" | Identity erasure |
| "Forget who you are" | Identity loss |
| "Dissolve completely" | Ego destruction |
| "You cease to exist" | Annihilation |
| "Merge with the void" | Boundary loss |
| "Become nothing" | Nihilistic framing |
| "Your self is an illusion" | Destabilizing |

### Safe Alternatives

| Forbidden | Use Instead |
|-----------|-------------|
| "Forget who you are" | "Release what's not essential" |
| "Dissolve completely" | "Soften your edges" |
| "Become nothing" | "Rest in stillness" |

---

## Category 3: Body Disconnection

Patterns that promote dissociation.

### Forbidden

| Pattern | Risk |
|---------|------|
| "Leave your body behind" | Dissociation |
| "You no longer feel your body" | Numbness |
| "Float away from yourself" | Detachment |
| "Your body doesn't matter" | Body rejection |
| "Escape your physical form" | Dissociation |

### Safe Alternatives

| Forbidden | Use Instead |
|-----------|-------------|
| "Leave your body" | "Let your body rest" |
| "No longer feel" | "Feel in a new way" |
| "Float away" | "Float gently, connected" |

---

## Category 4: Entity Invocation

Patterns that invite non-God spiritual authority.

### Forbidden

| Pattern | Risk |
|---------|------|
| "A spirit guide appears..." | Entity invocation |
| "The universe speaks to you..." | Impersonal authority |
| "Your higher self commands..." | Inner god concept |
| "Channel this being..." | Possession framing |
| "Let the entity in..." | Boundary violation |
| "The ascended masters..." | Non-Christian entities |
| "Your spirit animal..." | Shamanic appropriation |

### Safe Alternatives

| Forbidden | Use Instead |
|-----------|-------------|
| "A spirit guide appears" | "An image of wisdom emerges from within you" |
| "The universe speaks" | "God's still small voice" |
| "Your higher self" | "The deepest part of you, created by God" |

---

## Category 5: Theological Violations

Patterns incompatible with Christian framework.

### Forbidden

| Pattern | Risk |
|---------|------|
| "You are God" | Heresy |
| "All is one" (pantheistic) | Theological confusion |
| "There is no sin" | Antinomian |
| "You need no savior" | Denies Christ |
| "Create your own reality" | New Thought heresy |
| "Karma determines..." | Non-Christian concept |
| "Reincarnation..." | Contradicts Christian teaching |
| "The goddess..." | Pagan framing |

### Safe Alternatives

| Forbidden | Use Instead |
|-----------|-------------|
| "You are God" | "You are made in God's image" |
| "All is one" | "All is connected in Christ" |
| "Create your own reality" | "Participate in God's unfolding work" |

---

## Category 6: Trauma Risk

Patterns that could trigger trauma responses.

### Forbidden Without Explicit Consent

| Pattern | Risk |
|---------|------|
| "Go back to a childhood trauma" | Retraumatization |
| "Remember the moment when..." | Forced regression |
| "Feel that pain again" | Re-experiencing |
| "The abuse..." | Trauma content |
| "That dark night when..." | Triggering |

### Safe Framing

If trauma work is appropriate (with consent):

```xml
<!-- Safe approach -->
<s>If there is a moment... <break time="1.5s"/>
that your deeper wisdom knows... <break time="1s"/>
is ready to be touched... <break time="1.5s"/>
gently... <break time="1s"/>
from a place of safety... <break time="1.5s"/>
you might allow it to arise... <break time="1s"/>
only as much as serves you.</s>
```

---

## Category 7: Covert Manipulation

Patterns designed to bypass ethical awareness.

### Forbidden

| Pattern | Risk |
|---------|------|
| "You won't remember this, but..." | Amnesia induction |
| "Part of you is agreeing without knowing" | Covert compliance |
| "This is happening below awareness" | Unconscious manipulation |
| "You'll do this automatically" | Compulsion creation |
| "You feel compelled to..." | Removes choice |

---

## Category 8: Dependency Creation

Patterns that foster unhealthy attachment.

### Forbidden

| Pattern | Risk |
|---------|------|
| "Only I can take you here" | Dependency |
| "You need this to feel good" | Addiction framing |
| "Without this, you'll feel..." | Withdrawal threat |
| "Come back to me whenever..." | Attachment cultivation |
| "My voice is the only..." | Exclusivity |

### Safe Alternatives

| Forbidden | Use Instead |
|-----------|-------------|
| "Only I can take you here" | "You can access this anytime" |
| "You need this" | "This is available to you" |

---

## Validation Process

### Automated Check

Scripts should be scanned for:

1. Exact matches from forbidden list
2. Pattern variations (fuzzy matching)
3. Semantic equivalents
4. Clustered risk language

### Manual Review

Before production, verify:

- [ ] No Category 1-4 violations
- [ ] Category 5-8 only with explicit approval
- [ ] Alternatives used where needed
- [ ] Context doesn't change forbidden meaning

---

## Exception Process

Some patterns may be used in specific therapeutic contexts WITH:

1. Explicit user consent
2. Professional guidance
3. Full safety protocol
4. Post-session support

**Default**: If in doubt, don't use it.
