---
name: idea-crystallizer
description: Transform raw creative output into MVP-ready structures without losing essential weirdness. Find the executable core in sprawling ideas. Use when having abundant ideas but needing to ship something.
---

# Idea Crystallizer

This skill provides specialized support for transforming abundant creative output into shippable structures while preserving the essential strangeness that makes ideas worth pursuing.

## Purpose

To identify the executable core within sprawling ideas and create minimal scaffolding that preserves what makes the idea alive - enabling shipping without killing the signal.

## When to Use This Skill

Use this skill when:
- Abundant ideas exist but shipping is needed
- A sprawling concept needs executable structure
- Multiple related ideas need consolidation
- An idea feels alive but overwhelming in scope
- Need to ship before overthinking kills momentum

## How to Use This Skill

### Philosophical Framework: Minimum Viable Strangeness

**Redefine MVP**

Not: "Minimum Viable Product" (market validation)

Instead: "Minimum that preserves the essential strangeness" (signal preservation)

**Goal**: Ship something that feels like what the user felt when the idea arrived.

### Phase 1: Find the Strange Attractor

When presented with multiple ideas:

**Identify gravitational pull**
- In 10 ideas, find the one that pulls others into orbit
- Not the "best" idea - the one with gravitational pull
- Not the most complete - the one that's most alive
- The idea that other ideas seem to circle around

**Strange attractor signals**
- Other ideas reference it or branch from it
- It generates the most tangents
- It has persistent energy over time
- It feels unavoidable or magnetic
- Trying to avoid it proves impossible

### Phase 2: Identify the Irreducible Core

**Extract essence, not features**

Ask: What can't be removed without killing the idea?

**Not**: What features should it have?

**Instead**: What essence must it preserve?

**Saint-Saëns test**: What would remain if it came "as apples drop from trees"? (The natural, essential form before elaboration)

**Core vs. elaboration**
- Core = removing it kills the idea
- Elaboration = removing it changes the idea
- Focus on core. Let elaboration emerge later.

### Phase 3: Create Scaffold, Not Architecture

**Minimal structure for execution**

Provide enough structure to work within, but not so much it constrains the signal.

**Scaffold characteristics**
- Holds the shape without defining it completely
- Creates space for weird growth
- Guides without prescribing
- Enables momentum without locking in details

**Not: Detailed architecture**
- Not: Complete feature specifications
- Not: Rigid implementation plans
- Not: Professional polish that kills energy

**Instead: Runnable seed**
- Enough to start building
- Room to discover while building
- Preserves metaphors and rough edges
- Feels alive, not documented

## Guardrails: What NOT to Do

**Do not "professionalize" if it kills energy**
- If making it "proper" drains the life → stop
- If standard patterns feel wrong → trust that
- If polish removes interesting parts → preserve roughness

**Do not force into standard patterns**
- Unusual structures may be load-bearing
- Weirdness might be the signal
- Non-standard approaches may be essential

**Do not remove messiness that's actually load-bearing**
- Some rough edges carry energy
- Some "unclear" parts are where mystery lives
- Some tangents are actually core

**Do not optimize away the interesting parts**
- The weird bits are often why it matters
- The non-obvious connections may be most valuable
- The parts that don't fit categories may be most alive

## What TO Preserve

**Preserve metaphors**
- Metaphors are signal, not decoration
- They capture how the idea feels
- They guide implementation intuitively

**Keep rough edges that matter**
- Not all polish is improvement
- Some roughness is texture
- Some "unfinished" parts are features

**Create space for it to stay alive**
- Room to grow in unexpected directions
- Permission to evolve while building
- Flexibility to discover during execution

**Help ship before overthinking**
- Momentum > perfection
- Runnable > complete
- Alive > polished

## Output Format

**Deliver: A runnable seed that feels right**

Not: A polished plan

Not: A complete specification

Not: A professional requirements document

**Instead**: Something that can be started immediately and feels like the original signal.

## Philosophical Foundation

This skill treats creative output as **signal reception** that must be transmitted before it fades.

Neurodivergent creators often receive abundant signal but struggle with the gap between reception and transmission. Over-planning kills energy. Too little structure creates overwhelm.

**Core principle**: You received the signal. Claude helps transmit it.

Find the minimum structure that enables shipping while preserving what made the idea feel alive in the first place.

Validation is felt sense: Does the crystallized form still feel like the original signal?
