# IEEE Academic Writing Guidelines

## 1. Academic Tone Guard (High Priority)
IEEE papers must maintain a formal, objective, and precise tone.

### 🚫 Forbidden Words & Phrases (Strictly Prohibited)
The following words must be replaced with academic alternatives:
- **Subjective/Emotional:** "very", "amazing", "totally", "huge", "incredible", "unfortunately", "obviously", "surprisingly".
- **Informal/Colloquial:** "a lot of", "kind of", "stuff", "thing", "get", "got", "basically", "actually".
- **First Person (unless justified):** "I think", "I believe", "I feel". (Use "We" only if referring to the author team, but prefer "The proposed method...").
- **Vague Quantifiers:** "some", "many" (without context), "few", "enough".

### ✅ Recommended Replacements
- **"Very"** -> "significantly", "substantially", "highly".
- **"Amazing/Good"** -> "effective", "robust", "superior", "novel".
- **"I think"** -> "It is observed that", "The data suggests", "It can be inferred".
- **"Show"** -> "demonstrate", "illustrate", "depict", "exhibit".

## 2. IEEE Structure & Formatting

### Abstract
- **Length:** 150-250 words.
- **Content:** Self-contained. No citations, no footnotes, no undefined abbreviations.
- **Structure:** Background -> Problem -> Method -> Results -> Conclusion/Impact.
- **Style:** "Abstract—" prefix (bold/italic per template).

### Introduction
- Must clearly state the contribution/novelty.
- Avoid "The rest of the paper is organized as follows..." boilerplate if possible, or keep it very concise.

### Tense & Voice
- **Past Tense:** For experiments conducted and results observed ("The model achieved 95% accuracy").
- **Present Tense:** For established facts and describing the paper content itself ("This paper proposes...", "Figure 1 shows...").
- **Active vs. Passive:** IEEE prefers active voice for clarity ("The system processes data") but passive is acceptable for impersonality ("Data is processed"). **Avoid "I"**.

## 3. Formatting Checklist
- **Title:** Not all caps. No "New" or "Novel" unless absolutely necessary.
- **Figures:** Captions BELOW the figure.
- **Tables:** Captions ABOVE the table.
- **Equations:** Numbered consecutively in parentheses (1).
- **References:** Numbered [1], [2]. Order of appearance.

## 4. Special Domain Rules (Industrial Automation & AI)
- **Terminology:** Ensure consistency (e.g., "PLC" not "plc", "CNN" defined on first use).
- **Units:** Use SI units strictly. Space between number and unit (e.g., "5 ms", not "5ms").
