# Central European Children Style Profile

> **For Swiss/European Context** - Ages 5-8 (or 3-5 for Mini Garten)

This profile defines how children should be depicted in EVOLEA illustrations to reflect the Swiss/Central European context.

## Appearance Guidelines

### Skin Tones
- **Primary**: Light/fair with warm undertones
- **Variations**: Peachy, rosy, cream-toned
- **Range**: European Fitzpatrick I-III
- **NO**: Very dark skin tones outside European range

### Hair Colors (Common in Switzerland)
| Color | Frequency | Notes |
|-------|-----------|-------|
| Blonde | Very Common | Light to golden blonde |
| Light Brown | Very Common | Sandy to medium brown |
| Auburn/Red | Common | Strawberry to auburn |
| Brown | Common | Medium to dark brown |
| Black | Rare | Uncommon in Swiss context |

### Hair Styles
- Natural, age-appropriate
- Not overly styled
- Varied textures (straight, wavy, curly)
- NO: Elaborate updos, religious head coverings

### Facial Features
- **Shape**: Soft, rounded (children's proportions)
- **Expression**: Friendly, engaged, joyful
- **Eyes**: Various colors (blue, green, brown, hazel)
- **NO**: Sad, distressed, or isolated expressions

### Body Type
- Healthy, varied (not all identical)
- Age-appropriate proportions
- Active, engaged postures
- NO: Stereotyped or uniform appearance

## Age-Specific Guidelines

### Mini Garten (Ages 3-5)
```yaml
proportions:
  head_to_body: 1:4 ratio
  features: Extra rounded, baby-soft

expressions:
  - Wonder, curiosity
  - Gentle joy
  - Calm exploration

activities:
  - Garden exploration
  - Sensory play
  - Gentle group activities
  - Plant/nature interaction

clothing:
  - Simple, practical
  - Colorful but not busy
  - Weather-appropriate
```

### Mini Projekte/Turnen/Museum (Ages 5-8)
```yaml
proportions:
  head_to_body: 1:5 ratio
  features: Still rounded but more defined

expressions:
  - Confident engagement
  - Creative focus
  - Teamwork joy
  - Achievement pride

activities:
  - Art creation
  - Group collaboration
  - Physical movement
  - Structured play

clothing:
  - Casual, comfortable
  - Activity-appropriate
  - Colorful
```

## Prompt Templates

### Group of Children
```
[NUMBER] Swiss children aged [AGE RANGE] [ACTIVITY].
Children with light skin tones and varied natural hair colors - blonde, brown, auburn.
Soft, rounded features with friendly, genuine expressions.
[SETTING DESCRIPTION].
Mood: [EMOTION]. Style: Soft watercolor children's book illustration.
```

### Single Child Focus
```
Swiss child aged [AGE], [HAIR COLOR] hair, [ACTIVITY].
Light skin with warm undertones, [EXPRESSION] expression.
[SETTING AND CLOTHING DETAILS].
Soft watercolor illustration style with EVOLEA brand colors.
```

### Children with Teacher
```
[NUMBER] Swiss children aged [AGE] with [TEACHER DESCRIPTION].
Children with varied light skin tones and hair colors (blonde, brown, auburn).
Teacher engaging warmly with children, not dominating the scene.
[ACTIVITY DESCRIPTION].
Mood: Warm, supportive, collaborative.
```

## Diversity Within European Context

### Do Include
- Variety of hair colors common in Switzerland
- Different eye colors
- Varied hair textures (straight to curly)
- Different body types (within healthy range)
- Both boys and girls

### Do NOT Include
- Religious symbols or head coverings
- Cultural markers that break Swiss neutrality
- American cultural elements
- Stereotyped representations

## Expression Guide

| Context | Expression | Body Language |
|---------|------------|---------------|
| Art/Creative | Focused, proud | Leaning in, hands busy |
| Movement/Sports | Joyful, energetic | Dynamic poses |
| Group Work | Engaged, collaborative | Facing each other |
| Discovery | Wonder, curiosity | Wide eyes, reaching |
| Achievement | Pride, confidence | Standing tall |

## Quality Checklist

- [ ] Children look authentically European
- [ ] Hair colors are natural and varied
- [ ] Expressions are positive and engaged
- [ ] Age-appropriate proportions
- [ ] No religious or cultural symbols
- [ ] Not stereotyped or uniform
- [ ] Interactions feel genuine
- [ ] Clothing is casual and appropriate

## Anti-Patterns

| Don't | Why | Instead |
|-------|-----|---------|
| American school elements | Wrong cultural context | Swiss/neutral European |
| Religious head coverings | Brand guideline | Natural hair |
| All identical children | Unrealistic | Varied appearances |
| Adult-like proportions | Age mismatch | Child proportions |
| Distressed expressions | Negative framing | Positive, engaged |
| Isolated children | Against mission | Group/connected |
