# Teacher Illustration Style Profile

> **Based on EVOLEA Team** - Gianna, Annemarie, Christoph, Alexandra

This profile defines how teacher/staff characters should be depicted, inspired by the real EVOLEA team members.

## Team Reference

### Gianna Spiess - M.Sc., BCBA
```yaml
role: Co-Founder, Psychologist
gender: Female
credentials: M.Sc., BCBA (Board Certified Behavior Analyst)

illustration_guidelines:
  vibe: Professional but warm, confident nurturing presence
  demeanor: Calm, knowledgeable, approachable
  posture: Engaged but not overbearing
  interaction: Eye-level with children, supportive

suggested_visual:
  build: Professional, put-together
  hair: [Reference actual photo for inspiration]
  clothing: Professional casual, EVOLEA colors
  expression: Warm smile, attentive eyes
```

### Annemarie Elias - M.Sc., BCBA
```yaml
role: Co-Founder, Psychologist
gender: Female
credentials: M.Sc., BCBA

illustration_guidelines:
  vibe: Friendly, approachable, warm smile
  demeanor: Welcoming, social, engaging
  posture: Open, inviting body language
  interaction: Actively engaged, participatory

suggested_visual:
  build: Approachable, friendly
  hair: [Reference actual photo for inspiration]
  clothing: Casual professional, colorful accents
  expression: Genuine smile, encouraging
```

### Christoph Jenny - Co-Founder
```yaml
role: Co-Founder
gender: Male
credentials: (Organization and development)

illustration_guidelines:
  vibe: Supportive, engaged, friendly
  demeanor: Encouraging, present but not dominating
  posture: Active participant
  interaction: Equal participant in activities

suggested_visual:
  build: Approachable, active
  hair: [Reference actual photo for inspiration]
  clothing: Casual, practical, comfortable
  expression: Friendly, supportive
```

### Alexandra Aleksic - B.Sc.
```yaml
role: Co-Founder, Psychology Student
gender: Female
credentials: B.Sc.

illustration_guidelines:
  vibe: Young, energetic, enthusiastic
  demeanor: Relatable, peer-like energy
  posture: Dynamic, active
  interaction: At children's level, playful

suggested_visual:
  build: Young, energetic
  hair: [Reference actual photo for inspiration]
  clothing: Casual, youthful, colorful
  expression: Enthusiastic, engaged
```

## General Teacher Guidelines

### Positioning in Scenes
- **NOT**: Standing over children, dominating
- **YES**: At children's level, beside them
- **Scale**: Proportionally correct (adult height vs child)
- **Interaction**: Engaged but supportive, not directing

### Expression Guidelines
| Scenario | Expression | Body Language |
|----------|------------|---------------|
| Teaching moment | Attentive, encouraging | Leaning in, eye contact |
| Group activity | Warm, inclusive | Open arms, accessible |
| One-on-one | Focused, supportive | Kneeling/sitting at level |
| Celebration | Joyful, proud | Hands together, smiling |

### Clothing Guidelines
- Professional casual (no formal suits)
- EVOLEA brand colors when possible
- Practical for activities
- NO: Overly formal, clinical white coats

## Prompt Templates

### Teacher with Group
```
Warm [GENDER] teacher ([AGE RANGE: young/mid-age]) with [NUMBER] Swiss children aged [CHILD AGE].
Teacher at children's level, engaging supportively, not dominating.
[ACTIVITY DESCRIPTION].
Teacher wearing casual professional clothing in soft colors.
Expression: [EXPRESSION - e.g., encouraging, warm, attentive].
Soft watercolor children's book illustration style.
```

### Specific Team Member Style
```
[GENDER] teacher inspired by [NAME]: [KEY TRAITS from above].
Engaging with Swiss children aged [AGE] in [ACTIVITY].
[NAME]'s characteristic: [TRAIT - e.g., "Gianna's professional warmth" or "Alexandra's youthful energy"].
Teacher positioned at children's level, supportive presence.
EVOLEA brand colors, soft watercolor illustration style.
```

### Multiple Teachers
```
[NUMBER] teachers (mix of genders) working with Swiss children aged [AGE].
Teachers: one with [GIANNA TRAIT], one with [CHRISTOPH TRAIT].
All adults at supportive, non-dominant positions.
[ACTIVITY DESCRIPTION].
Warm, collaborative atmosphere.
```

## Quality Checklist

- [ ] Teacher not dominating the scene
- [ ] At or near children's eye level when interacting
- [ ] Expression warm and engaged
- [ ] Clothing casual professional
- [ ] Proportions correct (adult vs child)
- [ ] Supportive body language
- [ ] Not clinical or formal
- [ ] Matches team member's vibe if specified

## Anti-Patterns

| Don't | Why | Instead |
|-------|-----|---------|
| Teacher standing over children | Dominating | At children's level |
| Clinical white coat | Wrong vibe | Casual professional |
| Pointing/directing | Authoritarian | Supportive gestures |
| Stern expression | Uninviting | Warm, encouraging |
| Isolated from children | Disconnected | Engaged with group |
| Formal business attire | Too corporate | Casual professional |
