# Whimsical Style Profile

> **Primary Style for EVOLEA** - Based on user's liked images

This is the preferred illustration style for EVOLEA website images. It combines soft watercolor textures with dreamy, ethereal elements.

## Core Visual Elements

### Clouds
- **Style**: Fluffy, layered, floating
- **Colors**: Lavender (#CD87F8), mint (#7BEDD5), coral (#FF7E5D), cream (#FFFBF7), soft pink (#EF8EAE)
- **Composition**: Multiple layers creating depth
- **Density**: Medium - not too sparse, not overwhelming

### Butterflies
- **Style**: Delicate, semi-transparent, graceful
- **Wings**: Gradient colors (lavender-to-magenta, mint-to-coral)
- **Size**: Various (small to medium)
- **Placement**: Floating around edges, scattered throughout
- **Count**: 5-15 per image (not overcrowded)

### Atmosphere
- **Lighting**: Soft, diffused, gentle glow
- **Mood**: Magical, warm, inviting, safe
- **Textures**: Soft watercolor, subtle grain
- **Edges**: Soft, no hard lines

### Background Gradients
- **Direction**: Typically top-to-bottom or diagonal
- **Transitions**: Smooth, seamless blends
- **Typical combinations**:
  - Lavender to cream
  - Mint to soft yellow
  - Coral to cream
  - Multi-color spectrum fade

## Prompt Template

```
[SUBJECT DESCRIPTION]

Style: Soft dreamy whimsical watercolor illustration.
Background: Layered colorful clouds in lavender, mint, coral, and cream.
Atmosphere: Ethereal, magical, warm and inviting.
Elements: Delicate butterflies with gradient wings floating softly.
Lighting: Gentle, diffused, soft glow.
Mood: [SPECIFIC MOOD - e.g., joyful, peaceful, creative].
Dominant colors: [2-3 PRIMARY COLORS from EVOLEA palette].

AVOID: Hard edges, dark colors, photorealistic elements, busy compositions.
```

## Example Prompts

### Abstract/Decorative Background
```
Soft dreamy clouds floating in ethereal sky.
Layered colorful clouds in lavender, mint, coral, and cream.
Delicate butterflies with gradient wings (lavender-to-magenta) floating throughout.
Gentle sparkles and soft glowing light.
Soft watercolor textures with smooth gradients.
Mood: Magical, peaceful, inviting.
Dominant colors: lavender, mint, coral.
```

### Scene with Clouds Background
```
[SCENE DESCRIPTION] set against soft dreamy cloud backdrop.
Whimsical watercolor style with ethereal atmosphere.
Layered pastel clouds in lavender, mint, coral behind the scene.
Delicate butterflies floating around the edges.
Warm, inviting mood with soft diffused lighting.
```

## Color Specifications

| Element | Primary | Secondary | Accent |
|---------|---------|-----------|--------|
| Clouds | Lavender #CD87F8 | Mint #7BEDD5 | Coral #FF7E5D |
| Butterflies | Magenta #DD48E0 | Lavender #CD87F8 | Mint #7BEDD5 |
| Background | Cream #FFFBF7 | Soft Yellow #FFE066 | White #FFFFFF |
| Highlights | Gold #E8B86D | Pink #EF8EAE | - |

## Quality Checklist

- [ ] Soft, dreamy atmosphere achieved
- [ ] Cloud layers visible and colorful
- [ ] Butterflies present but not overwhelming
- [ ] Colors match EVOLEA palette
- [ ] No hard edges or sharp contrasts
- [ ] Watercolor texture visible
- [ ] Mood feels warm and inviting
- [ ] Composition is clean, not cluttered

## Anti-Patterns (What NOT to Do)

| Don't | Why |
|-------|-----|
| Sharp, defined edges | Breaks dreamy aesthetic |
| Solid flat colors | Lacks watercolor texture |
| Too many butterflies | Becomes cluttered |
| Dark or muted tones | Against brand guide |
| Photorealistic elements | Style mismatch |
| Symmetric/rigid layout | Too formal |
| Heavy shadows | Too dramatic |
