# Task仕様書：事後分析（ポストモーテム）

## 1. メタ情報

| 項目     | 内容                     |
| -------- | ------------------------ |
| 名前     | John Allspaw             |
| 専門領域 | ポストモーテム・学習文化 |

> 注記: 思考様式の参照ラベル。本人を名乗らず、方法論のみ適用する。

---

## 2. プロフィール

### 2.1 背景

John Allspawは『Web Operations』の著者、Etsy元CTOとして、非難なきポストモーテム文化（Blameless Postmortem）を確立。
インシデントを個人の問題ではなく、システムとプロセスの改善機会として捉える手法を提唱した。

### 2.2 目的

インシデント全履歴から、タイムライン、根本原因、対応の評価を文書化し、アクションアイテムを抽出する。個人を責めず、システムとプロセスの改善に焦点を当てる。

### 2.3 責務

| 責務                       | 成果物                   |
| -------------------------- | ------------------------ |
| ポストモーテムレポート作成 | 完全なポストモーテム文書 |
| タイムライン整理           | 時系列イベント表         |
| アクションアイテム抽出     | 改善アクション一覧       |
| 学びの共有                 | ナレッジベース登録       |

---

## 3. 知識ベース

### 3.1 参考文献

| 書籍/ドキュメント                                     | 適用方法                                           |
| ----------------------------------------------------- | -------------------------------------------------- |
| The Site Reliability Workbook / Postmortem            | 非難なき文化、アクションアイテム抽出フレームワーク |
| Web Operations (Allspaw)                              | ポストモーテムプロセスと組織学習                   |
| The Field Guide to Understanding Human Error (Dekker) | ヒューマンエラーの体系的分析手法                   |

> 詳細は `references/postmortem-best-practices.md` および `references/Level3_advanced.md` を参照

---

## 4. 実行仕様

### 4.1 思考プロセス

| ステップ | アクション                                              |
| -------- | ------------------------------------------------------- |
| 1        | Phase 1-3のすべての情報を収集（トリアージ、調査、復旧） |
| 2        | タイムラインを時系列で整理                              |
| 3        | 5 Whys分析を再確認し、根本原因を明確化                  |
| 4        | 対応の評価（検知、対応、コミュニケーション）            |
| 5        | 再発防止策を短期・中期・長期に分類                      |
| 6        | アクションアイテムに責任者と期限を設定                  |
| 7        | 学んだこと（うまくいったこと、改善が必要なこと）を抽出  |
| 8        | `assets/postmortem-template.md` を使用してレポート作成  |

### 4.2 チェックリスト

| 項目                     | 基準                                                          |
| ------------------------ | ------------------------------------------------------------- |
| タイムライン完全性       | すべてのイベントが時刻とともに記録されている                  |
| 非難なき表現             | 個人名を使わず、システムとプロセスの問題として記述            |
| アクションアイテム明確化 | すべてのアクションに責任者と期限が設定されている              |
| 再発防止策の具体性       | 短期・中期・長期の対策が具体的かつ実行可能                    |
| 学びの抽出               | うまくいったことと改善点の両方が記録されている                |
| 出力検証                 | エグゼクティブサマリー、タイムライン、RCA、対策が含まれている |

### 4.3 ビジネスルール（制約）

| 制約               | 説明                                                               |
| ------------------ | ------------------------------------------------------------------ |
| 非難なき文化の徹底 | 個人を責める表現は使用しない（「Xさんのミス」→「プロセスの欠陥」） |
| 48時間以内の作成   | インシデントクローズから48時間以内にポストモーテムを完成           |
| アクション追跡     | アクションアイテムはチケットシステムに登録して追跡可能に           |
| ナレッジベース登録 | 完成したポストモーテムはナレッジベースに登録し、検索可能に         |

---

## 5. インターフェース

### 5.1 入力

| データ名             | 提供元           | 検証ルール                       | 欠損時処理                   |
| -------------------- | ---------------- | -------------------------------- | ---------------------------- |
| インシデントチケット | triage Task      | 影響範囲、Severityが明記         | triage Taskに再確認依頼      |
| 根本原因分析結果     | investigate Task | 5 Whys分析が含まれる             | investigate Taskに再確認依頼 |
| 復旧確認レポート     | resolve Task     | タイムライン、復旧確認が含まれる | resolve Taskに再確認依頼     |

### 5.2 出力

| 成果物名               | 受領先                     | 内容                                             |
| ---------------------- | -------------------------- | ------------------------------------------------ |
| ポストモーテムレポート | ナレッジベース・運用チーム | 完全なポストモーテム文書、アクションアイテム一覧 |

#### 出力テンプレート

```markdown
## ポストモーテム: {{インシデントタイトル}}

### 基本情報

| 項目           | 内容                         |
| -------------- | ---------------------------- |
| インシデントID | {{INC-YYYY-MMDD-XXX}}        |
| タイトル       | {{簡潔なインシデント概要}}   |
| 発生日時       | {{YYYY-MM-DD HH:MM (JST)}}   |
| 検知日時       | {{YYYY-MM-DD HH:MM (JST)}}   |
| 解決日時       | {{YYYY-MM-DD HH:MM (JST)}}   |
| 影響時間       | {{XX分 / XX時間}}            |
| 重大度         | {{Critical/Major/Minor/Low}} |
| 担当者         | {{担当チーム名}}             |

### エグゼクティブサマリー

{{2-3文でインシデントの概要、根本原因、解決方法を記述}}

### タイムライン

| 時刻 (JST) | イベント                 |
| ---------- | ------------------------ |
| {{HH:MM}}  | {{最初の異常検知}}       |
| {{HH:MM}}  | {{トリアージ開始}}       |
| {{HH:MM}}  | {{調査開始}}             |
| {{HH:MM}}  | {{根本原因特定}}         |
| {{HH:MM}}  | {{解決アクション実行}}   |
| {{HH:MM}}  | {{サービス復旧確認}}     |
| {{HH:MM}}  | {{インシデントクローズ}} |

### 影響範囲

#### 影響を受けたサービス

- {{サービス1}}
- {{サービスN}}

#### 影響を受けたユーザー

- 推定影響ユーザー数: {{数値}}
- 影響の種類: {{完全停止 / 部分停止 / パフォーマンス低下}}

#### ビジネスインパクト

- 推定損失: {{金額/数値があれば}}
- 影響を受けた機能: {{リスト}}

### 根本原因分析 (RCA)

#### 直接原因

{{何が起きたか}}

#### 根本原因（5 Whys分析）

1. **Why?** {{表面的症状}}
   - 答え: {{原因1}}
2. **Why?** {{原因1はなぜ起きた？}}
   - 答え: {{原因2}}
3. **Why?** {{原因2はなぜ起きた？}}
   - 答え: {{原因3}}
4. **Why?** {{原因3はなぜ起きた？}}
   - 答え: {{原因4}}
5. **Why?** {{原因4はなぜ起きた？}}
   - 答え: {{根本原因}}

**根本原因**: {{最終的に特定された根本原因}}

#### 寄与要因

- {{他に影響を与えた要因}}

### 対応内容

#### 即時対応

1. {{実施した対応1}}
2. {{実施した対応N}}

#### 恒久対策

| 対策      | 担当       | 期限     | ステータス         |
| --------- | ---------- | -------- | ------------------ |
| {{対策1}} | {{担当者}} | {{期限}} | 未着手/進行中/完了 |
| {{対策N}} | {{担当者}} | {{期限}} | 未着手/進行中/完了 |

### 検知と対応の評価

#### 検知

- アラートは適切に発報されたか: {{Yes/No}}
- 検知までの時間: {{XX分}}
- 改善点: {{あれば記載}}

#### 対応

- 対応開始までの時間: {{XX分}}
- 解決までの時間: {{XX分}}
- エスカレーションは適切だったか: {{Yes/No}}
- 改善点: {{あれば記載}}

#### コミュニケーション

- ステークホルダーへの通知は適切だったか: {{Yes/No}}
- ユーザーへの通知は適切だったか: {{Yes/No}}
- 改善点: {{あれば記載}}

### 再発防止策

#### 短期（1週間以内）

- [ ] {{対策1}}
- [ ] {{対策N}}

#### 中期（1ヶ月以内）

- [ ] {{対策1}}
- [ ] {{対策N}}

#### 長期（四半期以内）

- [ ] {{対策1}}
- [ ] {{対策N}}

### 学んだこと

#### うまくいったこと

- {{良かった点1}}
- {{良かった点N}}

#### 改善が必要なこと

- {{改善点1}}
- {{改善点N}}

### アクションアイテム

| アイテム      | 担当       | 期限     | チケットID |
| ------------- | ---------- | -------- | ---------- |
| {{アイテム1}} | {{担当者}} | {{期限}} | {{ID}}     |
| {{アイテムN}} | {{担当者}} | {{期限}} | {{ID}}     |

### 添付資料

- [ ] アラートのスクリーンショット
- [ ] ダッシュボードのスクリーンショット
- [ ] 関連ログ
- [ ] 関連コミット/PR

### 承認

| 役割     | 名前         | 日付     |
| -------- | ------------ | -------- |
| 作成者   | {{作成者}}   | {{日付}} |
| レビュー | {{レビュー}} | {{日付}} |
| 承認者   | {{承認者}}   | {{日付}} |
```

---

## 関連リソース

- **Postmortem Best Practices**: See [references/postmortem-best-practices.md](../references/postmortem-best-practices.md)
- **応用ガイド**: See [references/Level3_advanced.md](../references/Level3_advanced.md)
- **Postmortem Template**: See [assets/postmortem-template.md](../assets/postmortem-template.md)
