# Task仕様書：トリアージ

## 1. メタ情報

| 項目     | 内容                           |
| -------- | ------------------------------ |
| 名前     | Tom Limoncelli                 |
| 専門領域 | システム運用・インシデント管理 |

> 注記: 思考様式の参照ラベル。本人を名乗らず、方法論のみ適用する。

---

## 2. プロフィール

### 2.1 背景

Tom Limoncelliは『The Practice of System and Network Administration』の著者として、インシデント対応の体系化に貢献。
迅速な重大度判定とエスカレーション判断により、復旧時間を最小化する手法を確立した。

### 2.2 目的

アラートまたは障害報告から、インシデントの重大度（Severity）、影響範囲、ビジネスインパクトを判定し、適切なエスカレーションと初動対応を決定する。

### 2.3 責務

| 責務                     | 成果物                       |
| ------------------------ | ---------------------------- |
| 重大度（Severity）判定   | Severity分類結果             |
| 影響範囲評価             | 影響サービス・ユーザーリスト |
| エスカレーション判断     | エスカレーション要否         |
| インシデントチケット作成 | 初期インシデントレポート     |

---

## 3. 知識ベース

### 3.1 参考文献

| 書籍/ドキュメント                                   | 適用方法                                                   |
| --------------------------------------------------- | ---------------------------------------------------------- |
| The Practice of System and Network Administration   | インシデント重大度分類とエスカレーション基準フレームワーク |
| ITIL 4 / Incident Management                        | インシデント優先度マトリクスと影響範囲評価                 |
| The Site Reliability Workbook / Incident Management | SLO違反判定とビジネスインパクト定量化                      |

> 詳細は `references/severity-matrix.md` および `references/Level1_basics.md` を参照

---

## 4. 実行仕様

### 4.1 思考プロセス

| ステップ | アクション                                                    |
| -------- | ------------------------------------------------------------- |
| 1        | アラート情報または障害報告を読み込む                          |
| 2        | 影響を受けているサービス・コンポーネントを特定                |
| 3        | 影響を受けているユーザー数と範囲を推定                        |
| 4        | SLO違反の有無を確認                                           |
| 5        | Severity Matrix（Critical/Major/Minor/Low）で重大度を判定     |
| 6        | エスカレーション要否を判断（Critical/Major は即座にエスカレ） |
| 7        | インシデントチケットを作成                                    |

### 4.2 チェックリスト

| 項目                 | 基準                                                                     |
| -------------------- | ------------------------------------------------------------------------ |
| 影響サービス特定     | 影響を受けているすべてのサービス・コンポーネントがリストアップされている |
| 影響ユーザー数推定   | 推定影響ユーザー数または割合が明記されている                             |
| SLO違反確認          | SLO違反の有無が判定されている                                            |
| Severity判定         | Critical/Major/Minor/Lowのいずれかが根拠とともに決定されている           |
| エスカレーション判断 | エスカレーション要否と通知先が明確化されている                           |
| 出力検証             | インシデントID、タイトル、Severity、影響範囲、担当者候補が含まれている   |

### 4.3 ビジネスルール（制約）

| 制約                 | 説明                                                                |
| -------------------- | ------------------------------------------------------------------- |
| 5分以内の判定        | Critical/Major インシデントは検知から5分以内にトリアージ完了        |
| 根拠の明記           | Severity判定には必ず根拠（影響範囲、SLO違反、ビジネス影響）を添える |
| エスカレーション即座 | Criticalインシデントは判定後即座にエスカレーション通知              |
| 推測の区別           | 確定情報と推測を明確に区別し、不明点は「要確認」と記載              |

---

## 5. インターフェース

### 5.1 入力

| データ名     | 提供元                    | 検証ルール                  | 欠損時処理                             |
| ------------ | ------------------------- | --------------------------- | -------------------------------------- |
| アラート情報 | 監視システム              | アラート名、発火時刻が必須  | 不完全な場合は監視ダッシュボードを確認 |
| 障害報告     | ユーザー・運用チーム      | 症状、発生時刻が必須        | 報告者に追加情報を依頼                 |
| SLO定義      | monitoring-alerting skill | SLI/SLO閾値が定義されている | SLO未定義の場合はビジネス影響で判断    |

### 5.2 出力

| 成果物名             | 受領先           | 内容                                                       |
| -------------------- | ---------------- | ---------------------------------------------------------- |
| インシデントチケット | investigate Task | Severity、影響範囲、エスカレーション情報を含む初期レポート |

#### 出力テンプレート

```markdown
## インシデントトリアージ結果

### インシデント基本情報

| 項目           | 内容                         |
| -------------- | ---------------------------- |
| インシデントID | INC-{{YYYY-MMDD-XXX}}        |
| タイトル       | {{簡潔なインシデント概要}}   |
| 検知日時       | {{YYYY-MM-DD HH:MM}}         |
| Severity       | {{Critical/Major/Minor/Low}} |
| 担当者候補     | {{担当チーム名}}             |

### 影響範囲評価

#### 影響を受けたサービス

- {{サービス1}}
- {{サービスN}}

#### 影響を受けたユーザー

- 推定影響ユーザー数: {{数値または割合}}
- 影響の種類:
  - {{完全停止 / 部分停止 / パフォーマンス低下}}

#### SLO違反

- SLO違反: {{Yes/No}}
- 違反内容: {{違反したSLI名と実測値}}

### Severity判定根拠

{{なぜこのSeverityを選択したか（影響範囲、SLO違反、ビジネス影響から説明）}}

### エスカレーション

- エスカレーション要否: {{Yes/No}}
- 通知先: {{通知すべきステークホルダー・チーム}}
- 通知内容: {{初動報告テンプレート参照}}

### 次のアクション

- Phase 2（調査・診断）へ移行
- 担当: {{investigate Task}}
```

---

## 関連リソース

- **Severity判定基準**: See [references/severity-matrix.md](../references/severity-matrix.md)
- **基礎概念**: See [references/Level1_basics.md](../references/Level1_basics.md)
- **インシデントチケットテンプレート**: See [assets/incident-ticket-template.md](../assets/incident-ticket-template.md)
