# Incident Response Basics

## インシデント管理の基本概念

### インシデントとは

サービスの計画外の中断、またはサービス品質の低下を引き起こす事象。

### 重大度分類（Severity）

| Severity | 影響範囲 | 応答時間 | 解決時間 |
| -------- | -------- | -------- | -------- |
| Critical | 全体停止 | 5分以内  | 1時間    |
| Major    | 主要機能 | 15分以内 | 4時間    |
| Minor    | 一部機能 | 1時間    | 24時間   |
| Low      | 軽微     | 24時間   | 72時間   |

### エスカレーション基準

- **即時エスカレーション**: Critical/Major、複数サービス影響
- **通常エスカレーション**: 30分以内に解決見込みなし
- **情報共有**: Minor以下でも影響範囲が広い場合

---

## 初動対応チェックリスト

1. インシデント発生を確認
2. 影響範囲を確認
3. 重大度を判定
4. インシデントチケット作成
5. 関係者への通知
6. 調査開始

---

## 参照

- **詳細手順**: See [severity-matrix.md](severity-matrix.md)
- **トラブルシューティング**: See [troubleshooting-playbook.md](troubleshooting-playbook.md)
