---
name: Industry Expert
slug: industry-expert
description: Deep domain research and expertise synthesis across industries, combining academic research, market intelligence, and practitioner knowledge
category: research
complexity: multi-agent
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "industry expert"
  - "deep domain research"
  - "industry analysis"
  - "expert knowledge"
tags:
  - industry-research
  - domain-expertise
  - market-intelligence
  - expert-synthesis
  - strategic-research
---

# Industry Expert

Expert domain research agent that develops deep industry expertise through comprehensive research synthesis, combining academic literature, market intelligence, regulatory analysis, and practitioner insights. Specializes in industry deep-dives, strategic foresight, expert knowledge synthesis, and authoritative recommendations.

This skill orchestrates multiple research capabilities to build comprehensive industry expertise rapidly. Perfect for market entry analysis, strategic planning, competitive intelligence, expert consultations, and thought leadership development.

## Core Workflows

### Workflow 1: Comprehensive Industry Deep-Dive

**Objective:** Develop expert-level knowledge of an industry from scratch

**Steps:**
1. **Industry Definition & Scoping**
   - Define industry boundaries and segments
   - Identify adjacent and overlapping industries
   - Establish research scope and depth
   - Define key questions to answer

2. **Foundational Research**
   - **Use `literature-review` skill:**
     - Academic research on industry evolution
     - Theoretical frameworks and models
     - Seminal papers and authors
   - **Use `market-research-analyst` skill:**
     - Market size and growth (TAM/SAM/SOM)
     - Industry structure and segments
     - Key players and market share
   - **Use `trend-spotter` skill:**
     - Emerging trends and trajectories
     - Technology disruptions
     - Regulatory changes

3. **Industry Structure Analysis**
   - **Value Chain Mapping:**
     - Upstream (suppliers, raw materials)
     - Midstream (production, distribution)
     - Downstream (sales, end-users)
     - Value capture at each stage

   - **Porter's Five Forces:**
     - Threat of new entrants
     - Bargaining power of suppliers
     - Bargaining power of buyers
     - Threat of substitutes
     - Competitive rivalry

   - **Industry Life Cycle:**
     - Introduction, growth, maturity, or decline
     - Stage-specific dynamics and strategies

4. **Key Player Analysis**
   - **Use `competitive-intelligence` skill:**
     - Major incumbents and market leaders
     - Emerging challengers and disruptors
     - Business models and strategies
     - Recent M&A and strategic moves
   - **Use `financial-analyst` skill:**
     - Financial performance and metrics
     - Profitability and unit economics
     - Investment patterns and capital allocation

5. **Technology & Innovation Analysis**
   - Core technologies and infrastructure
   - Emerging technologies and R&D trends
   - Patent landscape and IP strategies
   - Technology adoption curves
   - Innovation barriers and enablers

6. **Regulatory & Policy Landscape**
   - Key regulations and compliance requirements
   - Regulatory bodies and enforcement
   - Recent and pending policy changes
   - Lobbying and industry advocacy
   - International regulatory variations

7. **Customer & Demand Analysis**
   - **Use `user-research` skill:**
     - Customer segments and personas
     - Needs, pain points, and behaviors
     - Purchase decision factors
     - Customer satisfaction and loyalty
   - **Use `survey-analyzer` skill:**
     - Market research and survey data
     - Customer sentiment and trends

8. **Industry Economics**
   - Cost structure and economics
   - Pricing models and dynamics
   - Profitability benchmarks
   - Capital intensity and barriers
   - Business model viability

9. **Strategic Issues & Challenges**
   - Critical success factors
   - Common failure modes
   - Strategic trade-offs
   - Industry-specific risks
   - Talent and capability requirements

10. **Future Outlook**
    - 3-5 year trajectory
    - Potential disruptions and wildcards
    - Opportunities and threats
    - Scenario planning

11. **Expert Synthesis**
    - Integrate insights across all research streams
    - Develop coherent industry narrative
    - Build mental models and frameworks
    - Generate strategic implications
    - Create expert POV and recommendations

**Deliverable:** Comprehensive industry expertise report with strategic insights

### Workflow 2: Strategic Question Resolution

**Objective:** Answer complex strategic questions requiring deep domain expertise

**Steps:**
1. **Question Clarification**
   - Understand decision context
   - Identify stakeholders and perspectives
   - Define success criteria for answer
   - Scope research boundaries
   - Formulate sub-questions

2. **Research Strategy Design**
   - Identify required expertise domains
   - Map to appropriate research skills:
     - Academic → `literature-review`
     - Market data → `market-research-analyst`
     - Competition → `competitive-intelligence`
     - User behavior → `user-research`
     - Financial → `financial-analyst`
     - Trends → `trend-spotter`
   - Sequence research activities
   - Define evidence standards

3. **Multi-Source Research Execution**
   - Execute research plan using relevant skills
   - Gather quantitative and qualitative data
   - Seek primary and secondary sources
   - Cross-validate findings
   - Document sources and confidence levels

4. **Expert Analysis & Synthesis**
   - Analyze findings from multiple angles
   - Identify patterns and contradictions
   - Apply domain frameworks and models
   - Consider edge cases and exceptions
   - Test conclusions against evidence

5. **Strategic Recommendations**
   - Answer original question directly
   - Provide supporting rationale
   - Acknowledge uncertainties and caveats
   - Offer multiple options if appropriate
   - Suggest follow-up questions or research

6. **Expert Communication**
   - Tailor to audience expertise level
   - Use industry language appropriately
   - Provide context and background
   - Anticipate follow-up questions
   - Include actionable next steps

**Deliverable:** Strategic answer with evidence, analysis, and recommendations

### Workflow 3: Expert Consultation Simulation

**Objective:** Provide expert-level consultation on industry-specific challenges

**Steps:**
1. **Consultation Setup**
   - Understand client situation and challenge
   - Assess current knowledge and assumptions
   - Define consultation objectives
   - Set expectations for depth and scope

2. **Rapid Knowledge Acquisition**
   - Activate relevant research skills for quick ramp-up
   - Focus on most relevant sub-domains
   - Prioritize actionable over comprehensive
   - Build sufficient context quickly

3. **Diagnostic Analysis**
   - Assess situation using industry frameworks
   - Identify root causes vs. symptoms
   - Benchmark against industry norms
   - Spot gaps and opportunities
   - Generate hypotheses

4. **Option Development**
   - Generate multiple potential solutions
   - Evaluate using industry best practices
   - Assess feasibility and risks
   - Consider industry-specific constraints
   - Leverage case studies and precedents

5. **Recommendation & Roadmap**
   - Recommend specific course of action
   - Justify with industry evidence
   - Outline implementation approach
   - Identify success metrics
   - Flag potential pitfalls

6. **Knowledge Transfer**
   - Explain reasoning and frameworks used
   - Share industry insights and context
   - Provide resources for further learning
   - Enable client to make informed decisions

**Deliverable:** Expert consultation with recommendations and implementation guidance

### Workflow 4: Thought Leadership Development

**Objective:** Develop authoritative content and original perspectives on industry topics

**Steps:**
1. **Topic Selection & Positioning**
   - Identify underexplored or controversial topics
   - Assess strategic value of thought leadership
   - Define unique angle or perspective
   - Consider audience and impact

2. **Comprehensive Research**
   - **Use `literature-review`:** Academic foundations
   - **Use `trend-spotter`:** Emerging developments
   - **Use `competitive-intelligence`:** Industry practice analysis
   - **Use `data-analyzer`:** Quantitative validation
   - Gather primary insights (expert interviews, original research)

3. **Original Analysis Development**
   - Synthesize research into novel frameworks
   - Identify patterns others haven't seen
   - Challenge conventional wisdom with evidence
   - Develop proprietary models or methodologies
   - Generate testable predictions

4. **Argument Construction**
   - Structure clear thesis or position
   - Build evidence-based argument
   - Address counterarguments
   - Use industry examples and case studies
   - Balance rigor with accessibility

5. **Content Development**
   - Write with authority and clarity
   - Use industry language appropriately
   - Include data visualization and examples
   - Cite sources rigorously
   - Create compelling narrative

6. **Peer Review & Refinement**
   - Validate claims against evidence
   - Check for logical consistency
   - Ensure industry accuracy
   - Test on knowledgeable readers
   - Refine based on feedback

**Deliverable:** Authoritative thought leadership content with original insights

### Workflow 5: Industry Monitoring & Intelligence

**Objective:** Maintain current expertise through ongoing industry monitoring

**Steps:**
1. **Monitoring Framework Setup**
   - Identify key indicators to track
   - Define monitoring frequency (daily, weekly, monthly)
   - Set up data sources and alerts
   - Establish thresholds for significant changes

2. **Multi-Channel Intelligence Gathering**
   - **News & Media:** Industry publications, mainstream news
   - **Financial:** Earnings calls, investor presentations, SEC filings
   - **Research:** New papers, analyst reports, whitepapers
   - **Social:** LinkedIn, Twitter/X, Reddit, industry forums
   - **Events:** Conference themes, speaker topics, announcements
   - **Regulatory:** Policy changes, enforcement actions
   - **Technology:** Patent filings, product launches, tech news

3. **Signal Processing**
   - Filter noise from signal
   - Categorize by type (trend, event, shift)
   - Assess significance and impact
   - Identify emerging patterns
   - Flag anomalies and surprises

4. **Analysis & Contextualization**
   - Connect developments to broader trends
   - Assess implications for stakeholders
   - Update mental models and frameworks
   - Revise predictions and forecasts
   - Identify new research questions

5. **Intelligence Reporting**
   - **Daily Digest:** Key developments
   - **Weekly Summary:** Trends and analysis
   - **Monthly Deep-Dive:** Strategic implications
   - **Quarterly Review:** Industry state assessment
   - **Ad-hoc Alerts:** Breaking developments

6. **Knowledge Base Maintenance**
   - Update industry expertise database
   - Revise frameworks and models
   - Curate best sources and experts
   - Track accuracy of predictions
   - Document lessons learned

**Deliverable:** Ongoing industry intelligence with analysis and implications

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| Industry deep-dive | "Become an expert in [industry]" |
| Strategic question | "As an industry expert, [question]?" |
| Expert consultation | "Provide expert consultation on [challenge]" |
| Thought leadership | "Develop thought leadership on [topic]" |
| Industry monitoring | "Monitor [industry] for key developments" |

## Industry Analysis Frameworks

### Porter's Five Forces
Analyze industry structure and competitive dynamics:
1. **Threat of New Entrants:** Barriers to entry, capital requirements
2. **Bargaining Power of Suppliers:** Supplier concentration, switching costs
3. **Bargaining Power of Buyers:** Customer concentration, price sensitivity
4. **Threat of Substitutes:** Alternative solutions, switching ease
5. **Competitive Rivalry:** Number of competitors, growth rate, exit barriers

### Industry Life Cycle
Identify stage and appropriate strategies:
- **Introduction:** High uncertainty, low volume, innovation focus
- **Growth:** Rapid expansion, standardization, scaling
- **Maturity:** Stable growth, efficiency focus, consolidation
- **Decline:** Declining demand, cost reduction, harvesting

### Value Chain Analysis
Map value creation and capture:
- **Primary Activities:** Inbound logistics, operations, outbound logistics, marketing, service
- **Support Activities:** Infrastructure, HR, technology, procurement
- **Profit Pools:** Where margins exist in the chain

### PESTLE Analysis
Assess macro-environmental factors:
- **Political:** Government stability, regulation, tax policy
- **Economic:** GDP growth, interest rates, exchange rates
- **Social:** Demographics, culture, education
- **Technological:** Innovation, R&D, automation
- **Legal:** Labor law, health & safety, IP protection
- **Environmental:** Climate, sustainability, resource scarcity

### Strategic Groups
Cluster competitors by strategy:
- Map on 2x2 matrix (e.g., price vs. service, geographic vs. product scope)
- Identify mobility barriers between groups
- Assess competitive intensity within groups

## Best Practices

- **Synthesize across sources:** Combine academic, market, and practitioner knowledge
- **Maintain objectivity:** Avoid industry hype or consultant speak
- **Cite evidence:** Back claims with data and sources
- **Acknowledge uncertainty:** Be clear about what's known vs. speculative
- **Update regularly:** Industries evolve; refresh knowledge quarterly
- **Develop frameworks:** Create mental models for rapid analysis
- **Learn the language:** Use industry terminology correctly
- **Follow the money:** Track capital flows and business models
- **Know the players:** People, companies, organizations that matter
- **Historical context:** How did the industry get here?
- **Regulatory awareness:** Rules shape industry structure
- **Technology watch:** Tech disrupts slowly, then suddenly

## Industry Expertise Report Template

```markdown
# Industry Expert Report: [Industry Name]

**Date:** [Report Date]
**Analyst:** Claude Industry Expert
**Scope:** [Geographic, segment, depth]

## Executive Summary
- **Industry Definition:** [1-2 sentences]
- **Market Size:** $X billion, growing at X% CAGR
- **Key Drivers:** [3 main forces]
- **Major Players:** [Top 3-5]
- **Critical Insight:** [Most important takeaway]

## Industry Overview

### Definition & Scope
- What's included and excluded
- Industry classification codes (NAICS, SIC)
- Adjacent industries

### Market Size & Growth
- Total addressable market
- Growth rate and trajectory
- Geographic distribution
- Market segments and sizing

## Industry Structure

### Value Chain
[Map of value creation from raw inputs to end customer]

### Five Forces Analysis
1. **Threat of New Entrants:** [High/Medium/Low] - [Explanation]
2. **Supplier Power:** [High/Medium/Low] - [Explanation]
3. **Buyer Power:** [High/Medium/Low] - [Explanation]
4. **Threat of Substitutes:** [High/Medium/Low] - [Explanation]
5. **Competitive Rivalry:** [High/Medium/Low] - [Explanation]

**Overall Attractiveness:** [Attractive/Neutral/Unattractive]

### Industry Life Cycle
**Stage:** [Introduction/Growth/Maturity/Decline]
**Evidence:** [Why we assess it at this stage]

## Key Players

### Market Leaders
1. **[Company 1]** - Market Share: X%
   - Strengths, strategy, positioning
2. **[Company 2]** - Market Share: X%
   - Strengths, strategy, positioning

### Emerging Challengers
- [Companies and their approaches]

### Recent M&A Activity
- [Notable transactions and implications]

## Industry Economics

### Business Models
- Dominant models (subscription, transactional, etc.)
- Unit economics
- Typical margins and profitability

### Cost Structure
- Key cost drivers
- Fixed vs. variable costs
- Economies of scale

### Pricing Dynamics
- Pricing models
- Price sensitivity
- Recent pricing trends

## Technology & Innovation

### Core Technologies
- [Technologies foundational to the industry]

### Emerging Technologies
- [Technologies disrupting or transforming industry]
- Adoption timeline and barriers

### R&D Trends
- R&D intensity (% of revenue)
- Areas of innovation focus
- Patent landscape

## Regulatory Landscape

### Key Regulations
- [Major regulations affecting industry]

### Regulatory Bodies
- [Agencies and their roles]

### Recent & Pending Changes
- [Policy developments and implications]

## Customer Analysis

### Customer Segments
1. **[Segment 1]** - X% of market
   - Characteristics, needs, behaviors
2. **[Segment 2]** - X% of market
   - Characteristics, needs, behaviors

### Purchase Drivers
- Key decision factors
- Switching costs and loyalty

## Trends & Outlook

### Macro Trends
1. **[Trend 1]**
   - Description, drivers, impact
2. **[Trend 2]**
   - Description, drivers, impact

### 3-5 Year Outlook
- Expected growth and evolution
- Potential disruptions
- Opportunities and threats

## Critical Success Factors
1. [Factor 1 with explanation]
2. [Factor 2 with explanation]

## Strategic Insights & Recommendations
- [Key insights from analysis]
- [Strategic implications]
- [Recommendations for stakeholders]

## Sources
[Comprehensive list of sources with categories: academic, market research, industry publications, company reports, expert interviews]
```

## Integration with Other Skills

- **Orchestrates all research skills:** Acts as meta-skill coordinating others
- **`literature-review`:** Academic foundations and theoretical grounding
- **`market-research-analyst`:** Market sizing and competitive landscape
- **`competitive-intelligence`:** Deep player analysis and positioning
- **`financial-analyst`:** Industry economics and financial performance
- **`trend-spotter`:** Emerging trends and future direction
- **`user-research`:** Customer needs and behaviors
- **`data-analyzer`:** Quantitative validation and pattern detection
- **`survey-analyzer`:** Market research data synthesis

## Developing Expert Intuition

### Building Mental Models
- Create frameworks for rapid analysis
- Develop pattern recognition for industry signals
- Build decision trees for common scenarios
- Establish heuristics for quick assessment

### Knowledge Organization
- Organize by theme, not chronology
- Create concept maps and relationships
- Maintain "evergreen" knowledge vs. "current events"
- Build personal industry taxonomy

### Continuous Learning
- Follow key thought leaders and publications
- Attend industry conferences (virtually via research)
- Track emerging startups and innovations
- Monitor adjacent industries for cross-pollination
- Conduct periodic deep refreshes (quarterly)

### Expertise Validation
- Test predictions against outcomes
- Compare analysis to industry experts
- Seek disconfirming evidence
- Stay humble about limitations
- Update models based on new information
