---
name: influencer-outreach-template
description: Эксперт influencer outreach. Используй для шаблонов писем, partnership proposals и collaboration briefs.
---

# Influencer Outreach Templates

Expert in creating personalized, high-converting influencer outreach communications.

## Core Framework

### Personalization Approach
- Deep research into recent content and engagement patterns
- Lead with mutual benefits rather than brand-only needs
- Match communication style to influencer's voice
- Time outreach around posting schedules
- Reference specific content to show genuine familiarity

### Campaign Hierarchy
1. Warm introduction with specific content reference
2. Clear collaboration benefits presentation
3. Timeline and compensation details
4. Non-aggressive follow-up sequence

## Subject Line Examples

```yaml
High-Performing Subjects:
  personal_connection:
    - "Loved your [specific post/video] about [topic] 💡"
    - "Your [recent content] inspired this collaboration idea"
    - "Quick question about your [topic] content"

  mutual_value:
    - "Quick collab idea for [influencer name] x [brand name]"
    - "[Brand] + [Influencer] = perfect match?"
    - "Partnership opportunity aligned with your [niche]"

  social_proof:
    - "[Mutual connection] suggested we connect"
    - "Following up from [industry event/platform]"
    - "[Similar influencer] loved working with us"

  curiosity:
    - "Your [content type] style = perfect fit for [brand/campaign]"
    - "Something special for your [audience type] followers"
    - "Exclusive opportunity for [niche] creators"

Avoid:
  - Generic "Collaboration Opportunity" subjects
  - ALL CAPS or excessive punctuation
  - Clickbait or misleading promises
  - Overly long subject lines (>50 chars)
```

## Initial Outreach Templates

### Nano/Micro-Influencer (1K-100K)

```markdown
Subject: Loved your [specific recent content] 🌟

Hi [First Name],

I've been following your content for a while, and your [recent post about X]
really resonated with me. The way you [specific detail] was spot-on.

I'm [Your Name] from [Brand], and I think your authentic approach to
[their niche] would be a perfect fit for our community.

We'd love to collaborate with you on a [campaign type]:

📦 What we're offering:
• [Product/service] valued at $[X]
• [Compensation amount or "negotiable based on deliverables"]
• [Affiliate commission X%] on sales through your link
• Long-term partnership potential

📸 What we're looking for:
• [Number] [post type] featuring [product/campaign]
• Authentic review sharing your honest experience
• [Timeline expectations]

Would you be interested in chatting about this? I'd love to share more
details and hear your creative ideas.

Best,
[Your Name]
[Title] | [Brand]
[Calendar link or email]
```

### Macro-Influencer (100K-1M)

```markdown
Subject: Partnership Proposal: [Brand] x [Influencer Name]

Hi [First Name],

Your [specific content piece] perfectly captures what we stand for at [Brand]
– [shared value/mission]. Your audience's engagement with your [content type]
shows genuine connection that we deeply respect.

**The Opportunity:**

[Brand] is launching [campaign/product], and your voice would add authentic
credibility that paid ads simply can't replicate.

**Collaboration Details:**

| Component | Details |
|-----------|---------|
| Campaign | [Campaign name/theme] |
| Timeline | [Start - End dates] |
| Deliverables | [X posts, Y stories, Z video] |
| Compensation | $[Base fee] + [Performance bonus structure] |
| Exclusivity | [Category/timeline] |

**Why [Influencer Name]:**
- Your [specific audience demographic] aligns with our target market
- Your content about [topic] demonstrates expertise we value
- [Specific engagement metric] shows genuine audience connection

I'd love to schedule a 15-minute call to discuss creative direction and
answer any questions. Would [Day] or [Day] work for you?

[Calendar booking link]

Looking forward to potentially creating something amazing together.

Best regards,
[Your Name]
[Title] | [Brand]
[Phone] | [Email]
```

### Celebrity/Mega-Influencer (1M+)

```markdown
Subject: [Brand] Partnership Proposal for [Influencer Name]

Dear [Manager/Agent Name] and [Influencer Name],

[Brand] respectfully submits this partnership proposal for [Influencer Name]'s
consideration.

**Executive Summary:**

[Brand] ([brief description, key metrics]) seeks to partner with [Influencer]
for our [Campaign Name] launching [Date]. This campaign aligns with
[Influencer]'s established values around [shared values].

**Proposed Partnership:**

Campaign Period: [Dates]
Total Compensation: $[Amount] + [Performance incentives]
Content Deliverables: [Detailed breakdown]
Usage Rights: [Scope and duration]
Exclusivity: [Terms]

**Strategic Fit:**

[2-3 paragraphs explaining why this partnership makes sense, including:
- Audience overlap data
- Brand values alignment
- Previous successful collaborations in similar space]

**Next Steps:**

We're prepared to discuss terms at your earliest convenience. Please find
attached our detailed proposal deck and brand guidelines.

Contact: [Name], [Title]
Email: [Email] | Phone: [Phone]

Respectfully,
[Signature]
```

## Follow-Up Sequence

### Follow-Up #1 (Day 3-5)

```markdown
Subject: Re: [Original subject line]

Hi [First Name],

I wanted to follow up on my previous email about collaborating on [campaign].

I know your inbox is probably overflowing, so I wanted to quickly add that
we've just [new relevant development - product launch, campaign update,
social proof].

If now isn't the right time, no worries at all – I'd love to stay connected
for future opportunities.

Best,
[Your Name]
```

### Follow-Up #2 (Day 10-14)

```markdown
Subject: Quick resource for your [topic] content

Hi [First Name],

I came across [relevant industry resource/trend/data] and immediately
thought of your content about [their topic]. Thought you might find it
useful: [link]

If our [Brand] collaboration isn't the right fit, I completely understand.
If you'd prefer not to receive outreach, just let me know.

Either way, keep creating amazing [content type] – your community clearly
appreciates it!

Cheers,
[Your Name]
```

### Final Follow-Up (Day 21-28)

```markdown
Subject: Closing the loop on [Brand] partnership

Hi [First Name],

This will be my last follow-up about our [campaign] collaboration.

Quick recap of the opportunity:
• [Key benefit 1]
• [Key benefit 2]
• [Key benefit 3]

If you'd like to explore this now or in the future, I'm here. If not,
thanks for your time, and I'll continue enjoying your content!

Best,
[Your Name]
```

## Compensation Guidelines

```yaml
Rate Benchmarks:
  nano_1k_10k:
    instagram_post: "$10-100"
    instagram_story: "$5-50"
    tiktok_video: "$25-200"
    youtube_mention: "$50-250"

  micro_10k_100k:
    instagram_post: "$100-1,000"
    instagram_story: "$50-250"
    tiktok_video: "$200-2,500"
    youtube_integration: "$500-5,000"

  macro_100k_1m:
    instagram_post: "$1,000-10,000"
    instagram_story: "$250-1,000"
    tiktok_video: "$2,500-25,000"
    youtube_dedicated: "$5,000-50,000"

  mega_1m_plus:
    instagram_post: "$10,000+"
    tiktok_video: "$25,000+"
    youtube_dedicated: "$50,000+"

Premium Adjustments:
  video_content: "+50-100%"
  usage_rights: "+20-40%"
  exclusivity: "+30-60%"
  whitelisting: "+20-30%"
  rush_delivery: "+25-50%"
```

## Negotiation Scripts

### Handling Rate Pushback

```markdown
"I appreciate you sharing your standard rates. Based on our campaign scope
of [deliverables] and the [X-month] partnership duration, we can offer
$[counter-amount]. This also includes:

• [Additional benefit 1]
• [Additional benefit 2]
• Performance bonus up to $[X] based on [metric]

Would this structure work for you?"
```

### Requesting Lower Rates

```markdown
"Thank you for the rate card. Our budget for this campaign is $[amount],
but we're really excited about working with you specifically because
[genuine reason].

Could we explore:
• Reduced deliverables that fit our budget?
• Affiliate commission to supplement the base rate?
• A trial collaboration with potential for larger paid partnership?

We want to find something that works for both of us."
```

## Collaboration Brief Template

```yaml
Campaign Brief:

Overview:
  brand: "[Brand Name]"
  campaign_name: "[Campaign Title]"
  dates: "[Start] - [End]"
  contact: "[Name, Email, Phone]"

Objectives:
  primary: "[Awareness/Consideration/Conversion]"
  kpis:
    - "Impressions: [Target]"
    - "Engagement Rate: [Target]%"
    - "Link Clicks: [Target]"
    - "Conversions: [Target]"

Product/Service:
  name: "[Product Name]"
  key_features:
    - "[Feature 1]"
    - "[Feature 2]"
  unique_value: "[Why it's special]"
  link: "[URL]"

Creative Direction:
  tone: "[Authentic, Educational, Fun, Inspirational]"
  visual_style: "[Description or mood board link]"

  must_include:
    - "[Key message 1]"
    - "[Key message 2]"
    - "@[brand_handle]"
    - "[Required hashtags]"
    - "Disclosure: #ad or #sponsored"

  avoid:
    - "[Competitor mentions]"
    - "[Specific claims we can't make]"
    - "[Off-brand content types]"

  example_content: "[Links to examples we like]"

Deliverables:
  - type: "[Post/Story/Reel/Video]"
    platform: "[Platform]"
    quantity: "[Number]"
    deadline: "[Date]"

  approval_process:
    - "Submit concept by [Date]"
    - "Brand review: 48 hours"
    - "Revisions if needed: 24 hours"
    - "Final approval"
    - "Post within [window]"

Compensation:
  base_fee: "$[Amount]"
  payment_terms: "[50% upfront, 50% on completion]"
  bonus: "[Performance incentive details]"
  product_value: "$[Amount]"

Usage_Rights:
  duration: "[X months/perpetual]"
  platforms: "[Where brand can use content]"
  paid_amplification: "[Yes/No - boosting rights]"
```

## Performance Tracking

```yaml
Metrics to Request:
  reach:
    - Impressions
    - Unique viewers
    - Reach by demographics

  engagement:
    - Likes, comments, shares, saves
    - Engagement rate
    - Comment sentiment

  conversion:
    - Link clicks (UTM tracked)
    - Promo code usage
    - Affiliate sales
    - Sign-ups/conversions

  brand_impact:
    - Brand mention sentiment
    - Follower growth
    - DM inquiries

Reporting Template:
  "Please provide analytics screenshot within 48-72 hours of posting showing:
   - Total reach/impressions
   - Engagement breakdown
   - Link clicks (if applicable)
   - Story views and interactions"
```

## Лучшие практики

1. **Research first** — изучите контент перед outreach
2. **Personalize everything** — generic emails не работают
3. **Lead with value** — что получит инфлюенсер?
4. **Clear expectations** — конкретные deliverables и сроки
5. **Professional follow-ups** — не более 3 follow-up писем
6. **Fair compensation** — уважайте их работу и ставки
