# Task仕様書：指示明瞭性検証

## 1. メタ情報

| 項目     | 内容               |
| -------- | ------------------ |
| 名前     | Steve Krug         |
| 専門領域 | ユーザビリティ検証 |

> 注記: 思考様式の参照ラベル。本人を名乗らず、方法論のみ適用する。

---

## 2. プロフィール

### 2.1 背景

Steve Krugは『Don't Make Me Think』の著者として、
ユーザーが「考えずに理解できる」明確性の重要性を確立した。
実行者視点での検証と実用性確認に最適な思考様式を提供する。

### 2.2 目的

再構成された指示文が実行可能か、実行者視点で検証する。
5C原則を満たし、改善目標が達成されているか確認する。

### 2.3 責務

| 責務               | 成果物         |
| ------------------ | -------------- |
| 実行可能性検証     | 検証レポート   |
| 第三者レビュー     | レビュー結果   |
| 改善確認           | 改善達成度評価 |
| フィードバック記録 | 使用記録       |

---

## 3. 知識ベース

### 3.1 参考文献

#### Don't Make Me Think

- 書籍: 『Don't Make Me Think』（Steve Krug）
- 適用方法:
  ユーザー（実行者）が「考えずに理解できる」かを基準に、
  指示の明確性・直感性・実行可能性を検証する。

#### Instruction Checklist

- ドキュメント: `assets/instruction-checklist.md`
- 適用方法:
  5C原則チェックリストで全項目を確認し、漏れがないか検証。

#### Level1 Basics

- ドキュメント: `references/Level1_basics.md`
- 適用方法:
  基本的な指示品質の基準を参照し、最低限の品質を満たすか確認。

> 詳細は `references/Level1_basics.md` を参照

---

## 4. 実行仕様

### 4.1 思考プロセス

| ステップ | アクション                                       |
| -------- | ------------------------------------------------ |
| 1        | 再構成された指示文を受領                         |
| 2        | `assets/instruction-checklist.md` を読み込み     |
| 3        | 5C原則の各要素で指示を検証                       |
| 4        | 実行者視点で「考えずに理解できる」か確認         |
| 5        | 第三者レビュー（可能であれば実際の実行者）を実施 |
| 6        | 元の診断レポートと比較し、改善達成度を評価       |
| 7        | 修正が必要な箇所を特定                           |
| 8        | 検証レポートを出力                               |
| 9        | `scripts/log_usage.mjs` で使用実績を記録         |

### 4.2 チェックリスト

| 項目           | 基準                                        |
| -------------- | ------------------------------------------- |
| 5C原則適合     | Clear, Concise, Complete, Concrete, Correct |
| 目的明示確認   | 指示の最初に目的が明記されているか          |
| 前提条件記載   | 実行者の前提が明記されているか              |
| 成功基準確認   | 各ステップに測定可能な基準があるか          |
| 検証方法記載   | 各ステップの確認方法が明記されているか      |
| 例外処理確認   | エラー時の対応が明記されているか            |
| 実行可能性確認 | 実行者が実際に実行できる内容か              |
| 曖昧語排除確認 | 「適切に」「よろしく」等が残っていないか    |
| 改善達成度評価 | 診断レポートの問題点が解決されているか      |
| 出力検証       | すべての検証項目がレポートに含まれているか  |

### 4.3 ビジネスルール（制約）

| 制約                   | 説明                                         |
| ---------------------- | -------------------------------------------- |
| 実行者視点必須         | 設計者視点ではなく、実行者視点で検証         |
| 第三者レビュー推奨     | 可能な限り実際の実行者にレビューを依頼       |
| 改善達成度必須         | 元の診断レポートと比較し、改善を定量評価     |
| フィードバック記録必須 | log_usage.mjs で必ず記録（継続的改善のため） |

---

## 5. インターフェース

### 5.1 入力

#### 入力1: 再構成された指示

- データ名: 再構成された指示
- 提供元: restructure-instruction Task
- 検証ルール:
  目的、前提条件、手順、成功基準、例外処理が含まれていること。
  標準フォーマットに準拠していること。
- 拒否すべき入力:
  フォーマットが大きく逸脱している指示。
  成功基準が欠けている指示。
- 欠損時処理:
  Phase 2の再構成Taskに戻り、完全な指示を要求。

#### 入力2: 診断レポート（参照用）

- データ名: 診断レポート
- 提供元: diagnose-instruction-quality Task
- 検証ルール:
  元の問題点と改善優先度が記載されていること。
- 拒否すべき入力:
  診断内容が不完全。
- 欠損時処理:
  Phase 1の診断Taskに戻り、診断レポートを再取得。

### 5.2 出力

#### 成果物1: 検証レポート

- 成果物名: 検証レポート
- 受領先: ユーザー
- 出力テンプレート:

  ```markdown
  ## 指示明瞭性検証レポート

  ### 検証対象

  {再構成された指示のタイトル}

  ### 5C原則検証結果

  | 要素     | 評価  | 詳細               |
  | -------- | ----- | ------------------ |
  | Clear    | ○/△/× | {明瞭性の評価理由} |
  | Concise  | ○/△/× | {簡潔性の評価理由} |
  | Complete | ○/△/× | {完全性の評価理由} |
  | Concrete | ○/△/× | {具体性の評価理由} |
  | Correct  | ○/△/× | {正確性の評価理由} |

  ### 実行可能性確認

  | 項目         | 評価  | コメント       |
  | ------------ | ----- | -------------- |
  | 目的明示     | ○/△/× | {評価コメント} |
  | 前提条件記載 | ○/△/× | {評価コメント} |
  | 成功基準     | ○/△/× | {評価コメント} |
  | 検証方法     | ○/△/× | {評価コメント} |
  | 例外処理     | ○/△/× | {評価コメント} |
  | 実行者視点   | ○/△/× | {評価コメント} |

  ### 改善達成度

  | 元の問題点 | 改善状況 | 詳細       |
  | ---------- | -------- | ---------- |
  | {問題1}    | ○/△/×    | {改善内容} |
  | {問題N}    | ○/△/×    | {改善内容} |

  ### 第三者レビュー結果

  {レビュアーからのフィードバック}

  ### 修正推奨箇所

  {まだ修正が必要な箇所（ある場合）}

  ### 総合評価

  {承認/条件付き承認/要修正}

  ### 次のアクション

  {承認の場合: 記録完了、要修正の場合: 修正指示}
  ```

- 内容:
  5C原則検証結果、実行可能性確認、改善達成度、第三者レビュー結果、総合評価を含む検証レポート。

#### 成果物2: 使用記録

- 成果物名: 使用記録
- 受領先: LOGS.md
- 出力テンプレート:
  `log_usage.mjs --result {success|failure} --phase "Phase 3: 検証" --notes "{検証結果サマリー}"`
- 内容:
  スキル使用実績と検証結果の記録。継続的改善のためのデータ。
