# 指示品質チェックリスト

指示を作成・レビューする際に使用するチェックリスト。

## 5C原則チェック

### Clear（明瞭）

- [ ] 主語と述語が明確か
- [ ] 専門用語に説明があるか（または共通理解がある）
- [ ] 一文一義（一つの文で一つの意味）か
- [ ] 100文字以内の文に分割されているか

### Concise（簡潔）

- [ ] 冗長な修飾語がないか
- [ ] 同じ内容を繰り返していないか
- [ ] 実行に不要な背景情報を含んでいないか

### Complete（完全）

- [ ] 前提条件が明記されているか
- [ ] すべてのステップが記載されているか
- [ ] 例外処理の方法が書かれているか
- [ ] 成功基準が明記されているか
- [ ] 検証方法が示されているか

### Concrete（具体的）

- [ ] 「適切に」「よろしく」などの曖昧語がないか
- [ ] 数値基準が明確か（時間、量、サイズなど）
- [ ] 具体例が含まれているか

### Correct（正確）

- [ ] コマンド・API名が正確か
- [ ] ファイルパスが正しいか
- [ ] 用語の使い方が正確か

## 構造チェック

### Pyramid Principle

- [ ] 結論が最初に書かれているか
- [ ] 詳細は階層的に構成されているか
- [ ] 読者が「次に何をすべきか」を即座に理解できるか

### 実行可能性

- [ ] 実行者の権限で実行可能か
- [ ] 必要なツールが明記されているか
- [ ] 依存関係が明確か

## クイックチェック（簡易版）

最低限確認すべき3項目：

1. [ ] **目的が明確**: 何を達成すべきか1-2文で説明できる
2. [ ] **曖昧語なし**: 「適切に」「よろしく」「必要に応じて」がない
3. [ ] **成功基準あり**: 何をもって完了とするか測定可能な基準がある

## 使用方法

1. 指示を作成したらこのチェックリストで確認
2. 未チェック項目があれば修正
3. 第三者にレビューを依頼する場合もこのリストを共有
